/*
poker.c Version 1.4.0 - Poker Chi Square Test
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms */
/* Vol. 2, Chapter 3.3.2 */
/* Empirical Tests, Poker Test */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

#define HOUSES 7
#define HAND 5

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n", pgm);
   fprintf(stderr,"Where size is 1000 to 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,k,size,houses,hand,deal;
   int alldiff,onepr,twopr,thrkind;
   int fullhse,fourkind,fivekind;
   int tally;
   int house[16];
   int kinds[16];
   double v;
   double rslt;
   double postblv,negtblv;
   char card[16];
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 1000 || size > 1000000)
      putstx(*argv);
   houses = HOUSES;
   hand = HAND;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"poker: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* if out of mem */

   alldiff = onepr = twopr = thrkind
      = fullhse = fourkind = fivekind = 0;
   for (i=0;i<houses;i++)
      {
      house[i] = 0;
      } /* for each house */
   for (i=0;i<hand+2;i++)
      {
      card[i] = 99;
      kinds[i] = 0;
      } /* for each house */
   deal = 0;
   while (deal++ < size)
      {
      for (i=0;i<hand+2;i++)
         {
         card[i] = 99;
         kinds[i] = 0;
         } /* for each house */
      k = 0;
      while (k++ < hand)
         {
         i = rndnum(hand,sd);
         j = 0;
         while (j < hand)
            {
            if (i < card[j])
               {
               int tmp;
               tmp = card[j];
               card[j++] = i;
               while (j < hand)
                  {
                  int hold;
                  hold = card[j];
                  card[j++] = tmp;
                  tmp = hold;
                  } /* shift right */
               break;
               } /* insert point */
            j++;
            } /* insert card in order */
         } /* generate hand */
      i = 0;
      while (i < hand) kinds[i++] = 0;
      tally = i = 0;
      while (i < hand)
         {
         if (card[i] == card[i+1])
            {
            tally++;
            } /* matching cards */
         else
            {
            kinds[tally]++;
            tally = 0;
            } /* end of run */
         i++;
         } /* count by card */
      if (kinds[4] != 0)
         {
         fivekind++;
         } /* 5 of kind */
      else if (kinds[3] != 0)
         {
         fourkind++;
         } /* 4 of kind */
      else if (kinds[2] != 0)
         {
         if (kinds[1] != 0)
            {
            fullhse++;
            } /* full house 3 + 2 */
         else
            {
            thrkind++;
            } /* 3 of kind */
         } /* 3 of kind */
      else if (kinds[1] == 2)
         {
         twopr++;
         } /* two pairs */
      else if (kinds[1] == 1)
         {
         onepr++;
         } /* one pairs */
      else
         {
         alldiff++;
         } /* all different */
      } /* deal loop */
   v = 0.0;
   v += (double) ((double) alldiff  * (double) alldiff  / 0.0384);
   v += (double) ((double) onepr    * (double) onepr    / 0.384);
   v += (double) ((double) twopr    * (double) twopr    / 0.288);
   v += (double) ((double) thrkind  * (double) thrkind  / 0.192);
   v += (double) ((double) fullhse  * (double) fullhse  / 0.064);
   v += (double) ((double) fourkind * (double) fourkind / 0.032);
   v += (double) ((double) fivekind * (double) fivekind / 0.0016);
   rslt = (double) v / (double) size - (double) size;
   chirange(6,&negtblv,&postblv);
   printf("Chi-square %f\n", rslt);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
