/*
poierr.c Version 1.4.0 - Poisson test based on
confidence level, error rate, and probability of success
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 7, Discrete Probability Distributions */
/* Section 4, Poisson Distribution */
/* Chapter 9, Statistical Estimation */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s confidence "
      "error_rate mu\n", pgm);
   fprintf(stderr,"Where confidence is "
      "90.0, 95.0, 98.0, 99.0\n");
   fprintf(stderr,"      error_rate is 0.001 to 0.1\n");
   fprintf(stderr,"      mu   is 0.1  to 15.0\n");
   fprintf(stderr,"Example: %s 95.0 0.01 2.0\n", pgm);
   fprintf(stderr,"Mu is the population mean\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int size,nobserv;
   int successes;
   int min;
   int max;
   int degf;
   int *w;
   int *wptr;
   int *wend;
   double confidence;
   double errrate;
   double popstdev;
   double dblobs;
   double psuccess;
   double qfail;
   double *p,*q;
   double *prob;
   double *probptr;
   double totprob;
   double mu;
   double expmu;
   double mupwr;
   double xpermute;
   double expect;
   double variance,stdev;
   double dblx;
   double dbli;
   double dblz;
   double wval;
   double dblsuccess;
   double avg;
   double diff;
   double sumchi;
   double zscore;
   double dblsize;
   double sumx,sumxsqd;
   double negtblv,postblv;
   int getn(double confidence, double errrate,
      double psuccess);
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 4) putstx(*argv);
   confidence = atof(*(argv+1));
   if (confidence == 90.0 || confidence == 95.0
      || confidence == 98.0 || confidence == 99.0);
   else
      {
      fprintf(stderr,"Invalid confidence level %s.\n",
	 *(argv+1));
      putstx(*argv);
      } /* bad confidence */
   errrate = atof(*(argv+2));
   if (errrate < 0.001 || errrate > 0.1)
      {
      fprintf(stderr,"Invalid error rate %s.\n",
	 *(argv+2));
      putstx(*argv);
      } /* bad error rate */
   mu = atof(*(argv+3));
   if (mu < 0.1)
      {
      fprintf(stderr,"Mu (mean) %s "
	 "is too small.\n",
	 *(argv+2));
      putstx(*argv);
      } /* mu too small */
   if (mu > 15)
      {
      fprintf(stderr,"Mu (mean) %s "
	 "is too large.\n",
	 *(argv+2));
      putstx(*argv);
      } /* mu too large */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"pssn: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   /* Allocate array for the */
   /* Bernoulli random variable W */
   w = (int *) malloc(1000 * sizeof(int));
   if (w == NULL)
      {
      fprintf(stderr,"pssn: out of memory "
	 "allocating observation array.\n");
      exit(1);
      } /* out of memory */
   prob = (double *) malloc(1000 * sizeof(double));
   if (prob == NULL)
      {
      fprintf(stderr,"pssn: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   expmu = exp(-mu);
   dblobs = 100.0;
   nobserv = (int) dblobs;
   psuccess = mu / dblobs;
   qfail = 1.0 - psuccess;
   variance = mu * qfail;
   popstdev    = sqrt(variance);
   size = getn(confidence, errrate, psuccess);
   dblsize = (double) size;
   printf("p %9.6f   q %9.6f   n %5d\n",
      psuccess, qfail, nobserv);
   printf("Poisson Probability Distribution\n");
   printf("x = Number of items per batch, "
      "where the mean is %f\n",
      mu);
   printf(" x    P(x) "
      "                  "
      "Total P(x)             z\n");
   totprob = 0.0;
   mupwr = xpermute = 1.0;
   p = (double *) prob;
   q = (double *) p + 999;
   i = 0;
   while (p < q)
      {
      dbli = (double) i;
      if (!i)
	 {
         mupwr = xpermute = 1.0;
	 } /* if x == 0 */
      else if (i == 1)
	 {
         mupwr = mu;
	 } /* if x == 1 */
      else
	 {
         mupwr *= mu;
	 xpermute *= dbli;
	 } /* if x > 1 */
      *p = expmu * mupwr / xpermute;
      totprob += *p;
      dblz = (dbli - mu) / popstdev;
      printf("%2d %22.17f %22.17f %9.4f\n",
	 i, *p, totprob, dblz);
      if (totprob > 0.9999999999)
	 break;
      i++;
      p++;
      } /* for each # of heads */
   printf("\n");
   printf("  Confidence  Error Rate "
      "  Success Rate   Observations\n");
   printf("    %5.1f      %6.3f "
      "       %5.2f      %9d\n\n",
      confidence, errrate, psuccess, size);
   printf("             Mean       Variance   Stdev "
      "       Z Score      Min     Max\n");
   printf("Population %10.6f %10.6f %10.6f\n",
      mu, variance, popstdev);
   wptr = (int *) w;
   wend = (int *) wptr + 999;
   while (wptr < wend) *wptr++ = 0;
   sumx = sumxsqd = 0.0;
   min =  999999999;
   max = -999999999;
   i = size;
   while (i--)
      {
      successes = 0;
      j = nobserv;
      while (j--)
	 {
	 if (rndfrac(sd) < psuccess)
	    successes++;
	 } /* for each simple random event */
      wptr = (int *) w + successes;
      (*wptr)++;
      dblsuccess = (double) successes;
      sumx    += dblsuccess;
      sumxsqd += (dblsuccess * dblsuccess);
      if (successes < min) min = successes;
      if (successes > max) max = successes;
      } /* generate histogram */
   variance = (sumxsqd - (sumx * sumx / dblsize))
      / (dblsize - 1.0);
   stdev = sqrt(variance);
   sumchi = avg = 0.0;
   i = degf = 0;
   wptr = (int *) w;
   wend = (int *) wptr + 999;
   probptr = (double *) prob;
   while (wptr < wend)
      {
      dblx = (double) i++;
      wval = (double) *wptr++;
      if (dblx > mu
	 && *probptr < 0.00000000001)
	 break;
      degf++;
      avg += (wval * dblx / dblsize);
      expect = (*probptr++) * dblsize;
      if (expect != 0.0)
	 {
         diff = wval - expect;
         sumchi += (diff * diff / expect);
	 } /* if not divide by zero */
      } /* sum chi-sq */
   zscore = (avg - mu) / (popstdev / sqrt(dblsize));
   printf("Observed   %10.6f %10.6f %10.6f %12.6f %7d %7d\n",
      avg, variance, stdev, zscore, min, max);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
