/*
permute.c  Version 1.4.0 Calculate Permutation
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Subroutine call:
    	int n;
    	int r;
    	double rslt;
    	rslt = permute(n,r);

        Where:

	The number of permutations of r objects from
	a set of n objects =

              PPPP
             P    P  N                     n!
             PPPPP        = P(n,r) =     ------
             P       R                   (n-r)!
             P    
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double permute(int n, int r)
   {
   double dbln;
   double dblr;
   double tmpn;
   double n_r;
   double rslt;
   if (n < 0)
      {
      fprintf(stderr,"permute: n %d is "
	 "negative\n", n);
      exit(1);
      } /* if invalid n */
   else if (n > 999)
      {
      fprintf(stderr,"permute: n %d is "
	 "too large\n", n);
      exit(1);
      } /* if invalid n */
   else if (r < 0)
      {
      fprintf(stderr,"permute: r %d is "
	 "negative\n", r);
      exit(1);
      } /* if invalid r */
   else if (n < r)
      {
      fprintf(stderr,"permute: r %d is "
	 "larger than n %d\n", r, n);
      exit(1);
      } /* if invalid r */
   dbln = (double) n;
   dblr = (double) r;
   n_r = dbln - dblr;
   rslt  = 1.0;
   tmpn = dbln;
   while (tmpn > n_r)
      {
      rslt *= tmpn--;
      } /* for n - (n_r) + 1 */
   return(rslt);
   } /* permute */
