/*
permut.c Version 1.4.0 - Permutation Test
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage %s digits size\n", pgm);
   fprintf(stderr,"Where digits is 2-9\n");
   fprintf(stderr,"      size is 1000-1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,dgts,totdgts;
   int r,f,s,max,tmp;
   int size,iteration;
   int fact;
   int *numlst;
   int *cardlst;
   int *cardlstptr;
   int *cardlstend;
   int *ftable;
   int *p,*q;
   double dblfact,chisum,chisq;
   double postblv,negtblv,dblsize;
   if (argc != 3) putstx(*argv);
   dgts = atoi(*(argv+1));
   if (dgts < 2 || dgts > 9)
      {
      fprintf(stderr,"Invalid digits\n");
      putstx(*argv);
      } /* invalid dgts */
   fact = 1;
   for (i=dgts;i>1;i--)
      fact *= i;
   size = atoi(*(argv+2));
   if (size < 1000 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   if (dgts < 9 && size < fact * 10)
      {
      fprintf(stderr,"Size is too small\n");
      putstx(*argv);
      } /* size too large */
   else if (dgts == 9 && size < 1000000)
      {
      fprintf(stderr,"Size is too small\n");
      putstx(*argv);
      } /* size too large */
   numlst = (int *) malloc(dgts*sizeof(int)+16);
   if (numlst == NULL)
      {
      fprintf(stderr,"Out of memory allocating numlst\n");
      exit(1);
      } /* out of memory */
   cardlst = (int *) malloc(dgts*sizeof(int)+16);
   if (cardlst == NULL)
      {
      fprintf(stderr,"Out of memory allocating cardlst\n");
      exit(1);
      } /* out of memory */
   ftable = (int *) malloc(fact*sizeof(int)+16);
   if (ftable == NULL)
      {
      fprintf(stderr,"permut: out of memory "
	 "allocating ftable\n");
      exit(1);
      } /* out of memory */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"permut: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of memory */

   p = ftable;
   q = ftable + fact;
   while (p < q) *p++ = 0;

   iteration = 0;
   while (iteration++ < size)
      {
      /* shuffle the deck */
      p = cardlst;
      q = cardlst + dgts;
      cardlstend = q - 1;
      i = 0;
      while (p < q)
         {
         *p++ = i++;
         } /* fill numlst */
      p = numlst;
      q = numlst + dgts;
      totdgts = dgts;
      while (p < q)
         {
	 cardlstptr = cardlst + (int) rndnum(totdgts,sd);
         *p++ = *cardlstptr;
         *cardlstptr = *cardlstend;
         *cardlstend-- = 0;
         totdgts--;
         } /* fill numlst */
      /* Algorithm P */
      /* P1 */
      r = dgts;
      f = s = 0;
      /* P2 */
      while (r >= 1)
         {
         p = numlst;
         q = numlst + r;
         max = -999999999;
         i = 1;
         while (p < q)
            {
            if (*p > max)
               {
               max = *p;
               s = i;
               }
            i++;
            p++;
            } /* find max */
         f = (r * f) + s - 1;
         /* P3 */
         tmp = numlst[r-1];
         numlst[r-1] = numlst[s-1];
         numlst[s-1] = tmp;
         /* P4 */
         r--;
         } /* P2 loop */
      ftable[f]++;
      } /* for each iteration */
   dblsize = (double) size;
   chisum = 0.0;
   dblfact = (double) fact;
   p = ftable;
   q = ftable + fact;
   while (p < q)
      {
      double tmp;
      tmp = (double) *p++;
      chisum += (double) dblfact * tmp * tmp;
      } /* sum the chi square table */
   chisq = (double) (chisum / dblsize) - dblsize; 
   chirange(fact,&negtblv,&postblv);
   printf("Chi-square %f\n", chisq);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
