#!/usr/bin/make

# nonintel.mak - compile data generator test
# random number generator routines for non-Intel platform
# Version 1.4.0
# Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

# Makefile for non-Intel platforms:
# Source file rnd2.c    is used instead of rnd.s
# Source file rndpwr2.c is used instead of rndpwr.s
# Source file rndnum2.c is used instead of rndnum.s

# To compile test routines, run
#	make -f nonintel.mak
#	insttest

# To uninstall test routines, run
#	deinst

OBJ=rnd.o \
	rndpwr.o \
	rndnum.o \
	rndfrac.o

CC=gcc

CFLAGS=-c -Wall -O6

all:		clean $(OBJ)

rnd.o:		rnd2.c
	$(CC) $(CFLAGS) rnd2.c -o rnd.o

rndpwr.o:	rndpwr2.c
	$(CC) $(CFLAGS) rndpwr2.c -o rndpwr.o

rndnum.o:	rndnum2.c
	$(CC) $(CFLAGS) rndnum2.c -o rndnum.o

rndfrac.o:	rndfrac2.c
	$(CC) $(CFLAGS) rndfrac2.c -o rndfrac.o

clean:	
	rm -f $(OBJ)
