/*
lregr.c Version 1.4.0 - Linear Regression Test
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This linear regression test is based on */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Chapter 15, Simple Regression and Correlation */
/* Section  2, Linear Regression */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, California, when he wrote this book. */

/* sample test: */

/* lregr 10000 6 6 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

#define CONF 95.0
#define CONFSTR "95.0%"
#define ZLMT 1.96

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size \n",
      pgm);
   fprintf(stderr,"Where size is 3 to 10000\n");
   fprintf(stderr,"Example: %s 100\n",
      pgm);
   fprintf(stderr,"Degrees of freedom is 98 in "
      "this example for the t distribution.\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int size;
   char regrmsg[64];
   char correlmsg[64];
   double *xlst;
   double *ylst;
   double *p,*q,*r;
   double dblsz;
   double sumx;
   double sumxsqd;
   double sumy;
   double sumysqd;
   double sumxy;
   double left;
   double middle;
   double rght;
   double rootleft;
   double rootrght;
   double top;
   double bottom;
   double ycept;
   double slope;
   double y_stdev;
   double slope_stdev;
   double t_stat;
   double t_limit;
   double correl;
   double correl_stat;
   double getttbl(int degf);
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 3 || size > 10000)
      {
      fprintf(stderr,"Invalid size %s.\n",
	 *(argv+1));
      putstx(*argv);
      } /* bad size */
   dblsz = (double) size;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"lregr: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   xlst = (double *) malloc((size * sizeof(double)) + 32);
   if (xlst == NULL)
      {
      fprintf(stderr,"lregr: out of memory "
	 "allocating X array.\n");
      exit(1);
      } /* out of memory */
   ylst = (double *) malloc((size * sizeof(double)) + 32);
   if (ylst == NULL)
      {
      fprintf(stderr,"lregr: out of memory "
	 "allocating Y array.\n");
      exit(1);
      } /* out of memory */
   p = (double *) xlst;
   q = (double *) p + size;
   while (p < q) *p++ = rndfrac(sd);
   p = (double *) ylst;
   q = (double *) p + size;
   while (p < q) *p++ = rndfrac(sd);
   sumx = sumxsqd = 0.0;
   p = (double *) xlst;
   q = (double *) p + size;
   while (p < q)
      {
      sumx += *p;
      sumxsqd += (*p * *p);
      p++;
      } /* for each value of x */
   sumy = sumysqd = 0.0;
   p = (double *) ylst;
   q = (double *) p + size;
   while (p < q)
      {
      sumy += *p;
      sumysqd += (*p * *p);
      p++;
      } /* for each value of y */
   sumxy = 0.0;
   p = (double *) xlst;
   q = (double *) p + size;
   r = (double *) ylst;
   while (p < q)
      {
      sumxy += (*p * *r);
      p++;
      r++;
      } /* for each corresponding x and y */
   /* least squares calculation */
   left   = sumxsqd * sumy;
   rght   = sumx * sumxy;
   top    = left - rght;
   left   = dblsz * sumxsqd;
   rght   = sumx  * sumx;
   bottom = left - rght;
   ycept  = top / bottom;
   printf("Y Intercept %10.6f\n", ycept);
   left   = dblsz * sumxy;
   rght   = sumx  * sumy;
   top    = left - rght;
   /* bottom is same as for ycept */
   slope  = top / bottom;
   printf("Slope       %10.6f\n", slope);
   /* t statistic for linear regression */
   middle = ycept * sumy;
   rght   = slope * sumxy;
   top    = sumysqd - middle - rght;
   bottom = dblsz - 2.0;
   y_stdev = sqrt(top / bottom);
   rght   = sumx * sumx / dblsz;
   bottom = sqrt(sumxsqd - rght);
   slope_stdev = y_stdev / bottom;
   /* The value of beta is zero */
   if (slope_stdev != 0.0)
      t_stat = slope / slope_stdev;
   else
      {
      fprintf(stderr,"lregr: divide by zero 001\n");
      exit(1);
      } /* divide by zero */
   t_limit = getttbl(size - 2);
   if (t_stat < -t_limit || t_stat > t_limit)
      strcpy(regrmsg,"Failed");
   else
      strcpy(regrmsg,"Passed");
   /* coefficient of correlation */ 
   left = dblsz * sumxy;
   rght = sumx  * sumy;
   top  = left  - rght;
   left = dblsz * sumxsqd;
   rght = sumx  * sumx;
   rootleft = sqrt(left - rght);
   left = dblsz * sumysqd;
   rght = sumy  * sumy;
   rootrght = sqrt(left - rght);
   bottom = rootleft * rootrght;
   correl = top / bottom;
   /* t statistic of coef. correlation */
   top    = dblsz - 2.0;
   /* 1 - r^2 = (1 + r) (1 - r) */
   left   = (1.0 + correl);
   rght   = (1.0 - correl);
   bottom = left * rght;
   correl_stat = correl * sqrt(top / bottom);
   if (correl_stat < -t_limit
      || correl_stat > t_limit)
      strcpy(correlmsg,"Failed");
   else
      strcpy(correlmsg,"Passed");
   printf("Coef.Corr.  %10.6f\n", correl);
   printf("\n");
   printf("                    t Statistic\n");
   printf("Linear Regression %12.6f    %s\n",
      t_stat, regrmsg);
   printf("Coef. Correlation %12.6f    %s\n",
      correl_stat, correlmsg);
   printf("\n");
   printf("Critical values of t\n");
   printf("Confidence   Deg. Freedom "
      "  Lower Limit     Upper Limit\n");
   printf("  %s  %12d %15.4f %15.4f\n",
      CONFSTR, size-2, -t_limit, t_limit);
   free(sd);
   free(xlst);
   free(ylst);
   return(0);
   } /* main */
