/*
dicesz.c Version 1.4.0 - Sample Size for Rolling Dice
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */
/* Chapter 9, Statistical Estimation */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* dicesz 95.0 0.01 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s confidence "
      "est_error\n", pgm);
   fprintf(stderr,"Where confidence is "
      "90.0, 95.0, 98.0, 99.0\n");
   fprintf(stderr,"      est_error is "
      "0.001 to 10.0\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i;
   int size;
   double confidence;
   double esterr;
   double *p,*q;
   double *prob;
   double musq;
   double est_xsq;
   double popmu;
   double popvar;
   double popstdev;
   int getsz(double confidence, double esterr,
      double variance);
   if (argc != 3) putstx(*argv);
   confidence = atof(*(argv+1));
   if (confidence == 90.0 || confidence == 95.0
      || confidence == 98.0 || confidence == 99.0);
   else
      {
      fprintf(stderr,"Invalid confidence level.\n");
      putstx(*argv);
      } /* bad confidence level */
   esterr = atof(*(argv+2));
   if (esterr < 0.001 || esterr > 10.0)
      {
      fprintf(stderr,"Invalid confidence level.\n");
      putstx(*argv);
      } /* bad confidence level */
   prob = (double *) malloc((36 + 2) * sizeof(double));
   if (prob == NULL)
      {
      fprintf(stderr,"dicesz: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   p = prob;
   q = p + 36 + 2;
   while (p < q) *p++ = 0.0;
   p = prob + 2;
   *p++ = 1.0 / 36.0;
   *p++ = 2.0 / 36.0;
   *p++ = 3.0 / 36.0;
   *p++ = 4.0 / 36.0;
   *p++ = 5.0 / 36.0;
   *p++ = 6.0 / 36.0;
   *p++ = 5.0 / 36.0;
   *p++ = 4.0 / 36.0;
   *p++ = 3.0 / 36.0;
   *p++ = 2.0 / 36.0;
   *p++ = 1.0 / 36.0;
   popmu = 0.0;
   p = prob + 2;
   q = p + 11;
   i = 2;
   while (p < q)
      {
      popmu += ((double) i * *p++);
      i++;
      } /* for each score of the dice */
   musq = popmu * popmu;
   est_xsq = 0.0;
   p = prob + 2;
   q = p + 11;
   i = 2;
   while (p < q)
      {
      est_xsq += ((double) (i * i) * *p++);
      i++;
      } /* for each score of the dice */
   popvar   = est_xsq -  musq;
   popstdev = sqrt(popvar);
   size = getsz(confidence, esterr, popvar);
   printf("Sample size is %d\n", size);
   return(0);
   } /* main */
