/*
collide.c Version 1.4.0 - Collision Test
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

#define SIZE 16384
#define URNS 1048576

int main()
   {
   int i,collisions;
   int toturns,size;
   char urn[URNS];
   char *p,*q;
   toturns = URNS;
   size = SIZE;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"collide: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of mem */
   p = urn;
   q = urn + toturns;
   while (p < q) *p++ = '\0';
   i = 0;
   collisions = 0;
   while (i++ < size)
      {
      p = (char *) urn + (int) rndpwr(20,sd);
      if (*p)
         {
         collisions++;
         } /* collision */
      else
         {
         *p = 1;
         } /* no collision */
      } /* for each toss */
   printf("%d\n", collisions);
   printf("Range 101 to 153\n");
   return(0);
   } /* main */
