/*
chival.c Version 1.4.0 - Calculate v in Table 1
Copyright (C) 2002-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This calculation is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.1, General Test Procedures */
/* Chi Square Test */
/* For degrees of freedom not in the table, */
/* Knuth's formula is used. */
/* The table used in this program is in */
/* Lincoln L. Chao */
/* California State University, Long Beach */
/* Statistics for Management */
/* 2nd edition */
/* Palo Alto:  The Scientific Press, 1984 */
/* Appendix F */
/* All numbers have been chosen for the */
/* 2.5% and 97.5% tails of the distribution. */
/* giving a 95 percent confidence in the test. */

#include <stdio.h>
#include <math.h>

void chirange(degf,lowrange,hirange)
int degf;
double *lowrange,*hirange;
   {
   double v,postblv,negtblv;
   double lotbl[38] = {0.0,  /* 0 */
      0.000982069,  /*  1 */
      0.0506356,    /*  2 */
      0.215975,     /*  3 */
      0.484419,     /*  4 */
      0.831212,     /*  5 */
      1.23734,      /*  6 */
      1.68987,      /*  7 */
      2.17973,      /*  8 */
      2.70039,      /*  9 */
      3.24697,      /* 10 */
      3.81575,      /* 11 */
      4.40379,      /* 12 */
      5.00875,      /* 13 */
      5.62873,      /* 14 */
      6.26214,      /* 15 */
      6.90766,      /* 16 */
      7.56419,      /* 17 */
      8.23075,      /* 18 */
      8.90652,      /* 19 */
      9.59078,      /* 20 */
      10.28293,     /* 21 */
      10.9823,      /* 22 */
      11.6886,      /* 23 */
      12.4012,      /* 24 */
      13.1197,      /* 25 */
      13.8439,      /* 26 */
      14.5734,      /* 27 */
      15.3079,      /* 28 */
      16.0471,      /* 29 */
      16.7908,      /* 30 */
      24.4330,      /* 40 */
      32.3574,      /* 50 */
      40.4817,      /* 60 */
      48.7576,      /* 70 */
      57.1532,      /* 80 */
      65.6466,      /* 90 */
      74.2219 };    /* 100 */
   double hitbl[38] = {0.0,
      5.02389,  /*  1 */
      7.37776,  /*  2 */
      9.34840,  /*  3 */
      11.1433,  /*  4 */
      12.8325,  /*  5 */
      14.4494,  /*  6 */
      16.0128,  /*  7 */
      17.5345,  /*  8 */
      19.0228,  /*  9 */
      20.4832,  /* 10 */
      21.9200,  /* 11 */
      23.3367,  /* 12 */
      24.7356,  /* 13 */
      26.1189,  /* 14 */
      27.4884,  /* 15 */
      28.8454,  /* 16 */
      30.1910,  /* 17 */
      31.5264,  /* 18 */
      32.8523,  /* 19 */
      34.1696,  /* 20 */
      35.4789,  /* 21 */
      36.7807,  /* 22 */
      38.0756,  /* 23 */
      39.3641,  /* 24 */
      40.6465,  /* 25 */
      41.9232,  /* 26 */
      43.1945,  /* 27 */
      44.4608,  /* 28 */
      45.7223,  /* 29 */
      46.9792,  /* 30 */
      59.3417,  /* 40 */
      71.4202,  /* 50 */
      83.2977,  /* 60 */
      95.0232,  /* 70 */
      106.629,  /* 80 */
      118.136,  /* 90 */
      129.561 };  /* 100 */
   if (degf < 1 || degf > 999999)
      {
      fprintf(stderr,"chirange: invalid "
         "degree of freedom %d\n", degf);
      exit(1);
      } /* bad degf */
   if (degf == 35)
      {
      *lowrange = 20.1398;
      *hirange  = 52.7018;
      return;
      } /* if low deg of freedom */
   else if (degf == 40)
      {
      *lowrange = 24.4330;
      *hirange  = 59.3417;
      return;
      } /* if low deg of freedom */
   else if (degf == 50)
      {
      *lowrange = 32.3574;
      *hirange  = 71.4202;
      return;
      } /* if low deg of freedom */
   else if (degf == 60)
      {
      *lowrange = 40.4817;
      *hirange  = 83.2977;
      return;
      } /* if low deg of freedom */
   else if (degf == 70)
      {
      *lowrange = 48.7576;
      *hirange  = 95.0232;
      return;
      } /* if low deg of freedom */
   else if (degf == 80)
      {
      *lowrange = 57.1532;
      *hirange  = 106.629;
      return;
      } /* if low deg of freedom */
   else if (degf == 90)
      {
      *lowrange = 65.6466;
      *hirange  = 118.136;
      return;
      } /* if low deg of freedom */
   else if (degf == 99)
      {
      *lowrange = 72.9109 ;
      *hirange  = 127.931 ;
      return;
      } /* if low deg of freedom */
   else if (degf == 100)
      {
      *lowrange = 74.2219 ;
      *hirange  = 129.561 ;
      return;
      } /* if low deg of freedom */
   else if (degf < 31)
      {
      *lowrange = lotbl[degf];
      *hirange  = hitbl[degf];
      return;
      } /* if low deg of freedom */
   v = (double) degf;
   postblv = v + (sqrt(v + v) * 2.33)
      + (2.0 * 2.33 * 2.33 / 3.0)
      - (2.0 / 3.0)
      + (1.0 / sqrt(v));
   negtblv = v - (sqrt(v + v) * 2.33)
      + (2.0 * 2.33 * 2.33 / 3.0)
      - (2.0 / 3.0)
      + (1.0 / sqrt(v));
   *lowrange = negtblv;
   *hirange  = postblv;
   return;
   } /* chirange */
