/*
bingo.c Version 1.4.0 - Bingo Test
Copyright (C) 2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* John Scarne */
/* Scarne's New Complete Guide to Gambling */
/* Fully revised, expanded, updated edition */
/* New York: Simon & Schuster, 1961, 1974, 1986 */
/* A Fireside book, 871 p. */
/* ISBN: 0-671-21734-8 hardback */
/* ISBN: 0-671-63063-6 paperback */
/* Chapter 8, Bingo: The $3 Billion National Pasttime */
/* Section: Bingo Mathematics */

/* Sample test: */

/* bingo 10000 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "rnd.h"

#define MAXN 16
#define CVR    0
#define ROW1   1
#define ROW2   2
#define ROW3   3
#define ROW4   4
#define ROW5   5
#define COL1   6
#define COL2   7
#define COL3   8
#define COL4   9
#define COL5  10
#define NWSE  11
#define NESW  12

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n", pgm);
   fprintf(stderr,"Where size is 30 to 1000000000\n");
   fprintf(stderr,"Example: %s 10000\n", pgm);
   exit(1);
   } /* putstx */

void shwcard(unsigned char *card)
   {
   int i;
   unsigned char *p;
   unsigned char *q;
   p = (unsigned char *) card;
   q = (unsigned char *) card + 25;
   *(p+12) = 0;
   i = 0;
   while (p < q)
      {
      printf(" %4d ", (int) *p++);
      if (++i == 5)
         {
         printf("\n");
         i = 0;
         } /* if end of row */
      } /* for each number in card */
   } /* shwcard */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int size;
   int degf;
   int ofst;
   int lastnum;
   int drawnum;
   int mtchsw;
   int *swptr;
   int *swend;
   int bingosw[MAXN];
   int row;
   int col;
   int totmtch;
   int totbingo;
   /* cover-all or blackout */
   int covernum;
   int mincover;
   int maxcover;
   int tot;
   int *coverlstptr;
   int *coverlstend;
   int coverlst[80];
   int row1lst[80];
   int row2lst[80];
   int row3lst[80];
   int row4lst[80];
   int row5lst[80];
   int col1lst[80];
   int col2lst[80];
   int col3lst[80];
   int col4lst[80];
   int col5lst[80];
   int nwselst[80];
   int neswlst[80];
   unsigned char *p,*q;
   unsigned char *numptr;
   unsigned char *numend;
   unsigned char numlst[80];
   unsigned char card[32];
   double dblsz;
   double rootsz;
   double totprob;
   double sqrprob;
   double cardprob;
   double prevprob;
   double currprob;
   double ratio;
   double expect;
   double diff;
   double popmu;
   double popvar;
   double popstdev;
   double *dtlptr;
   double *dtlend;
   double cvrnum;
   double count[MAXN];
   double sumx[MAXN];
   double sumxsqd[MAXN];
   double mean;
   double estxsqd;
   double top;
   double bot;
   double variance;
   double stdev;
   double zscore;
   double sumchi;
   double negtblv,postblv;
   double permute(int n, int r);
   double *probptr;
   double *probend;
   double cvrprob[80];
   double fiveprob[80];
   double fourprob[80];
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 30 || size > 1000000000)
      {
      fprintf(stderr,"Invalid size.\n");
      putstx(*argv);
      } /* bad size */
   dblsz = (double) size;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"bingo: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */

   coverlstptr = (int *) coverlst;
   coverlstend = (int *) coverlst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) row1lst;
   coverlstend = (int *) row1lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) row2lst;
   coverlstend = (int *) row2lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) row3lst;
   coverlstend = (int *) row3lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) row4lst;
   coverlstend = (int *) row4lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) row5lst;
   coverlstend = (int *) row5lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) col1lst;
   coverlstend = (int *) col1lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) col2lst;
   coverlstend = (int *) col2lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) col3lst;
   coverlstend = (int *) col3lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) col4lst;
   coverlstend = (int *) col4lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) col5lst;
   coverlstend = (int *) col5lst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) nwselst;
   coverlstend = (int *) nwselst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   coverlstptr = (int *) neswlst;
   coverlstend = (int *) neswlst + 80;
   while (coverlstptr < coverlstend)
      *coverlstptr++ = 0;

   dtlptr = (double *) count;
   dtlend = (double *) count + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   cardprob = permute(75,24);
   i = 25;
   probptr = (double *) cvrprob + 25;
   probend = (double *) cvrprob + 76;
   while (probptr < probend)
      {
      sqrprob = permute(i,24);
      *probptr = sqrprob / cardprob;
      i++;
      probptr++;
      } /* for each draw number */
   
   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) cvrprob + 25;
   probend = (double *) cvrprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   mincover =  999999999;
   maxcover = -999999999;
   i = size;
   while (i--)
      {
      totbingo = 0;
      /* unshuffle column 'B' */
      j = 1;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 15;
      while (p < q)
	 *p++ = (unsigned char) j++;
      *p = 255;
      /* shuffle/fill column */
      lastnum = 15;
      p = (unsigned char *) card;
      q = (unsigned char *) card + 25;
      numend = (unsigned char *) numlst + 14;   /* 15 - 1 */
      while (p < q)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 *p = *numptr;
	 *numptr = *numend;
	 *numend-- = (unsigned char) 255;
	 p += 5;
	 } /* for each row in column 'B' */
      /* unshuffle column 'I' */
      j = 16;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 15;
      while (p < q)
	 *p++ = (unsigned char) j++;
      *p = 255;
      /* shuffle/fill column */
      lastnum = 15;
      p = (unsigned char *) card + 1;
      q = (unsigned char *) card + 25;
      numend = (unsigned char *) numlst + 14;   /* 15 - 1 */
      while (p < q)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 *p = *numptr;
	 *numptr = *numend;
	 *numend-- = (unsigned char) 255;
	 p += 5;
	 } /* for each row in column 'I' */
      /* unshuffle column 'N' */
      j = 31;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 15;
      while (p < q)
	 *p++ = (unsigned char) j++;
      *p = 255;
      /* shuffle/fill column */
      lastnum = 15;
      p = (unsigned char *) card + 2;
      q = (unsigned char *) card + 25;
      numend = (unsigned char *) numlst + 14;   /* 15 - 1 */
      while (p < q)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 *p = *numptr;
	 *numptr = *numend;
	 *numend-- = (unsigned char) 255;
	 p += 5;
	 } /* for each row in column 'N' */
      /* unshuffle column 'G' */
      j = 46;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 15;
      while (p < q)
	 *p++ = (unsigned char) j++;
      *p = 255;
      /* shuffle/fill column */
      lastnum = 15;
      p = (unsigned char *) card + 3;
      q = (unsigned char *) card + 25;
      numend = (unsigned char *) numlst + 14;   /* 15 - 1 */
      while (p < q)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 *p = *numptr;
	 *numptr = *numend;
	 *numend-- = (unsigned char) 255;
	 p += 5;
	 } /* for each row in column 'G' */
      /* unshuffle column 'O' */
      j = 61;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 15;
      while (p < q)
	 *p++ = (unsigned char) j++;
      *p = 255;
      /* shuffle/fill column */
      lastnum = 15;
      p = (unsigned char *) card + 4;
      q = (unsigned char *) card + 25;
      numend = (unsigned char *) numlst + 14;   /* 15 - 1 */
      while (p < q)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 *p = *numptr;
	 *numptr = *numend;
	 *numend-- = (unsigned char) 255;
	 p += 5;
	 } /* for each row in column 'O' */
      /* central square */
      p = (unsigned char *) card;
      *(p+12) = 0;
      /* unshuffle draw number list */
      j = 1;
      p = (unsigned char *) numlst;
      q = (unsigned char *) numlst + 75;
      while (p < q) *p++ = j++;
      *p++ = (unsigned char) 255;
      swptr = (int *) bingosw;
      swend = (int *) bingosw + MAXN;
      while (swptr < swend) *swptr++ = 0;
      numend = (unsigned char *) numlst + 74;
      lastnum = 75;
      while (lastnum >= 0)
	 {
	 ofst = (int) rndnum(lastnum--,sd);
	 numptr = (unsigned char *) numlst + ofst;
	 drawnum = (int) *numptr;
	 *numptr = (unsigned char) *numend;
	 *numend-- = (unsigned char) 255;
	 mtchsw = 0;
	 row = 1;
	 col = 0;
	 p = (unsigned char *) card;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    col++;
	    if (col > 5)
	       {
	       row++;
	       col = 1;
	       } /* if beyond end of col */
	    if (*p == (unsigned char) drawnum)
	       {
	       *p |= (unsigned char) 0x80;
	       mtchsw = 1;
	       break;
	       } /* if number match */
	    p++;
	    } /* for each position on bingo card */
	 if (!mtchsw) continue;
	 totbingo = 0;
	 /* test for bingo in 'B' column */
	 totmtch = 0;
	 p = (unsigned char *) card;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p += 5;
	    } /* for each position in B col */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[COL1])
	       {
	       count[COL1]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[COL1]    += cvrnum;
               sumxsqd[COL1] += (cvrnum * cvrnum);
	       bingosw[COL1]  = 1;
               coverlstptr = (int *) col1lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in 'I' column */
	 totmtch = 0;
	 p = (unsigned char *) card + 1;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p += 5;
	    } /* for each position in I col */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[COL2])
	       {
	       count[COL2]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[COL2]    += cvrnum;
               sumxsqd[COL2] += (cvrnum * cvrnum);
	       bingosw[COL2]  = 1;
               coverlstptr = (int *) col2lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in 'N' column */
	 totmtch = 0;
	 p = (unsigned char *) card + 2;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p > 0 && *p < 0x7f) break;
	    totmtch++;
	    p += 5;
	    } /* for each position in N col */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[COL3])
	       {
	       count[COL3]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[COL3]    += cvrnum;
               sumxsqd[COL3] += (cvrnum * cvrnum);
	       bingosw[COL3]  = 1;
               coverlstptr = (int *) col3lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in 'G' column */
	 totmtch = 0;
	 p = (unsigned char *) card + 3;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p += 5;
	    } /* for each position in G col */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[COL4])
	       {
	       count[COL4]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[COL4]    += cvrnum;
               sumxsqd[COL4] += (cvrnum * cvrnum);
	       bingosw[COL4]  = 1;
               coverlstptr = (int *) col4lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in 'O' column */
	 totmtch = 0;
	 p = (unsigned char *) card + 4;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p += 5;
	    } /* for each position in O col */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[COL5])
	       {
	       count[COL5]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[COL5]    += cvrnum;
               sumxsqd[COL5] += (cvrnum * cvrnum);
	       bingosw[COL5]  = 1;
               coverlstptr = (int *) col5lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in row 1 */
	 totmtch = 0;
	 p = (unsigned char *) card;
	 q = (unsigned char *) card + 5;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p++;
	    } /* for each position in row 1 */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[ROW1])
	       {
	       count[ROW1]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[ROW1]    += cvrnum;
               sumxsqd[ROW1] += (cvrnum * cvrnum);
	       bingosw[ROW1]  = 1;
               coverlstptr = (int *) row1lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in row 2 */
	 totmtch = 0;
	 p = (unsigned char *) card + 5;
	 q = (unsigned char *) card + 10;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p++;
	    } /* for each position in row 2 */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[ROW2])
	       {
	       count[ROW2]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[ROW2]    += cvrnum;
               sumxsqd[ROW2] += (cvrnum * cvrnum);
	       bingosw[ROW2]  = 1;
               coverlstptr = (int *) row2lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in row 3 */
	 totmtch = 0;
	 p = (unsigned char *) card + 10;
	 q = (unsigned char *) card + 15;
	 while (p < q)
	    {
	    if (*p > 0 && *p < 0x7f) break;
	    totmtch++;
	    p++;
	    } /* for each position in row 3 */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[ROW3])
	       {
	       count[ROW3]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[ROW3]    += cvrnum;
               sumxsqd[ROW3] += (cvrnum * cvrnum);
	       bingosw[ROW3]  = 1;
               coverlstptr = (int *) row3lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in row 4 */
	 totmtch = 0;
	 p = (unsigned char *) card + 15;
	 q = (unsigned char *) card + 20;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p++;
	    } /* for each position in row 4 */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[ROW4])
	       {
	       count[ROW4]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[ROW4]    += cvrnum;
               sumxsqd[ROW4] += (cvrnum * cvrnum);
	       bingosw[ROW4]  = 1;
               coverlstptr = (int *) row4lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in row 5 */
	 totmtch = 0;
	 p = (unsigned char *) card + 20;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p < 0x80) break;
	    totmtch++;
	    p++;
	    } /* for each position in row 5 */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[ROW5])
	       {
	       count[ROW5]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[ROW5]    += cvrnum;
               sumxsqd[ROW5] += (cvrnum * cvrnum);
	       bingosw[ROW5]  = 1;
               coverlstptr = (int *) row5lst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in diag nw-se */
	 totmtch = 0;
	 p = (unsigned char *) card;
	 q = (unsigned char *) card + 25;
	 while (p < q)
	    {
	    if (*p > 0 && *p < 0x7f) break;
	    totmtch++;
	    p += 6;
	    } /* for each position in diag nw-se */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[NWSE])
	       {
	       count[NWSE]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[NWSE]    += cvrnum;
               sumxsqd[NWSE] += (cvrnum * cvrnum);
	       bingosw[NWSE]  = 1;
               coverlstptr = (int *) nwselst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 /* test for bingo in diag ne-sw */
	 totmtch = 0;
	 p = (unsigned char *) card + 4;
	 q = (unsigned char *) card + 24;
	 while (p < q)
	    {
	    if (*p > 0 && *p < 0x7f) break;
	    totmtch++;
	    p += 4;
	    } /* for each position in diag ne-sw */
	 if (totmtch == 5)
	    {
	    totbingo++;
	    if (!bingosw[NESW])
	       {
	       count[NESW]   += 1.0;
               cvrnum         = (double) (75 - lastnum);
               sumx[NESW]    += cvrnum;
               sumxsqd[NESW] += (cvrnum * cvrnum);
	       bingosw[NESW]  = 1;
               coverlstptr = (int *) neswlst + (int) cvrnum;
               (*coverlstptr)++;
	       } /* if first bingo detection */
	    } /* if bingo */
	 if (totbingo >= 12) break;
	 } /* for each draw number */
      covernum = 75 - lastnum;
      if (covernum < mincover)
	 mincover = covernum;
      if (covernum > maxcover)
	 maxcover = covernum;
      coverlstptr = (int *) coverlst + covernum;
      (*coverlstptr)++;
      cvrnum = (double) covernum;
      count[CVR]   += 1.0;
      sumx[CVR]    += cvrnum;
      sumxsqd[CVR] += (cvrnum * cvrnum);
      } /* count bingos */
   printf("\n");

   printf("    Number of draws per bingo\n");
   printf("             Mean "
      "          Stdev\n");
   mean = sumx[ROW1] / count[ROW1];
   top = sumxsqd[ROW1] - (sumx[ROW1] * sumx[ROW1] / count[ROW1]);
   bot = count[ROW1] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Row 1 %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[ROW2] / count[ROW2];
   top = sumxsqd[ROW2] - (sumx[ROW2] * sumx[ROW2] / count[ROW2]);
   bot = count[ROW2] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Row 2 %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[ROW3] / count[ROW3];
   top = sumxsqd[ROW3] - (sumx[ROW3] * sumx[ROW3] / count[ROW3]);
   bot = count[ROW3] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Row 3 %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[ROW4] / count[ROW4];
   top = sumxsqd[ROW4] - (sumx[ROW4] * sumx[ROW4] / count[ROW4]);
   bot = count[ROW4] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Row 4 %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[ROW5] / count[ROW5];
   top = sumxsqd[ROW5] - (sumx[ROW5] * sumx[ROW5] / count[ROW5]);
   bot = count[ROW5] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Row 5 %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[COL1] / count[COL1];
   top = sumxsqd[COL1] - (sumx[COL1] * sumx[COL1] / count[COL1]);
   bot = count[COL1] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Col B %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[COL2] / count[COL2];
   top = sumxsqd[COL2] - (sumx[COL2] * sumx[COL2] / count[COL2]);
   bot = count[COL2] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Col I %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[COL3] / count[COL3];
   top = sumxsqd[COL3] - (sumx[COL3] * sumx[COL3] / count[COL3]);
   bot = count[COL3] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Col N %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[COL4] / count[COL4];
   top = sumxsqd[COL4] - (sumx[COL4] * sumx[COL4] / count[COL4]);
   bot = count[COL4] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Col G %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[COL5] / count[COL5];
   top = sumxsqd[COL5] - (sumx[COL5] * sumx[COL5] / count[COL5]);
   bot = count[COL5] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Col O %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[NWSE] / count[NWSE];
   top = sumxsqd[NWSE] - (sumx[NWSE] * sumx[NWSE] / count[NWSE]);
   bot = count[NWSE] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("NW-SE %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[NESW] / count[NESW];
   top = sumxsqd[NESW] - (sumx[NESW] * sumx[NESW] / count[NESW]);
   bot = count[NESW] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("NE-SW %14.6f %14.6f\n",
      mean, stdev);

   mean = sumx[CVR] / count[CVR];
   top = sumxsqd[CVR] - (sumx[CVR] * sumx[CVR] / count[CVR]);
   bot = count[CVR] - 1.0;
   variance = top / bot;
   stdev = sqrt(variance);
   printf("Cover %14.6f %14.6f\n",
      mean, stdev);
   printf("\n");

   printf("               Number of Draws to "
      "Cover Bingo Card\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");
   degf = tot = 0;
   prevprob = sumx[CVR] =
      sumxsqd[CVR] = sumchi = 0.0;
   rootsz = sqrt(dblsz);
   i = 25;
   probptr = (double *) cvrprob + 25;
   probend = (double *) cvrprob + 76;
   coverlstptr = (int *) coverlst + 25;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[CVR]    += (double) *coverlstptr * currprob;
      sumxsqd[CVR] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[CVR] - (sumx[CVR] * sumx[CVR]);
   stdev = sqrt(variance);
   mean = sumx[CVR] / dblsz;
   zscore = (sumx[CVR] - popmu) / (popstdev / rootsz);
   printf("Cover            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[CVR], stdev, zscore);
   printf("\n");

   printf("Cover Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");

   /* bingos that don't cross the middle square */
   /* rows 1,2,4,5, and cols 'B','I','G','O'    */
   cardprob = permute(75,5);
   i = 5;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      sqrprob = permute(i,5);
      *probptr = sqrprob / cardprob;
      i++;
      probptr++;
      } /* for each draw number */
   
   /* bingos that cross the middle square       */
   /* row 3, col 'N', diagonals NW-SE and NE-SW */
   cardprob = permute(75,4);
   i = 4;
   probptr = (double *) fourprob + 4;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      sqrprob = permute(i,4);
      *probptr = sqrprob / cardprob;
      i++;
      probptr++;
      } /* for each draw number */
   
   printf("                Number of "
      "Draws for Row 1 Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) row1lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[ROW1]    += (double) *coverlstptr * currprob;
      sumxsqd[ROW1] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[ROW1] - (sumx[ROW1] * sumx[ROW1]);
   stdev = sqrt(variance);
   mean = sumx[ROW1] / dblsz;
   zscore = (sumx[ROW1] - popmu) / (popstdev / rootsz);
   printf("Row 1            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[ROW1], stdev, zscore);
   printf("\n");

   printf("Row 1 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Row 2 Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) row2lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[ROW2]    += (double) *coverlstptr * currprob;
      sumxsqd[ROW2] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[ROW2] - (sumx[ROW2] * sumx[ROW2]);
   stdev = sqrt(variance);
   mean = sumx[ROW2] / dblsz;
   zscore = (sumx[ROW2] - popmu) / (popstdev / rootsz);
   printf("Row 2            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[ROW2], stdev, zscore);
   printf("\n");

   printf("Row 2 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Row 3 Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) row3lst + i;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[ROW3]    += (double) *coverlstptr * currprob;
      sumxsqd[ROW3] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[ROW3] - (sumx[ROW3] * sumx[ROW3]);
   stdev = sqrt(variance);
   mean = sumx[ROW3] / dblsz;
   zscore = (sumx[ROW3] - popmu) / (popstdev / rootsz);
   printf("Row 3            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[ROW3], stdev, zscore);
   printf("\n");

   printf("Row 3 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Row 4 Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) row4lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[ROW4]    += (double) *coverlstptr * currprob;
      sumxsqd[ROW4] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[ROW4] - (sumx[ROW4] * sumx[ROW4]);
   stdev = sqrt(variance);
   mean = sumx[ROW4] / dblsz;
   zscore = (sumx[ROW4] - popmu) / (popstdev / rootsz);
   printf("Row 4            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[ROW4], stdev, zscore);
   printf("\n");

   printf("Row 4 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Row 5 Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) row5lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[ROW5]    += (double) *coverlstptr * currprob;
      sumxsqd[ROW5] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[ROW5] - (sumx[ROW5] * sumx[ROW5]);
   stdev = sqrt(variance);
   mean = sumx[ROW5] / dblsz;
   zscore = (sumx[ROW5] - popmu) / (popstdev / rootsz);
   printf("Row 5            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[ROW5], stdev, zscore);
   printf("\n");

   printf("Row 5 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/
   /*****************************************************************/

   printf("                Number of "
      "Draws for Column 'B' Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) col1lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[COL1]    += (double) *coverlstptr * currprob;
      sumxsqd[COL1] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[COL1] - (sumx[COL1] * sumx[COL1]);
   stdev = sqrt(variance);
   mean = sumx[COL1] / dblsz;
   zscore = (sumx[COL1] - popmu) / (popstdev / rootsz);
   printf("Col 1            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[COL1], stdev, zscore);
   printf("\n");

   printf("Col 1 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Column 'I' Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) col2lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[COL2]    += (double) *coverlstptr * currprob;
      sumxsqd[COL2] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[COL2] - (sumx[COL2] * sumx[COL2]);
   stdev = sqrt(variance);
   mean = sumx[COL2] / dblsz;
   zscore = (sumx[COL2] - popmu) / (popstdev / rootsz);
   printf("Col 2            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[COL2], stdev, zscore);
   printf("\n");

   printf("Col 2 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Column 'N' Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) col3lst + i;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[COL3]    += (double) *coverlstptr * currprob;
      sumxsqd[COL3] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[COL3] - (sumx[COL3] * sumx[COL3]);
   stdev = sqrt(variance);
   mean = sumx[COL3] / dblsz;
   zscore = (sumx[COL3] - popmu) / (popstdev / rootsz);
   printf("Col 3            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[COL3], stdev, zscore);
   printf("\n");

   printf("Col 3 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Column 'G' Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) col4lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[COL4]    += (double) *coverlstptr * currprob;
      sumxsqd[COL4] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[COL4] - (sumx[COL4] * sumx[COL4]);
   stdev = sqrt(variance);
   mean = sumx[COL4] / dblsz;
   zscore = (sumx[COL4] - popmu) / (popstdev / rootsz);
   printf("Col 4            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[COL4], stdev, zscore);
   printf("\n");

   printf("Col 4 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of "
      "Draws for Column 'O' Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) col5lst + i;
   probptr = (double *) fiveprob + 5;
   probend = (double *) fiveprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[COL5]    += (double) *coverlstptr * currprob;
      sumxsqd[COL5] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[COL5] - (sumx[COL5] * sumx[COL5]);
   stdev = sqrt(variance);
   mean = sumx[COL5] / dblsz;
   zscore = (sumx[COL5] - popmu) / (popstdev / rootsz);
   printf("Col 5            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[COL5], stdev, zscore);
   printf("\n");

   printf("Col 5 Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of Draws "
      "for Diagonal NW-SE Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) nwselst + i;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[NWSE]    += (double) *coverlstptr * currprob;
      sumxsqd[NWSE] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[NWSE] - (sumx[NWSE] * sumx[NWSE]);
   stdev = sqrt(variance);
   mean = sumx[NWSE] / dblsz;
   zscore = (sumx[NWSE] - popmu) / (popstdev / rootsz);
   printf("NW-SE            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[NWSE], stdev, zscore);
   printf("\n");

   printf("NW-SE Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   printf("                Number of Draws "
      "for Diagonal NE-SW Bingo\n\n");
   printf("  Draw "
      "      "
      "Count"
      "    "
      "Sample Proportion"
      "      "
      "Population Prob."
      "    "
      "z\n");

   prevprob = totprob = popmu = estxsqd = 0.0;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      expect   = currprob * dblsz;
      popmu   += (expect * currprob);
      estxsqd += (expect * expect * currprob);
      prevprob = *probptr;
      probptr++;
      } /* for each draw number */
   popvar = estxsqd - (popmu * popmu);
   popstdev = sqrt(popvar);

   dtlptr = (double *) sumx;
   dtlend = (double *) sumx + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   dtlptr = (double *) sumxsqd;
   dtlend = (double *) sumxsqd + MAXN;
   while (dtlptr < dtlend) *dtlptr++ = 0.0;

   tot = degf = 0;
   sumchi = totprob = prevprob = 0.0;
   i = 5;
   coverlstptr = (int *) neswlst + i;
   probptr = (double *) fourprob + 5;
   probend = (double *) fourprob + 76;
   while (probptr < probend)
      {
      currprob = *probptr - prevprob;
      totprob += currprob;
      ratio = (double) *coverlstptr / dblsz;
      diff  = (double) *coverlstptr - popmu;
      zscore = diff / popstdev;
      if (*coverlstptr)
	 {
	 degf++;
         printf("%6d %9d %22.17f %22.17f %10.6f\n",
	    i, *coverlstptr, ratio,
	    currprob, zscore);
	 } /* if not zero */
      expect   = currprob * dblsz;
      diff     = (double) *coverlstptr - expect;
      sumx[NESW]    += (double) *coverlstptr * currprob;
      sumxsqd[NESW] += (double) (*coverlstptr * *coverlstptr) * currprob;
      tot     += *coverlstptr;
      sumchi  += (diff * diff / expect);
      prevprob = *probptr;
      i++;
      coverlstptr++;
      probptr++;
      } /* for each cover draw number */

   ratio = (double) tot / dblsz;
   printf(" Total %9d %22.17f %22.17f\n",
      tot, ratio, totprob);
   printf("\n");
   variance = sumxsqd[NESW] - (sumx[NESW] * sumx[NESW]);
   stdev = sqrt(variance);
   mean = sumx[NESW] / dblsz;
   zscore = (sumx[NESW] - popmu) / (popstdev / rootsz);
   printf("NE-SW            Mean "
      "            Stdev "
      "       Z Score\n");
   printf("Expected %16.6f %16.6f\n",
      popmu, popstdev);
   printf("Observed %16.6f %16.6f %11.4f\n",
      sumx[NESW], stdev, zscore);
   printf("\n");

   printf("NE-SW Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   /*****************************************************************/

   free(sd);
   return(0);
   } /* main */
