/* sample.c Version 1.4.0. test datagen library */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fsample.mak     */

/* Sample test data program, */

#include "datagen.h"

int main(int argc,char **argv)
   {
   int i;
   int rslt;
   dgfmt *dg;            /* global parameters */
   char optfname[128];   /* output file name */
   if (argc > 3) putstx(*argv);  /* too many arguments */
   dg = (dgfmt *) dginit();      /* initialize global structure */
   if (dg == NULL)
      {
      fprintf(stderr,"sample: out of memory "
         "initializing dg structure\n");
      } /* out of mem */
   dg->verbose = 0;        /* default values */
   dg->opthndl = 1;        /* stdout */
   optfname[0] = '\0';     /* default: stdout */
   i = 1;
   while (i < argc)
      {
      rslt = strcmp(*(argv+i),"-v");
      if (!rslt)
         {
         dg->verbose = 1;
         i++;
         continue;
         }
      rslt = strcmp(*(argv+i),"-h");
      if (!rslt)
         {
         putstx(*argv);        /* syntax help */
         i++;
         continue;
         }
      rslt = strcmp(*(argv+i),"-o");
      if (!rslt)
         {
         if (i+1 < argc)
            {
            strcpy(optfname,*(argv+i+1));    /* output file */
            dg->opthndl = opnopt(optfname);  /* open */
            i += 2;
            continue;
            } /* if parm available */
         else
            {
            fprintf(stderr,"sample: missing "
               "output file name\n");
            putstx(*argv);
            } /* bad optfile */
         } /* if output file */
      else
         {
         fprintf(stderr,"sample: invalid "
            "parameter %s\n",
            *(argv+i));
         putstx(*argv);
         } /* invalid parm */
      } /* for each parm */
   putstr(dg->opthndl,"Sample Test");   /* dummy title line */
   putstr(dg->opthndl,"\n");
   i = 11;                    /* first transaction of */
   while (i--)                /* 11 records */
      {                       /* a transaction is a */
      dg->lentype = CONSTANTLEN;          /* record group */
      dg->fromlen = 10;         /* this data is garbage */
      dgseq(dg);                /* to show how subroutines */
      putstr(dg->opthndl,":");      /* are called */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 8;          /* upper and lower case */
      dgalfa(dg);               /* alpha */
      putstr(dg->opthndl,"\n");
      } /* transaction loop */
   cls(dg->opthndl);
   return(0);
   }  /* main */
