/*
rndinit.c  Version 1.4.0
Initialize random number generator seed to date, time,
& clock ticks. Resulting seed is unpredictable.
Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* The following copyright notice is for the call */
/* to getmd5. */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

/*
Usage:
    	unsigned char *RandSeed;
    	RandSeed = (unsigned char *) rndinit();
*/

/*
System subroutine calls:
	times
	time
*/

/* This is a batch version of rndinit. */
/* If memory allocation fails, the program */
/* terminates abnormally. */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/times.h>
#include "md5glbl.h"
#include "md5.h"
#define SEEDLEN 16

unsigned char *rndinit()
	{
	int i,j;
	unsigned char *r;
	unsigned char sd[32];
	unsigned char *md5sd;
	time_t now,*p;
	clock_t clk,*q;
	struct tms t;
        void getmd5(unsigned char *seed,
           int seedlen, unsigned char *digest);
	/* allocate memory for md5 digest */
	md5sd = (unsigned char *) malloc(SEEDLEN+16);
	if (md5sd == NULL)
	   {
	   fprintf(stderr,"rndinit: out of memory "
	      "allocating md5sd\n");
	   exit(1);
	   } /* out of memory */
	/* get clock ticks since boot */
	clk = times(&t);
	/* get date & time */
	time(&now);
	r = sd;
	/* initialize seed to zeros */
	for (i=0;i<SEEDLEN;i++) *r++ = '\0';
	/* fill seed with unique data */
	r = sd;
	for (i=0;i<2;i++)
	   {
	   p = &now;	/* date & time */
	   for (j=0;j<4;j++) *r++ = *p++;
	   q = &clk;	/* clock ticks @ 100/sec */
	   for (j=0;j<4;j++) *r++ = *q++;
	   } /* for each 8 bytes of seed */
	/* Make seed more random by hashing it. */
        /* RSA Data Security, Inc. */
	/* MD5 Message-Digest Algorithm */
	/* Input is a 16 byte date-time stamp */
	/* Output is a 16 byte message digest */
	/* The MD5 algorithm is described in */
	/* RFC 1321 (April 1992). */
        /* The getmd5 subroutine is derived from */
	/* the RSA Data Security, Inc. */
	/* MD5 Message-Digest Algorithm. */
	getmd5(sd,SEEDLEN,md5sd);
	*md5sd |= 1;	/* seed must be odd */
	return(md5sd);
	} /* rndinit */
