# rndfrac.s - random number generator based on 16 byte seed
#   	generates a random fraction with normal distribution
#   	0.0 <= x < 1.0
# Version 1.4.0
# Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

#	Free Software Foundation, Inc.
#	59 Temple Place - Suite 330
#	Boston, MA  02111-1307, USA.

# Usage:
#   	double rndfrac(unsigned char *sd);

#   	rnd() function is inline

# initialize the seed with:
#   	unsigned char *sd;
#   	sd = (unsigned char *) rndinit();

# The inner loop (again:) is a copy of rnd()

	.file	"rndfrac.s"
	.version	"0.1.0"
gcc2_compiled.:
	.align 8
.LC0:	.long 0x0,0x3fe00000
.text
	.align 4
.globl rndfrac
	.type	 rndfrac,@function
rndfrac:
	pushl %ebp
	movl %esp,%ebp
	subl $96,%esp           /* local variables */
	pushl %eax
	pushl %ecx
	pushl %esi
	finit			/* initialize co-processor */
	fldl .LC0		/* 0.5 */
	fldz			/* 0.0 */
	movl $52,%ecx		/* loop counter = 52 */
	movl 8(%ebp),%esi	/* 1st parm = sd pointer */
again:
	/* next iteration of randomizer */
	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	shll $1,%eax			/* double it */
	movl %eax,-48(%ebp)		/* save in sd2 */
	movl 4(%esi),%eax		/* get sd+4 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-44(%ebp)		/* save in sd2+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-40(%ebp)		/* save in sd2+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	rcll $1,%eax			/* double it with carry */
	movl %eax,-36(%ebp)		/* save in sd2+12 */

	clc				/* clear carry flag */
	movl 8(%esi),%eax		/* get sd+8 */
	addl (%esi),%eax		/* add sd */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl 4(%esi),%eax		/* add sd+4 */
	movl %eax,12(%esi)		/* save in sd+12 */

	clc				/* clear carry flag */
	movl (%esi),%eax		/* get sd */
	addl -48(%ebp),%eax		/* add sd2 */
	movl %eax,(%esi)		/* save in sd */
	movl 4(%esi),%eax		/* get sd+4 */
	adcl -44(%ebp),%eax		/* add sd2+4 */
	movl %eax,4(%esi)		/* save in sd+4 */
	movl 8(%esi),%eax		/* get sd+8 */
	adcl -40(%ebp),%eax		/* add sd2+8 */
	movl %eax,8(%esi)		/* save in sd+8 */
	movl 12(%esi),%eax		/* get sd+12 */
	adcl -36(%ebp),%eax		/* add sd2+12 */
	movl %eax,12(%esi)		/* save in sd+12 */
	fld %st(1)		/* copy 0.5 */
	fmulp %st,%st(1)	/* multiply frac by 0.5 */
	shll $1,%eax		/* high order bit to carry */
	jc .L2			/* if carry */
	fld %st(1)		/* copy 0.5 */
	faddp %st,%st(1)	/* add 0.5 to frac */
.L2:
	loop again

	jmp .L1
	.align 4
.L1:
	popl %esi
	popl %ecx
	popl %eax
	movl %ebp,%esp
	popl %ebp
	ret
