/* puthx.c Version 1.4.0. Print 16 bytes in hex */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330    */
/*       Boston, MA  02111-1307, USA.   */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use:                    */

/*                make -fdatagen.mak              */

/*									*/
/*      PUTHX: Print 16 bytes of memory in hex                          */
/*									*/

#include "datagen.h"

void puthx(int adr,int len,unsigned char *mem)
   {
   unsigned char *p,*q,*r;
   sleep(1);
   printf("%06x  ", adr);
   p = (unsigned char *) mem;
   q = (unsigned char *) mem + 4;
   r = (unsigned char *) mem + len;
   while (p < q)
      {
      if (p < r)
         printf("%02x", *p);
      else
         printf("  ");
      p++;
      } /* print 4 bytes */
   printf("  ");
   q += 4;
   while (p < q)
      {
      if (p < r)
         printf("%02x", *p);
      else
         printf("  ");
      p++;
      } /* print 4 bytes */
   printf("  ");
   q += 4;
   while (p < q)
      {
      if (p < r)
         printf("%02x", *p);
      else
         printf("  ");
      p++;
      } /* print 4 bytes */
   printf("  ");
   q += 4;
   while (p < q)
      {
      if (p < r)
         printf("%02x", *p);
      else
         printf("  ");
      p++;
      } /* print 4 bytes */
   printf("  *");
   p = (unsigned char *) mem;
   q = (unsigned char *) mem + 16;
   while (p < q)
      {
      if (p < r)
         {
         if (*p >= ' ' && *p <= '~')
            printf("%c", *p);
         else
            printf(" ");
         } /* if within len */
      else
         printf(" ");
      p++;
      } /* print 16 bytes in ASCII */
   printf("*");
   printf("\n");
   } /* puthx */
