/*
jd2g.c Release 1.4.0  Julian Day to Gregorian Conversion
Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This program is the outer routine for converting */
/* a scientific Julian Day to a calendar date. */
/* The calendar date is based on the Julian calendar, */
/* if prior to October 15, 1582.  If later than */
/* October 4, 1582, the date is based on the */
/* Gregorian calendar. */

/* In datagen, daterange is defined by a lower */
/* and upper Julian Day. This routine helps you */
/* to verify that a Julian Day in daterange */
/* corresponds to a desired Gregorian date. */

/* The subroutine called by this program, */
/* jd2greg(), is based on Peter Duffett-Smith */
/* Practical Astronomy with Your Calculator */
/* Third Edition */
/* Cambridge University Press */
/* ISBN 0 521 35629 6 hardback */
/* ISBN 0 521 35699 7 paperback */
/* Chapter 5: Converting the Julian Day Number */
/* to the Calendar Date */

/* In this implementation, */
/* dates prior to the Christian Era are true */
/* Julian dates.  Year 0 is bypassed. */
/* The year has been adjusted, if less than 1, */
/* to allow for true dates. */
/* December 31, -1 is immediately followed by */
/* January 1, 1. */
/* October 4, 1582 is immediately followed by */
/* October 15, 1582. */

/* Notice that the integer routine described */
/* in the book has been implemented as astrint() */
/* astrint(-3.914) = -3.0 */
/* astrint() gives the same result as the integer */
/* result from the modf() function. */

#include "datagen.h"

void jd2g_stx(char *pgm)
   {
   fprintf(stderr,"Usage: %s julianday\n", pgm);
   fprintf(stderr,"Where julianday is 0.0 to 10000000.0\n");
   exit(1);
   } /* jd2g_stx */

int main(int argc,char **argv)
   {
   int year,month,day,hour,minute;
   double jd,second;
   if (argc != 2) jd2g_stx(*argv);
   jd = atof(*(argv+1));
   if (jd < 0 || jd > 10000000.0)
      jd2g_stx(*argv);
   jd2greg(jd,&year,&month,&day,
      &hour,&minute,&second);
   printf("%d %d %d  %d %d %f\n",
      year, month, day, hour, minute, second);
   return(0);
   } /* main */
