/* dgsine.c Version 1.4.0. Generate sine wave */
/* step by step */
/* Step is delta(x) */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* magnitude is dg->loflrng */
/* axis      is dg->hiflrng */

void dgsine(dgfmt *dg)
   {
   double magnitude;
   double axis;
   double twopi;
   double yval;
   char fmtstr[32];
   char wrkstr[32];
   dg->sinex += dg->sinestep;
   twopi = M_PI + M_PI;
   if (dg->sinex > twopi)
      dg->sinex -= twopi;
   magnitude = dg->loflrng;
   axis      = dg->hiflrng;
   yval = (sin(dg->sinex) * magnitude) + axis;
   sprintf(fmtstr, "%s%d%s", "%.", dg->dec, "f");
   sprintf(wrkstr, fmtstr, yval);
   putstr(dg->opthndl, wrkstr);
   } /* dgsine */
