/* dgreal.c Version 1.4.0. Generate real number field */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void dgreal(dgfmt *dg)
   {
   int negsw;
   int i;
   int len;
   char *p,*q;
   char str[8];
   negsw = (int) rnd(dg->sd);
   if (negsw)
      {
      if (dg->sign == PRESIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,"(");
      } /* if negative */
   len = calclen(dg);
   p = (char *) str;
   q = (char *) str + 1;
   i = len;
   while (i--)
      {
      *p = (char) (rndnum(10,dg->sd) + '0');
      *q = '\0';
      putstr(dg->opthndl,p);
      } /* for each digit */
   if (dg->dec > 0)
      {
      putstr(dg->opthndl,".");
      i = dg->dec;
      while (i--)
         {
         *p = (char) (rndnum(10,dg->sd) + '0');
         *q = '\0';
         putstr(dg->opthndl,p);
         } /* for each decimal */
      } /* if decimals */
   if (negsw)
      {
      if (dg->sign == POSTSIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,")");
      } /* if negative */
   } /* dgreal */
