/* dgjul.c Version 1.4.0. Generate julian day field */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The julian day generated is the scientific */
/* julian day used in astonomy. */
/* It is based on the current time down to the */
/* second at the time of calculation. */
/* Therefore, two calls to this subroutine */
/* will yield different fractions, depending */
/* when the calls are made. */

void dgjul(dgfmt *dg)
   {
   double jd;
   double hour;
   time_t now;
   struct tm *t;
   char jdfmt[64];
   char str[64];
   time(&now);
   t = (struct tm *) localtime(&now);
   hour = (double) t->tm_hour +
      ((double) t->tm_min / 60.0) +
      ((double) t->tm_sec / 3600.0);
   jd = (double) greg2jd(t->tm_year+1900,
      t->tm_mon+1, t->tm_mday, hour);
   sprintf(jdfmt,"%s%d%s", "%.", dg->dec, "f");
   sprintf(str,jdfmt,jd);
   putstr(dg->opthndl,str);
   } /* dgjul */
