/* dgbinom.c Version 1.4.0. Generate binomial */
/* Copyright (C) 2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The number of trials is in dg->trials. */
/* The number of trials is 2 - 30. */
/* The probability is in dg->prob. */
/* The probability is 0.1 - 0.9. */
/* Prints the number of successes. */

void dgbinom(dgfmt *dg)
   {
   int i;
   int tot;
   int pfxlen;
   char str[16];
   if (dg->trials < 2 || dg->trials > 30)
      {
      fprintf(stderr,"\ndgbinom: invalid "
         "number of trials: %d\n",
         dg->trials);
      fprintf(stderr,"Number of trials "
         "is 2 - 30\n");
      exit(1);
      } /* invalid #trials */
   if (dg->prob < 0.1 || dg->prob > 0.9)
      {
      fprintf(stderr,"\ndgbinom: invalid "
         "binomial probability: %30.20f\n",
         dg->prob);
      fprintf(stderr,"Probability "
         "is 0.1 - 0.9\n");
      exit(1);
      } /* invalid probability */
   tot = 0;
   i = dg->trials;
   while (i--)
      {
      if (rndfrac(dg->sd) < dg->prob)
	 tot++;
      } /* for each trial */
   sprintf(str,"%d",tot);
   pfxlen = dg->fromlen - strlen(str);
   if (pfxlen > 0)
      {
      while (pfxlen--)
         putstr(dg->opthndl,"0");
      } /* if leading zeros */
   putstr(dg->opthndl,str);
   } /* dgbinom */
