/* dgamt.c Version 1.4.0. Generate amount field */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The amount data type has a pseudo logarithmic */
/* distribution, base 2 */

void dgamt(dgfmt *dg)
   {
   int negsw;
   int i;
   int len;
   unsigned long diff;
   unsigned long lmt;
   double intgr;
   char str[64];
   negsw = (int) rnd(dg->sd);
   if (negsw)
      {
      if (dg->sign == PRESIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,"(");
      } /* if negative */
   if (dg->fromlen < dg->tolen)
      {
      diff = (unsigned long) dg->tolen - dg->fromlen;
      len = (int) rndnum(diff,dg->sd) + dg->fromlen;
      }
   else len = dg->fromlen;
   str[1] = '\0';
   intgr = 0.0;
   if (len > 48 || len < 0)
      {
      fprintf(stderr,"\ndgamt: invalid "
         "bits %d\n", dg->fromlen);
      fprintf(stderr,"Bits is 0 - 48\n");
      exit(1);
      } /* invalid integer bitlen */
   lmt = (unsigned long) len;
   i = (int) rndnum(lmt,dg->sd) + 1;
   while (i--)
      {
      intgr *= 2.0;
      intgr = intgr + (double) rnd(dg->sd);
      } /* for each digit */
   sprintf(str,"%.0f", intgr);
   putstr(dg->opthndl,str);
   str[1] = '\0';
   if (dg->dec > 0)
      {
      putstr(dg->opthndl,".");
      i = dg->dec;
      while (i--)
         {
         str[0] = (char) rndnum(10L,dg->sd) + '0';
         putstr(dg->opthndl,str);
         } /* for each decimal */
      } /* if decimals */
   if (negsw)
      {
      if (dg->sign == POSTSIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,")");
      } /* if negative */
   } /* dgamt */
