/* dgalfa.c Version 1.4.0. Generate alpha field */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void rndalfa(dgfmt *dg)
   {
   int ch;
   int i;
   int len;
   int padlen;
   char *p;
   len    = (int) calclen(dg);
   dg->strptr = (char *) dg->str;
   padlen = 0;
   if (dg->totlen > len
      && dg->padding == LPAD)
      {
      padlen = dg->totlen - len;
      dgpad(dg,padlen);
      dg->strptr += padlen;
      } /* if padding */
   p = (char *) dg->strptr;
   i = len;
   while (i--)
      {
      ch = (int) (rndnum(26,dg->sd) + 'A');
      if (rnd(dg->sd)) ch += 32;
      *p++ = (char) ch;
      } /* for each alpha letter */
   *p = '\0';
   if (dg->totlen > len
      && dg->padding == RPAD)
      {
      padlen = dg->totlen - len;
      dg->strptr = (char *) dg->str + len;
      dgpad(dg,padlen);
      } /* if padding */
   } /* rndalfa */

void dgalfa(dgfmt *dg)
   {
   rndalfa(dg);
   putstr(dg->opthndl,dg->str);
   } /* dgalfa */
