/* datagen.h Version 1.4.0. datagen header file */
/* Copyright (C) 2004-2005  dondalah@ripco.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <malloc.h>

#define ESC	0x1b			/* Define the escape key	*/
#define TRUE	1			/* Define some handy constants	*/
#define FALSE	0			/* Define some handy constants	*/
#define PI      3.141592654             /* Define a value for PI        */
#define ON	1			/* Define some handy constants	*/
#define OFF	0			/* Define some handy constants	*/
#define TKNMIN  101
#define CONSTANTLEN   1
#define LENRANGE      2
#define AVERAGELEN    3
#define NORATE        0
#define CONSTANTRATE  1
#define LINEARRATE    2
#define RATEBITS      3
#define PRESIGN       1
#define POSTSIGN      2
#define ACCTSIGN      3
#define LPAD          1
#define RPAD          2
#define DCML          '.'
#define SEEDLEN       16

#define AFRNG         101
#define AIRNG         102
#define ALFA          103
#define AMT           104
#define DAY           105
#define DTRNG         106
#define EXP           107
#define FLRNG         108
#define HOUR          109
#define INT           110
#define INTRNG        111
#define JUL           112
#define LOG           113
#define LTR           114
#define MIN           115
#define MONTH         116
#define NUM           117
#define REAL          118
#define SEC           119
#define SEQ           120
#define SINE          121
#define SLCT          122
#define TEXT          123
#define TICKS         124
#define YEAR          125
#define SLCTISRT      126

/*									*/
/*      datagen data fields                                              */
/*									*/

typedef struct slctfmt {
   struct slctfmt *next;
   char *val;
   } slctfmt;

typedef struct dgfmt {
   unsigned char *sd;
   char *strptr;
   char *str;
   char *padstr;
   slctfmt *slcthead;
   slctfmt *slcttail;
   double loflrng;
   double hiflrng;
   double sinestep;
   double sinex;
   double prob;
   double mu;
   double lointrng;
   double hiintrng;
   int rcdnum;
   int opthndl;
   int verbose;
   int wtfact;
   int lentype;
   int fromlen;
   int tolen;
   int totlen;
   int padding;
   int dec;
   int sign;
   int slctmax;
   int trials;
   } dgfmt;

/* datagen routines */
int  opnopt(char *fname);
void cls(int hndl);
void putbyte(dgfmt *dg,int ch);
void dgalfa(dgfmt *dg);
void dgtext(dgfmt *dg);
void dgltr(dgfmt *dg,char *code);
void dgnum(dgfmt *dg);
void dgint(dgfmt *dg);
void dgreal(dgfmt *dg);
void dgamt(dgfmt *dg);
void dgintrng(dgfmt *dg);
void dgairng(dgfmt *dg);
void dgflrng(dgfmt *dg);
void dgafrng(dgfmt *dg);
void dgsine(dgfmt *dg);
void dgexp(dgfmt *dg);
void dglog(dgfmt *dg);
void dgbinom(dgfmt *dg);
void dgpois(dgfmt *dg);
void dgseq(dgfmt *dg);
void dgjul(dgfmt *dg);
double greg2jd(int year,int month,
   int day,double hour);
void jd2greg(double jd,
   int *year,int *month,int *day,
   int *hour,int *minute,double *second);
double astrint(double num);
void dgyear(dgfmt *dg);
void dgmonth(dgfmt *dg);
void dgday(dgfmt *dg);
void dghour(dgfmt *dg);
void dgmin(dgfmt *dg);
void dgsec(dgfmt *dg);
void dgdtrng(dgfmt *dg,double fromjd,
   double tojd,struct tm *t);
void dgticks(dgfmt *dg);
void dgslct(dgfmt *dg,slctfmt *slct);
dgfmt *dginit(void);
slctfmt *slctinit(dgfmt *dg);
void slctisrt(dgfmt *dg,
   slctfmt *slct,char *str);
void hxmem(unsigned char *mem,int len);
void puthx(int adr,int linelen,unsigned char *mem);
void putstx(char *pgm);
void putstr(int hndl,char *str);
void dgncpy(unsigned char *to,
   unsigned char *from,int len);
int  calclen(dgfmt *dg);
void dgpad(dgfmt *dg,int len);
void slp(int speed);
unsigned char *rndinit(void);
int rnd(unsigned char *sd);
unsigned int rndpwr(int bits,unsigned char *sd);
unsigned int rndnum(unsigned int lmt,unsigned char *sd);
double rndfrac(unsigned char *sd);
