/*
datagen.y - bison source for datagen
Release 1.4.0
Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Usage:
    	see makefile for compile instructions
*/

%{

/* Set YYDEBUG to 1 to insert debugging code */
/* and to turn on debugging in bison */
/* Run flex with the -d option to turn on flex debugging */

#define YYDEBUG 0

#define VERBOSE 2
#define YYSTYPE char *
#define CONSTANTLEN 0
#define LENRANGE 1
#define AVERAGELEN 2
#define NORATE 0
#define CONSTANTRATE 1
#define LINEARRATE 2
#define RATEBITS 3
#define DCML '.'
#define SEEDLEN 16
#define MAXBITS 31
#define DAYTICKS 8640000

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <sys/times.h>
#include <math.h>
#include <values.h>
#include "datagen.tab.h"
#include "rnd.h"

typedef struct fldfmt {
   struct fldfmt *next;
   struct slctfmt *slcthead;
   char *val;
   char *fldsep;
   char *padstr;
   char *fmtstr;
   unsigned char *seed;
   double loflrng;
   double hiflrng;
   double sinestep;
   double sinex;
   int lentype;
   int fromlen;
   int tolen;
   int totlen;
   int padding;
   int dec;
   int sign;
   int typ;
   int slctmax;
   int lointrng;
   int hiintrng;
   int dateadj;
   } fldfmt;

typedef struct rcdfmt {
   struct rcdfmt *next;
   fldfmt *fldhead;
   int totrcds;
   int reset;
   int ratetype;
   int fromrate;
   int torate;
   char *fldsep;
   } rcdfmt;

typedef struct slctfmt {
   struct slctfmt *next;
   char *val;
   } slctfmt;

int yydebug = YYDEBUG;
int slctnum,fromlgth,sgntype,rcdnum,fldnum;
int dbsw; /* debug switch */
int adjsecs;
char *wrkstr;
unsigned char *rseed;
unsigned char *dgfldsep;
rcdfmt *currcd,*newrcd,*rcdhead,*rcdtail;
fldfmt *curfld,*newfld,*head,*tail;
slctfmt *curslct,*newslct,*slcttail;
struct tm *dt;

void yyerror(char *msg);
int yylex();

void parsparm(argc,argv)
int argc;
char **argv;
   {
   int i;
   i = 0;
   printf("argc %d\n", argc);
   while (i < argc)
      {
      printf("%3d %s\n", i, *(argv+i));
      i++;
      } /* for each parm */
   exit(0);
   } /* parsparm */

/* show seed in big endian, hexadecimal format */
void shwseed(seed)
unsigned char *seed;
   {
   unsigned char *p,*q;
   p = seed + SEEDLEN;
   q = seed;
   while (p-- > q)
      fprintf(stderr,"%02x", *p);
   fprintf(stderr,"\n");
   }

fldfmt *initfld()
   {
   fldfmt *f;
   f = (fldfmt *) malloc(sizeof(fldfmt));
   if (f == NULL)
      {
      fprintf(stderr,"Out of memory "
         "allocating field definition\n");
      exit(1);
      }
   f->next = tail;
   f->fromlen =
   	f->tolen =
   	f->totlen =
   	f->dec =
   	f->sign =
   	f->typ =
   	f->lointrng =
   	f->hiintrng = 0;
   f->loflrng =
   	f->hiflrng =
   	f->sinestep =
   	f->sinex = 0.0;
   f->val =
   	f->fldsep =
   	f->padstr =
   	f->fmtstr =
   	f->seed = NULL;
   f->slcthead = slcttail;
   return(f);
   } /* initfld */

rcdfmt *initrcd()
   {
   rcdfmt *r;
   fldfmt *f;
   r = (rcdfmt *) malloc(sizeof(rcdfmt));
   if (r == NULL)
      {
      fprintf(stderr,"Out of memory "
         "allocating record definition\n");
      exit(1);
      }
   r->next = rcdtail;
   f = initfld();
   r->fldhead = f;
   r->totrcds = 1; 
   r->reset =
   	r->fromrate =
   	r->torate = 0;
   r->fldsep = NULL;
   r->ratetype = NORATE;
   curfld = r->fldhead;
   return(r);
   } /* initrcd */

slctfmt *initslct()
   {
   slctfmt *f;
   f = (slctfmt *) malloc(sizeof(slctfmt));
   if (f == NULL)
      {
      fprintf(stderr,"Out of memory "
         "allocating field select\n");
      exit(1);
      }
   f->next = slcttail;
   f->val = NULL;
   return(f);
   } /* initslct */

void shwlst(fldone)
fldfmt *fldone;
   {
   int i;
   fldfmt *f;
   slctfmt *m;
   f = fldone;
   if (f == tail)
      {
      fprintf(stderr,"empty list\n");
      return;
      }
   i = 0;
   while (f != tail)
      {
      i++;
      fprintf(stderr,"field %3d lentype %d fromlen %d "
         "tolen %d totlen %d dec %d\n"
         "padding %d loflrng %f hiflrng %f\n"
         "sinestep %f sinex %f\n"
         "lointrng %d hiintrng %d sign %d "
         "type %d slct %d dateadj %d \n"
         "fldsep <<%s>> val <<%s>> "
         "pad <<%s>> fmt <<%s>> seed %p\n",
         i, f->lentype, f->fromlen, f->tolen, f->totlen,
         f->dec, f->padding,
	 f->loflrng, f->hiflrng,
	 f->sinestep, f->sinex,
	 f->lointrng, f->hiintrng,
         f->sign, f->typ, f->slctmax, f->dateadj,
         f->fldsep, f->val, f->padstr,
         f->fmtstr, f->seed);
      m = f->slcthead->next;
      while (m != slcttail)
         {
         fprintf(stderr,"<<%s>>\n", m->val);
         m = m->next;
         }
      f = f->next;
      } /* field loop */
   } /* shwlst */

void shwrcd()
   {
   int i;
   rcdfmt *r;
   r = rcdhead->next;
   if (r == rcdtail)
      {
      fprintf(stderr,"no record formats to show\n");
      return;
      }
   i = 0;
   while (r != rcdtail)
      {
      i++;
      fprintf(stderr,"record %d\n", i);
      fprintf(stderr,"total records %d "
         "field sep <<%s>> reset seq %d\n"
         "ratetype %d fromrate %d torate %d\n",
         r->totrcds, r->fldsep, r->reset,
         r->ratetype, r->fromrate, r->torate);
      shwlst(r->fldhead->next);
      r = r->next;
      }
   } /* shwrcd */

void isrtrcd(new)
rcdfmt *new;
   {
   currcd->next = new;
   currcd = new;
   } /* isrtrcd */

void isrt(new)
fldfmt *new;
   {
   curfld->next = new;
   curfld = new;
   } /* isrt */

void isrtslct(new)
slctfmt *new;
   {
   curslct->next = new;
   curslct = new;
   } /* isrtslct */

%}

%token RECORD ENDRCD POSFLOAT NEGFLOAT RESETSEQ
%token TOTRCDS SEED FLDSEED FLDSEP
%token FIELD LEN AVGLEN ALPHA JULIANDAY
%token NUMERIC SELECT ENDSELECT FULLDATE DATERANGE 
%token FORMAT DATE DAYS TIME TOTLEN LPAD RPAD
%token REAL DECIMALS LETTERS TEXT SECONDS TICKS
%token PAUSE PAUSERANGE AVGPAUSE PAUSEBITS
%token INTEGER OUTPUTRATE AVGRATE
%token SEQUENCE INTRANGE FLRANGE AVGFLRANGE AVGINTRANGE
%token PRESIGN POSTSIGN ACCTSIGN
%token SINEWAVE PERIOD MAGNITUDE AXIS
%token AMOUNT BITS TO QSTR SEP NUM NEGNUM ENDFLD
%token YEAR MONTH DAY HOUR MINUTE SECOND

%%

srcdef:		glbldefs rcdbldexp glblexp fldlst
		= {
		if (dbsw)
		   fprintf(stderr,"end of source "
		   "with implied record definition\n");
		}

		| glbldefs rcddef
		= {
		if (dbsw)
		   fprintf(stderr,"end of source "
		   "with explicit record definition\n");
		}
		;

rcddef:		RECORD datagdef
		= {
		if (dbsw)
		   fprintf(stderr,"end of first record\n");
		}
		| rcddef RECORD datagdef
		= {
		if (dbsw)
		   fprintf(stderr,"end of multiple records\n");
		}
		;

glbldefs:	/* empty def */
		= {
		if (dbsw)
		   fprintf(stderr,"no seedexp "
		   "& no global fldsep\n");
		}
		| seedexp
		= {
		if (dbsw)
		   fprintf(stderr,"seedexp done\n");
		}
		| glbdgfldsep
		= {
		if (dbsw)
		   fprintf(stderr,"global field "
		      "separator done\n");
		}
		| seedexp glbdgfldsep
		= {
		if (dbsw)
		   fprintf(stderr,"seedexp & global "
		      "field separator done\n");
		}
		| glbdgfldsep seedexp
		= {
		if (dbsw)
		   fprintf(stderr,"global field "
		      "separator & seedexp done\n");
		}
		;

/* initialize seed to an ASCII string */
/* for regression testing */

seedexp:	SEED '=' QSTR
		= {
		unsigned char *p,*q,*r;
		int len;
		len = strlen(yylval+1) - 1;
		if (len > SEEDLEN)
		   {
		   fprintf(stderr,"seed len %d too long\n",
		      len);
		   exit(1);
		   }
		p = sd;
		q = sd + SEEDLEN + 1;
		while (p < q) *p++ = '\0';
		p = yylval + 1;
		q = sd;
		r = sd + len;
		while (q < r) *q++ = *p++;
		*sd |= 1;
		if (dbsw)
		   fprintf(stderr,"len %d seed <<%s>>\n",
		      len, sd);
		}
		;

glbdgfldsep:	/* empty */
		= {
		dgfldsep = " ";
		if (dbsw)
		   fprintf(stderr,"global default field "
		      "separator is blank\n");
		}
		| FLDSEP '=' QSTR
		= {
		int len;
		dgfldsep = yylval+1;
		len = strlen(dgfldsep) - 1;
		dgfldsep[len] = '\0';
		if (dbsw)
		   fprintf(stderr,"len %d global field "
		      "separator <<%s>>\n",
		      len, dgfldsep);
		}
		;

datagdef:	rcdbldexp glblexp fldlst
		= {
		if (dbsw)
		   {
		   fprintf(stderr,"no endrcd\n");
		   fprintf(stderr,"end of record definition\n");
		   } /* if debug */
		}

		| rcdbldexp glblexp fldlst ENDRCD
		= {
		if (dbsw)
		   {
		   fprintf(stderr,"endrcd done\n");
		   fprintf(stderr,"end of record definition\n");
		   } /* if debug */
		}
		;

rcdbldexp:	/* empty */
		= {
		newrcd = initrcd();
		isrtrcd(newrcd);
		if (dbsw == VERBOSE) shwrcd();
		fldnum = 0;
		if (dbsw)
		   fprintf(stderr,"new record "
		      "inserted in list\n");
		}
		;

glblexp:	totrcdexp glbfldsep resetexp outrateexp
		= {
		if (dbsw)
		   fprintf(stderr,"glblexp: totrcdexp "
		      "& glbfldsep & resetexp done\n");
		}

		| glbfldsep totrcdexp resetexp outrateexp
		= {
		if (dbsw)
		   fprintf(stderr,"glblexp: glbfldsep "
		      "& totrcdexp & resetexp done\n");
		}
		;

totrcdexp:	/* empty */
		= {
		newrcd->totrcds = 1;
		if (dbsw)
		   fprintf(stderr,"default totrcds = 1\n");
		}

		| TOTRCDS '=' NUM
		= {
		int len;
		len = strlen(yylval);
		if (len > 8)
		   {
		   yyerror("totrcds too long");
		   }
		newrcd->totrcds = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"totrcds %s\n", yylval);
		}
		;

glbfldsep:	/* empty */
		= {
		currcd->fldsep = (unsigned char *) dgfldsep;
		if (dbsw)
		   fprintf(stderr,"default field "
		      "separator is <<%s>>\n",
		      dgfldsep);
		}

		| FLDSEP '=' QSTR
		= {
		int len;
		currcd->fldsep = yylval+1;
		len = strlen(currcd->fldsep) - 1;
		currcd->fldsep[len] = '\0';
		if (dbsw)
		   fprintf(stderr,"len %d field separator <<%s>>\n",
		      len, currcd->fldsep);
		}
		;

resetexp:	/* empty */
		= {
		currcd->reset = 0;
		if (dbsw)
		   fprintf(stderr,"do not reset sequence number\n");
		}

		| RESETSEQ
		= {
		currcd->reset = 1;
		if (dbsw)
		   fprintf(stderr,"reset sequence number\n");
		}
		;

outrateexp:	/* empty */
		= {
		currcd->fromrate =
		   currcd->torate = 0;
		currcd->ratetype = NORATE;
		if (dbsw)
		   fprintf(stderr,"no output rate\n");
		}

		| OUTPUTRATE '=' NUM 
		= {
		currcd->fromrate = atoi(yylval);
		currcd->ratetype = CONSTANTRATE;
		if (dbsw)
		   fprintf(stderr,"output rate "
		   "%d\n", currcd->fromrate);
		}

		| OUTPUTRATE fromrateexp torateexp
		= {
		currcd->ratetype = LINEARRATE;
		if (dbsw)
		   fprintf(stderr,"record output "
		      "rate:  rate = %d "
		      "to %d\n",
		      currcd->fromrate,
		      currcd->torate);
		}

		| AVGRATE fromrateexp torateexp
		= {
		currcd->ratetype = AVGRATE;
		if (dbsw)
		   fprintf(stderr,"record average "
		      "output rate done\n");
		}

		| OUTPUTRATE ratebitsexp
		= {
		if (dbsw)
		   fprintf(stderr,"record variable "
		      "rate = %d bits\n",
		      currcd->fromrate);
		}
		;

fromrateexp:	NUM
		= {
		currcd->fromrate = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"record: from "
		      "output rate %s\n", yylval);
		}
		;

torateexp:	TO NUM
		= {
		currcd->torate = atoi(yylval);
		if (currcd->fromrate >
		   currcd->torate)
		   {
		   fprintf(stderr,"record: "
		      "from_rate %d > to_rate %d \n",
		      currcd->fromrate, currcd->torate);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"record: to "
		      "output rate %s\n", yylval);
		}
		;

ratebitsexp:	BITS '=' NUM
		= {
		currcd->fromrate = atoi(yylval);
		currcd->ratetype = RATEBITS;
		if (currcd->fromrate < 1)
		   {
		   fprintf(stderr,"record: "
		      "outputrate bits %d < 1\n",
		      currcd->fromrate);
		   exit(1);
		   }
		else if (currcd->fromrate > MAXBITS)
		   {
		   fprintf(stderr,"record: "
		      "varrate %d > %d bits\n",
		      currcd->fromrate, MAXBITS);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"record output "
		      "rate = %s bits\n", yylval);
		}
		;

fldlst:		flddef
		= {
		fldnum++;
		if (dbsw)
		   fprintf(stderr,"first field %d done\n",
		      fldnum);
		adjsecs = 0;
		}

		| fldlst flddef
		= {
		fldnum++;
		if (dbsw)
		   fprintf(stderr,"field %d done\n",
		      fldnum);
		adjsecs = 0;
		}
		;

flddef:		FIELD fldexp fldsepexp ENDFLD
		= {
		if (dbsw)
		   fprintf(stderr,"field def endfld done\n");
		}

		| FIELD fldexp fldsepexp ';'
		= {
		if (dbsw)
		   fprintf(stderr,"field def semi done\n");
		}

		| fldexp fldsepexp ENDFLD
		= {
		if (dbsw)
		   fprintf(stderr,"(field) def endfld done\n");
		}

		| fldexp fldsepexp ';'
		= {
		if (dbsw)
		   fprintf(stderr,"(field) def semi done\n");
		}

		| PAUSE '=' NUM 
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = PAUSE;
		newfld->fromlen = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"field constant "
		   "pause %d\n", newfld->fromlen);
		}

		| PAUSERANGE lopauserng hipauserng
		= {
		if (dbsw)
		   fprintf(stderr,"field pause " 
		      "range done\n");
		}

		| AVGPAUSE avglopauserng avghipauserng
		= {
		if (dbsw)
		   fprintf(stderr,"field average "
		      "pause done\n");
		}

		| PAUSEBITS '=' NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = PAUSEBITS;
		newfld->fromlen = atoi(yylval);
		if (newfld->fromlen < 1)
		   {
		   fprintf(stderr,"field: "
		      "pause bits %d < 1\n",
		      newfld->fromlen);
		   exit(1);
		   }
		else if (newfld->fromlen > MAXBITS)
		   {
		   fprintf(stderr,"field: "
		      "pause bits %d > %d bits\n",
		      newfld->fromlen, MAXBITS);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"field logarithmic "
		      "pause done\n");
		}
		;

fldexp:		len type fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field len type done\n");
		}

		| avglen type fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field avglen done\n");
		}
		
		| ALPHA len padexp fldsdexp
		= {
		newfld->typ = ALPHA;
		if (dbsw)
		   fprintf(stderr,"alpha\n");
		}

		| ALPHA avglen padexp fldsdexp
		= {
		newfld->typ = ALPHA;
		if (dbsw)
		   fprintf(stderr,"alpha\n");
		}

		| TEXT len fldsdexp
		= {
		newfld->typ = TEXT;
		if (dbsw)
		   fprintf(stderr,"text\n");
		}
		
		| TEXT avglen fldsdexp
		= {
		newfld->typ = TEXT;
		if (dbsw)
		   fprintf(stderr,"text\n");
		}
		
		| quotedstring
		= {
		if (dbsw)
		   fprintf(stderr,"field constant done\n");
		}
		
		| selectdef fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field select def done\n");
		}
		
		| LETTERS '=' ltrmyalphabet ltrlen
		   padexp fldsdexp
		= {
		newfld->typ = LETTERS;
		if (dbsw)
		   fprintf(stderr,"letters\n");
		}
		
		| LETTERS '=' ltrmyalphabet ltravglen
		   padexp fldsdexp
		= {
		newfld->typ = LETTERS;
		if (dbsw)
		   fprintf(stderr,"letters\n");
		}
		
		| AMOUNT bitsdef decimaldef signexp fldsdexp
		= {
		newfld->typ = AMOUNT;
		if (dbsw)
		   fprintf(stderr,"field amount done\n");
		}
		
		| NUMERIC len fldsdexp
		= {
		newfld->typ = NUMERIC;
		if (dbsw)
		   fprintf(stderr,"field numeric done\n");
		}
		
		| NUMERIC avglen fldsdexp
		= {
		newfld->typ = NUMERIC;
		if (dbsw)
		   fprintf(stderr,"field numeric done\n");
		}
		
		| INTEGER bitlen fldsdexp
		= {
		newfld->typ = INTEGER;
		if (newfld->fromlen > 1024
		   || newfld->tolen > 1024)
		   {
		   yyerror("integer bit length too long");
		   }
		if (dbsw)
		   fprintf(stderr,"field integer done\n");
		}
		
		| REAL len realexp signexp fldsdexp
		= {
		newfld->typ = REAL;
		if (dbsw)
		   fprintf(stderr,"field real done\n");
		}
		
		| REAL avglen realexp signexp fldsdexp
		= {
		newfld->typ = REAL;
		if (dbsw)
		   fprintf(stderr,"field real done\n");
		}
		
		| FLRANGE lowflrange highflrange fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field float range done\n");
		}
		
		| AVGFLRANGE avglowflrange highflrange
			rnglen fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field avg float range done\n");
		}
		
		| INTRANGE lowintrange highintrange
			rnglen fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field integer range done\n");
		}
		
		| AVGINTRANGE avglowintrange highintrange
			rnglen fldsdexp
		= {
		if (dbsw)
		   fprintf(stderr,"field avg intgr range done\n");
		}
		
		| seqexp rnglen
		= {
		if (dbsw)
		   fprintf(stderr,"field sequence done\n");
		}
		
		| sinexp decimaldef
		= {
		if (dbsw)
		   fprintf(stderr,"field sinewave done\n");
		}
		
		| fulldateexp
		= {
		if (dbsw)
		   fprintf(stderr,"field fulldate done\n");
		}
		
		| daterangeexp
		= {
		if (dbsw)
		   fprintf(stderr,"field daterange done\n");
		}
		
		| dateexp
		= {
		if (dbsw)
		   fprintf(stderr,"field date done\n");
		}
		
		| timeexp
		= {
		if (dbsw)
		   fprintf(stderr,"field time done\n");
		}
		
		| YEAR
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = YEAR;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"year %04d\n", dt->tm_year+1900);
		}
		
		| MONTH
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = MONTH;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"month %02d\n", dt->tm_mon+1);
		}
		
		| DAY
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = DAY;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"day %02d\n", dt->tm_mday);
		}
		
		| JULIANDAY
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = JULIANDAY;
		newfld->fromlen = newfld->totlen = 3;
		if (dbsw)
		   fprintf(stderr,"julianday %03d\n", dt->tm_yday);
		}
		
		| HOUR
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = HOUR;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"hour %02d\n", dt->tm_hour);
		}
		
		| MINUTE
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = MINUTE;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"minute %02d\n", dt->tm_min);
		}
		
		| SECOND
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = SECOND;
		newfld->fromlen = newfld->totlen = 2;
		if (dbsw)
		   fprintf(stderr,"second %02d\n", dt->tm_sec);
		}
		
		| TICKS
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = TICKS;
		if (dbsw)
		   fprintf(stderr,"field ticks computed at run time\n");
		}
		;

len:		LEN '=' NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->fromlen = atoi(yylval);
		newfld->lentype = CONSTANTLEN;
		if (newfld->fromlen < 1)
		   {
		   yyerror("field length < 1");
		   }
		if (dbsw)
		   fprintf(stderr,"len %s\n", yylval);
		}
		| LEN '=' fromlen tolen
		= {
		newfld->lentype = LENRANGE;
		if (newfld->fromlen > newfld->tolen)
		   {
		   yyerror("from field length > to field length");
		   }
		if (dbsw)
		   fprintf(stderr,"len = fromlen to tolen done\n");
		}
		;

avglen:		AVGLEN '=' fromlen tolen
		= {
		newfld->lentype = AVERAGELEN;
		if (newfld->fromlen > newfld->tolen)
		   {
		   yyerror("from avg length > to avg length");
		   }
		if (dbsw)
		   fprintf(stderr,"average len\n");
		}
		;

fromlen:	NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->fromlen = atoi(yylval);
		if (newfld->fromlen < 1)
		   {
		   yyerror("from field length < 1");
		   }
		if (dbsw)
		   fprintf(stderr,"from len %s\n",
		      yylval);
		}
		;

tolen:		TO NUM
		= {
		newfld->tolen = atoi(yylval);
		if (newfld->totlen &&
		   newfld->tolen > newfld->totlen)
		   {
		   fprintf(stderr,"tolen: tolen %d > "
		      "totlen %d \n",
		      newfld->tolen, newfld->totlen);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"to len %s\n",
		      yylval);
		}
		;

ltrlen:		LEN '=' NUM
		= {
		newfld->fromlen = atoi(yylval);
		newfld->lentype = CONSTANTLEN;
		if (newfld->fromlen < 1)
		   {
		   yyerror("field length < 1");
		   }
		if (dbsw)
		   fprintf(stderr,"len %s\n", yylval);
		}
		| LEN '=' ltrfromlen tolen
		= {
		newfld->lentype = LENRANGE;
		if (newfld->fromlen > newfld->tolen)
		   {
		   yyerror("from field length > to field length");
		   }
		if (dbsw)
		   fprintf(stderr,"len = fromlen to tolen done\n");
		}
		;

ltravglen:	AVGLEN '=' ltrfromlen tolen
		= {
		newfld->lentype = AVERAGELEN;
		if (newfld->fromlen > newfld->tolen)
		   {
		   yyerror("from avg length > to avg length");
		   }
		if (dbsw)
		   fprintf(stderr,"average len\n");
		}
		;

ltrfromlen:	NUM
		= {
		newfld->fromlen = atoi(yylval);
		if (newfld->fromlen < 1)
		   {
		   yyerror("from field length < 1");
		   }
		if (dbsw)
		   fprintf(stderr,"from len %s\n",
		      yylval);
		}
		;

type:		ALPHA padexp
		= {
		newfld->typ = ALPHA;
		if (dbsw)
		   fprintf(stderr,"alpha\n");
		}

		| LETTERS '=' myalphabet padexp
		= {
		newfld->typ = LETTERS;
		if (dbsw)
		   fprintf(stderr,"letters\n");
		}
		
		| TEXT
		= {
		newfld->typ = TEXT;
		if (dbsw)
		   fprintf(stderr,"text\n");
		}
		
		| REAL realexp signexp
		= {
		if (dbsw)
		   fprintf(stderr,"real done\n");
		}
		
		| NUMERIC
		= {
		newfld->typ = NUMERIC;
		if (dbsw)
		   fprintf(stderr,"numeric\n");
		}
		;

padexp:		/* empty */
		= {
		if (dbsw)
		   fprintf(stderr,"no padding\n");
		}

		| totlenexp justexp
		= {
		if (dbsw)
		   fprintf(stderr,"padding expression done\n");
		}
		;

totlenexp:	TOTLEN '=' NUM
		= {
		newfld->totlen = atoi(yylval);
		if (newfld->totlen &&
		   newfld->tolen > newfld->totlen)
		   {
		   fprintf(stderr,"totlenexp tolen %d > "
		      "totlen %d \n",
		      newfld->tolen, newfld->totlen);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"total length <<%s>>\n",
		      yylval);
		if (dbsw)
		   fprintf(stderr,"total length %d\n",
		      newfld->totlen);
		}
		;

justexp:	LPAD '=' QSTR
		= {
		int len;
		char *k,*p;
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating left padding\n");
		   exit(1);
		   }
		p = yylval+1;
			strcpy(k,p);
		*(k+len-2) = '\0';
			newfld->padstr = k;
		newfld->padding = LPAD;
		if (dbsw)
		   fprintf(stderr,"Left padding "
		   	"<<%s>>\n", k);
		}

		| RPAD '=' QSTR
		= {
		int len;
		char *k,*p;
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating right padding\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		newfld->padstr = k;
		newfld->padding = RPAD;
		if (dbsw)
		   fprintf(stderr,"Right padding "
		   	"<<%s>>\n", k);
		}
		;

realexp:	DECIMALS '=' NUM
		= {
		newfld->typ = REAL;
		newfld->dec = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"real decimals <<%s>>\n",
		      yylval);
		if (dbsw)
		   fprintf(stderr,"real type %d\n",
		      newfld->typ);
		if (dbsw)
		   fprintf(stderr,"real dec %d\n",
		      newfld->dec);
		}
		;

signexp:	PRESIGN
		= {
		newfld->sign = PRESIGN;
		if (dbsw)
		   fprintf(stderr,"real presign\n");
		}

		| POSTSIGN
		= {
		newfld->sign = POSTSIGN;
		if (dbsw)
		   fprintf(stderr,"real postsign\n");
		}
		
		| ACCTSIGN
		= {
		newfld->sign = ACCTSIGN;
		if (dbsw)
		   fprintf(stderr,"real acctsign\n");
		}
		;

bitsdef:	BITS '=' NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->fromlen = atoi(yylval);
		newfld->lentype = CONSTANTLEN;
		if (newfld->fromlen < 1)
		   {
		   fprintf(stderr,"amount bits <<%s>>\n",
		      yylval);
		   yyerror("amount bits < 1"); 
		   }
		else if (newfld->fromlen > MAXBITS)
		   {
		   fprintf(stderr,"amount bits <<%s>>\n",
		      yylval);
		   yyerror("bits > MAXBITS"); 
		   }
		if (dbsw)
		   fprintf(stderr,"amount bits <<%s>>\n",
		      yylval);
		}
		| BITS '=' fromlen tolen
		= {
		newfld->lentype = LENRANGE;
		if (newfld->fromlen < 1)
		   {
		   fprintf(stderr,"amount from bits: %s\n",
		      yylval);
		   yyerror("amount bits < 1"); 
		   }
		else if (newfld->tolen < 1)
		   {
		   fprintf(stderr,"amount to bits: %s\n",
		      yylval);
		   yyerror("amount bits < 1"); 
		   }
		else if (newfld->fromlen > MAXBITS)
		   {
		   fprintf(stderr,"amount from bits "
		      "too long: %d\n", newfld->fromlen);
		   yyerror("from bits > MAXBITS"); 
		   }
		else if (newfld->tolen > MAXBITS)
		   {
		   fprintf(stderr,"amount to bits "
		      "too long: %d\n", newfld->tolen);
		   yyerror("to bits > MAXBITS"); 
		   }
		if (dbsw)
		   fprintf(stderr,"amount bits range done\n");
		}
		;

bitlen:		BITS '=' NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->fromlen = atoi(yylval);
		newfld->lentype = CONSTANTLEN;
		if (newfld->fromlen < 1)
		   {
		   yyerror("field length < 1");
		   }
		if (dbsw)
		   fprintf(stderr,"bits %s\n", yylval);
		}
		| BITS '=' fromlen tolen
		= {
		newfld->lentype = LENRANGE;
		if (newfld->fromlen > newfld->tolen)
		   {
		   yyerror("from field length > to field length");
		   }
		if (dbsw)
		   fprintf(stderr,"bits = fromlen to tolen done\n");
		}
		;

decimaldef:	DECIMALS '=' NUM
		= {
		newfld->dec = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"amount decimals <<%s>>\n",
		      yylval);
		}
		;

myalphabet:	QSTR
		= {
		int len;
		char *k,*p;
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating special alphabet\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		newfld->val = k;
		newfld->typ = LETTERS;
		if (dbsw)
		   fprintf(stderr,"letters <<%s>>\n",
			 k);
		}
		;

ltrmyalphabet:		QSTR
		= {
		int len;
		char *k,*p;
		newfld = initfld();
		isrt(newfld);
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating special alphabet\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		newfld->val = k;
		newfld->typ = LETTERS;
		if (dbsw)
		   fprintf(stderr,"letters <<%s>>\n",
			 k);
		}
		;

selectdef:	SELECT selectlist ENDSELECT
		= {
		newfld->slctmax = slctnum;
		slctnum = 0;
		if (dbsw)
		   fprintf(stderr,"end selectdef %d\n",
		      newfld->slctmax);
		}
		;

selectlist:	slctconst
		= {
		if (dbsw)
		   fprintf(stderr,"single select list\n");
		}
		| selectlist slctconst
		= {
		if (dbsw)
		   fprintf(stderr,"multiple select list\n");
		}
		;

slctconst:	QSTR
		= {
		int len;
		char *k,*p;
		slctfmt *m;
		if (!slctnum)
		   {
		   if (dbsw)
		      fprintf(stderr,"new select list\n");
		   newfld = initfld();
		   isrt(newfld);
		   newfld->typ = SELECT;
		   newfld->slcthead = initslct();
		   curslct = newfld->slcthead;
		   }
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating field select\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		m = initslct();
		isrtslct(m);
		m->val = k;
		slctnum++;
		if (dbsw)
		   fprintf(stderr,"select %d value <<%s>>\n",
			 slctnum, k);
		}
		;

quotedstring:	QSTR
		= {
		int len;
		char *k,*p;
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating quoted string\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		newfld = initfld();
		isrt(newfld);
		newfld->val = k;
		newfld->typ = QSTR;
		if (dbsw)
		   fprintf(stderr,"constant <<%s>>\n",
			 k);
		}
		;

lowintrange:	NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = INTRANGE;
		newfld->lointrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"lo intrng num <<%s>>\n",
			yylval);
		}

		| NEGNUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = INTRANGE;
		newfld->lointrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"lo intrng negnum <<%s>>\n",
			yylval);
		}
		;

lowflrange:	POSFLOAT
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = FLRANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"lo flrng posfloat <<%s>>\n",
			yylval);
		}

		| NEGFLOAT
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = FLRANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"lo flrng negfloat <<%s>>\n",
			yylval);
		}
		;

highintrange:	TO NUM
		= {
		newfld->hiintrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"hi intrng num <<%s>>\n",
			yylval);
		}

		| TO NEGNUM
		= {
		newfld->hiintrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"hi intrng negnum <<%s>>\n",
			yylval);
		}
		;

highflrange:	TO POSFLOAT
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"hi flrng posfloat <<%s>>\n",
			yylval);
		}

		| TO NEGFLOAT
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"hi flrng negfloat <<%s>>\n",
			yylval);
		}
		;

rnglen:		/* empty */
		= {
		newfld->fromlen = 0;
		newfld->lentype = CONSTANTLEN;
		if (dbsw)
		   fprintf(stderr,"no rangelen\n");
		}

		| LEN '=' NUM
		= {
		newfld->fromlen = atoi(yylval);
		newfld->lentype = CONSTANTLEN;
		if (newfld->fromlen < 1)
		   yyerror("range field length < 1");
		if (dbsw)
		   fprintf(stderr,"rangelen %s\n", yylval);
		}
		;

avglowintrange:		NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = AVGINTRANGE;
		newfld->lointrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"avg lointrng num <<%s>>\n",
			yylval);
		}

		| NEGNUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = AVGINTRANGE;
		newfld->lointrng = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"avg lointrng negnum <<%s>>\n",
			yylval);
		}
		;

avglowflrange:	POSFLOAT
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = AVGFLRANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"avg loflrng posfloat <<%s>>\n",
			yylval);
		}

		| NEGFLOAT
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = AVGFLRANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"avg loflrng negfloat <<%s>>\n",
			yylval);
		}
		;

seqexp:		SEQUENCE
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = SEQUENCE;
		if (dbsw)
		   fprintf(stderr,"sequence number\n");
		}
		;

sinexp:		SINEWAVE periodexp magnitudeexp axisexp
		= {
		if (dbsw)
		   fprintf(stderr,"sinewave expression done\n");
		}
		;

periodexp:	PERIOD '=' NUM
		= {
		int tmp;
		newfld = initfld();
		isrt(newfld);
		newfld->typ = SINEWAVE;
		tmp = atoi(yylval);
		if (tmp < 2)
		   {
		   yyerror("sinewave period is less than 2");
		   } /* invalid period */
		newfld->sinestep = (double) (M_PI + M_PI) / tmp;
		newfld->sinex = -newfld->sinestep;
		if (dbsw)
		   fprintf(stderr,"sinewave period %s\n",
		      yylval);
		}
		;

magnitudeexp:	/* empty */
		= {
		newfld->loflrng = 1.0;
		if (dbsw)
		   fprintf(stderr,"default sinewave magnitude\n");
		}

		| MAGNITUDE '=' POSFLOAT
		= {
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"positive sinewave magnitude %s\n",
		      yylval);
		}

		| MAGNITUDE '=' NEGFLOAT
		= {
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"negative sinewave magnitude %s\n",
		      yylval);
		}
		;

axisexp:	/* empty */
		= {
		newfld->hiflrng = 0.0;
		if (dbsw)
		   fprintf(stderr,"default sinewave axis\n");
		}

		| AXIS '=' POSFLOAT
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"positive sinewave axis %s\n",
		      yylval);
		}

		| AXIS '=' NEGFLOAT
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"negative sinewave axis %s\n",
		      yylval);
		}
		;

fulldateexp:	FULLDATE adjtimeexp
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = FULLDATE;
		newfld->dateadj = adjsecs;
		if (dbsw)
		   fprintf(stderr,"fulldate done\n");
		}
		;

daterangeexp:	DATERANGE fromjdexp tojdexp dtrngfmtexp
		= {
		if (dbsw)
		   fprintf(stderr,"daterange done\n");
		}
		;

fromjdexp:	POSFLOAT 
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = DATERANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"fromjdexp posfloat <<%s>>\n",
			yylval);
		}

		| NEGFLOAT
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = DATERANGE;
		newfld->loflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"fromjdexp negfloat <<%s>>\n",
			yylval);
		}
		;

tojdexp:	TO POSFLOAT 
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"tojdexp posfloat <<%s>>\n",
			yylval);
		}

		| TO NEGFLOAT
		= {
		newfld->hiflrng = atof(yylval);
		if (dbsw)
		   fprintf(stderr,"tojdexp negfloat <<%s>>\n",
			yylval);
		}
		;

dtrngfmtexp:	FORMAT '=' QSTR
		= {
		int len;
		char *k,*p;
		len = strlen(yylval);
		k = (char *) malloc(len+1);
		if (k == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating quoted string\n");
		   exit(1);
		   }
		p = yylval+1;
		strcpy(k,p);
		*(k+len-2) = '\0';
		newfld->fmtstr = k;
		if (dbsw)
		   fprintf(stderr,"date range format "
		   	"<<%s>>\n", k);
		}
		;

timeexp:	TIME adjtimeexp
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = TIME;
		newfld->dateadj = adjsecs;
		if (dbsw)
		   fprintf(stderr,"time done\n");
		}
		;

dateexp:	DATE adjdateexp
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = DATE;
		newfld->dateadj = adjsecs;
		if (dbsw)
		   fprintf(stderr,"date done\n");
		}
		;

adjdateexp:	/* empty */
		= {
		adjsecs = 0;
		if (dbsw)
		   fprintf(stderr,"no date adjustment\n");
		}

		| shftdateexp DAYS
		= {
		if (dbsw)
		   fprintf(stderr,"date adjustment done\n");
		}
		;

adjtimeexp:	/* empty */
		= {
		adjsecs = 0;
		if (dbsw)
		   fprintf(stderr,"no time adjustment\n");
		}

		| shfttimeexp SECONDS
		= {
		if (dbsw)
		   fprintf(stderr,"time adjustment done\n");
		}
		;

shftdateexp:	'+' NUM
		= {
		adjsecs = atoi(yylval);
		adjsecs *= 3600;
		adjsecs *= 24;
		if (dbsw)
		   fprintf(stderr,"date adj %d seconds "
		   	"<<%s>> days\n",
		   	adjsecs, yylval);
		}

		| '-' NUM
		= {
		int i;
		i = atoi(yylval);
		adjsecs = -i * 3600 * 24;
		if (dbsw)
		   fprintf(stderr,"date adj %d seconds "
		   	"<<%s>> days\n",
		   	adjsecs, yylval);
		}
		;

shfttimeexp:	'+' NUM
		= {
		adjsecs = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"date adj %d <<%s>> seconds\n",
		      adjsecs, yylval);
		}

		| '-' NUM
		= {
		int i;
		i = atoi(yylval);
		adjsecs = -i;
		if (dbsw)
		   fprintf(stderr,"date adj %d <<%s>> seconds\n",
		      adjsecs, yylval);
		}
		;

fldsdexp:	/* empty */
		= {
		newfld->seed = NULL;
		if (dbsw)
		      fprintf(stderr,"no field seed\n");
		}

		| FLDSEED '=' QSTR
		= {
		unsigned char *p,*q,*r;
		int len,holdyyn;
		void getmd5(unsigned char *oldseed,
		   int seedlen, unsigned char *newseed);
		len = strlen(yylval+1) - 1;
		if (len > SEEDLEN)
		   {
		   fprintf(stderr,"field seed len %d too long\n",
		      len);
		   yyerror("field seed too long");
		   }
		newfld->seed = (unsigned char *)
		   malloc(SEEDLEN+16);
		if (newfld->seed == NULL)
		   {
		   fprintf(stderr,"Out of memory "
		      "allocating field password\n");
		   exit(1);
		   }
		p = (unsigned char *) newfld->seed;
		q = (unsigned char *) newfld->seed + SEEDLEN + 1;
		while (p < q) *p++ = '\0';
		p = (unsigned char *) yylval + 1;
		q = (unsigned char *) newfld->seed;
		r = (unsigned char *) newfld->seed + len;
		while (q < r) *q++ = *p++;
		*q = '\0';
		q = (unsigned char *) newfld->seed;
		*q |= 1;
		if (dbsw)
		   fprintf(stderr,"len %d field seed <<%s>>\n",
		      len, newfld->seed);
		/* this save and restore of yyn is a workaround */
		/* for a bison bug */
		holdyyn = yyn;
		getmd5(newfld->seed,SEEDLEN,newfld->seed);
		yyn = holdyyn;
		}
		;

fldsepexp:	/* empty */
		= {
		newfld->fldsep = NULL;
		if (dbsw)
		   fprintf(stderr,"no fldsep at "
		   "the field level\n");
		}

		| FLDSEP '=' QSTR 
		= {
		int len;
		curfld->fldsep = yylval+1;
		len = strlen(curfld->fldsep);
		curfld->fldsep[len-1] = '\0';
		if (dbsw)
		   fprintf(stderr,"len %d field separator <<%s>>\n",
		      len-1, curfld->fldsep);
		}
		;

lopauserng:	NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = PAUSERANGE;
		newfld->fromlen = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"average "
		      "from pause %s\n", yylval);
		}
		;

hipauserng:	TO NUM
		= {
		newfld->tolen = atoi(yylval);
		if (newfld->fromlen >
		   newfld->tolen)
		   {
		   fprintf(stderr,"field: "
		      "frompause %d > topause %d \n",
		      newfld->fromlen, newfld->tolen);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"average "
		      "to pause %s\n", yylval);
		}
		;

avglopauserng:	NUM
		= {
		newfld = initfld();
		isrt(newfld);
		newfld->typ = AVGPAUSE;
		newfld->fromlen = atoi(yylval);
		if (dbsw)
		   fprintf(stderr,"average "
		      "from pause %s\n", yylval);
		}
		;

avghipauserng:	TO NUM
		= {
		newfld->tolen = atoi(yylval);
		if (newfld->fromlen >
		   newfld->tolen)
		   {
		   fprintf(stderr,"field: "
		      "frompause %d > topause %d \n",
		      newfld->fromlen, newfld->tolen);
		   exit(1);
		   }
		if (dbsw)
		   fprintf(stderr,"average "
		      "to pause %s\n", yylval);
		}
		;

%%

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s <#records>\n", pgm);
   exit(1);
   }

void yyerror(msg)
char *msg;
   {
   fprintf(stderr,"%s\n", msg);
   exit(1);
   } /* yyerror */

void pauseticks(ticks)
int ticks;
   {
   int rslt;
   struct tms t;
   clock_t origclk,clk,wtclk;
   struct timespec request;
   struct timespec remain;
   origclk = times(&t);
   fflush(stdout);
   clk = origclk;
   wtclk = origclk + ticks;
   while (clk < wtclk)
      {
      clk = times(&t);
      if (clk < origclk) clk += DAYTICKS;
      request.tv_sec  = (long int) 0;
      request.tv_nsec = (long int) 1;
      rslt = nanosleep(&request,&remain);
      if (rslt < 0)
         {
         fprintf(stderr,"Nanosleep error %d\n", errno);
         perror("Nanosleep error");
         exit(1);
         } /* nanosleep error */
      } /* wait loop */
   } /* pauseticks */

void OutputRateBits(r)
rcdfmt *r;
   {
   int ticks,size;
   ticks = 0;
   size = rndnum(r->fromrate,rseed);
   size++;
   if (size > 0)
      ticks = rndpwr(size,rseed);
   if (ticks > 0)
      pauseticks(ticks);
   } /* OutputRateBits */

void OutputAvgRate(r)
rcdfmt *r;
   {
   int i,diff,ticks;
   diff = r->torate - r->fromrate + 1;
   ticks = 0;
   for (i=0;i<4;i++)
      {
      ticks += r->fromrate
         + rndnum(diff,rseed);
      }
   ticks >>= 2;
   pauseticks(ticks);
   } /* OutputAvgRate */

void OutputRateRange(r)
rcdfmt *r;
   {
   int diff,ticks;
   diff = r->torate - r->fromrate + 1;
   ticks = r->fromrate
      + rndnum(diff,rseed);
   pauseticks(ticks);
   } /* OutputRateRange */

void sendchar(ch)
char ch;
   {
   if (currcd->ratetype)
      {
      switch (currcd->ratetype)
         {
         case CONSTANTRATE:
            pauseticks(currcd->fromrate);
            break;
         case LINEARRATE:
            OutputRateRange(currcd);
            break;
         case AVGRATE:
            OutputAvgRate(currcd);
            break;
         case RATEBITS:
            OutputRateBits(currcd);
            break;
         default:
            fprintf(stderr,"Invalid output "
               "rate type %d\n",
               currcd->ratetype);
            exit(1);
         } /* switch currcd->ratetype */
      } /* if output rate type != NORATE */
   putchar(ch);
   } /* sendchar */

void putstr(str)
char *str;
   {
   char *p;
   p = str;
   while (*p) sendchar(*p++);
   } /* putstr */

void isrtpad(len,str)
int len;
char *str;
   {
   int i;
   char *p;
   i = 0;
   while (i < len)
      {
      p = str;
      while (*p && i++ < len) sendchar(*p++);
      }
   } /* isrtpad */

void bldalf(len,totlen,padding,padstr)
int len,totlen,padding;
char *padstr;
   {
   int i,j,k;
   char alfbet[96];
   if (totlen > len && padding == LPAD)
      isrtpad(totlen-len,padstr);
   strcpy(alfbet,"bcdfghjklmnpqrstvwxyz");
   strcat(alfbet,"bcdfghjklmnpqrstvwxyz");
   strcat(alfbet,"bcdfghjklmnpqrstvwxyz");
   for (i=0;i<len;i++)
      {
      j = rndnum(63,rseed);
      k = alfbet[j];
      sendchar(k);
      }
   if (totlen > len && padding == RPAD)
      isrtpad(totlen-len,padstr);
   } /* bldalf */

void bldltr(len,totlen,padding,alphabet,padstr)
int len,totlen,padding;
char *alphabet,*padstr;
   {
   int alflen,i,j,k;
   if (totlen > len && padding == LPAD)
      isrtpad(totlen-len,padstr);
   alflen = strlen(alphabet);
   for (i=0;i<len;i++)
      {
      j = rndnum(alflen,rseed);
      k = alphabet[j];
      sendchar(k);
      }
   if (totlen > len && padding == RPAD)
      isrtpad(totlen-len,padstr);
   } /* bldltr */

void bldtxt(len)
int len;
   {
   int i,j,k;
   char alfbet[96];
   strcpy(alfbet,"    abcdefghijklmnopqrstuvwxyz");
   strcat(alfbet,"    ABCDEFGHIJKLMNOPQRSTUVWXYZ");
   strcat(alfbet,"    abcdefghijklmnopqrstuvwxyz");
   for (i=0;i<len;i++)
      {
      j = rndnum(90,rseed);
      k = alfbet[j];
      sendchar(k);
      }
   } /* bldtxt */

void bldnumbitsrng(len)
int len;
   {
   int i,tmplen,stk;
   unsigned int rmndr;
   unsigned int rslt;
   unsigned int lst[128];
   unsigned int num;
   char str[16];
   char dgtstk[1024];
   if (len <= 32)
      {
      num = rndpwr(len,rseed);
      sprintf(str,"%u", num);
      putstr(str);
      return;
      } /* if single integer */
   tmplen = len;
   i = 0;
   while (tmplen > 0)
      {
      if (tmplen < 25)
         {
         lst[i] = rndpwr(tmplen,rseed);
         } /* if highest order half word */
      else
         lst[i] = rndpwr(24,rseed);
      tmplen -= 24;
      i++;
      } /* for each 24 bits */
   stk = 0;
   rslt = 1;
   while (rslt)
      {
      i = len / 24;
      rslt = rmndr = 0;
      while (i >= 0)
         {
         unsigned int tmp;
         tmp = (rmndr << 24) + lst[i];
         rmndr  = tmp % 10;
         lst[i] = rslt = tmp / 10;
         i--;
         } /* for each 24 bits */
      dgtstk[stk++] = rmndr;
      } /* collect digits right to left */
   stk--;
   while (stk >= 0)
      {
      sendchar(dgtstk[stk--] + '0');
      } /* flush stack */
   } /* bldnumbitsrng */

void bldnumbits(len,lentype)
int len,lentype;
   {
   int i,bitlen,tmplen,stk;
   unsigned int rmndr;
   unsigned int rslt;
   unsigned int lst[64];
   unsigned int num;
   char str[16];
   char dgtstk[1024];
   if (lentype == CONSTANTLEN)
      bitlen = rndnum(len,rseed) + 1;
   else
      bitlen = len;
   if (len <= 32)
      {
      num = rndpwr(bitlen,rseed);
      sprintf(str,"%u", num);
      putstr(str);
      return;
      } /* if single integer */
   tmplen = bitlen;
   i = 0;
   while (tmplen > 0)
      {
      if (tmplen < 25)
         {
         lst[i] = rndpwr(tmplen,rseed);
         } /* if highest order half word */
      else
         lst[i] = rndpwr(24,rseed);
      tmplen -= 24;
      i++;
      } /* for each 24 bits */
   stk = 0;
   rslt = 1;
   while (rslt)
      {
      i = bitlen / 24;
      rslt = rmndr = 0;
      while (i >= 0)
         {
         unsigned int tmp;
         tmp = (rmndr << 24) + lst[i];
         rmndr  = tmp % 10;
         lst[i] = rslt = tmp / 10;
         i--;
         } /* for each 24 bits */
      dgtstk[stk++] = rmndr;
      } /* collect digits right to left */
   stk--;
   while (stk >= 0)
      {
      sendchar(dgtstk[stk--] + '0');
      } /* flush stack */
   } /* bldnumbits */

void bldnum(len)
int len;
   {
   int i,j,k;
   char alfbet[16];
   strcpy(alfbet,"0123456789");
   for (i=0;i<len;i++)
      {
      j = rndnum(10,rseed);
      k = alfbet[j];
      sendchar(k);
      }
   } /* bldnum */

void bldflrng(loflrng,hiflrng)
double loflrng,hiflrng;
   {
   double diff,rslt;
   diff = hiflrng - loflrng;
   rslt = loflrng + (rndfrac(rseed) * diff);
   sprintf(wrkstr,"%f", rslt);
   putstr(wrkstr);
   } /* bldflrng */

void fmtint(num,len)
int num,len;
   {
   int tmp,i,dgt,ten;
   char *p;
   char str[64];
   i = len;
   p = str + i;
   *p-- = '\0';
   if (num < 0) tmp = -num;
   else tmp = num;
   ten = 10;
   while (i-- > 0)
      {
      dgt = tmp % ten;
      *p-- = dgt + '0';
      tmp /= ten;
      } /* right to left */
   if (num < 0)
      {
      str[0] = '-';
      }
   putstr(str);
   } /* fmtint */

void bldseq(len)
int len;
   {
   rcdnum++;
   if (!len)
      {
      sprintf(wrkstr,"%d", rcdnum);
      putstr(wrkstr);
      }
   else fmtint(rcdnum,len);
   } /* bldseq */

void bldsine(decimals,step,magnitude,axis,sinex)
int decimals;
double step,magnitude,axis,*sinex;
   {
   double yval,twopi;
   char fmtstr[32];
   char wrkstr[32];
   *sinex += step;
   twopi = M_PI + M_PI;
   if (*sinex > twopi) *sinex -= twopi;
   yval = (sin(*sinex) * magnitude) + axis;
   sprintf(fmtstr,"%s%d%s", "%.", decimals, "f");
   sprintf(wrkstr,fmtstr,yval);
   putstr(wrkstr);
   } /* bldsine */

void bldintrng(lointrng,hiintrng,fromlen)
int lointrng,hiintrng,fromlen;
   {
   int diff,rslt,i;
   diff = hiintrng - lointrng + 1;
   i = rndnum(diff,rseed);
   rslt = lointrng + i;
   if (!fromlen)
      {
      sprintf(wrkstr,"%d", rslt);
      putstr(wrkstr);
      }
   else fmtint(rslt,fromlen);
   } /* bldintrng */

void bldavgflrng(loflrng,hiflrng)
double loflrng,hiflrng;
   {
   double diff,fact1,fact2,fact3,fact4,rslt;
   diff = hiflrng - loflrng;
   fact1 = (double) rndfrac(rseed);
   fact2 = (double) rndfrac(rseed);
   fact3 = (double) rndfrac(rseed);
   fact4 = (double) rndfrac(rseed);
   rslt = loflrng + (diff * ((fact1 + fact2 + fact3 + fact4) / 4.0));
   sprintf(wrkstr,"%f", rslt);
   putstr(wrkstr);
   } /* bldavgflrng */

void bldavgintrng(lointrng,hiintrng)
int lointrng,hiintrng;
   {
   int diff,rslt,i,j,k,l;
   diff = hiintrng - lointrng + 1;
   i = rndnum(diff,rseed);
   j = rndnum(diff,rseed);
   k = rndnum(diff,rseed);
   l = rndnum(diff,rseed);
   rslt = lointrng + ((i + j + k + l) >> 2);
   sprintf(wrkstr,"%d", rslt);
   putstr(wrkstr);
   } /* bldavgintrng */

void bldreal(len,dec,sign)
int len,dec,sign;
   {
   int i,j,k,negsw;
   char alfbet[16];
   strcpy(alfbet,"0123456789");
   negsw = (int) rnd(rseed);
   if (negsw)
      {
      if (sign == PRESIGN) sendchar('-');
      else if (sign == ACCTSIGN) sendchar('(');
      }
   for (i=0;i<len;i++)
      {
      j = rndnum(10,rseed);
      k = alfbet[j];
      sendchar(k);
      }
   if (dec > 0)
      {
      sendchar('.');
      for (i=0;i<dec;i++)
         {
         j = rndnum(10,rseed);
         k = alfbet[j];
         sendchar(k);
         } /* gen decimals */
      } /* if decimals */
   if (negsw)
      {
      if (sign == POSTSIGN) sendchar('-');
      else if (sign == ACCTSIGN) sendchar(')');
      }
   } /* bldreal */

void bldamt(len,dec,sign,lentype)
int len,dec,sign,lentype;
   {
   int i,j,k,bitlen,negsw;
   unsigned int intgr;
   char alfbet[16];
   strcpy(alfbet,"0123456789");
   intgr = 0;
   if (lentype == CONSTANTLEN)
      bitlen = rndnum(len,rseed) + 1;
   else
      bitlen = len;
   if (bitlen > 0)
      intgr = rndpwr(bitlen,rseed);
   negsw = (int) rnd(rseed);
   if (negsw)
      {
      if (sign == PRESIGN) sendchar('-');
      else if (sign == ACCTSIGN) sendchar('(');
      }
   sprintf(wrkstr,"%d", intgr);
   putstr(wrkstr);
   intgr = len - dec;
   if (dec) sendchar('.');
   for (i=0;i<dec;i++)
      {
      j = rndnum(10,rseed);
      k = alfbet[j];
      sendchar(k);
      }
   if (negsw)
      {
      if (sign == POSTSIGN) sendchar('-');
      else if (sign == ACCTSIGN) sendchar(')');
      }
   } /* bldamt */

void bldslct(max,k)
slctfmt *k;
   {
   int i,j;
   slctfmt *p;
   i = rndnum(max,rseed);
   p = k;
   for (j=0;j<i;j++) p = p->next;
   putstr(p->val);
   } /* bldslct */

void getdate()
   {
   time_t t;
   time(&t);
   /* global dt structure */
   dt = (struct tm *) localtime(&t);
   } /* getdate */

void putticks()
   {
   struct tms t;
   clock_t clk;
   clk = times(&t);
   sprintf(wrkstr,"%d", (int) clk);
   putstr(wrkstr);
   } /* getdate */

void bldfuldt(adj,sep)
int adj;
char *sep;
   {
   time_t t;
   struct tm *dat;
   time(&t);
   t += adj;
   dat = (struct tm *) localtime(&t);
   sprintf(wrkstr,"%04d%s", dat->tm_year+1900, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_mon+1, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_mday, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_hour, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_min, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_sec, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%03d%s", dat->tm_yday, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%d%s", dat->tm_wday+1, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%d", dat->tm_isdst);
   putstr(wrkstr);
   } /* bldfuldt */

void blddtrng(from,to,fmt,sep)
double from,to;
char *fmt;
char *sep;
   {
   int year,month,day,hour,minute;
   int fmtlen;
   double second,jd,yrbeg;
   double dblweek,dblwday;
   double diff;
   double jd2greg();
   double greg2jd();
   char wrkstr[256];
   struct tm dat;
   diff = to - from;
   jd = from + (rndfrac(rseed) * diff);
   jd2greg(jd,&year,&month,&day,&hour,&minute,&second);
   yrbeg = greg2jd(year,1,1,0.0);
   dat.tm_year = year - 1900;
   dat.tm_mon  = month - 1;
   dat.tm_mday = day;
   dat.tm_hour = hour;
   dat.tm_min  = minute;
   dat.tm_sec  = (int) second;
   dblweek = (jd + 1.5) / 7.0;
   dblwday = (dblweek - floor(dblweek)) * 7.0;
   dat.tm_wday = (int) dblwday;
   dat.tm_yday = (int) floor(jd - yrbeg);
   dat.tm_isdst = 0;
   fmtlen = strftime(wrkstr,
      sizeof(wrkstr),fmt,&dat);
   putstr(wrkstr);
   } /* blddtrng */

void blddate(adj,sep)
int adj;
char *sep;
   {
   time_t t;
   struct tm *dat;
   time(&t);
   t += adj;
   dat = (struct tm *) localtime(&t);
   sprintf(wrkstr,"%04d%s", dat->tm_year+1900, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_mon+1, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d", dat->tm_mday);
   putstr(wrkstr);
   } /* blddate */

void bldtime(adj,sep)
int adj;
char *sep;
   {
   time_t t;
   struct tm *dat;
   time(&t);
   t += adj;
   dat = (struct tm *) localtime(&t);
   sprintf(wrkstr,"%02d%s", dat->tm_hour, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d%s", dat->tm_min, sep);
   putstr(wrkstr);
   sprintf(wrkstr,"%02d", dat->tm_sec);
   putstr(wrkstr);
   } /* bldtime */

int calclen(f)
fldfmt *f;
   {
   int i,j,totlen,len;
   if (f->lentype == CONSTANTLEN)
      return(f->fromlen);
   else if (f->lentype == LENRANGE)
      {
      i = f->tolen - f->fromlen + 1;
      j = rndnum(i,rseed);
      len = j + f->fromlen;
      return(len);
      } /* else if LENRANGE */
   else
      {
      i = f->tolen - f->fromlen + 1;
      j = rndnum(i,rseed);
      totlen = j + f->fromlen;
      j = rndnum(i,rseed);
      totlen += j;
      totlen += f->fromlen;
      len = totlen >> 1;
      return(len);
      } /* else AVERAGELEN */
   } /* calclen */

void FldPauseBits(f)
fldfmt *f;
   {
   int ticks,size;
   ticks = 0;
   size = rndnum(f->fromlen,rseed);
   size++;
   if (size > 0)
      ticks = rndpwr(size,rseed);
   if (ticks > 0)
      pauseticks(ticks);
   } /* FldPauseBits */

void FldAvgPause(f)
fldfmt *f;
   {
   int i,diff,ticks;
   diff = f->tolen - f->fromlen + 1;
   ticks = 0;
   for (i=0;i<4;i++)
      {
      ticks += f->fromlen
         + rndnum(diff,rseed);
      }
   ticks >>= 2;
   pauseticks(ticks);
   } /* FldAvgPause */

void FldPauseRange(f)
fldfmt *f;
   {
   int diff,ticks;
   diff = f->tolen - f->fromlen + 1;
   ticks = f->fromlen
      + rndnum(diff,rseed);
   pauseticks(ticks);
   } /* FldPauseRange */

void genfld(rcd)
rcdfmt *rcd;
   {
   int i,len,maxrcd;
   char *sep;
   fldfmt *f;
   maxrcd = rcd->totrcds;
   if (rcd->fldsep == NULL)
      sep = dgfldsep;
   else
      sep = rcd->fldsep;
   f = rcd->fldhead->next;
   if (f == tail)
      {
      fprintf(stderr,"genfld: empty list\n");
      return;
      }
   for (i=0;i<maxrcd;i++)
      {
      f = rcd->fldhead->next;
      fldnum = 0;
      while (f != tail)
         {
         fldnum++;
         if (f->seed != NULL)
            {
            rseed = f->seed;
            }
         else
            {
            rseed = sd;
            }
         len = calclen(f);
         switch(f->typ)
            {
            case ALPHA: {
               bldalf(len,f->totlen,f->padding,f->padstr);
               break;
               }
            case LETTERS: {
               bldltr(len,f->totlen,f->padding,
                  f->val,f->padstr);
               break;
               }
            case TEXT: {
               bldtxt(len);
               break;
               }
            case SELECT: {
               bldslct(f->slctmax,f->slcthead->next);
               break;
               }
            case NUMERIC: {
               bldnum(len);
               break;
               }
            case INTEGER: {
               bldnumbits(len,f->lentype);
               break;
               }
            case REAL: {
               bldreal(len,f->dec,f->sign);
               break;
               }
            case AMOUNT: {
               bldamt(len,f->dec,f->sign,f->lentype);
               break;
               }
            case FLRANGE: {
               bldflrng(f->loflrng,f->hiflrng);
               break;
               }
            case AVGFLRANGE: {
               bldflrng(f->loflrng,f->hiflrng);
               break;
               }
            case INTRANGE: {
               bldintrng(f->lointrng,f->hiintrng,f->fromlen);
               break;
               }
            case AVGINTRANGE: {
               bldintrng(f->lointrng,f->hiintrng,f->fromlen);
               break;
               }
            case SEQUENCE: {
               bldseq(f->fromlen);
               break;
               }
            case SINEWAVE: {
               bldsine(f->dec,f->sinestep,f->loflrng,
                  f->hiflrng,&f->sinex);
               break;
               }
            case FULLDATE: {
               bldfuldt(f->dateadj,sep);
               break;
               }
            case DATERANGE: {
               blddtrng(f->loflrng,f->hiflrng,
                  f->fmtstr,sep);
               break;
               }
            case DATE: {
               blddate(f->dateadj,sep);
               break;
               }
            case TIME: {
               bldtime(f->dateadj,sep);
               break;
               }
            case YEAR: {
               getdate();
               sprintf(wrkstr,"%04d", dt->tm_year+1900);
               putstr(wrkstr);
               break;
               }
            case MONTH: {
               getdate();
               sprintf(wrkstr,"%02d", dt->tm_mon+1);
               putstr(wrkstr);
               break;
               }
            case DAY: {
               getdate();
               sprintf(wrkstr,"%02d", dt->tm_mday);
               putstr(wrkstr);
               break;
               }
            case JULIANDAY: {
               getdate();
               sprintf(wrkstr,"%03d", dt->tm_yday);
               putstr(wrkstr);
               break;
               }
            case HOUR: {
               getdate();
               sprintf(wrkstr,"%02d", dt->tm_hour);
               putstr(wrkstr);
               break;
               }
            case MINUTE: {
               getdate();
               sprintf(wrkstr,"%02d", dt->tm_min);
               putstr(wrkstr);
               break;
               }
            case SECOND: {
               getdate();
               sprintf(wrkstr,"%02d", dt->tm_sec);
               putstr(wrkstr);
               break;
               }
            case TICKS: {
               putticks();
               break;
               }
            case QSTR: {
               putstr(f->val);
               break;
               }
            case PAUSE: {
               pauseticks(f->fromlen);
               break;
               }
            case PAUSERANGE: {
               FldPauseRange(f);
               break;
               }
            case AVGPAUSE: {
               FldAvgPause(f);
               break;
               }
            case PAUSEBITS: {
               FldPauseBits(f);
               break;
               }
            default:
               {
               if (dbsw == VERBOSE) shwrcd();
               fprintf(stderr,"invalid field %d type %d\n",
                  fldnum, f->typ);
               exit(1);
               }
            } /* switch field type */
         if (f->next != tail)
	    {
	    if (f->next->typ == PAUSE
	       || f->next->typ == PAUSERANGE
	       || f->next->typ == AVGPAUSE
	       || f->next->typ == PAUSEBITS)
	       {
	       if (f->fldsep != NULL)
	          f->next->fldsep = f->fldsep;
	       }
	    else if (f->fldsep != NULL)
               putstr(f->fldsep);
	    else
               putstr(sep);
	    }
         f = f->next;
         } /* field loop */
      sendchar('\n');
      } /* record loop */
   } /* genfld */

void genrcd()
   {
   rcdfmt *r;
   r = rcdhead->next;
   if (r == rcdtail)
      {
      fprintf(stderr,"no record definitions\n");
      exit(1);
      }
   while (r != rcdtail)
      {
      currcd = r;
      if (r->reset) rcdnum = 0;
      genfld(r);
      r = r->next;
      } /* record loop */
   } /* genrcd */

int main(argc,argv)
int argc;
char **argv;
   {
   int rslt;
   dbsw = 0;
   if (argc == 2)
      {
      rslt = strcmp(*(argv+1),"-v");
      if (!rslt) dbsw = 1;
      rslt = strcmp(*(argv+1),"-V");
      if (!rslt) dbsw = 2;
      } /* if one arg */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"datagen: out of memory "
         "allocating sd\n");
      exit(1);
      }
   getdate();
   fprintf(stderr,"%02d/", dt->tm_mon+1);
   fprintf(stderr,"%02d/", dt->tm_mday);
   fprintf(stderr,"%04d  ", dt->tm_year+1900);
   fprintf(stderr,"%02d:", dt->tm_hour);
   fprintf(stderr,"%02d:", dt->tm_min);
   fprintf(stderr,"%02d\n", dt->tm_sec);
   fprintf(stderr,"Datagen version 1.4.0\n");
   fprintf(stderr,"Copyright (C) 1999-2005"
   	" dondalah@ripco.com (Dondalah)\n\n");
   fprintf(stderr,"Datagen comes with ABSOLUTELY"
   	" NO WARRANTY;\n");
   fprintf(stderr,"for details see the GNU"
   	" General Public License.\n\n");
   fprintf(stderr,"This is free software, and you"
   	" are welcome to redistribute it\n");
   fprintf(stderr,"under certain conditions;\n");
   fprintf(stderr,"for details see the GNU"
   	" General Public License.\n\n");
   fprintf(stderr,"For help browse datagen.html.\n\n");

   tail = initfld();
   tail->next = tail;
   rcdtail = initrcd();
   rcdtail->next = rcdtail;
   rcdhead = initrcd();
   currcd = rcdhead;
   slcttail = initslct();
   slcttail->next = slcttail;
   slctnum = 0;
   rcdnum = 0;
   adjsecs = 0;
   dgfldsep = " ";

   rslt = yyparse();
   fprintf(stderr,"Result of compile = %d\n", rslt);
   if (dbsw == VERBOSE) shwrcd();
   wrkstr = (char *) malloc(1024);
   if (wrkstr == NULL)
      {
      fprintf(stderr,"Out of memory "
         "allocating wrkstr\n");
      exit(1);
      }
   genrcd();
   return(0);
   } /* main */
