/*
datagen.l - flex subroutine for datagen
Release 1.4.0
Copyright (C) 1999-2005  dondalah@ripco.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Usage:
    	see makefile for compile instructions
*/

%{

#define YYSTYPE char *
#include <stdio.h>
#include "datagen.tab.h"

%}

D	[0-9]
L	[a-zA-Z]
H	[0-9A-Fa-f]

%%

record		{ return(RECORD); }

endrcd		{ return(ENDRCD); }

totrcds		{ return(TOTRCDS); }

resetseq	{ return(RESETSEQ); }

fldsep		{ return(FLDSEP); }

tmpfldsep	{ return(FLDSEP); } /* abrogated: see fldsep */

fldseed		{ return(FLDSEED); }

seed		{ return(SEED); }

field		{ return(FIELD); }

len		{ return(LEN); }

avglen		{ return(AVGLEN); }

to		{ return(TO); }

totlen		{ return(TOTLEN); }

lpad		{ return(LPAD); }

rpad		{ return(RPAD); }

alpha		{ return(ALPHA); }

letters		{ return(LETTERS); }

text		{ return(TEXT); }

select		{ return(SELECT); }

endselect	{ return(ENDSELECT); }

fulldate	{ return(FULLDATE); }

date		{ return(DATE); }

daterange	{ return(DATERANGE); }

format		{ return(FORMAT); }

time		{ return(TIME); }

year		{ return(YEAR); }

month		{ return(MONTH); }

day		{ return(DAY); }

julianday	{ return(JULIANDAY); }

hour		{ return(HOUR); }

minute		{ return(MINUTE); }

second		{ return(SECOND); }

days		{ return(DAYS); }

seconds		{ return(SECONDS); }

ticks		{ return(TICKS); }

pause		{ return(PAUSE); }

pauserange	{ return(PAUSERANGE); }

avgpause	{ return(AVGPAUSE); }

pausebits	{ return(PAUSEBITS); }

outputrate	{ return(OUTPUTRATE); }

avgrate		{ return(AVGRATE); }

real		{ return(REAL); }

decimals	{ return(DECIMALS); }

numeric		{ return(NUMERIC); }

amount		{ return(AMOUNT); }

integer		{ return(INTEGER); }

bits		{ return(BITS); }

presign		{ return(PRESIGN); }

postsign	{ return(POSTSIGN); }

acctsign	{ return(ACCTSIGN); }

flrange		{ return(FLRANGE); }

avgflrange	{ return(AVGFLRANGE); }

intrange	{ return(INTRANGE); }

avgintrange	{ return(AVGINTRANGE); }

sequence	{ return(SEQUENCE); }

sinewave	{ return(SINEWAVE); }

period		{ return(PERIOD); }

magnitude	{ return(MAGNITUDE); }

axis		{ return(AXIS); }

endfld		{ return(ENDFLD); }

[:,\.&]		{
		yylval = yytext;
		return(SEP);
		}

{D}+		{
		yylval = yytext;
		return(NUM);
		}

\-{D}+		{
		yylval = yytext;
		return(NEGNUM);
		}

"-"{D}+"."{D}*   {
		yylval = yytext;
		/* fprintf(stderr,"negfloat <<%s>>\n", */
			/* yytext); */
		return(NEGFLOAT);
		}

{D}+"."{D}*	{
		yylval = yytext;
		/* fprintf(stderr,"posfloat <<%s>>\n", */
			/* yytext); */
		return(POSFLOAT);
		}

\"(\\\"|[^"])*\"	{
			int len;
			char *p,*q;
			len = strlen(yytext);
			p = yytext;
			q = (char *) malloc(len+1);
			yylval = q;
			while (*p != '\0')
			   {
			   if (*p == '\\')
			      {
			      if (*(p+1) == '\"')
				 {
				 p++;
				 *q++ = *p++;
				 }
			      else *q++ = *p++;
			      }
			   else *q++ = *p++;
			   }
			*q = '\0';
			return(QSTR);
			}

;		{ return(';'); }

=		{ return('='); }

\+		{ return('+'); }

-		{ return('-'); }

end		{ return(0); }

\#(.)*\n	{ /* comment */ }

[ \t\n.]	{ /* nothing */ }

%%
