/** fib.y test file for PRECCX v2.43/4      P.T. Breuer August 1994 **/

/* This is not the good old friendly fib example of many a yesteryear.
 * No. This is a version designed to BREAK your system. It uses a
 * compound  structure as the value carried by all terms. If your C
 * system does weird (i.e. unexpected by me) things with non-int
 * -sized arguments on the C stack, then this will find out in a hurry.
 * If you want a version that guarantees to work, try the one shown
 * in the manual page(s).
 *
 * PTB
 */

# define TOKEN char
# define PARAM long
# define VALUE struct {long count, nexta, nextb;}

# include "ccx.h"

long FIRSTDIGIT(long n) {
        static char cs[256];
        if (n <= 0) 
           return (long)0;
        sprintf((char*)cs,"%-lu%c",n,0);
        return (long)(cs[0] - '0');
}
long LASTDIGITS(long n) {
        static char cs[256];
        if (n <= 9) 
           return (long)0;
        sprintf((char*)cs,"%-lu%c",n,0);
        sscanf(&cs[1],"%ul",&n);
        return n;
}

@fibber   = { fibs $! }*

@fibs     = fib((PARAM)1,(PARAM)1)\k
@           {: printf("%d terms OK\n",(int)$k.count); :}
@           {: printf("Next terms are %d,%d,..\n",(int)$k.nexta,(int)$k.nextb); :}

@fib(a,b) = number(a) <','> fib(b,a+b)\k {@ ($k.count+=1,$k) @}
@         | <'.'> <'.'>             {}\k {@ ($k.count=0,$k.nexta=a,$k.nextb=b,$k) @}

@number(n)= digit(n)
@         | digit(FIRSTDIGIT(n)) number(LASTDIGITS(n))

@digit(n) = <n+'0'>  /* rep. of 1 digit n */

MAIN(fibber)

/************************************************************
     The following are some example inputs and responses:

          1,1,2,3,5,..
          5 terms OK
          Next terms are 8,13,..

          1,1,2,3,5,8,13,21,34,51,85,..
          error: failed parse: probable error at <>1,85,..
 ************************************************************/



