/** fib.y test file for PRECCX v2.43/4      P.T. Breuer August 1994 **/

/* This is not the good old friendly fib example of many a yesteryear.
 * No. This is a version designed to BREAK your system. It uses a
 * compound  structure as the value carried by all terms. If your C
 * system does weird (i.e. unexpected by me) things with non-int
 * -sized arguments on the C stack, then this will find out in a hurry.
 * If you want a version that guarantees to work, try the one shown
 * in the manual page(s).
 *
 * PTB
 */

# define TOKEN char
# define PARAM long
# define VALUE struct {long count, nexta, nextb;}

# include "ccx.h"

long FIRSTDIGIT(long n) {
        static char cs[256];
        if (n <= 0) 
           return (long)0;
        sprintf((char*)cs,"%-lu%c",n,0);
        return (long)(cs[0] - '0');
}
long LASTDIGITS(long n) {
        static char cs[256];
        if (n <= 9) 
           return (long)0;
        sprintf((char*)cs,"%-lu%c",n,0);
        sscanf(&cs[1],"%ul",&n);
        return n;
}

P_BEGIN
static STATUS hid0(PRECC_DATA* self) {
PARSER fibs, p_lastuniq0;
return p_andparse0n (self,TOPARSER fibs,0,TOPARSER p_lastuniq0,0);
}
static STATUS hid1(PRECC_DATA* self) {
PARSER hid0;
return p_many0n(self,TOPARSER hid0,0);
}
STATUS fibber(PRECC_DATA* self) {
PARSER hid1;
P_RETURN((TOPARSER hid1)(self),"fibber");
}
P_END

P_BEGIN
static VOID hid2(PRECC_DATA* self,VALUE k) {
 printf("%d terms OK\n",(int)(TOVALUE k).count); 
}
static STATUS hid3(PRECC_DATA* self,VALUE k) {
PARSER p_nothing0;ACTION hid2;
return p_attach0n(self,TOPARSER p_nothing0,0,hid2,P_SZ(1,1),k);
}
static VOID hid4(PRECC_DATA* self,VALUE k) {
 printf("Next terms are %d,%d,..\n",(int)(TOVALUE k).nexta,(int)(TOVALUE k).nextb); 
}
static STATUS hid5(PRECC_DATA* self,VALUE k) {
PARSER p_nothing0;ACTION hid4;
return p_attach0n(self,TOPARSER p_nothing0,0,hid4,P_SZ(1,1),k);
}
static STATUS hid6(PRECC_DATA* self,VALUE k) {
PARSER hid3, hid5;
return p_andparse0n (self,TOPARSER hid3,P_SZ(1,1),k,TOPARSER hid5,P_SZ(1,1),k);
}
static STATUS hid7(PRECC_DATA* self) {
PARSER fib, hid6; VALUE k;
static STATUS p_tok;
P_PSTAR(k,(TOPARSER fib)(self,(PARAM)1,(PARAM)1),(TOPARSER hid6)(self,k));
return p_tok;
}
STATUS fibs(PRECC_DATA* self) {
PARSER hid7;
P_RETURN((TOPARSER hid7)(self),"fibs");
}
P_END

P_BEGIN
static STATUS hid8(PRECC_DATA* self,PARAM a,PARAM b) {
return p_exactly0(self,',');
}
static STATUS hid9(PRECC_DATA* self,PARAM a,PARAM b,VALUE k) {
return p_atch0(self,/* VALUE */ ((TOVALUE k).count+=1,(TOVALUE k)) );
}
static STATUS hid10(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER fib, hid9; VALUE k;
static STATUS p_tok;
P_PSTAR(k,(TOPARSER fib)(self,b,a+b),(TOPARSER hid9)(self,a,b,k));
return p_tok;
}
static STATUS hid11(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER hid8, hid10;
return p_andparse0n (self,TOPARSER hid8,P_SZ(2,0),a,b,TOPARSER hid10,P_SZ(2,0),a,b);
}
static STATUS hid12(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER number, hid11;
return p_andparse0n (self,TOPARSER number,P_SZ(1,0),a,TOPARSER hid11,P_SZ(2,0),a,b);
}
static STATUS hid13(PRECC_DATA* self,PARAM a,PARAM b) {
return p_exactly0(self,'.');
}
static STATUS hid14(PRECC_DATA* self,PARAM a,PARAM b) {
return p_exactly0(self,'.');
}
static STATUS hid15(PRECC_DATA* self,PARAM a,PARAM b,VALUE k) {
return p_atch0(self,/* VALUE */ ((TOVALUE k).count=0,(TOVALUE k).nexta=a,(TOVALUE k).nextb=b,(TOVALUE k)) );
}
static STATUS hid16(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER p_nothing0, hid15; VALUE k;
static STATUS p_tok;
P_PSTAR(k,(TOPARSER p_nothing0)(self),(TOPARSER hid15)(self,a,b,k));
return p_tok;
}
static STATUS hid17(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER hid14, hid16;
return p_andparse0n (self,TOPARSER hid14,P_SZ(2,0),a,b,TOPARSER hid16,P_SZ(2,0),a,b);
}
static STATUS hid18(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER hid13, hid17;
return p_andparse0n (self,TOPARSER hid13,P_SZ(2,0),a,b,TOPARSER hid17,P_SZ(2,0),a,b);
}
static STATUS hid19 (PRECC_DATA* self,PARAM a,PARAM b) {
PARSER hid12, hid18;
return p_orparse0n (self,TOPARSER hid12,P_SZ(2,0),a,b,TOPARSER hid18,P_SZ(2,0),a,b);
}
STATUS fib(PRECC_DATA* self,PARAM a,PARAM b) {
PARSER hid19;
P_RETURN((TOPARSER hid19)(self,a,b),"fib");
}
P_END

P_BEGIN
static STATUS hid20(PRECC_DATA* self,PARAM n) {
PARSER digit, number;
return p_andparse0n (self,TOPARSER digit,P_SZ(1,0),FIRSTDIGIT(n),TOPARSER number,P_SZ(1,0),LASTDIGITS(n));
}
static STATUS hid21 (PRECC_DATA* self,PARAM n) {
PARSER digit, hid20;
return p_orparse0n (self,TOPARSER digit,P_SZ(1,0),n,TOPARSER hid20,P_SZ(1,0),n);
}
STATUS number(PRECC_DATA* self,PARAM n) {
PARSER hid21;
P_RETURN((TOPARSER hid21)(self,n),"number");
}
P_END

P_BEGIN
static STATUS hid22(PRECC_DATA* self,PARAM n) {
return p_exactly0(self,n+'0');
}
STATUS digit(PRECC_DATA* self,PARAM n) {
PARSER hid22;
P_RETURN((TOPARSER hid22)(self,n),"digit");
}
P_END

MAIN(fibber)

/************************************************************
     The following are some example inputs and responses:

          1,1,2,3,5,..
          5 terms OK
          Next terms are 8,13,..

          1,1,2,3,5,8,13,21,34,51,85,..
          error: failed parse: probable error at <>1,85,..
 ************************************************************/



