/* A superior version of the "calculator" described in the PRECCX manual.
 * It should run on every system as it only uses ints. You should never
 * need a floating point library to compile this, and in that sense it
 * is a good test.
 *
 * Another good point about this example (as opposed to the one in the
 * manual) is that it is up to date with respect to 2.44 at least. It
 * uses parameters in quite a sophisticated way. At one point it uses
 * the fact that an option [foo] returns 0 when it doesn't match, and
 * returns the value attached to foo when it does match. But that
 * feature (though intended) may not be as portable as an explicit
 * { foo | {@ 0 @} }.
 *
 * The other point illustrated here is that a sequence {a b c}
 * returns the value attached to the last of the sequence. Mind
 * you, an attachment {@ bar @} has a value too! It is "bar".
 * You can't just insert attachments and then think they won't
 * be "seen".
 
 * On the other hand, naked actions (which don't appear here)
 * : bar; : really are invisible when you count for value. But one
 * puts curly brackets round them in any sane situation: {: bar; :}
 * and that makes them count. Moral: everything has a value :-)
 *
 * PTB
 */

# define TOKEN char
# define VALUE int
# define BEGIN printf("\nready> ");

# include "ccx.h"
# include <ctype.h>

@ digit = (isdigit)\x        {@ $x-'0' @}

@ posint(t)= digit\x [posint(10*t+$x) |
@                            {@ 10*t+$x @}]

@ posint0= posint(0)

@ anyint= <'-'> posint0\x    {@ -$x @}
@       | posint0

@ atom  = <'('> expr\x <')'> {@ $x @}
@       | anyint

@ prod  = dterm\x [<'*'> prod | {@ 1 @}]\y
@                            {@ $x*$y @}

/* a dterm is a product ending in maybe some divisions */

@ dterm = dhead\x  [dtail | {@ 1 @}]\y
@                            {@ $x/$y @}

/* a dhead is the product part */

@ dhead = atom\x [<'*'> dhead | {@ 1 @}]\y
@                            {@ $x*$y @}

/* the dtail is the division part */

@ dtail = <'/'> atom\x [dtail | {@ 1 @}]\y
@                            {@ $x*$y @}

@ expr  = prod\x [sign_sum]\y
@                            {@ $x+$y @}

@ sign_sum= <'-'>  prod\x [sign_sum]\y
@                            {@ -$x+$y @}
@       | <'+'> prod\x [sign_sum]\y
@                            {@ $x+$y @}

@ top   = expr\x             {: printf("=%d",$x); :}

/* because yywrap() returns 1, MAIN repeats ad infinitum */

MAIN(top)

