/* A superior version of the "calculator" described in the PRECCX manual.
 * It should run on every system as it only uses ints. You should never
 * need a floating point library to compile this, and in that sense it
 * is a good test.
 *
 * Another good point about this example (as opposed to the one in the
 * manual) is that it is up to date with respect to 2.44 at least. It
 * uses parameters in quite a sophisticated way. At one point it uses
 * the fact that an option [foo] returns 0 when it doesn't match, and
 * returns the value attached to foo when it does match. But that
 * feature (though intended) may not be as portable as an explicit
 * { foo | {@ 0 @} }.
 *
 * The other point illustrated here is that a sequence {a b c}
 * returns the value attached to the last of the sequence. Mind
 * you, an attachment {@ bar @} has a value too! It is "bar".
 * You can't just insert attachments and then think they won't
 * be "seen".
 
 * On the other hand, naked actions (which don't appear here)
 * : bar; : really are invisible when you count for value. But one
 * puts curly brackets round them in any sane situation: {: bar; :}
 * and that makes them count. Moral: everything has a value :-)
 *
 * PTB
 */

# define TOKEN char
# define VALUE int
# define BEGIN printf("\nready> ");

# include "ccx.h"
# include <ctype.h>

P_BEGIN
static STATUS hid0(PRECC_DATA* self) {
PREDICATE isdigit;
return p_range0n(self,isdigit,0);
}
static STATUS hid1(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x)-'0' );
}
static STATUS hid2(PRECC_DATA* self) {
PARSER hid0, hid1; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER hid0)(self),(TOPARSER hid1)(self,x));
return p_tok;
}
STATUS digit(PRECC_DATA* self) {
PARSER hid2;
P_RETURN((TOPARSER hid2)(self),"digit");
}
P_END

P_BEGIN
static STATUS hid3(PRECC_DATA* self,PARAM t,VALUE x) {
return p_atch0(self,/* VALUE */ 10*t+(TOVALUE x) );
}
static STATUS hid4 (PRECC_DATA* self,PARAM t,VALUE x) {
PARSER posint, hid3;
return p_orparse0n (self,TOPARSER posint,P_SZ(1,0),10*t+(TOVALUE x),TOPARSER hid3,P_SZ(2,1),t,x);
}
static STATUS hid5(PRECC_DATA* self,PARAM t,VALUE x) {
PARSER hid4;
return p_option0n(self,TOPARSER hid4,P_SZ(2,1),t,x);
}
static STATUS hid6(PRECC_DATA* self,PARAM t) {
PARSER digit, hid5; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER digit)(self),(TOPARSER hid5)(self,t,x));
return p_tok;
}
STATUS posint(PRECC_DATA* self,PARAM t) {
PARSER hid6;
P_RETURN((TOPARSER hid6)(self,t),"posint");
}
P_END

P_BEGIN
STATUS posint0(PRECC_DATA* self) {
PARSER posint;
P_RETURN((TOPARSER posint)(self,0),"posint0");
}
P_END

P_BEGIN
static STATUS hid7(PRECC_DATA* self) {
return p_exactly0(self,'-');
}
static STATUS hid8(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ -(TOVALUE x) );
}
static STATUS hid9(PRECC_DATA* self) {
PARSER posint0, hid8; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER posint0)(self),(TOPARSER hid8)(self,x));
return p_tok;
}
static STATUS hid10(PRECC_DATA* self) {
PARSER hid7, hid9;
return p_andparse0n (self,TOPARSER hid7,0,TOPARSER hid9,0);
}
static STATUS hid11 (PRECC_DATA* self) {
PARSER hid10, posint0;
return p_orparse0n (self,TOPARSER hid10,0,TOPARSER posint0,0);
}
STATUS anyint(PRECC_DATA* self) {
PARSER hid11;
P_RETURN((TOPARSER hid11)(self),"anyint");
}
P_END

P_BEGIN
static STATUS hid12(PRECC_DATA* self) {
return p_exactly0(self,'(');
}
static STATUS hid13(PRECC_DATA* self,VALUE x) {
return p_exactly0(self,')');
}
static STATUS hid14(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid15(PRECC_DATA* self,VALUE x) {
PARSER hid13, hid14;
return p_andparse0n (self,TOPARSER hid13,P_SZ(1,1),x,TOPARSER hid14,P_SZ(1,1),x);
}
static STATUS hid16(PRECC_DATA* self) {
PARSER expr, hid15; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER expr)(self),(TOPARSER hid15)(self,x));
return p_tok;
}
static STATUS hid17(PRECC_DATA* self) {
PARSER hid12, hid16;
return p_andparse0n (self,TOPARSER hid12,0,TOPARSER hid16,0);
}
static STATUS hid18 (PRECC_DATA* self) {
PARSER hid17, anyint;
return p_orparse0n (self,TOPARSER hid17,0,TOPARSER anyint,0);
}
STATUS atom(PRECC_DATA* self) {
PARSER hid18;
P_RETURN((TOPARSER hid18)(self),"atom");
}
P_END

P_BEGIN
static STATUS hid19(PRECC_DATA* self,VALUE x) {
return p_exactly0(self,'*');
}
static STATUS hid20(PRECC_DATA* self,VALUE x) {
PARSER hid19, prod;
return p_andparse0n (self,TOPARSER hid19,P_SZ(1,1),x,TOPARSER prod,0);
}
static STATUS hid21(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ 1 );
}
static STATUS hid22 (PRECC_DATA* self,VALUE x) {
PARSER hid20, hid21;
return p_orparse0n (self,TOPARSER hid20,P_SZ(1,1),x,TOPARSER hid21,P_SZ(1,1),x);
}
static STATUS hid23(PRECC_DATA* self,VALUE x) {
PARSER hid22;
return p_option0n(self,TOPARSER hid22,P_SZ(1,1),x);
}
static STATUS hid24(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)*(TOVALUE y) );
}
static STATUS hid25(PRECC_DATA* self,VALUE x) {
PARSER hid23, hid24; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid23)(self,x),(TOPARSER hid24)(self,x,y));
return p_tok;
}
static STATUS hid26(PRECC_DATA* self) {
PARSER dterm, hid25; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER dterm)(self),(TOPARSER hid25)(self,x));
return p_tok;
}
STATUS prod(PRECC_DATA* self) {
PARSER hid26;
P_RETURN((TOPARSER hid26)(self),"prod");
}
P_END

/* a dterm is a product ending in maybe some divisions */

P_BEGIN
static STATUS hid27(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ 1 );
}
static STATUS hid28 (PRECC_DATA* self,VALUE x) {
PARSER dtail, hid27;
return p_orparse0n (self,TOPARSER dtail,0,TOPARSER hid27,P_SZ(1,1),x);
}
static STATUS hid29(PRECC_DATA* self,VALUE x) {
PARSER hid28;
return p_option0n(self,TOPARSER hid28,P_SZ(1,1),x);
}
static STATUS hid30(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)/(TOVALUE y) );
}
static STATUS hid31(PRECC_DATA* self,VALUE x) {
PARSER hid29, hid30; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid29)(self,x),(TOPARSER hid30)(self,x,y));
return p_tok;
}
static STATUS hid32(PRECC_DATA* self) {
PARSER dhead, hid31; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER dhead)(self),(TOPARSER hid31)(self,x));
return p_tok;
}
STATUS dterm(PRECC_DATA* self) {
PARSER hid32;
P_RETURN((TOPARSER hid32)(self),"dterm");
}
P_END

/* a dhead is the product part */

P_BEGIN
static STATUS hid33(PRECC_DATA* self,VALUE x) {
return p_exactly0(self,'*');
}
static STATUS hid34(PRECC_DATA* self,VALUE x) {
PARSER hid33, dhead;
return p_andparse0n (self,TOPARSER hid33,P_SZ(1,1),x,TOPARSER dhead,0);
}
static STATUS hid35(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ 1 );
}
static STATUS hid36 (PRECC_DATA* self,VALUE x) {
PARSER hid34, hid35;
return p_orparse0n (self,TOPARSER hid34,P_SZ(1,1),x,TOPARSER hid35,P_SZ(1,1),x);
}
static STATUS hid37(PRECC_DATA* self,VALUE x) {
PARSER hid36;
return p_option0n(self,TOPARSER hid36,P_SZ(1,1),x);
}
static STATUS hid38(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)*(TOVALUE y) );
}
static STATUS hid39(PRECC_DATA* self,VALUE x) {
PARSER hid37, hid38; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid37)(self,x),(TOPARSER hid38)(self,x,y));
return p_tok;
}
static STATUS hid40(PRECC_DATA* self) {
PARSER atom, hid39; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER atom)(self),(TOPARSER hid39)(self,x));
return p_tok;
}
STATUS dhead(PRECC_DATA* self) {
PARSER hid40;
P_RETURN((TOPARSER hid40)(self),"dhead");
}
P_END

/* the dtail is the division part */

P_BEGIN
static STATUS hid41(PRECC_DATA* self) {
return p_exactly0(self,'/');
}
static STATUS hid42(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ 1 );
}
static STATUS hid43 (PRECC_DATA* self,VALUE x) {
PARSER dtail, hid42;
return p_orparse0n (self,TOPARSER dtail,0,TOPARSER hid42,P_SZ(1,1),x);
}
static STATUS hid44(PRECC_DATA* self,VALUE x) {
PARSER hid43;
return p_option0n(self,TOPARSER hid43,P_SZ(1,1),x);
}
static STATUS hid45(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)*(TOVALUE y) );
}
static STATUS hid46(PRECC_DATA* self,VALUE x) {
PARSER hid44, hid45; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid44)(self,x),(TOPARSER hid45)(self,x,y));
return p_tok;
}
static STATUS hid47(PRECC_DATA* self) {
PARSER atom, hid46; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER atom)(self),(TOPARSER hid46)(self,x));
return p_tok;
}
static STATUS hid48(PRECC_DATA* self) {
PARSER hid41, hid47;
return p_andparse0n (self,TOPARSER hid41,0,TOPARSER hid47,0);
}
STATUS dtail(PRECC_DATA* self) {
PARSER hid48;
P_RETURN((TOPARSER hid48)(self),"dtail");
}
P_END

P_BEGIN
static STATUS hid49(PRECC_DATA* self,VALUE x) {
PARSER sign_sum;
return p_option0n(self,TOPARSER sign_sum,0);
}
static STATUS hid50(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)+(TOVALUE y) );
}
static STATUS hid51(PRECC_DATA* self,VALUE x) {
PARSER hid49, hid50; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid49)(self,x),(TOPARSER hid50)(self,x,y));
return p_tok;
}
static STATUS hid52(PRECC_DATA* self) {
PARSER prod, hid51; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER prod)(self),(TOPARSER hid51)(self,x));
return p_tok;
}
STATUS expr(PRECC_DATA* self) {
PARSER hid52;
P_RETURN((TOPARSER hid52)(self),"expr");
}
P_END

P_BEGIN
static STATUS hid53(PRECC_DATA* self) {
return p_exactly0(self,'-');
}
static STATUS hid54(PRECC_DATA* self,VALUE x) {
PARSER sign_sum;
return p_option0n(self,TOPARSER sign_sum,0);
}
static STATUS hid55(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ -(TOVALUE x)+(TOVALUE y) );
}
static STATUS hid56(PRECC_DATA* self,VALUE x) {
PARSER hid54, hid55; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid54)(self,x),(TOPARSER hid55)(self,x,y));
return p_tok;
}
static STATUS hid57(PRECC_DATA* self) {
PARSER prod, hid56; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER prod)(self),(TOPARSER hid56)(self,x));
return p_tok;
}
static STATUS hid58(PRECC_DATA* self) {
PARSER hid53, hid57;
return p_andparse0n (self,TOPARSER hid53,0,TOPARSER hid57,0);
}
static STATUS hid59(PRECC_DATA* self) {
return p_exactly0(self,'+');
}
static STATUS hid60(PRECC_DATA* self,VALUE x) {
PARSER sign_sum;
return p_option0n(self,TOPARSER sign_sum,0);
}
static STATUS hid61(PRECC_DATA* self,VALUE x,VALUE y) {
return p_atch0(self,/* VALUE */ (TOVALUE x)+(TOVALUE y) );
}
static STATUS hid62(PRECC_DATA* self,VALUE x) {
PARSER hid60, hid61; VALUE y;
static STATUS p_tok;
P_PSTAR(y,(TOPARSER hid60)(self,x),(TOPARSER hid61)(self,x,y));
return p_tok;
}
static STATUS hid63(PRECC_DATA* self) {
PARSER prod, hid62; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER prod)(self),(TOPARSER hid62)(self,x));
return p_tok;
}
static STATUS hid64(PRECC_DATA* self) {
PARSER hid59, hid63;
return p_andparse0n (self,TOPARSER hid59,0,TOPARSER hid63,0);
}
static STATUS hid65 (PRECC_DATA* self) {
PARSER hid58, hid64;
return p_orparse0n (self,TOPARSER hid58,0,TOPARSER hid64,0);
}
STATUS sign_sum(PRECC_DATA* self) {
PARSER hid65;
P_RETURN((TOPARSER hid65)(self),"sign_sum");
}
P_END

P_BEGIN
static VOID hid66(PRECC_DATA* self,VALUE x) {
 printf("=%d",(TOVALUE x)); 
}
static STATUS hid67(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid66;
return p_attach0n(self,TOPARSER p_nothing0,0,hid66,P_SZ(1,1),x);
}
static STATUS hid68(PRECC_DATA* self) {
PARSER expr, hid67; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER expr)(self),(TOPARSER hid67)(self,x));
return p_tok;
}
STATUS top(PRECC_DATA* self) {
PARSER hid68;
P_RETURN((TOPARSER hid68)(self),"top");
}
P_END

/* because yywrap() returns 1, MAIN repeats ad infinitum */

MAIN(top)

