
/* this avoids warnings about implicitly declaring filbuf in
 * some installations, but it also shifts to functions from
 * macros, which may not be as fast unless your optimizer magics
 * it all away again.
 */

#undef getchar
#undef putchar
#if ! defined(HAVE_DECL_GETCHAR) && ! defined(__STDC__)
    extern int getchar();
    extern int putchar();
#endif

#include "ccx.h"

static int      goteof;      /* EOF flag */
int             yytchar;     /* the last char read */
static char     lastc;       /* pushed back char */
static int      lastcsemaphore;
int             yylineno;    /* line count */
int             yylen;       /* the length of the token we catch */
char           *yylloc;      /* where the last token came from */
VALUE           yylval;

#if 1  /* define to stress test the yylex buffering behaviour */
# define YYREADBUFFERSIZE 2
#endif

# ifndef YYREADBUFFERSIZE
# define YYREADBUFFERSIZE READBUFFERSIZE
# endif

int
yylex()
/*
 * Just in case you don't have a lexer available.
 * 
 * Read in characters into yybuffer up to the next  EOL, but ignore escaped
 * End-Of-Lines, then dole them out one at a time.
 * 
 * Return 0!=token for a good read and 0=FAILURE when an EOF is encountered.
 * 
 * I'm not quite doing things right here, since yylen actually represents the
 * size of the readahead buffer store (and doesn't decrease as I dole out
 * TOKENs), but yylloc does point to the last character out.
 * 
 * I should have yylen as 1 always.
 */
{
    /*
     * if we get an EOF not immediately after a LF, pretend we got a LF (so
     * the final line will be empty).
     */

    static char     vline[YYREADBUFFERSIZE+1];/* virtual line buffer   */
    static int      nvline;                   /* remaining in virtual line */

    char           *rline = (char *)vline;    /* pointer to real line  */

    static int      nrline;                   /* remaining in real line */
    static union {int i; VALUE v;}
                    yycast;                   /* casting hack */
    static int      yycont;                   /* this line extends previous */

    
    if (NULL != yylloc) {  /* tokens available */

      if (nvline > 0) {    /* we can use a token we read ahead for */
        yylen = 1;
        nvline--;
        nrline--;           /* this is just for accounting - no purpose */
        yytchar = * ++yylloc;
        yycast.i = yytchar; /* handle the 'cast' via union */
        yylval = yycast.v;
        return yytchar;     /* return a pre-read token */

      }

      /* nvline == 0 */

      if (yycont == 0) {

        /*
         * we ask for more TOKENS next time and return the EOL (0) now
         * It'll be used to terminate a TOKEN string, but we don't know
         * that.
         */

          yylloc = (char*)NULL; /* signal that next time we must read more */
          yylen = 0;
          nvline = 0;
          nrline = 0;       /* this is just for accounting - no purpose */
          yycast.i = 0;     /* casting hack */
          yylval = yycast.v;
          return yytchar = 0; /* return 0 token */
      } 

      /* we fake a reentry, and eventually return the first
       * next token. We haven't set anything yet, so reentry
       * can be faked by just continuing
       */

      yycont = 1;

    }

    /* yylloc == NULL signalled,  we have to load the readahead buff  */

    /* yylloc := vline - 1 for starters  (rline := vline on every entry) */

    yylloc = rline - 1;        /* we will return a token at *rline ... */
    *rline = yytchar = 0;      /* ... but we start clean               */
    nvline  = 0;               /* length of readahead buffer           */
    nrline  = 0;               /* just for accounts - no purpose       */

    /*
     * we're here because the readahead buffer was empty and so the
     * initialization conditions hold: yylloc=rline - 1, etc.
     */

    /* handle fixed length buffer and long input lines properly */

    while (fgets(rline,(vline+YYREADBUFFERSIZE)-rline,stdin) != NULL) { 
      rline[YYREADBUFFERSIZE] = 0;               /* use the extra entry */
      yylineno++;
      nrline = (int) strlen((char *) rline);     /* count the booty */

    /* check that we didn't read past a newline */

    if (nrline > 0) {
        if (rline[nrline - 1] == '\n')  {
	    --nrline;             /* we did, so null it out */
	    yycont = 0;           /* next input is new line */
	} else  {
	   /* we signal ahead not to believe that we saw an (extra) \n now.
	   */
	    yycont = 1;           /* signal that next input is same line */
	}
    }
    else {
       /* we hit eof withut finding a \n */
       yycont = 0;
    }

    nvline += nrline ;

    /* just forget about detecting escaped linefeeds */

    /* nrline > 0 */

    if (nvline == 0) {
      /* we got a linefeed only */

      yylen = 0;
      yylloc = (char*)NULL; /* signal to read ahead again next time round */
      yycast.i = 0;       /* casting hack */
      yylval = yycast.v;
      return yytchar = 0; /* return the 0 string terminator */
  
    }

    /* ordinary token return. just crank our buffer */

    nvline--;
    yylen = 1;

    /*
     * the absence of a reason to continue reading is a reason to cease
     * reading ahead
     */

    yytchar = * ++yylloc;
    yycast.i = yytchar; /* casting hack */
    yylval = yycast.v;
    return yytchar;

    }                /* endwhile */

    /* we're here because gets() failed */
    goteof = 1;
    yytchar = EOF;        /* EOF encountered */
    yylloc = (char*)NULL; /* signal that readahead buffer is empty */
    return 0;

}



int
yyinput()
/* in case no lexer */
{
    if (goteof) {
    yytchar = EOF;
    return 0;
    }
    if (lastcsemaphore > 0) {    /* an unput char must be regot */
    lastcsemaphore = 0;
    return yytchar = lastc;
    }
    /* lastcsemaphore == 0        so take a new character now */
    yytchar = getchar();
    if (yytchar == EOF)
    return 0;
    else
    return yytchar;
}

void
yyunput(int c)
/* in case no lexer */
{
    lastc = c;            /* stash char and set flag */
    lastcsemaphore++;
}

int
yyoutput(int c)
/* in case no lexer */
{
    return putchar(c);    /* straight stuff */
}

int
yywrap()
/* makes us repeat parse attempts */
{
    return 1;
}
