# include "ccx.h"

/*
 * Explanation of typing. In C++ and C the polymorphic ACTION type is
 * respectively
 *  C++: ACTION = VOID(P_DATA*, ...)
 *  C:   ACTION = VOID()
 * and the "normal" type here would ordinarily be
 *                VOID(P_DATA*)
 * which is fine as an instantiation for C polymorphism, but not so
 * fine for C++. In C++ the instantiations of a polymorphic type
 * declaration must be polymorphic themselves.
 *
 * The most obvious solution is to change the ACTION type in C++ to
 * have C linkage, which allows it to be VOID() and if these functions
 * here are also declared to have C linkage then VOID(P_DATA*) would
 * be correct. However, it appears that declaring C linkage on VOID()
 * just translates it to C++ VOID(...), and then I just can't figure
 * out how to treat that at all in C++ except by declaring C linkage
 * on everything that touches one of those, and so on, recursively,
 * until we get C linkage everywhere. That's not bad, just against the
 * C++ spirit, and I'd prefer to make some progress towards OO.
 *
 * Another solution is to give up on declaring these as ACTIONs
 * elsewhere, and to declare their natural individual types. That's
 * possible, but not neat either.
 */

#ifdef __cplusplus
VOID  p_bad_error(PRECC_DATA * self, ...){
#else
VOID  p_bad_error(PRECC_DATA * self){
#endif __cplusplus
BAD_ERROR(1);
}

#ifdef __cplusplus
VOID  p_zer_error(PRECC_DATA * self, ...){
#else
VOID  p_zer_error(PRECC_DATA * self){
#endif __cplusplus
ZER_ERROR(0);
}

#ifdef __cplusplus
VOID  p_btk_error(PRECC_DATA * self, ...){
#else
VOID  p_btk_error(PRECC_DATA * self){
#endif __cplusplus
BTK_ERROR(-1);
}

#ifdef __cplusplus
VOID  p_begin(PRECC_DATA * self, ...){
#else
VOID  p_begin(PRECC_DATA * self){
#endif __cplusplus
BEGIN;
}

#ifdef __cplusplus
VOID  p_end(PRECC_DATA * self, ...){
#else
VOID  p_end(PRECC_DATA * self){
#endif __cplusplus
END;
}

