
#include "cc.h"
#include <setjmp.h>

#undef init_jmp
#undef long_jmp
#undef push_jmp
#undef pop_jmp

/*
 * class that implements a stack of jmp_buf
 *
 * This class is used to access the pointer to the present jump target (in
 * case of a jump). The functions here only serve to isolate those accesses
 * reliably. In a namespace safe environment, they could go ..
 *
 * .. but while they are here, they are used as the basic elements in the
 * P_TRY { ... } P_CATCH(1) {  ... } P_CAUGHT; P_THROW(1) macros ...
 *
 */

/* public interface *
 * 
 *   void	init_jmp (PRECC_DATA *);
 *   void	long_jmp (PRECC_DATA *, int);
 *   jmp_buf	*push_jmp (PRECC_DATA *, jmp_buf *);
 *   void	pop_jmp (PRECC_DATA *, jmp_buf *);
 *
 */

/* private :   */

/*static jmp_buf *last_pjmp;*/

/* public :    */


void 
init_jmp (PRECC_DATA *self)
{
    self->last_pjmp = 0;		/* pointer to front of stack */
}

void 
long_jmp (PRECC_DATA *self, int retval)
{
    jmp_buf *t;
    t = self->last_pjmp;
    if (t) {
        /* printf("jump on jmp buffer %x while pstr = %s (%x)\n", t, self->_pstr, self->_pstr); */
	longjmp (*t, retval);
    }
}

int
set_jmp (PRECC_DATA *self, jmp_buf *head)
    /* just a dummy call to help debugging */
{
    static int p_retval;
    /* printf("set jmp buffer %x while pstr = %s (%x)\n", head, self->_pstr, self->_pstr); */
    return p_retval;
}

jmp_buf *
push_jmp (PRECC_DATA *self, jmp_buf * new_pjmp)
{

    /*
     * Add new element to front of stack and return a pointer
     * to the old front of the stack so that it can be saved
     * locally.
     * 
     * We need to do a prev_pjmp = push_jmp(&my_jmp) externally.
     */

    jmp_buf *t;

    t = self->last_pjmp;	/* save previous breakpoint   */
    self->last_pjmp = new_pjmp;	/* and push new breakpoint    */

    return t;                   /* return previous breakpoint */
}

void 
pop_jmp (PRECC_DATA *self, jmp_buf * prev_pjmp)
{

    /* 
     * Restore old front of stack from local saved value.
     *
     * We'll need to do a pop_jmp(&my_jmp) externally.
     */

    self->last_pjmp = prev_pjmp;	/* discard present breakpoint */
}


