
/*
   This is the evaluation engine of the parser suite - which mainly
   consists of and / or / nothing / something  parsers and super-
   combinators.

   parser = [token] -> ([token],status)
    
   Implemented as side-effecting on [token], returns status.

   ptb@comlab.ox.ac.uk ptb@eng.cam.ac.uk ptb@dit.upm.es
*/

# include "cc.h"

/* for debugging: allow some error codes to be listed out by p_evaluate()
 * before terminating
 */

# define MAXERRS 10

int 
p_evaluate (PRECC_DATA *self)
/*
 * This is the prog interpreter. It runs the instruction block starting at
 * (global) _ _pc _ with the evaluation stack pointer at (global)
 * _ value _, and returns the address (_pc') of the next block of code
 * when it exits.
 */
{
    /* all static variables made automatic for speed */

    /* static */ ACTION *a;
    /* static */ P_OPCODE n;
    /* static */ int nargs = 0; /* counting args of an action */
    /* static */ int nerrs = 0; /* how many times we've blown it */

    /* static */ PARAM args[P_MAXARGS]; /* local stack for action args */

    /* static */ P_INSTRUCTION instr;   /* instruction cache */

    int _pc;
    P_INSTRUCTION *program;

#if 0
    extern void *mkstack ();
    /* reset the evaluation stack */

    (void *) self->_value = mkstack (self->stacksize, (void **) &self->stack);
    if (!self->_value) {
        fprintf (stderr, "error: not enough memory (%d) for runtime stack\n",
                 self->stacksize);
        p_exit (1);
    }
#endif

    _pc = self->_pc;
    program = self->program;

    while (_pc < self->maxprogramsize) {

#ifndef C_COMPILE_BUG_1
        instr = program[_pc++];
        n = P_Opcode (instr);
        switch (n)
#else           /* do it quickly to avoid MSDOS bug */
        switch (n = P_Opcode (instr = program[_pc++]))
#endif
          {
          case P_CNST:            /* this is a literal */

              /* This case is not usually needed! Actions don't read the
               * attribute stack any more. Retained for -old flag.
               */

              if (self->stacktokens)
                  (self->_value++)->val = P_Value (instr);
              break;

          case P_NOP:             /* treat it as a exit */
              /* fallthrough */
          case P_EXIT:            /* end of code block */
              return (_pc);

          case P_INCR:            /* increment value stack pointer */
              /* This case is no longer needed. This instruction should never
               * be generated any more. If in doubt, uncomment the next
               * line. It makes no difference.
               */
              /* self->_value+=(int)P_Param(instr); */
              break;

          case P_PARM:            /* load parameters into local store */
              args[nargs++] = P_Param(instr);

              /* PARMs always come together before a FUNC. 
               * The rightmost arg is first to appear.
               */

              break;

          case P_FUNC:            /* We use parameters in our local store */

              /* These definitions are for spurious generality,
               * and they should go sometime. The code is not
               * machine dependent and therefore doesn't need
               * a macro to protect it.
               */

#define ARG(N) (args[N])
#define PREPARE(N)

              /* Read the opcode. */
              a = P_Action (instr);
              if (a)
                  switch (nargs) {
                    case 16:
                        PREPARE (16);
                        (*a) (self, ARG (15), ARG (14), ARG (13), ARG (12),
                              ARG (11), ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 15:
                        PREPARE (15);
                        (*a) (self, ARG (14), ARG (13), ARG (12),
                              ARG (11), ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 14:
                        PREPARE (14);
                        (*a) (self, ARG (13), ARG (12),
                              ARG (11), ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 13:
                        PREPARE (13);
                        (*a) (self, ARG (12),
                              ARG (11), ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 12:
                        PREPARE (12);
                        (*a) (self, ARG (11), ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 11:
                        PREPARE (11);
                        (*a) (self, ARG (10), ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 10:
                        PREPARE (10);
                        (*a) (self, ARG (9), ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 9:
                        PREPARE (9);
                        (*a) (self, ARG (8),
                              ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 8:
                        PREPARE (8);
                        (*a) (self, ARG (7), ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 7:
                        PREPARE (7);
                        (*a) (self, ARG (6), ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 6:
                        PREPARE (6);
                        (*a) (self, ARG (5), ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 5:
                        PREPARE (5);
                        (*a) (self, ARG (4),
                              ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 4:
                        PREPARE (4);
                        (*a) (self, ARG (3), ARG (2), ARG (1), ARG (0));
                        break;
                    case 3:
                        PREPARE (3);
                        (*a) (self, ARG (2), ARG (1), ARG (0));
                        break;
                    case 2:
                        PREPARE (2);
                        (*a) (self, ARG (1), ARG (0));
                        break;
                    case 1:
                        PREPARE (1);
                        (*a) (self, ARG (0));
                        break;
                    case 0:
                        PREPARE (0);
                        (*a) (self);
                        break;
                    default:
                        fprintf (stderr,
                        "error: too many args (%d) in action call\n", nargs);
                        fprintf (stderr, "     : program counter: %d\n", _pc);
                        fprintf (stderr, "     : line number    : %d\n", * self->yylinenop);
                        p_exit (1);
                  }

              /* get rid of the fake generalizations we just
               * did/didn't use!
               */
#undef PREPARE
#undef ARG
              nargs = 0;        /*  We used up all the args OK */
              break;

          default:
              fprintf (stderr,
                       "The \"engine\" module reports a client has overwritten the\n");
              fprintf (stderr,
                       "program area it is interpreting. This foreign code will be\n");
              fprintf (stderr,
              "skipped for now but other insertions may not be detected\n");
              fprintf (stderr,
                 "and could cause a program crash. The following may be\n");
              fprintf (stderr, "useful for debugging purposes:\n\n");
              fprintf (stderr, "error: illegal opcode (%d)\n", n);
              fprintf (stderr, "     : program counter(%d)\n", _pc);
              fprintf (stderr, "     : line number    (%d)\n", * self->yylinenop);
              if (nerrs++ < MAXERRS)
                  break;        /* allow a retry */
              fprintf (stderr, "engine: Too many errors (%u)\n", MAXERRS);
              p_exit (1);
              return (_pc);

          } /* end case */
    } /* end while loop; overflow code below */

    fprintf (stderr, "precc: program stack overflow (%d)\n", _pc);
    p_exit (1);
    return -1; /* to avoid compiler warning */

}

static
void
readerror(PRECC_DATA * self,int n)
/* raise an error because the read buffer has overflowed */
{
    /* If this ever attempts to replace buffer (and lvbuff) with a bigger
     * one, then we have to go through the frame stack too, replacing
     * references to the buffer. Either that or we have to use offsets
     * instead of pointers (_pstr).
     */

    if (1)
    {
      fprintf(stderr,
      "Hello. This is the \"engine\" module reporting that the read buffer\n");
      fprintf(stderr,
      "has overflowed and can't be extended. I will execute all pending actions\n");
      fprintf(stderr,
      "now and reset the buffer, which should get you out of this hole,\n");
      fprintf(stderr,
      "but the parser will not backtrack through this point any longer,\n");
      fprintf(stderr,
      "which may send you down an unusual parse path with consequent errors.\n");
      fprintf(stderr,
      "Please check that you really needed this much look ahead!\n\n");
      fprintf(stderr,
      "The buffer is currently set at %d tokens and it has read %d tokens.\n\n",
      self->readbuffersize, n);
      fprintf(stderr,
      "To prevent reoccurrence, insert more cut marks (!) in the definition\n");
      fprintf(stderr,
      "script or increase the READBUFFERSIZE macro definition\n");
      fprintf(stderr,
      "or use a command line option, if available. I'm sorry, I'm just\n");
      fprintf(stderr,
      "a simple engine and I don't know what they have up there!\n\n");
      p_uniq0(self);
    }
    /* otherwise we made it bigger OK */
}

/* get1token() is the ONLY place I call yylex() - it is the
 * interface with the lexer and I am trying to give it most
 * rights over _pstr and _maxp too.
 */

TOKEN 
get1token (PRECC_DATA *self)

/* Yylex() a token into the NEXT position for _pstr if we are currently
 * at _pstr=_maxp, and increment _pstr. Otherwise just increment _pstr
 * and return the token we see.

 * Also get the matching attribute into the lvbuff, increase _maxp if
 * needed.

 * Return EOF for fail and the token otherwise. Note that _pstr is always
 * incremented by this call.

 * At the moment, I am calling readerror() on overflow, which may
 * eventually dynamically extend the buffer. I think it (would) work.
 */
{
    if (++self->_pstr <= self->_maxp)
        return *self->_pstr;       /* There was a read ahead token available */

    if ((TOKEN) * self->yytcharp == (TOKEN) EOF)         /* we got EOF before already */
        return (TOKEN) EOF;

    /* Now a check that I never used to do, for speed,
     * but which seemed to be the cause of most bangs.
     */

    /* logically this ought to be 1 on the safe
     * side, but I seem not to be able to take it
     * away without problems when _maxp < _pstr.
     */

    if ((self->_pstr - self->buffer) >= self->readbuffersize) {

        /* trying to read beyond the buffer */
        self->_pstr--;     /* don't claim to have read it yet */

        /* this may elongate the buffer */
        readerror (self, self->_pstr - self->buffer);

        self->_pstr++;     /* ready to try to read this again */
    }

#if 0
    self->yybuffer = self->_pstr;    /* We give yylex a buffer - ours */
#endif
    *self->_pstr = self->yylex ();   /* We read yylex's return token. */

    /* Just in case yylex forgot to tell us ... */
    if ((TOKEN) * self->yytcharp == (TOKEN) EOF)
        return (TOKEN) EOF;

    /* We read yylex's stashed attribute ... */
    self->lvbuff[(int) (self->_pstr - self->buffer)] = * self->yylvalp;

    /* Someday the lvbuff and the buff should be
     * combined into one! This parallel reading
     * is just silly. We'd only need ONE pointer then.
     */

    /* We're only here because we had _maxp < _pstr' */
    self->_maxp = self->_pstr;

    return *self->_pstr;   /* Everybody happy. This is `_pstr+1 */
}

void 
realignbuffer (PRECC_DATA *self)
/* Set _pstr back to buffer and copy the buffer over itself so that the
 * token we have just read now seems to be in the first buffer position.
 */
{
    int n;                      /* the number of readahead tokens */
    int o;                      /* the _pstr starting offset */

    /* this doesn't count the present token */
    n = (int) (self->_maxp - self->_pstr);

    o = (int) (self->_pstr - self->buffer);

    /* get the first token */
    *self->buffer = *self->_pstr;
    *self->lvbuff = self->lvbuff[o];

    /* now get the rest */
    if (n > 0) {
        memcpy (self->buffer + 1, self->_pstr + 1, n * sizeof (TOKEN));
        memcpy (self->lvbuff + 1, self->lvbuff + o + 1, n * sizeof (VALUE));
    }

    /* Finally, reset _pstr and _maxp to point to the front of the buffer */
    self->_pstr = self->buffer;
    self->_maxp = self->_pstr + n;
}


static
VOID
p_run_once (PRECC_DATA *self, PARSER *p)
/* discharge actions and run parser p */
{
        static STATUS tok;

        /* _maxp = _pstr
                 = buffer;     - all this is now set by our caller */

        self->_pc = 0;  /* program start address */
        self->fptr = self->fstack+1;   /* frame stack zeroed ! */
        tok      = (*p) (self);  /* call the parser designated as entry point */

        if (GOODSTATUS(tok))
        {                   /* same as p_uniq0() */
            p_pushEXIT;

            /* we catch programs without EXIT in p_evaluate so it is safe to
             * actually not write an EXIT here if the program  space is full */

            self->_pc = 0;         /* program start address */
            self->_pc = p_evaluate (self);

                            /* p_evaluate wants to start with _pc=0 next time */

            self->_pc=0;
            self->_passcount++;

                            /* if an error occurred, you might want to look at
                             * self->program[self->_pc-1] now
                             */

            if (* self->_pstr)
                self->zer_error(self);/* incomplete parse */
        }
        else
            self->bad_error(self) ;   /* failed parse */
}

VOID  p_run (PRECC_DATA * self, ...)
/*
  Read lines from terminal, parse them, and if they are good according to p,
  execute the program that p built up. If the line is bad, re-echo it -
  thats the default error action, anyhow. Read the source here to find
  out what really happens on error!

  There is some fuzzy logic in here which has meant that this routine
  has taken a lot of debugging in the past. It needs some more formal
  thinking about still. To do.
*/
{
          static int retval;

          /* we don't really accept args for the parser yet  - we could */
          PARSER *p;
          int n;
          va_list ap;

          va_start(ap, self);
          p = va_arg(ap,PARSER *);
          n = va_arg(ap,int);        /* always 0 at present */
          va_end(ap);


          self->p_entry = 0;         /* The user btk error parser */

          for (;self->yywrap();)     /* While _once_ & almost forever ... */
          switch(retval = setjmp(self->jmpb)) /* Longjmp here on btk error */
          {
             case 0:                 /* Normal continuation */



                    if (self->precc_begin)
                    self->precc_begin (self);  /* User defined setup stuff */

                    if(!self->_pstr) /* Not set yet! Then it's the ... */
                    {                /* ... first time through */
                        self->_pstr = self->_maxp  /* we set it. */
                                    = self->buffer;
                                     /* or - 1  maybe? Seems OK as is. */
                       *self->_pstr = 0; /* Set to canonical situation */
                    }

         /* Else -
          * we got here with _pstr set but *_pstr = 0 because the
          * parse read everything successfully, including a final EOL,
          * so we have to skip the 0 and get another token. Then we
          * realign the buffer to make the new token irrevocably first.
          * What a good idea!
          */
                    if (! * self->_pstr)  /* increment _pstr */
                    {
                        if (get1token(self) == (TOKEN)EOF)
                        {            /* passed EOF */
                             if (self->precc_end)
                                self->precc_end (self);
                             return;
                        }
                    }

         /* Open questions -
          * can we get here successfully with *_pstr nonzero? and
          * if so what do we do with the token? That should mean ZER_ERROR
          * which would have invoked the error handler and jumped elsewhere.
          *
          * I think we just realign so that the token is first, which means
          * we are in danger of reparsing it, but the alternative is to
          * throw it away. To throw it away, remove the if(!* ... _pstr) above.
          */
                    else  /* debug trap - seems never to be sprung */
                    {
                       self->_pstr = self->_pstr;
                    }

          /* Because the above trap is never sprung I believe that
           * indeed *_pstr nonzero is impossible here. It should cause a
           * ZER_ERROR and be treated elsewhere (where?).
           */

         /* Now we have a genuine token, make it first */

                    realignbuffer(self);

                    p_run_once (self, p);
                    break;

             default:                /* error action */

             if (self != (PRECC_DATA*)retval) {
                 fprintf(stderr,"aiee! p_run(%x) handles btk_error in different parser (%x)\n",(int)self,retval);
                 self = (PRECC_DATA*)retval;
             }

         /* We had an error, which means that there are probably read
          * ahead tokens to deal with. Now we are about to apply our
          * reserve parser to them. It had better be very forgiving
          * or we will be in trouble.
          */

         /* Another question -
          * should we pull a token to prevent same error again?
          * Maybe, but why? It's really the error parser's lookout.
          */

         /* We realign the buffer because there will be no backtrack */

                    realignbuffer(self);

                    if (self->p_entry)
                      p_run_once (self, self->p_entry);

        /* I hope that ate everything OK, and it is time to behave
         * normally again.
         */

                    break;
          }

        /* Go round the loop */
}

