
/*
   parser suite - and / or / nothing / something  parsers

   parser = [token] -> ([token],status)
    
   implemented as sideeffecting on [token], returns status.
*/


# include "cc.h"

P_BEGIN

STATUS   p_nothing0 (PRECC_DATA * self)
/*
parser succeeds without looking at any tokens from
the input stream.
*/
{
    static STATUS p_tok;

    p_pushINCR;

    return SUCCESS;
}


STATUS   p_anything0 (PRECC_DATA * self)
/*
Parser which takes any token at all - except 0 - and places it as
a constant on the program stack.  This parser only fails at EOS.
*/
{
    TOKEN c;
    VALUE v;
    static STATUS p_tok;

        c = *self->_pstr;
        v = self->lvbuff[(int)(self->_pstr - self->buffer)];
        if (c)
        {
           P_MOVEON;
           p_pushVALUE(v);
           return OK(v);    /* so CAN'T use attribute 0 */
        }

        P_THROW("p_anything0");

        return FAILURE;
}

STATUS   p_first0 (PRECC_DATA * self)
/*
This parser only succeeds at BOS and does nothing
*/
{   
    static STATUS p_tok;

    if ((void*)self->_pstr <= (void*)self->buffer
            || ! self->_pstr[-1])
    {
        p_pushVALUE((p_tok.status=EOF,p_tok.value));
        return SUCCESS;
    }
    /* doesnt move on */

    P_THROW("p_first0");

    return FAILURE;
}

STATUS  p_eof0 (PRECC_DATA * self)
{
    static STATUS p_tok;

    if ((TOKEN)yytchar==(TOKEN)EOF && ! * self->_pstr)
        /* cast in case unsigned */
    {
       p_pushVALUE((p_tok.status=EOF,p_tok.value));
       return SUCCESS;
    }

    P_THROW("p_eof0");

    return FAILURE;
}

STATUS  p_uerror0  (PRECC_DATA * self, PARSER *p)  
/* return OK but set a frame boundary and an error handler parser p */
{
        static STATUS p_tok;

        p_pushEXIT;

        self->_pc=0;
        self->_pc=p_evaluate (self);
        self->_pc=0;  
        /* have to write the next program in the right place */

        /* we can't reset the _pstr at present. Only when we get a backtrack
           can we seem to be able to do it, perhaps because that's like an
	   escape to top level, where
           we do reset the _pstr every time. The problem is MAYBE that earlier
           sequents are holding frame info which points into the _pstr as
           it is now. OK, we can't backtrack to them, but still ...
           -- hmm. this may be past history now.
         */


        /* this used to cause crashes  */

        /* there's an ordinary token up ahead. Let's play with it. */
        realignbuffer(self);

        self->_passcount++;  /* that means that a backtrack error will be
                         signalled if we try and backtrack through here */

#if 1
        init_jmp(self);     /* set the jump stack to zero - can't backtrack */

        self->p_enargs= 0;
        self->p_entry = p;  /* set the btk_error reentry pt */
#else /* failed  attempt at handling cuts on the jump stack */
        init_jmp(self);     /* set the jump stack to zero - can't backtrack */
        P_TRY {             /* register a jump target here */
          goto escape;      /* don't pop the jump */
        } P_CATCH(-1) {     /* in case we catch we will restore */
          P_RESTORE;
          return (*p)(self);
        } P_CAUGHT;
escape:
#endif

        /* in theory, we should dump our outstanding alternate parses too */


        /* Uh, not at all sure about the next, folks! - we won't backtrack
         * but we are still inside various andparse things that will all
         * try and pop the frame stack as they exit!!
         */

        return SUCCESS;

   /* and don't reset STACKVALUE *value because we may later backtrack
    * to earlier stack values  - hey, that's past history now too!
    * We don't have an attribute stack any more. */
}

STATUS  p_uniq0  (PRECC_DATA * self)
{
    return p_uerror0(self, 0);
}


STATUS  p_lastuniq0  (PRECC_DATA * self)
{
    static STATUS p_tok;

    if ((TOKEN)yytchar==(TOKEN)EOF) /* we saw EOF already so don't try again */
        return FAILURE;

    /* the problem here is that we want to execute what we have
     * before pulling more characters so we can't call p_last0(),
     * which pulls, before p_uniq, which executes. So we just
     * have to duplicate the p_uniq0 code early.
     */

    if (! * self->_pstr)   /* we're in the right place to try & move on  */
    {
        p_pushEXIT;   /* remember to execute before pulling ...*/
        self->_pc=0;
        self->_pc=p_evaluate (self);
        self->_pc=0;        /* ... a new line */

        self->p_enargs= 0;
        self->p_entry = 0;  /* set the btk_error reentry pt */

        /* in theory, we should dump our outstanding alternate parses too */

        init_jmp(self);

        if (get1token(self) != (TOKEN)EOF)
        {            /* we got a new token and we restart */
            realignbuffer(self);
            p_pushVALUE((p_tok.status=1,p_tok.value));
            self->_passcount++;

            return SUCCESS;
        }
                     /* at EOF */

                return SUCCESS;
   }

                /* not at EOL */
   P_THROW("p_lastuniq0");

   return FAILURE;

}

STATUS   p_last0 (PRECC_DATA * self)
/*
This p_parser only succeeds at EOS.
*/
{
    static STATUS p_tok;

    if ((yytchar!=EOF) && ! * self->_pstr)  /* does move on */
        {
            P_MOVEON;
            p_pushVALUE((p_tok.status=EOF,p_tok.value));

         /* the P_MOVEON did the pull of a token into the lookahead buff */
            
            return SUCCESS;
        }

    P_THROW("p_last0");

    return FAILURE;
}


#if ! defined(__STDC__) || defined(__cplusplus)
STATUS   p_exactly0 (PRECC_DATA * self, TOKEN   c)
#else  /* use automatic promotions */
 STATUS   p_exactly0 (self, c)
 PRECC_DATA * self;
 TOKEN c;
#endif
/*
this parser only succeeds when given token c.
It places the token's attribute as a literal on the program stack,
but not on the value stack. It gets put onto the latter at
runtime. It's also the return value, and a NULL attrib is changed
according to the OK macro to prevent a FAIL return in those cases.
*/
{
    VALUE v;
    static STATUS p_tok;

    if (* self->_pstr && * self->_pstr == c)
    {                     /* read the attribute value */
        v = self->lvbuff[(int)(self->_pstr - self->buffer)];
        P_MOVEON;
        p_pushVALUE(v); /* save the attribute on the program stack */
        return OK(v);
    }

    #ifdef JMP_DEBUG
    { static char buff[] = "p_exactly0 reject t as c";
      sprintf(buff,"p_exactly0 reject %c as %c",*self->_pstr,c);
      P_THROW(buff);
    }
    #else
      P_THROW("p_exactly0");
    #endif

    return FAILURE;
}

#if ! defined(__STDC__) || defined(__cplusplus)
STATUS   p_notexactly0 (PRECC_DATA * self, TOKEN   c)
#else  /* use automatic promotions */
 STATUS   p_notexactly0 (self, c)
 PRECC_DATA * self;
 TOKEN c;
#endif
/*
this parser only succeds when given a TOKEN not equal to c.
It places the token's attribute as a literal on the program stack.
*/
{
    VALUE v;
    static STATUS p_tok;

    if (*self->_pstr && * self->_pstr != c)
    {
        c = *self->_pstr;
        v = self->lvbuff[(int)(self->_pstr - self->buffer)];
        P_MOVEON;
        p_pushVALUE(v);
        return OK(v);
    }

    P_THROW("p_notexactly0");

    return FAILURE;
}

STATUS  p_attach0 (PRECC_DATA * self, PARSER *p)
{
    return (*p) (self);
}


VOID  p_nop(PRECC_DATA * self)
/*
a very trivial stack manipulation action
*/
{
}

#undef p_atch0
STATUS  p_atch0 (PRECC_DATA * self, VALUE v)
/*
trivial parser which returns a fixed value
*/
{
    static STATUS p_tok;

    return OK(v);
}

STATUS
p_test0 (PRECC_DATA * self, int x)
/* succeed if x is 1, fail if x is 0 */
{
    static STATUS p_tok;

    if (x)
    {
        p_pushVALUE((p_tok.status=x,p_tok.value));
        return SUCCESS;
    }

    P_THROW("p_test0");

    /* never reached */
    return FAILURE;
}

P_END

