/*
   parser suite - and / or / nothing / something  parsers

   parser = [token] -> ([token],status)
    
   implemented as sideeffecting on [token], returns status.
*/

# include "ccx.h"

static ARGUNIT a0[P_MAXARGS];	/* buffer holds the fn parameters */
static ARGUNIT *a = a0;         /* pointer to buffer or real params! */

extern int orcount;

STATUS
p_errparse0 (PRECC_DATA * self, ...)
/* I'm just here to help detect errors */
{
    static STATUS p_tok;

    fprintf(stderr,"An unspecified parser has been called. Aborting.\n");
    p_exit(100);
        /* this is never called */
    return FAILURE;
}


static
VOID
callerror(int m)
/* aux: for diagnosing errors in the P_CALL macro */
{
    fprintf(stderr,"error: too many (%d) args in P_CALL\n",m-1);
    p_exit(100);
}


STATUS 
#if 0
p_andparse0n (PRECC_DATA *self, va_alist)
     va_dcl
#else
p_andparse0n (PRECC_DATA *self, ...)
#endif
/*
 * Serial composition of parsers. Does
 * first p then q. Put p's instructions on the
 * top of the program stack, then layer q's above
 * it.
 * This version has full rewind of the input stream on
 * failure, but this can be altered to single token
 * lookahead by deleting the line of code marked.
 */
{
    static PARSER *p;
    static PARSER *q = (PARSER*)p_errparse0;
    va_list ap;

    static int m;
    static STATUS p_tok;

    P_MARK;

    va_start (ap, self);

    p = va_arg (ap, PARSER *);

    P_CALL (p_tok = (*p), m, a);

    if (BADSTATUS (p_tok)) {
	va_end (ap);
	P_RELEASE;
	return p_tok;
    }

    q = va_arg (ap, PARSER *);

    P_CALL (p_tok = (*q), m, a);

    va_end (ap);

    if (BADSTATUS (p_tok)) {	/* error */
	P_REWIND;		/* remove this line for 1-token LA parsing */
	return p_tok;		/* fail */
    }

    p_pushDECR;
    P_RELEASE;

    return p_tok;		/* succeed */
}


STATUS
#if 0
p_orparse0n (PRECC_DATA * self, va_alist)
     va_dcl
#else
p_orparse0n (PRECC_DATA * self, ...)
#endif
/*
 * alternate composition of parsers. Tries p first,
 * and if it doesnt work, tries q. Code corresponding
 * to the successful parse is placed on the program stack.
 * If both fail, the routine relies on p and q's auto-rewind
 * mechanisms to do the rewind for it.
 */
{
    volatile va_list ap; /* non-reg to avoid compiler warning */

    static PARSER *p;
    static PARSER *q = (PARSER*)p_errparse0;
    static int m;
    static STATUS p_tok;

    P_MARK;

    va_start (ap, self);
    p = va_arg (ap, PARSER *);

    P_TRY {	/* set our breakpoint */

	  P_CALL (p_tok = (*p), m, a);

        } P_CATCH(P_THROWABLE) {

	  /* we got here because of a fail from p and a long_jmp   */
	  /* so we have to try and restore the frame stack as well */

	  P_REWIND;
          p_tok = FAILURE;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {

	      va_end (ap);
	      return p_tok;	/* succeed */
    }

   /* failure -- assume the callee retracted all correctly */

    /* we have to try our second option */

    P_TRY {	/* tell people to jump back here */

	  q = va_arg (ap, PARSER *);

	  P_CALL (p_tok = (*q), m, a);

    } P_CATCH(P_THROWABLE) {

	  /* we got here because of a fail from q and a long_jmp  
	   * so we have to try and restore the frame stack
           */

	  P_REWIND;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {

              va_end(ap);
	      return p_tok;	/* success */
    }

    /* failure -- assume the callee retracted all correctly */

    /* no more options - we have to fail */

    P_RELEASE;

    /* jump to previous jump location */

    va_end (ap);
    P_THROW("p_orparse0n");

    /* never reached */

    return p_tok;		/* fail */
}

STATUS 
#if 0
p_hidden0n (PRECC_DATA * self, va_alist)
     va_dcl
#else
p_hidden0n (PRECC_DATA * self, ...)
#endif
/* parser which tries p, but doesn't moveon, just reports the result
 * of p.
 */
{
    static va_list ap;

    static PARSER *p;
    static int m;
    static STATUS p_tok;
    P_MARK;

    va_start (ap, self);
    p = va_arg (ap, PARSER *);

    P_TRY {	/* set our breakpoint */

	  P_CALL (p_tok = (*p), m, a);

    } P_CATCH(P_THROWABLE) {

	  /* we got here because of a fail from p and a long_jmp   */
	  p_tok = FAILURE;

    } P_CAUGHT;

    va_end (ap);

    P_REWIND;

    if (GOODSTATUS (p_tok)) {
	p_pushVALUE (p_tok.value);
	return p_tok;
    }

    /* failure */

    P_THROW ("p_hidden0n");

    /* never reached */

    return p_tok;
}


STATUS 
#if 0
p_option0n (PRECC_DATA * self, va_alist)
     va_dcl
#else
p_option0n (PRECC_DATA * self, ...)
#endif
/* parser which tries p, but doesnt worry if p fails,
 * just rewinds and considers itself happy with nothing at all.
 */
{
    static va_list ap;

    static PARSER *p;
    static int m;
    static STATUS p_tok;

    P_MARK;

    va_start (ap, self);
    p = va_arg (ap, PARSER *);

    P_TRY {	/* set our breakpoint */

	  P_CALL (p_tok = (*p), m, a);

    } P_CATCH(P_THROWABLE) {

	  /* we got here because of a fail from p and a long_jmp   */
	  /* so we have to try and restore the frame stack as well */

	  P_REWIND;
          p_tok = FAILURE;

    } P_CAUGHT;

    va_end (ap);

    if (GOODSTATUS (p_tok)) {

	      P_RELEASE;

	      return p_tok;
    }

    /* failure -- assume the callee retracted all correctly */

    P_RELEASE;

    p_pushINCR;

    return SUCCESS;
}

STATUS 
#if 0
p_many0n (PRECC_DATA * self, va_alist)
     va_dcl
#else
p_many0n (PRECC_DATA * self, ...)
#endif
{
    static int m;
    static va_list (ap);
#ifdef  C_VASTART_REPEAT_BROKEN
    va_list (ap1);		/* this shenanigan is for a hp/gcc-2.7.2 bug */
#endif
    static PARSER *p;
    static STATUS p_tok;
    volatile STATUS q_tok = SUCCESS; /* non-reg to avoid compiler warning */

    P_MARK;

/* to use this from a function which has parameters foo,m,a1,...,am
   use va_start(ap,foo) and call us */

    P_TRY {	/* set our breakpoint */

	  p_tok = SUCCESS;

#ifdef  C_VASTART_REPEAT_BROKEN
	  ap1 = ap;		/* this shenanigan is for a hp/gcc-2.7.2 bug */

	  do {

	      va_start (ap, self);
              p = va_arg (ap, PARSER *);

	      ap = ap1;		/* this shenanigan is for a hp/gcc-2.7.2 bug */

#else

	  do {

	      va_start (ap, self);
              p = va_arg (ap, PARSER *);

#endif

	      q_tok = p_tok;

	      P_CALL (p_tok = (*p), m, a);

	      va_end (ap);

	  } while (GOODSTATUS (p_tok));

	  /* failure -- assume the callee retracted all correctly */

	  P_RELEASE;

          } P_CATCH(P_THROWABLE) {

	  /* we got here because of a fail from p and a long_jmp   *
	   * so we have to try and restore the frame as well *
	   * but only as far as the last success
	   */

	  va_end (ap);

	  P_REWIND;

    } P_CAUGHT;

    return q_tok;		/* last successful value */
}



STATUS
#if 0
p_uerror0n (PRECC_DATA * self, va_alist)
va_dcl
#else
p_uerror0n (PRECC_DATA * self, ...)
#endif
{
    static va_list(ap);

    static PARSER *p;
    static int m;
    static STATUS p_tok;

        va_start(ap,self);
        p = va_arg (ap, PARSER *);
# if 1
        m=va_arg(ap,int);
	P_GRABARGS(m,a,ap);
#else
       P_TRY {
         p_tok = FAILURE;
         goto pling_and_do_more; /* avoids P_RESTORE = pop_jmp */
       } P_CATCH(-1) {
         P_CALL(p_tok=(*p),m,a);
         p_tok = SUCCESS;
       } P_CAUGHT;

#endif

        va_end(ap);

        if (BADSTATUS(p_tok)) {
          return SUCCESS;
        }

        self->p_entry = p;  /* set the btck_error reentry pt */
        self->p_enargs= m;

        init_jmp(self);   /* discard jump stack */

        if (m>0) {
          while (--m >= 0) {
            self->p_eargv[m] = a[m];
          }
          m = self->p_enargs;  /* restablish m in case we need it */

       }

pling_and_do_more:

        p_pushEXIT;

        self->_pc = 0;
        self->_pc = p_evaluate(self);
        self->_pc = 0;      /* we have to write the next program in
                                 * the right place */

        if ((TOKEN)yytchar!=(TOKEN)EOF && ! * self->_pstr) /* we can ask */
            if (get1token(self) != (TOKEN)EOF)
            {                   /* cast in case unsigned */
                /* now we restart */
                realignbuffer(self);
            }

        self->_passcount++;

        return SUCCESS;
}

STATUS 
#if 0
p_iter0n (PRECC_DATA * self, va_alist)
va_dcl
#else
p_iter0n (PRECC_DATA * self, ...)
#endif
{
    static va_list(ap);
#ifdef C_VASTART_REPEAT_BROKEN
    va_list(ap1);/* this shenanigan is for a gcc 2.7.2 bug on hp's */
# endif

    static int m;
    static int repeat;
    static PARSER * p;
    static STATUS p_tok;
    int k;
    P_MARK;

    va_start(ap,self);
    repeat = va_arg (ap, int);
    k = repeat;
    p = va_arg (ap, PARSER *);

#ifdef C_VASTART_REPEAT_BROKEN
    ap1 = ap;  /* this shenanigan is for a gcc 2.7.2 bug on hp's */
# endif

    while(k-->0)
    {
#ifdef C_VASTART_REPEAT_BROKEN
        ap = ap1;  /* this shenanigan is for a gcc 2.7.2 bug on hp's */
# else
        va_start(ap,self);
        repeat = va_arg (ap, int);
        p = va_arg (ap, PARSER *);
# endif

        P_CALL(p_tok=(*p),m,a);

#ifdef C_VASTART_REPEAT_BROKEN
        ap = ap1;  /* this shenanigan is for a gcc 2.7.2 bug on hp's */
# else
        va_end(ap);
# endif

        if (BADSTATUS(p_tok))
        {
            P_REWIND;

#ifdef C_VASTART_REPEAT_BROKEN
            va_end(ap);
# endif
            return p_tok; /* failed early */
        }
    }

#ifdef C_VASTART_REPEAT_BROKEN
        va_end(ap);
# endif

    P_RELEASE;
    return p_tok;  /* return the last successful value */
}


STATUS
#if 0
p_prepend0n (PRECC_DATA * self, va_alist)
va_dcl
#else
p_prepend0n (PRECC_DATA * self, ...)
#endif
{
    static PARSER *p;
    static ACTION *f;
    static STATUS p_tok;
    static int m;

    va_list(ap);
    P_MARK;

    va_start(ap,self);
    f = va_arg (ap, ACTION *);

    m=va_arg(ap,int);
    P_GRABARGS(m,a,ap)
    m++;

    while(--m>0)
    {
         p_pushPARAM(a[m-1]);
    }

    p_pushACTION(f);

    p = va_arg(ap,PARSER *);

    P_CALL(p_tok=(*p),m,a);

    va_end(ap);

    if (GOODSTATUS(p_tok))
    {
        P_RELEASE;
        return p_tok;
    }

    P_REWIND;

    return p_tok;
}




STATUS
#if 0
p_some0n (PRECC_DATA * self, va_alist)
va_dcl
#else
p_some0n (PRECC_DATA * self, ...)
#endif
/*
At least one repetition of parser p
*/
{
    static va_list(ap);  /* we reset this after every call to a p */

    static PARSER *p;
    static int m;        /* and ditto */
    static STATUS  p_tok;

    va_start(ap,self);
    p = va_arg (ap, PARSER *);

    P_CALL(p_tok=(*p),m,a);

    va_end(ap);

    /* this should really be a call of p_many0v(p,m,ap) */

    if (GOODSTATUS(p_tok))
    {
        va_start(ap,self);   /* reset the ap */
        p = va_arg (ap, PARSER *);
        P_CALL1(p_tok=p_many0n,p,m,a); 

        p_pushDECR;
        va_end(ap);
    }
            
    return p_tok;
}




STATUS
#if 0
p_attach0n (PRECC_DATA * self, va_alist)
va_dcl
#else
p_attach0n (PRECC_DATA * self, ...)
#endif
/*
attach an action to a parse.
*/
{
    va_list(ap);

    static PARSER *p;
    STATUS p_tok;
    static int m;
    static ACTION *f;

    va_start(ap,self);
    p = va_arg (ap, PARSER *);
    
    P_CALL(p_tok=(*p),m,a);

    f=va_arg(ap,ACTION*);

    m=va_arg(ap,int);

    P_GRABARGS(m,a,ap);
    m++;

    va_end(ap);

    if (GOODSTATUS(p_tok))
    {
           while(--m > 0)
	   {
             p_pushPARAM(a[m-1]);
           }

        p_pushACTION(f);
        return p_tok;          /* success */
    }

    P_THROW("p_attach0n");

    /* never reached */
    return p_tok;          /* fail */
}

STATUS 
p_range0n (PRECC_DATA * self, va_alist)
     va_dcl
{
    static va_list (ap);

    static PREDICATE * p;
    BOOLEAN tok;		/* could make this static, but range is
				 * always a leaf */
    static int m;		/* so it's hardly worth the bother. */
    static STATUS p_tok;

    TOKEN c;
    VALUE v;

    va_start (ap, self);
    p = va_arg (ap, PREDICATE *);

    m = va_arg (ap, int);
    P_GRABARGS (m, a, ap);
    m++;

    va_end (ap);

    c = *self->_pstr;
    v = self->lvbuff[(int) (self->_pstr - self->buffer)];

    switch (m - 1) {
      case 0:
	  tok = (*p) (c);
	  break;
      case 1:
	  tok = (*p) (c, a[0]);
	  break;
      case 2:
	  tok = (*p) (c, a[0], a[1]);
	  break;
      case 3:
	  tok = (*p) (c, a[0], a[1], a[2]);
	  break;
      case 4:
	  tok = (*p) (c, a[0], a[1], a[2], a[3]);
	  break;
      case 5:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4]);
	  break;
      case 6:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5]);
	  break;
      case 7:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6]);
	  break;
      case 8:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]);
	  break;
      case 9:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8]);
	  break;
      case 10:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9]);
	  break;
      case 11:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9], a[10]);
	  break;
      case 12:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9], a[10], a[11]);
	  break;
      case 13:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9], a[10], a[11], a[12]);
	  break;
      case 14:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9], a[10], a[11], a[12], a[13]);
	  break;
      case 15:
	  tok = (*p) (c, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7],
		      a[8], a[9], a[10], a[11], a[12], a[13], a[14]);
	  break;
      default:
	  fprintf (stderr, "error: too many (%d) args in predicate\n", m - 1);
	  tok = 0;		/* to avoid compiler complaint */
	  p_exit (100);
    }

    if (tok) {
	P_MOVEON;
	p_pushVALUE (v);
	return OK (v);
    }

    P_THROW("p_range0n");

    /* never reached */

    return FAILURE;
}

STATUS   p_nothing0n (PRECC_DATA * self, ...)
/*
parser succeeds without looking at any tokens from
the input stream.
*/
{
    static STATUS p_tok;

    p_pushINCR;

    return SUCCESS;
}

