
/*
 * parser suite - and / or / nothing / something  parsers
 *
 * parser = [token] -> ([token],status)
 *
 * implemented as sideeffecting on [token], returns status.
 */

#include "cc.h"
#include <stdlib.h>

#ifdef HAVE_ALLOC_H
#include <alloc.h>		/* we're in DOS */
#endif

    /* bad hack to prevent yacc-style stack underflow (used only by precc) */

#ifndef VALUE_STACK_SAFETY_MARGIN
#define VALUE_STACK_SAFETY_MARGIN 4
#endif

    /* compilation warnings for maybe losing digits from the args of
     * p_calloc should always be ignored. The numbers can't be that big!
     */

static void *mkgen (void *, int, int);
static void *freegen (void *);

static void *
mkgen (void *s, int n, int m)
/* if s is NULL, make a generic item of size n*m and put it in s */
{
    if (s)	 /* _stupid_ return value. It might as well be s */
	return NULL;
    else
        return s = (void *) p_calloc ((unsigned long) n, (unsigned long) m);
}

void *
mkstack (int n, void **s1)
/* make the yacc-attribute stack of the right sizes and install it */
{
    /* we seem to need a safety margin - that is simpler than debugging
     * some of the programs that underflow the stack! Since there is
     * only one of these using this stack nowadays (precc itself), I
     * feel safe in using this outrageous hack. Perhaps the stack ought
     * to adjust the rest of the data downwards when it underflows :-) ?
     */
    void *s2;

    if (n <= VALUE_STACK_SAFETY_MARGIN) {
	n = VALUE_STACK_SAFETY_MARGIN + 1;
    }

    /* we just do the reset part if the stack is already there
     * so we can act as a universal setup interface to it.
     */

    if (!*s1) {			/* something to do */

	*s1 = mkgen (*s1, VALUE_STACK_SAFETY_MARGIN + n, sizeof (P_STACKVALUE));

	if (*s1) 
	    s2 = (void *)((P_STACKVALUE*)*s1 + VALUE_STACK_SAFETY_MARGIN);
	else 
	    s2 = NULL;

	return s2;
    }
                            /* nothing to do */
    s2 = (void *)((P_STACKVALUE*)*s1 + VALUE_STACK_SAFETY_MARGIN);
    return s2;
}

static VOID
mkdblbuffer (int n, TOKEN ** tb, VALUE ** vb)
/* Make the read buffers of the right size in the same zone, but offset. 
 * *buffer and *lvbuff must be NULL on entry.
 */
{
    /* make both together to keep const offset between them (efficiency) */

    /* there is a possible alignment bug here - vb needs better choosing */

    *tb = (TOKEN *) mkgen ((void *) *tb, n,
			   sizeof (struct {
				   TOKEN x;
				   VALUE y;
				   }));

    if (*tb) {
	*vb = (VALUE *) (*tb + n);
    }
    else {
	*vb = (VALUE *) NULL;
    }
}

static void *
freegen (void *s)
{
    if (!s)
	return s;
    (void) p_free (s);
    return s = NULL;		/* so that we don't try freeing it twice */
}


VOID
p_init_data (PRECC_DATA * self, ...)
    /* run one time only to setup INITIAL initial conditions */
{
    
    /* default sizes */
    self->readbuffersize = 0;
    self->maxprogramsize = 0;
    self->stacksize = 0;
    self->contextstacksize = 0;
    self->stacktokens = 0;
    self->oldattributes = 0;
    /* stacks will be built in p_creat */
    self->stack = 0;
    self->_value = 0;
    self->buffer = 0;
    self->lvbuff = 0;
    self->program = 0;
    /* zero pointers and offsets - they'll be set in p_creat */
    self->_passcount = 0;
    self->_pc = 0;
    self->fstack = 0;
    self->fptr = 0;
    /* self->jmpb = 0; */
    self->last_pjmp = 0;
    self->p_depth = 0;
    self->_pstr = 0;
    self->_maxp = 0;
    /* defaults */
    self->zer_error = (ACTION *)p_zer_error;
    self->bad_error = (ACTION *)p_bad_error;
    self->btk_error = (ACTION *)p_btk_error;
    /* these will be ignored of set to 0  - safe default */
    self->precc_begin = 0;
    self->precc_end = 0;
    /* set to the default lexer ? */
    self->yylex = yylex;
    self->yywrap = yywrap;
    self->yytcharp = &yytchar;
    self->yylinenop = &yylineno;
    self->yylenp = &yylen;
    self->yyllocp = &yylloc;
    self->yylvalp = &yylval;         
    /* error resources */
    self->p_entry = 0;         
    self->p_enargs = 0;         
}

PRECC_DATA *p_new() {
      PRECC_DATA *self = (PRECC_DATA *)p_calloc(1,sizeof(PRECC_DATA));
      p_init_data(self);
      return self;
}

VOID
p_creat_data (PRECC_DATA * self, ...)
/* we think one of the stacks is NULL, and we try and alloc it
 * according to the defined size
 */
{
    long bytesfree;

    bytesfree = p_memleft ();	/* but which stack is it? */

    /* make these together to keep const offset between them */
    mkdblbuffer (self->readbuffersize,
		 & self->buffer, & self->lvbuff);

    self->program = (P_INSTRUCTION *)mkgen ((void *) (self->program),
					    self->maxprogramsize,
					    sizeof (P_INSTRUCTION));

    /* yacc-style attributes. Not used much now! */
    self->_value = (P_STACKVALUE *)mkstack (self->stacksize,
				 (void **) & self->stack);

    self->fstack = (P_FRAME *)mkgen ((void *) (self->fstack),
					   self->contextstacksize,
					   sizeof (P_FRAME));

    self->fptr = self->fstack;

    if (!self->buffer  || !self->lvbuff ||
	!self->program || !self->stack  ||
	!self->fstack) {
	fprintf (stderr,
		 "error; not enough memory (%lu) for internal stacks\n",
		 bytesfree);
	p_exit (1);
    }

}

VOID
p_destr_data (PRECC_DATA * self, ...)
{
    self->buffer = (TOKEN *)freegen ((void *) self->buffer);
    /* the next is not needed because of the way these
     * buffers are made, i.e. as one lump from malloc, not two.
     *
     (void*) self->lvbuff  = freegen ((void *) self->lvbuff);
     */
    self->lvbuff = 0;
    self->program = (P_INSTRUCTION *)freegen ((void *) self->program);
    self->stack = (P_STACKVALUE *)freegen ((void *) self->stack);
    self->fstack = (P_FRAME *)freegen ((void *) self->fstack);
}

/* globals */

int p_argc;
char **p_argv;
char *p_infile,			/* stdin name (eventually "-" if not a file) */
     *p_outfile;		/* stdout name (eventually "-" if not a file) */


int call_mode = 0;		/* flag for call convention. 1 = pascal
				 * (manual), 0 = C (auto) */
int optimize = 0;		/* flag for flying program optimization */

#ifdef DOS
int msdos = 1;			/* 1 if we're in MSDOS */
#else
int msdos = 0;
#endif


unsigned p_size_value = P_SIZE_VALUE;	/* stack space taken by a VALUE */
int      p_argsign    = ARGSIGN;	/* ascending/descending stack args */


