/*              
 * parser suite - and / or / nothing / something  parsers
 *
 * parser = [token] -> ([token],status)
 *
 * implemented as side-effecting on [token], returns status.
 */

#include "cc.h"

extern int orcount;


STATUS
p_andparse0 (PRECC_DATA *self, PARSER *p, PARSER *q)
/*
 * Serial composition of parsers. Does
 * first p then q. Put p's instructions on the
 * top of the program stack, then layer q's above it.
 * 
 * This version has full rewind of the input stream on
 * failure, but this can be altered to single token
 * lookahead by deleting the line of code marked.
 */
{
    static STATUS p_tok;	/* why can't this be static? */

    P_MARK;

    p_tok = (*p) (self);

    if (BADSTATUS (p_tok)) {	/* error */

	P_REWIND;

	return p_tok;
    }

    p_tok = (*q) (self);

    if (BADSTATUS (p_tok)) {	/* error */

	P_REWIND;	/* remove this line for 1-token LA parsing */

	return p_tok;		/* fail */
    }

    P_RELEASE;

    return p_tok;		/* succeed */
}

STATUS
p_orparse0 (PRECC_DATA *self, PARSER p, PARSER q)
/*
 * alternate composition of parsers. Tries p first,
 * and if it doesnt work, tries q. Code corresponding
 * to the successful parse is placed on the program stack.
 * If both fail, the routine relies on p and q's auto-rewind
 * mechanisms to do the rewind for it.
 */
{
    static STATUS p_tok;	/* I don't see why this can't be static */

    P_MARK;

    P_TRY {

	p_tok = p (self);

    } P_CATCH(P_THROWABLE) {

	/* we got here because of a fail from p and a long_jmp
	 * so we have to try and restore the frame stack
	 */
	p_tok = FAILURE;
	P_REWIND;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {

	/* restore previous breakpt and exit */

	P_RELEASE;

	return p_tok;		/* success */

    }

    /* failure -- assume the callee retracted all correctly */

    /* we have to try our second option */

    P_TRY {

	p_tok = q (self);		/* try q */

    } P_CATCH(P_THROWABLE) {

	/* we got here because of a fail from q and a long_jmp 
	 * so we have to try and restore the frame stack
	 */

	p_tok = FAILURE;
	P_REWIND;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {

	/* restore previous breakpt and exit */

	P_RELEASE;

	return p_tok;		/* success */
    }

    /* no more options - we have to fail */

    P_RELEASE;

    /* jump to previous jump location */

    P_THROW("p_orparse0");

    /* never reached */

    return p_tok;		/* FAILURE */

}

STATUS
p_many0 (PRECC_DATA *self, PARSER *p)
/*
 * parser which tries p any number of times
 * until p fails, but returns success anyhow.
 */
{
    static STATUS p_tok;
    volatile STATUS q_tok = SUCCESS; /* non-reg to avoid compiler warning */

    P_MARK;

    /* this should be a while(GOODSTATUS(p_tok=(*p)())
       but one MSDOS compiler fails on it!
     */

    P_TRY {			/* set our breakpoint */

	p_tok = SUCCESS;

	do {

	    /* save successful advances */
	    P_REMARK;

	    q_tok = p_tok;
	    p_tok = (*p) (self);

	} while (GOODSTATUS (p_tok));

	/* failure -- assume the callee retracted all correctly */

	P_RELEASE;

    } P_CATCH(P_THROWABLE) {

	/* we got here because of a fail from p and a long_jmp   *
	 * so we have to try and restore the frame as well *
	 * but only as far as the last success
	 */

	P_REWIND;

    } P_CAUGHT;

    /* restore previous breakpt and exit */

    return q_tok;		/* last successful value */

}

STATUS
p_iter0 (PRECC_DATA * self, int repeat, PARSER *p)
/*
 * parser which tries p repeat number of times exactly
 */
{
    static int k;
    static STATUS p_tok;
    P_MARK;

    k = repeat;

    while (k-- > 0) {

	p_tok = (*p) (self);

	if (BADSTATUS (p_tok)) {

	    P_REWIND;

	    return p_tok;	/* failed early */
	}
    }

    P_RELEASE;
    return p_tok;		/* return last successful value */
}

STATUS
p_some0 (PRECC_DATA * self, PARSER *p)
/*
 * At least one repetition of parser p
 */
{
    STATUS p_tok;

    p_tok = (*p) (self);

    if (GOODSTATUS (p_tok)) {

	p_tok = p_many0 (self, p);
    }

    return p_tok;		/* last successful value */
}

STATUS
p_option0 (PRECC_DATA * self, PARSER *p)
/*
 * optionally p
 */
{
    static STATUS p_tok;

    P_MARK;

    P_TRY {			/* set our breakpoint */

	p_tok = (*p) (self);

    } P_CATCH(P_THROWABLE) {

	/* we got here because of a fail from p and a long_jmp   */
	/* so we have to try and restore the frame stack as well */

	p_tok = FAILURE;
	P_REWIND;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {

	P_RELEASE;

	return p_tok;
    }

    P_RELEASE;
    return SUCCESS;
}

STATUS
p_range0 (PRECC_DATA * self, PREDICATE *p)
/*
 * checks whether *_pstr satisfies predicate p.
 * p must take a TOKEN as arg. That is a mistake. It should be
 * an int (a PARAM).
 */
{
    TOKEN c;
    VALUE v;
    static STATUS p_tok;

    c = *self->_pstr;
    v = self->lvbuff[(int) (self->_pstr - self->buffer)];

    if ((*p) (c)) {
	P_MOVEON;
	p_pushVALUE (v);
	return OK (v);
    }

    P_THROW("p_range0");

    /* never reached */

    return FAILURE;
}

STATUS
p_attach (PRECC_DATA * self, PARSER *p, ACTION *f)
{
    static STATUS p_tok;

    p_tok = (*p) (self);
    if (GOODSTATUS (p_tok)) {

	p_pushACTION (f);
	return p_tok;
    }

    /* never reached */

    return p_tok;

}

STATUS
p_prepend (PRECC_DATA * self, ACTION *f, PARSER *p)
{
    static STATUS p_tok;

    P_MARK;

    p_pushACTION (f);

    p_tok = (*p) (self);

    if (GOODSTATUS (p_tok)) {

	P_RELEASE;
    }
    else {

	P_REWIND;

    }

    return p_tok;
}

STATUS
p_hidden0 (PRECC_DATA * self, PARSER *p)
/*
 * parser which tries p, but doesnt moveon, just reports the result
 * of p.
 */
{
    static STATUS p_tok;
    P_MARK;

    P_TRY {

	p_tok = (*p) (self);

	P_REWIND;

    } P_CATCH(P_THROWABLE) {

	/* we got here because of a fail from p and a long_jmp   */
	/* so we have to try and restore the frame stack as well */

	P_REWIND;

	p_tok = FAILURE;

    } P_CAUGHT;

    if (GOODSTATUS (p_tok)) {
	/* we have to show we were here to keep in V(n) step */

	p_pushVALUE (INSTATUS (p_tok));
	return p_tok;
    }

    /* failure */

    P_THROW("p_hidden0");

    /* never reached */

    return p_tok;
}
