#include <p_config.h>

#include <signal.h>
#include <stdio.h>

#ifndef __STDC__
extern int printf(), fprintf();
extern int scanf(), fscanf(), sscanf();
extern int ungetc(), _filbuf(), _flsbuf();
extern int fclose(), fflush();
#endif

#include <stdlib.h>

#ifdef HAVE_UNISTD_H
/* for posix */
#include <unistd.h>
#else
#ifdef HAVE_IO_H
/* for close() prototype */
#include <io.h>
#endif
#endif


#ifndef HAVE_ATEXIT

#ifdef HAVE_ON_EXIT /* use that instead */

extern int on_exit();

int atexit(RETSIGTYPE f())
    /* f is to be executed just before program termination */
{
    return on_exit(f,0);
}

#else /* down to nothing but us now */

#ifndef ATEXIT_MAX
#define ATEXIT_MAX 32
#endif

static RETSIGTYPE   exithandler(int);

static RETSIGTYPE (*(flist[ATEXIT_MAX]))(int);
static int fptr;

int atexit(RETSIGTYPE f(int))
    /* f is to be executed just before program termination */
{
    if(fptr>=ATEXIT_MAX)
        return(1);
    flist[fptr++]=f;
    signal(SIGABRT,exithandler);
    signal(SIGSEGV,exithandler);
    signal(SIGILL, exithandler);
    signal(SIGFPE, exithandler);
    signal(SIGTERM,exithandler);

    /* SIGINT is left free */
    return 0;
}

RETSIGTYPE exithandler(int x)
{
    while (--fptr)
    {
        flist[fptr](x);
    }
    /* and go home happy? */
}

#endif /* HAVE_ON_EXIT */

#endif /* HAVE_ATEXIT */

void p_fcloseall(void)
{
    extern char *p_infile, *p_outfile;

    /* in case something goes wrong */
    fflush(stdin);
    fflush(stdout);
    fflush(stderr);

    if (p_infile &&
       *p_infile!='-')
      {
        fclose(stdin);/* close the in file */
        dup2(5,0);    /* restore stdin */
        close(5);
      }
    p_infile = 0;
    if (p_outfile &&
       *p_outfile!='-')
      {
	fclose(stdout);
	dup2(6,1);   /* restore stdout */
	close(6);
      }
    else
      {
	fflush(stdout);
	  /* at least clear stdout */
      }
    p_outfile = 0;
}

void p_exit(int n)
{
    p_fcloseall();

#if defined(DOS)
    /* use default handler, which exits */
    signal(SIGTERM, SIG_DFL);
    /* this avoids a normal exit, which can crash for unknown reasons */
    raise(SIGTERM);
    /* but the exit code is 1 */
#endif

    /* ok to exit normally under unix */
       exit(n);
    /* exit code is n */
}
