/* ccx.h */
# ifndef CC_H
# define CC_H

# include <p_config.h>

# ifdef DOS
#   define p_memleft  coreleft
# else
#   define p_memleft()  64000
# endif

/* standard clib */
# include <stdio.h>
#ifdef STDC_HEADERS
#include <unistd.h>
#endif

/* make no jumps the default for now */
#if !defined(USE_JUMPS)
# if !defined(DO_NOT_USE_JUMPS)
#  define DO_NOT_USE_JUMPS
# endif
#else
# if defined(DO_NOT_USE_JUMPS)
#  undef DO_NOT_USE_JUMPS
# endif
#endif


#ifndef __STDC__
/* it doesn't do any harm to redeclare these, and we need them if stdio
 * does not have them.
 */
extern int printf(), fprintf();
extern int scanf(), fscanf(), sscanf();
extern int ungetc(), _filbuf(), _flsbuf();
extern int fclose(), fflush();
#endif


# define p_gets gets
# define p_calloc  calloc
# define p_free    free


#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
  extern  char *strchr(), *strrchr(), *strstr();
  extern  int strcmp(), strncmp();
#endif

#include <setjmp.h>

#if defined(STDC_HEADERS) || defined(HAVE_STDLIB_H)
# include <stdlib.h>
#else
  /* we probably need to type "free" and "calloc" ourselves */
  extern void free();
  extern void *calloc();
#endif

/* try and set up for varargs.h if we don't have stdargs.h  -- this is
 * definitely not worth the havoc it causes! */
#if defined(STDC_HEADERS) ||  defined(HAVE_STDARG_H)
# include <stdarg.h>
# undef va_alist
# undef va_dcl
# define va_alist ...
# define va_dcl   
#else
# ifdef HAVE_VARARGS_H
#  include <varargs.h>
   /* this tries to do "#define va_start(ap,p) va_start(ap)" */
#  undef va_start
#  define va_start(ap,p) ap=(va_list) &(p)
   /* we don't want va_dcl because it's K&R style */
#  undef va_dcl
#  define va_dcl
   /* we kill va_alist and use the stdarg style instead */
#  undef va_alist
#  define va_alist ...
# endif
#endif

/* default defs */
# ifndef VALUE
#   define VALUE char*       /* Make sure you define VALUE ...     */
#   ifdef SIZEOF_CHAR_P
#     define P_T_SIZE_VALUE SIZEOF_CHAR_P
#   endif
# endif
# ifndef P_T_SIZE_VALUE
#  define P_T_SIZE_VALUE P_ROUND(VALUE)
# endif
/* Now we can adjust our final size according to what we know */
# ifdef C_USES_STACK_INDIRECTION
/* this hideousness is because solaris does not support "#if a>b"*/
#   define P_SIZE_VALUE \
  ((P_T_SIZE_VALUE>P_SIZE_ARGUNIT)?P_ROUND(sizeof(VALUE*)):P_T_SIZE_VALUE)
# else
#   define P_SIZE_VALUE P_T_SIZE_VALUE
# endif

# ifndef PARAM
#   define PARAM long        /* (VALUE=synthetic, PARAM=inherited) */
#   ifdef SIZEOF_LONG
#     define P_T_SIZE_PARAM SIZEOF_LONG
#   endif
# endif
# ifndef P_T_SIZE_PARAM
#  define P_T_SIZE_PARAM P_ROUND(PARAM)
# endif
/* Now we can adjust our final size according to what we know */
# ifdef C_USES_STACK_INDIRECTION
/* this hideousness is because solaris does not support "#if a>b"*/
#   define P_SIZE_PARAM \
  ((P_T_SIZE_PARAM>P_SIZE_ARGUNIT)?P_ROUND(sizeof(PARAM*)):P_T_SIZE_PARAM)
# else
#   define P_SIZE_PARAM P_T_SIZE_PARAM
# endif

# ifndef TOKEN
#   define TOKEN char        /* ... and TOKEN, if not int and char */
#   ifdef SIZEOF_CHAR
#     define P_SIZE_TOKEN SIZEOF_CHAR
#   endif
# endif

/* parameter space is calculated in ARGUNITs. These should be the
 * largest things that are passed by value in a VARARGS function call.
 * I think they can't be bigger than long.
 */
# ifndef ARGUNIT
#  define ARGUNIT long
#  ifdef SIZEOF_LONG
#    define P_SIZE_ARGUNIT SIZEOF_LONG
#  endif
# endif
# ifndef P_SIZE_ARGUNIT
#  define P_SIZE_ARGUNIT P_ROUND(ARGUNIT)
# endif

/* now for some labelling shenanigans */
typedef VALUE P_VALUE_0;
typedef TOKEN P_TOKEN_0;
typedef PARAM P_PARAM_0;
# undef VALUE
# undef TOKEN
# undef PARAM
typedef P_VALUE_0 VALUE;
typedef P_TOKEN_0 TOKEN;
typedef P_PARAM_0 PARAM;
/*
 * That converted the defines to typedefs, which in turn could help avoid
 * spurious typing errors from braindead compilers.
 */

# ifndef MAXPROGRAMSIZE
# define MAXPROGRAMSIZE 4096 /* 20K (chars) is often too big in DOS*/
# endif                      /* but this is proportional to line length */
# ifndef READBUFFERSIZE
# define READBUFFERSIZE 2048 /* ditto */
# endif                     /* because this IS the line length */
# ifndef STACKSIZE
# define STACKSIZE 1        /* NOT NEEDED ANY MORE UNLESS OLD STYLE VV(n) */
# endif                     /* ATTRIBUTE REFS ARE BEING SUPPORTED */
                            /* If set, it is very difficult to overun 2K ! */

                            /* msdos defns */
# ifndef CONTEXTSTACKSIZE
# define CONTEXTSTACKSIZE 1024
# endif
# ifndef C_STACKSIZE       
# define C_STACKSIZE 0x7FFF
# endif                     /* expect to need as large a stack as possible */

                            /* compatibility */
# ifndef STACKTOKENS
# define STACKTOKENS 0      /* Don't put tokens on the attribute stack */
# endif                     /* unless you are sure there is a stack! */
# ifndef OLDATTRIBUTES
# define OLDATTRIBUTES 0    /* Don't generate code which supports $1, $2, ... */
# endif                     /* (The $named attr. refs. are supported anyway) */

# define P_MAXARGS 16       /* number of params catered for */
# define P_MAXBITS  4       /* number of bits required */
                            /* DON'T change it! */

/* yylex decls */
extern  int        yytchar;         /* the last thing yylex saw     */
extern  int        yylineno;        /* line count */
/* I'll put in the decls for the yystuff here, in case they're needed */
extern  int        yylen;
extern  int        yylex();
extern  char      *yylloc;
extern  VALUE      yylval;
extern  int        yywrap();


/* local defs */
# define P_OPCODE char
# define VOID void

/* typedefs */
typedef union {                 /* STATUS is returned by a PARSER */
        int  status;
        VALUE value;
        } STATUS;

typedef int BOOLEAN;            /* BOOLEAN is returned by a PREDICATE */

# define TOPARSER *(PARSER*)
# define TOVALUE                /* could be "(VALUE)" */

typedef struct {                /* an P_INSTRUCTION consists of ... */
    P_OPCODE  opcode;           /* an P_OPCODE as opcode and ... */
    union {                     /* an ACTION (really!) or  ... */
        VOID   *act;            /* ... a literal as operand. */
        TOKEN   tok;            /* The opcode selects the ... */
        VALUE   val;
        PARAM   par;
        } operand;             /* ... interpretation of the operand. */
}       P_INSTRUCTION;
typedef union {                /* The VALUE stack actually contains */
           VALUE val;          /* P_STACKVALUES, which may be either */
        TOKEN tok;             /* VALUEs or TOKENs. TOKENs are */
        PARAM par;             /* ... */
        } P_STACKVALUE;        /* ... pushed when literals are hit. */
typedef struct{                /* All the info required for a REWIND */
        TOKEN     *_pstr;
        P_STACKVALUE *_value;
        int _pc;
        int _lineno;
        /* P_INSTRUCTION instr;*/ /* will introduce for optimization */
        } P_FRAME;

typedef struct P_DATA {
int     readbuffersize,      /* READBUFFERSIZE */
        maxprogramsize,      /* MAXPROGRAMSIZE */
        stacksize,           /* STACKSIZE */
        contextstacksize,    /* CONTEXTSTACKSIZE */
        stacktokens,         /* (boolean) support tokens as attrs for old code*/
        oldattributes;       /* (boolean) generate yacc style attr. refs */
TOKEN  *_pstr,               /* input token buffer pointer */
       *_maxp,               /* max penetration into buffer */
       *buffer,              /* input buffer */
       *yybuffer;            /* another name for the input buffer */
VALUE  *lvbuff;              /* attributes for input buffer */
int     _passcount,          /* cut counter */
        _pc;                 /* program index */
P_INSTRUCTION
       *program,             /* program area */
        instr;               /* program instruction cache */
P_FRAME *fstack,             /* parse frame stack */
       *fptr,                /* and pointer */
        p_frame;             /* frame cache */
P_STACKVALUE
       *stack,               /* obsolete yacc attribute stack */
       *_value;              /* and pointer */
jmp_buf jmpb,                /* environment */
       *last_pjmp;           /* jump stack top */
int     p_depth;             /* for debugging */
#ifdef __cplusplus
STATUS (*p_entry)(struct P_DATA *, ...);      /* error parser */
#else
STATUS (*p_entry)();         /* error parser */
#endif __cplusplus
int     p_enargs;            /* always zero */
PARAM   p_eargv[P_MAXARGS];  /* the 0 args of the error parser */
#ifdef __cplusplus
VOID   (*zer_error)(struct P_DATA *, ...),    /* error operators */
       (*bad_error)(struct P_DATA *, ...),
       (*btk_error)(struct P_DATA *, ...),
       (*precc_begin)(struct P_DATA *, ...),  /* user supplied routines */
       (*precc_end)(struct P_DATA *, ...);
#else
VOID   (*zer_error)(),       /* error operators */
       (*bad_error)(),
       (*btk_error)(),
       (*precc_begin)(),     /* user supplied routines */
       (*precc_end)();
#endif __cplusplus
int    (*yylex)(),           /* lexer stuff */
       (*yywrap)(),
       *yytcharp,
       *yylinenop,
       *yylenp;
char  **yyllocp;
VALUE  *yylvalp;
}       P_DATA;              /* the class data */
typedef P_DATA PRECC_DATA;   /* the class is its data in C */
typedef PRECC_DATA PRECC;    /* the class is its data in C */

#ifdef __cplusplus
#define P_BEGIN extern "C" {
#define P_END   }
#else
#define P_BEGIN 
#define P_END   
#endif

#ifdef __cplusplus
P_BEGIN
typedef STATUS  PARSER(P_DATA *, ...);
typedef BOOLEAN PREDICATE(TOKEN, ...);
typedef VOID    ACTION(P_DATA *, ...);
P_END
#else
typedef STATUS  PARSER();    /* PARSER returns a STATUS */
typedef BOOLEAN PREDICATE(); /* PREDICATE returns a BOOLEAN */
typedef VOID    ACTION();    /* VALUE stack manipulation */
#endif

/* compatibility */
#define pstr self->_pstr
#define maxp self->_maxp
#define pc   self->_pc

#ifdef __cplusplus
class PRECC_OBJ {
  public:
    PRECC_DATA data;
    PRECC_OBJ() { extern VOID p_init_data(PRECC_DATA*);  p_init_data(&data); };
    void creat(){ extern VOID p_creat_data(PRECC_DATA*); p_creat_data(&data); };
   ~PRECC_OBJ() { extern VOID p_destr_data(PRECC_DATA*); p_destr_data(&data); };
    void       run(PARSER *x) { extern ACTION p_run; p_run(&data,x,0); };
};
#endif


/* instruction destructors and constructors */
#define P_Action(x)  ((ACTION *)(x).operand.act)
# define P_Token(x)  ((x).operand.tok)
# define P_Param(x)  ((x).operand.par)
# define P_Opcode(x) ((x).opcode)
# define P_Value(x)  ((x).operand.val)

/* status macros */
#define BADSTATUS(x)  (!(x).status)    /* BADSTATUS(x) is a PREDICATE */
#define GOODSTATUS(x) ((x).status)     /* as is GOODSTATUS(x) */
                                       /* This reads the PARAM part */
# define INSTATUS(x) (  (x).status -= ( 0>(x).status ? 0 : 1 ), (x).value )
                                       /* success deconstructor */
# define OK(x) ( p_tok.value = (VALUE)(x), p_tok.status += ( 0>p_tok.status ? 0 : 1 ), p_tok )
                                     /* success constructor */
#define KO(x)  ( p_tok.status = 0, p_tok )

# define SUCCESS ( p_tok.status = 1, p_tok )
# define FAILURE KO(0)


/* input stream manipulations */
                    /* P_MARK has to be first line in a */
                    /* routine. 'string' is a reserved */
                    /* local variable, as is 'count'. */
                    /* The P_MARK sets string and count to */
                    /* the current parse point and _pc. */

#ifndef C_NONCONST_INITIALIZERS /* constant initializers only */
# define P_MARK P_FRAME p_frame; { p_fsave(p_frame); }
#else
# define P_MARK P_FRAME p_frame = {\
self->_pstr,\
0, /* "_value" not required by p_fsave */\
self->_pc,\
self->_passcount\
};
#endif
  
/* P_REMARK overwrites the current P_MARK
 */
  
#if 0 /* separate frame stack */
# define P_REMARK { p_fsave(p_frame); }
#else
# define P_REMARK P_MARK
#endif


                    /* P_REWIND resets the parse point and */
                    /* to the P_MARK at the head of the fn.*/
                    /* provided that a new line hasn't   */
                    /* already been read, in which case  */
                    /* just go back as far as possible */

#define P_REWIND { p_frestore(p_frame); }

                    /* MOVEON budges the high-water mark */
                    /* maxp up to the current parse pt. */

#define P_MOVEON { get1token(self); }

                   /* P_RELEASE destroys the frame */

#define P_RELEASE 

typedef struct {
        jmp_buf *tail;
        jmp_buf  head;
} P_JMPSTACK;

#ifndef DO_NOT_USE_JUMPS
# define P_THROWABLE 1
# define P_CATCH(x) break; \
            case x: printf("return in jmp buffer %x while pstr = %s (%x)\n", p_alt_frame.head, self->_pstr, self->_pstr);
# define P_CAUGHT break; \
            default: \
                     fprintf(stderr,"handler rethrows signal %d\n",p_retval);\
                     P_RESTORE;\
                     long_jmp(self,p_retval);\
                     fprintf(stderr,"handler cannot rethrow bad signal %d\n",p_retval); \
                     p_exit(1); break; \
            } P_RESTORE; }
# define P_ALTSET setjmp(p_alt_frame.head)
# define P_TRY { static int p_retval; P_JMPSTACK p_alt_frame = {0,};\
        switch(set_jmp(self,p_alt_frame.head),(p_retval=P_ALTSET),p_retval) { case 0: P_ALTMARK;
# define P_THROW(x) long_jmp(self,P_THROWABLE)
# define P_ALTMARK p_alt_frame.tail = push_jmp(self,&(p_alt_frame.head))
# define P_RESTORE pop_jmp (self,p_alt_frame.tail)
#else
# define P_THROWABLE 1
# define P_ALTMARK
# define P_RESTORE
# define P_TRY if(1) { 
# define P_CATCH(x) } else {
# define P_CAUGHT }
# define P_THROW(x)
#endif


/* global parameters */
extern int call_mode;           /* 0 for auto-calling convention, 1=manual */
extern int optimize;            /* 1 = flying program optimization */
extern int p_argc;              /* main() arg count  */
extern char **p_argv;           /* main() arg vector */
extern PRECC_DATA precc_data;   /* all globals kept here */
extern int msdos;
extern char   *p_infile,        /* stdin name (eventually "-" if not a file) */
              *p_outfile;       /* stdout name (eventually "-" if not a file) */
extern int     p_argsign;	/* (+-1) ascending/descending args on stack */


/* engine opcodes */
#define P_INCR   5            /* increment value stack */
#define P_PARM   4            /* parameter to a function call */
#define P_FUNC   3            /* That's got an ACTION operand */
#define P_EXIT   2
#define P_CNST   1            /* That's got a VALUE operand. */
#define P_NOP    0            /* Saves time. */

/* program stack manipulation */
#define p_push(x) {if(self->_pc>=self->maxprogramsize-1){\
                 fprintf(stderr,"precc: program stack overflow (%d).\n\
If the application accepts the -p flag, try using -p%d\n",(int)self->_pc,\
                 (int)(2*self->maxprogramsize*sizeof(P_INSTRUCTION))/1024);\
                 p_exit(1);\
                 }\
                 self->program[self->_pc++]=(x);\
                }
#define p_pull(n) (self->_pc-=(n))
#define p_pop(x)  (x=self->program[--self->_pc])
#define p_ppeek(x) (self->_pc>0?x=self->program[self->_pc-1]:((x).opcode=EXIT,(x)))
#define p_ppoke(x) {if(self->_pc>0)self->program[self->_pc-1]=(x);}

/* load and unload the current instruction */
#define p_getinstruction(i,n,x)   {P_Opcode(i)=(n);P_Action(i)=(x);}
#define p_pushinstruction(n,x)  {P_INSTRUCTION instr;p_getinstruction(instr,n,x);p_push(instr);}
#define p_getTOKEN(i,x)           {P_Opcode(i)=(P_CNST);P_Token(i)=(TOKEN)(x);}
#define p_getPARAM(i,x)           {P_Opcode(i)=(P_PARM);P_Param(i)=(PARAM)(x);}
#define p_getMANIP(i,x)           {P_Opcode(i)=(P_INCR);P_Param(i)=(PARAM)(x);}
#define p_getVALUE(i,x)           {P_Opcode(i)=(P_CNST);P_Value(i)=(VALUE)(x);}
#define p_pushTOKEN(x)   {P_INSTRUCTION instr;p_getTOKEN(instr,x);p_push(instr);}
#define p_pushPARAM(x)   {P_INSTRUCTION instr;p_getPARAM(instr,x);p_push(instr);}
#define p_pushVALUE(x)   {P_INSTRUCTION instr;p_getVALUE(instr,x);p_push(instr);}
/* cast is temporary hack - 2.45i */
#define p_pushACTION(x)            p_pushinstruction(P_FUNC,(VOID *)(x))
#define p_pushEXIT                 p_pushinstruction(P_EXIT,0)

#define p_pushMANIP(x)             /* vacuous */
#define p_pushINCR                 p_pushMANIP(1)
#define p_pushDECR                 p_pushMANIP(-1)
#define p_pushNOP                  p_pushinstruction(P_NOP,0)

/* evaluation stack manipulation */
#define p_pushvalue(x) ((self->_value++)->val)=(x)
#define p_pushparam(x) ((self->_value++)->par)=(x)
#define p_pushtoken(x) ((self->_value++)->val)=(TOKEN)(x)
#define p_popvalue(x)  (x=(--self->_value)->val)
#define p_poptoken(x)  (x=(TOKEN)((--self->_value)->val))
#define p_popparam(x)  (x=(--self->_value)->par)
#define p_pullvalue(n) &((self->_value-=(n))->val)
#define p_pullparam(n) &((self->_value-=(n))->par)
#define p_pulltoken(n) (TOKEN)(&((self->_value-=(n))->val))
  

/* frame stack manipulation */
#define p_fpush(x) (*self->fptr++=(x))
#define p_fpop(x)  (x=*--self->fptr)
#define p_fpull(n) (self->fptr-=(n))
#define p_fsave(x) \
x._pstr=self->_pstr;\
/*x._value=self->_value;*/\
x._pc=self->_pc;\
x._lineno=self->_passcount
/*;\ ppeek(x.instr)*/
#define p_frestore(x) \
self->_pstr=(x._lineno==self->_passcount)?x._pstr:(self->btk_error(self),self->buffer);\
self->_pc=x._pc\
/*; self->_value=x._value*/
/*;ppoke(x.instr)*/



/*# if defined(hppa) || defined(hp9000s800) || defined(hp9k8)
 *#   ifndef C_DESCENDING_STACK
 *#   define C_DESCENDING_STACK
 *#   endif
 *# endif
 */


/* ARGSIGN may be negative (-1) for vaxen, (+1) otherwise */
#ifndef ARGSIGN
# ifdef C_DESCENDING_STACK
#  define ARGSIGN (-1)
# else
#  define ARGSIGN (+1)
# endif
#endif

#ifndef USE_GENERIC_VARARGS_TRANSFER
# ifdef C_DESCENDING_STACK
#  define USE_GENERIC_VARARGS_TRANSFER
# endif
#endif

/* multi-argument function call
 * I have to use int's at least in the param list because of
 * possible promotion
 */

#ifndef USE_GENERIC_VARARGS_TRANSFER
# define P_GRABARGS(m,a,ap) \
    a=(ARGUNIT*)ap; /* very NON-PORTABLE, but it's fast */\
    /* now skip m varargs */\
    ap = (va_list)(a + ARGSIGN*P_UNCODE(m));
#else
# define P_GRABARGS(m,a,ap) \
    { /* this will work anywhere, but slowly */\
      switch (P_UNCODE(m)) /* to get size in ARGUNITS */ {\
      case 0:\
        break;\
      case 1:\
        a[0] = va_arg(ap,ARGUNIT);\
        break;\
      case 2:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        break;\
      case 3:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT);\
        break;\
      case 4:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        break;\
      case 5:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT);\
        break;\
      case 6:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        break;\
      case 7:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT);\
        break;\
      case 8:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        break;\
      case 9:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT);\
        break;\
      case 10:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        break;\
      case 11:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT);\
        break;\
      case 12:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT); a[11]= va_arg(ap,ARGUNIT);\
        break;\
      case 13:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT); a[11]= va_arg(ap,ARGUNIT);\
        a[12]= va_arg(ap,ARGUNIT);\
        break;\
      case 14:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT); a[11]= va_arg(ap,ARGUNIT);\
        a[12]= va_arg(ap,ARGUNIT); a[13]= va_arg(ap,ARGUNIT);\
        break;\
      case 15:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT); a[11]= va_arg(ap,ARGUNIT);\
        a[12]= va_arg(ap,ARGUNIT); a[13]= va_arg(ap,ARGUNIT);\
        a[14]= va_arg(ap,ARGUNIT);\
        break;\
      case 16:\
        a[0] = va_arg(ap,ARGUNIT); a[1] = va_arg(ap,ARGUNIT);\
        a[2] = va_arg(ap,ARGUNIT); a[3] = va_arg(ap,ARGUNIT);\
        a[4] = va_arg(ap,ARGUNIT); a[5] = va_arg(ap,ARGUNIT);\
        a[6] = va_arg(ap,ARGUNIT); a[7] = va_arg(ap,ARGUNIT);\
        a[8] = va_arg(ap,ARGUNIT); a[9] = va_arg(ap,ARGUNIT);\
        a[10]= va_arg(ap,ARGUNIT); a[11]= va_arg(ap,ARGUNIT);\
        a[12]= va_arg(ap,ARGUNIT); a[13]= va_arg(ap,ARGUNIT);\
        a[14]= va_arg(ap,ARGUNIT); a[15]= va_arg(ap,ARGUNIT);\
        break;\
      default:\
        {\
        int k;\
          for (k=0; k<(m); k++) \
          { \
            a[k] = va_arg(ap,ARGUNIT); \
          } \
        }\
        break;\
      }\
    }
#endif

#define P_CALL(p,m,a)  {\
    m=va_arg(ap,int);\
    P_GRABARGS(m,a,ap);\
    m++;\
    switch(m-1) {\
    case 0: p(self);break;\
    case 1: p(self,a[0]);break;\
    case 2: p(self,a[0],a[1]);break;\
    case 3: p(self,a[0],a[1],a[2]);break;\
    case 4: p(self,a[0],a[1],a[2],a[3]);break;\
    case 5: p(self,a[0],a[1],a[2],a[3],a[4]);break;\
    case 6: p(self,a[0],a[1],a[2],a[3],a[4],a[5]);break;\
    case 7: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6]);break;\
    case 8: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7]);break;\
    case 9: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8]);break;\
    case 10: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9]);break;\
    case 11: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10]);\
             break;\
    case 12: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],\
             a[11]);break;\
    case 13: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],\
             a[11],a[12]);break;\
    case 14: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],\
             a[11],a[12],a[13]);break;\
    case 15: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],\
             a[11],a[12],a[13],a[14]);break;\
    case 16: p(self,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],\
             a[11],a[12],a[13],a[14],a[15]);break;\
    default: callerror(m);\
    }\
}

#define P_CALL1(q,p,m,a) \
        m=va_arg(ap,int);\
        P_GRABARGS(m,a,ap);\
        m++;\
        switch(m-1){\
        case 0: q (self,p,0); break;\
        case 1: q (self,p,1,a[0]); break;\
        case 2: q (self,p,2,a[0],a[1]); break;\
        case 3: q (self,p,3,a[0],a[1],a[2]); break;\
        case 4: q (self,p,4,a[0],a[1],a[2],a[3]); break;\
        case 5: q (self,p,5,a[0],a[1],a[2],a[3],a[4]); break;\
        case 6: q (self,p,6,a[0],a[1],a[2],a[3],a[4],a[5]); break;\
        case 7: q (self,p,7,a[0],a[1],a[2],a[3],a[4],a[5],a[6]); break;\
        case 8: q (self,p,8,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7]);\
                break;\
        case 9: q (self,p,9,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8]); break;\
        case 10:q (self,p,10,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9]); break;\
        case 11:q (self,p,11,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10]); break;\
        case 12:q (self,p,12,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10],a[11]); break;\
        case 13:q (self,p,13,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10],a[11],a[12]); break;\
        case 14:q (self,p,14,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10],a[11],a[12],a[13]); break;\
        case 15:q (self,p,15,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10],a[11],a[12],a[13],a[14]); break;\
        case 16:q (self,p,16,a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],\
                a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15]); break;\
        default: callerror(m); break;\
        }


#ifndef DOS
/* SUNUNIX versions */
# define p_setvalue(n)  p_pullvalue(call_mode?(n)-1:0);p_refvalue(1)
# define p_settoken(n)  p_pullvalue(call_mode?(n)-1:0);p_reftoken(1)
# define p_refvalue(n)  (self->_value[(n)-2].val)
# define p_reftoken(n)  (TOKEN)(long)(self->_value[(n)-2].val)
# define p_refpar(n)    (self->_value[(n)-2].par)
# else
/* BORLAND versions */
# define p_setvalue(n)  ((p_pullvalue(call_mode?(n)-1:0))[-1].val)
# define p_settoken(n)  (TOKEN)((p_pullvalue(call_mode?(n)-1:0))[-1].val)
# define p_refvalue(n)  (self->_value[(n)-2].val)
# define p_reftoken(n)  (TOKEN)(self->_value[(n)-2].val)
# define p_refpar(n)    (self->_value[(n)-2].par)
#endif

/* program-interpreter */
    /* in engine.c */
extern int p_evaluate(PRECC_DATA*);

/* read and run parser, interpret resulting program */
    /* in engine.c */
extern VOID    p_run(PRECC_DATA*,...);

/* parsers without actions */
    /* defined in cc.c */
P_BEGIN
extern PARSER p_andparse0;
extern PARSER p_orparse0;
extern PARSER p_many0;
extern PARSER p_iter0;
extern PARSER p_some0;
extern PARSER p_option0;
extern PARSER p_range0;
extern PARSER p_hidden0;
extern PARSER p_atch0;
extern PARSER p_until0;
P_END

    /* but here are macros */
#define p_andparse0(x,y) p_andparse0n(x,0,y,0)
#define  p_orparse0(x,y) p_orparse0n(x,0,y,0)
#define     p_many0(x) p_many0n(x,0)
#define   p_iter0(n,x) p_iter0n(n,x,0)
#define     p_some0(x) p_some0n(x,0)
#define   p_option0(x) p_option0n(x,0)
#define    p_range0(x) p_range0n(x,0)
#define   p_hidden0(x) p_hidden0n(x,0)
#define    p_until0(x) p_until0n(x,0)

    /* defined in common.c */
P_BEGIN
extern PARSER p_nothing0;
extern PARSER p_anything0;
extern PARSER p_first0;
extern PARSER p_last0;
extern PARSER p_exactly0;
extern PARSER p_notexactly0;
extern PARSER p_attach0;
extern PARSER p_uerror0;
extern PARSER p_uniq0;
extern PARSER p_test0;
P_END

/* parsers with actions attached */
    /* in cc.c */
P_BEGIN
extern PARSER p_attach;
extern PARSER p_prepend;
P_END
    /* in common.c */
P_BEGIN
extern PARSER p_andparse;
extern PARSER p_orparse;
extern PARSER p_nothing;
extern PARSER p_option;
extern PARSER p_many;
extern PARSER p_iter;
extern PARSER p_some;
extern PARSER p_anything;
extern PARSER p_first;
extern PARSER p_last;
extern PARSER p_exactly;
extern PARSER p_notexactly;
extern PARSER p_range;
P_END

    /* but replaced by macros here */

#define P_ATTACH(p,f) if(GOODSTATUS(p))p_pushACTION(f)
#define p_attach(s,x,y) p_attach0n(s,x,(char)0,y,(char)0)
#define p_prepend(s,x,y) p_prepend0n(s,x,(char)0,y,(char)0)

#define p_andparse(s,p,q,f) P_ATTACH(p_andparse0(s,p,q),f)
#define p_orparse(s,p,q,f) P_ATTACH(p_orparse0(s,p,q),f)
#define p_many(s,p,f) P_ATTACH(p_many0(s,p),f)
#define p_iter(s,n,p,f) P_ATTACH(p_iter0(s,n,p),f)
#define p_some(s,p,f) P_ATTACH(p_some0(s,p),f)
#define p_option(s,p,f) P_ATTACH(p_option0(s,p),f)
#define p_nothing(s,f) P_ATTACH(p_nothing0(s),f)
#define p_anything(s,f) P_ATTACH(p_anything0(s),f)
#define p_first(s,f) P_ATTACH(p_first0(s),f)
#define p_last(s,f) P_ATTACH(p_last0(s),f)
#define p_exactly(s,x,f) P_ATTACH(p_exactly0(s,x),f)
#define p_notexactly(s,x,f) P_ATTACH(p_notexactly0(s,x),f)
#define p_range(s,p,f) P_ATTACH(p_range0(s,p),f)


/* parsers taking a variable number of arguments */
extern STATUS   p_andparse0n(PRECC_DATA *,...);
extern STATUS   p_orparse0n (PRECC_DATA *,...);
extern STATUS   p_option0n  (PRECC_DATA *,...);
extern STATUS   p_hidden0n  (PRECC_DATA *,...);
extern STATUS   p_many0n    (PRECC_DATA *,...);
extern STATUS   p_iter0n    (PRECC_DATA *,...);
extern STATUS   p_some0n    (PRECC_DATA *,...);
extern STATUS   p_uniq0n    (PRECC_DATA *,...);
extern STATUS   p_attach0n  (PRECC_DATA *,...);
extern STATUS   p_prepend0n (PRECC_DATA *,...);
extern STATUS   p_range0n   (PRECC_DATA *,...);
extern STATUS   p_uerror0n  (PRECC_DATA *,...);
extern STATUS   p_until0n   (PRECC_DATA *,...);
extern STATUS   p_test0n    (PRECC_DATA *,...);

/* actions*/
    /* in common.c */
extern ACTION p_nop;

/* aux */
extern void p_exit(int);
    /* in engine.c */
extern TOKEN      get1token(PRECC_DATA*);
extern VOID       realignbuffer(PRECC_DATA*);
    /* (in on_error.c) */
extern ACTION p_zer_error;
extern ACTION p_bad_error;
extern ACTION p_btk_error;
extern ACTION p_begin;
extern ACTION p_end;
    /* lexer (in yystuff.c)*/
extern int yylex();

    /* in jmp.c */
extern   void	  init_jmp (PRECC_DATA *);
extern   void	  long_jmp (PRECC_DATA *, int);
extern   jmp_buf *push_jmp (PRECC_DATA *, jmp_buf *);
extern   void	  pop_jmp (PRECC_DATA *, jmp_buf *);

    /* (in ccdata.c) */
extern VOID   p_init_data(PRECC_DATA *, ...);
extern VOID   p_creat_data(PRECC_DATA *, ...);
extern VOID   p_destr_data(PRECC_DATA *, ...);

#ifndef BEGIN
# define BEGIN
#endif
#ifndef END
# define END
#endif

#ifndef BAD_ERROR    /* failed parse marked at deepest pt */
# define BAD_ERROR(x) fprintf(stderr,"(line %d) failed parse:\
 probable error near .. <%c> ..\nSkipping ...\n",yylineno,*(char*)self->_maxp);\
 while(yytchar!=EOF && get1token(self));/*get1token(self);*/\
 yylloc=(char*)NULL;
#endif

#ifndef ZER_ERROR    /* incomplete parse shows remainder */
# define ZER_ERROR(x) fprintf(stderr,"(line %d) incomplete parse:\
 possible error near .. <%c> ..\nSkipping ...\n",yylineno,*(char*)self->_maxp);\
 while(yytchar!=EOF && get1token(self));/*get1token(self);*/\
 yylloc=(char*)NULL;
#endif

/* if p_entry is set, use that as handler, else print message. */

#ifndef BTK_ERROR       /* backtracking across a new line boundary */
# define BTK_ERROR(x) \
 if (!self->p_entry){\
 fprintf(stderr,"(line %d) error:\
 parse backtracked across cut from point near .. <%c> ..\n",\
 yylineno,*(char*)self->_maxp);\
 }\
 yylloc=(char*)NULL;\
 long_jmp(self,-1);/* see if we handle it on the jump stack first */\
 longjmp(self->jmpb,(unsigned)self); /* to the ! we're backtracking across */
#endif


#define P_PSTAR(X,P_CALL1,P_CALL2) \
  P_MARK;  p_tok = P_CALL1;\
  if (BADSTATUS(p_tok)) {P_RELEASE;return p_tok;}\
  X = INSTATUS(p_tok); p_tok = P_CALL2;\
  if (BADSTATUS(p_tok)) {P_REWIND;} else {P_RELEASE;}

#define P_PAND(P_CALL1,P_CALL2) \
  P_MARK; p_tok = P_CALL1;\
  if (BADSTATUS(p_tok)) {P_RELEASE;return p_tok;}\
  p_tok = P_CALL2;\
  if (BADSTATUS(p_tok)) {P_REWIND;} else {P_RELEASE;}

#ifdef DEBUG
# define P_RETURN(x,y) {static STATUS p_tok;\
  fprintf(stderr,"(%d) Looking for %s\n",self->p_depth++,y);\
  p_tok = x;\
  if (GOODSTATUS(p_tok))\
    fprintf(stderr,"(%d) Found %s\n",--self->p_depth,y);\
  else\
    fprintf(stderr,"(%d) Failed to find %s\n",--self->p_depth,y);\
  return p_tok;\
  }
#else
# define P_RETURN(x,y) return x
#endif

/* round a size up to an integer size multiple of bytes */
#define P_ROUND(TYPE) (((sizeof(TYPE)+sizeof(int)-1)/sizeof(int))*sizeof(int))

/* (Don't worry about this if you don't use compound data structures
 * as synthetic attribute VALUEs)
 *
 * Some machines and compilers place compound values on the stack in a
 * location where you would not expect to find them, and leave just a
 * pointer to the location in the normal place. The receiving function
 * does dereferencing automatically.
 *
 * If your setup has this strategy (eg, sun OS 4.1 + gcc), set
 * C_USES_STACK_INDIRECTION.
 *
 * If not, (eg. Linux for i386 + gcc) unset the value. 
 *
 * The latter kind of setup places compounds on the stack in the
 * normally expected position, just occupying more space than
 * an ordinary integer.
 *
 */

#if defined (__i386__) \
/*||((defined (__hp9000s300) || defined (__hp9000s800)) && (P_SIZE_VALUE <
9))*/
/* This may work for all little-endian machines  and
 * this is a list to check:
 * __arm__ ||  __i386__ ||  __i860__ ||  __ns32000__ ||  __vax__
 */
# ifdef C_USES_STACK_INDIRECTION
#  undef C_USES_STACK_INDIRECTION
# endif
#else
/* This may work for all big-endian machines  and
 * this is a list to check:
 * __sun__ 
 */
# ifndef C_USES_STACK_INDIRECTION
#  define C_USES_STACK_INDIRECTION
# endif
#endif


/* P_CODE is our way of passing info about the stack arrangement in a varargs
 * call. "narg" is the amount of space we THINK the args will occupy,
 * expressed in ARGUNITs. "nvar" is the number of args there actually
 * were. Of these most will be PARAMs but some will be VALUEs. The
 * positions of the latter appear as 1s in the bitmap "pat". P_MAXBITS
 * is the number of bits required to express P_MAXARGS. If P_MAXARGS=16 then
 * P_MAXBITS=4.
 */

#define P_CODE(narg,nvar,pat) (((narg) & ((0x01 << P_MAXBITS) - 1)) | ((pat) << P_MAXBITS) | (0x01 << (nvar)))
#define P_UNCODE(n) ((n) & ((0x01 << P_MAXBITS) - 1))

/* or maybe (((((nvar << 16) & ~0x0ffff) | pat) << 8) & ~0x00ff) | narg
 * when we are passing a 4-byte int or long. This gives us P_MAXARGS=16.
 * [ nvar |  pat  | narg ]
 *   4bit   16bit   8bit
 * and we get narg back by simple masking. This looks best. 
 *
 * If we only have a 2-byte integer to encode this in, then we have
 * to decide to go for size OR pattern info. Both info's could still be
 * done as (((((nvar << 8) & ~0x0ff) | pat) << 5) & ~0x01f) | narg
 * which has P_MAXARGS=8.
 * [ nvar |  pat  | narg ]
 *   3bit   8bit    5bit
 *
 * Maybe a better strategy is to use the first 1 in pattern as the nvar
 * count. With 4 bytes coding space this gives us for P_MAXARGS=16
 * [ nvar | pat  | narg ]
 *   1bit  16bit   15bit
 * i.e. ((( ((0x1<<nvar) & ~(0x1<<(nvar-1)) | pat) << 15) & * ~0x07fff) | narg
 *
 * In a 2-byte coding space, for P_MAXARGS=11, we get
 * [ nvar | pat  | narg ]
 *   1bit   11bit   4bit
 *
 * But it may be sensible to do away with nvar as we can reconstruct
 * that from the narg and pat info.
 */ 

/* Calculate the size of stack (in ARGUNIT) we need to pass in a varargs
 * fn call - but why are we using ARGUNIT? Can't we use a PARAM as a
 * basic unit of length? The temporary varargs buffer ("a") is an
 * array of ARGUNIT, but I don't see why it HAS to be. It is just a
 * contiguous memory area. n1 is the total number of args. n2 is the
 * number of VALUE sized args. The others are PARAMs. p is the int bitmap
 * describing the position of the VALUEs. 0x00001 means that the last
 * is a VALUE.  Notice that there may always be an extra leading 1 in
 * the 2^n1th position.
 *
 * We know that the size calculated (call it narg) in the easy case
 * (C_USES_STACK_INDIRECTION) gives nvar = (narg * P_SIZE_ARGUNIT)/P_SIZE_PARAM
 * In the difficult case, narg * P_SIZE_ARGUNIT =
 *    nvar*P_SIZE_PARAM + nval*(P_SIZE_VALUE-P_SIZE_PARAM)
 * where nval is the number of VALUE sized args in nvar so we would need
 * to recover nval too.
 */

/* convert (up) to a multiple of sizeof(ARGUNIT)s */
#define P_ARG_CONV(n) (((n)+P_SIZE_ARGUNIT-1)/P_SIZE_ARGUNIT)

#if 0
# ifdef C_USES_STACK_INDIRECTION
/* then large structs (>12 bytes?) on the stack are really just pointers */
#  define P_SZ(n1,n2,p) \
P_CODE(P_ARG_CONV((n1)*P_SIZE_PARAM), n1, p)
# else
/* then large structs (>12 bytes?) are really passed by value */
#  define P_SZ(n1,n2,p) \
P_CODE(P_ARG_CONV(((n1)-(n2))*P_SIZE_PARAM+(n2)*P_SIZE_VALUE), n1, p)
# endif
#else
# ifdef C_USES_STACK_INDIRECTION
#  define P_SZ(n1,n2) \
(((n1)*P_SIZE_PARAM+sizeof(ARGUNIT)-1)/sizeof(ARGUNIT))
# else
#  define P_SZ(n1,n2) \
((((n1)-(n2))*P_SIZE_PARAM+(n2)*P_SIZE_VALUE+sizeof(ARGUNIT)-1)/sizeof(ARGUNIT))
# endif
#endif

/* maybe large structures are handled via indirection - but the constants
 * that decide excatly when they are handled that way and not placed
 * directly on the stack may need adjustment system by system.
 */


#ifdef DOS
# define P_IFDEF_DOS(x) x
#else
# define P_IFDEF_DOS(x)
#endif



# define MAIN(x) \
 VOID  precc_zer_error(PRECC_DATA * self, ...){ZER_ERROR(0);}\
 VOID  precc_bad_error(PRECC_DATA * self, ...){BAD_ERROR(1);}\
 VOID  precc_btk_error(PRECC_DATA * self, ...){BTK_ERROR(-1);}\
 VOID  precc_begin(PRECC_DATA * self, ...){BEGIN;}\
 VOID  precc_end(PRECC_DATA * self, ...){END;}\
 VOID  precc_free(PRECC_DATA * self, ...){\
       VOID  p_destr_data(PRECC_DATA*, ...); p_destr_data(self);\
 }\
 VOID precc_brk(PRECC_DATA * self, ...){\
       P_IFDEF_DOS(int brk(); brk((void*)C_STACKSIZE); /* C stack to 32K or near */);\
 }\
 VOID  precc_alloc(PRECC_DATA * self, ...){ \
 p_init_data(self); /* default setups */\
 self->readbuffersize=READBUFFERSIZE;\
 self->maxprogramsize=MAXPROGRAMSIZE;\
 self->stacksize=STACKSIZE;\
 self->contextstacksize=CONTEXTSTACKSIZE;\
 self->stacktokens=STACKTOKENS;\
 self->oldattributes=OLDATTRIBUTES;\
 self->zer_error=(ACTION*)precc_zer_error;\
 self->bad_error=(ACTION*)precc_bad_error;\
 self->btk_error=(ACTION*)precc_btk_error;\
 self->precc_begin=(ACTION*)precc_begin;\
 self->precc_end=(ACTION*)precc_end;\
 /* default anyway - just made explicit for maintainability */\
 self->yylex = yylex;\
 self->yywrap = yywrap;\
 self->yytcharp = &yytchar;\
 self->yylinenop = &yylineno;\
 self->yylenp = &yylen;\
 self->yyllocp = &yylloc;\
 self->yylvalp = &yylval;\
 p_creat_data(self); /* mallocs */\
 }\
int main(int argc,char **argv)\
{\
 void p_exit(int);\
 PRECC_DATA precc_data, *self;\
 self=&precc_data;\
 precc_brk(self) /* only in dos */;\
 p_argc=argc;p_argv=argv;\
 precc_alloc(self);         /* set data as per params */\
 p_run (self,x,0);\
 precc_free(self);          /* release memory, close files */\
 p_exit(0);                   /* abnormal exit to avoid unknown MSDOS bug */\
 return 0;\
}

#ifdef PRECC_Y
# define V(n)  p_refvalue(n)   /* n'th argument */
# define T(n)  p_reftoken(n)   /* n'th argument */
# define VV(n) p_setvalue(n)   /* result from n args */
# define TT(n) p_settoken(n)   /* result of n args */
#endif

#endif

