
#ifndef CC_H
#define CC_H

#include <p_config.h>

#ifdef DOS
# define p_memleft    coreleft
#else
# define p_memleft()    64000
#endif


/* standard clib */
#include <stdio.h>
#ifdef STDC_HEADERS
# include <unistd.h>
#endif

/* make no jumps the default for now */
#if !defined(USE_JUMPS)
# if !defined(DO_NOT_USE_JUMPS)
#  define DO_NOT_USE_JUMPS
# endif
#else
# if defined(DO_NOT_USE_JUMPS)
#  undef DO_NOT_USE_JUMPS
# endif
#endif

#ifndef __STDC__
extern int printf(), fprintf();
extern int scanf(), fscanf(), sscanf();
extern int ungetc(), _filbuf(), _flsbuf();
extern int fclose(), fflush();
#endif

#define p_gets gets
#define p_calloc calloc
#define p_free free

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
  extern  char *strchr(), *strrchr(), *strstr();
  extern  int strcmp(), strncmp();
#endif

#include <setjmp.h>
#include <stdlib.h>
#include <stdarg.h>

/* default defs */
#ifndef VALUE
# define VALUE char*       /* make sure you define VALUE !! */
#endif
#ifndef TOKEN
# define TOKEN char        /* and TOKEN, if not int and char */
#endif
#ifndef PARAM
# define PARAM long        /* VALUE=synthetic, PARAM=inherited */
#endif

/* now for some labelling shenanigans */
typedef VALUE P_VALUE_0;
typedef TOKEN P_TOKEN_0;
typedef PARAM P_PARAM_0;
#undef VALUE
#undef TOKEN
#undef PARAM
typedef P_VALUE_0 VALUE;
typedef P_TOKEN_0 TOKEN;
typedef P_PARAM_0 PARAM;
/* that converted the defines to typedefs and avoids spurious compiler type
 * match errors */

#ifndef MAXPROGRAMSIZE
# define MAXPROGRAMSIZE 4096    /* 20K (chars) is often too big in DOS */
#endif                /* but this is ~3x line length, at least */
#ifndef READBUFFERSIZE
# define READBUFFERSIZE 2048    /* ditto */
#endif                /* because this IS the line length */
#ifndef STACKSIZE
# define STACKSIZE 1        /* NOT NEEDED ANY MORE UNLESS OLD STYLE VV(n) */
#endif                      /* ATTRIBUTE REFS ARE BEING SUPPORTED */
                            /* If set, it is very difficult to overun 2K ! */

                            /* msdos defns */
#ifndef CONTEXTSTACKSIZE
# define CONTEXTSTACKSIZE 1024
#endif
#ifndef C_STACKSIZE
# define C_STACKSIZE 0x7FFF
#endif
                            /* compatibility */
#ifndef STACKTOKENS
# define STACKTOKENS 0      /* Don't put tokens on the attribute stack */
#endif                      /* unless you are sure there is one! */
#ifndef OLDATTRIBUTES
# define OLDATTRIBUTES 0    /* Don't generate code which supports $1, $2, ... */
#endif                      /* (The $named attr. refs. are supported anyway) */


#define P_MAXARGS 16        /* number of params catered for */
/* DON'T change it! */


 /* yylex decls */
extern int      yytchar;    /* the last thing yylex saw     */
extern int      yylineno;    /* line count */
/* I'll put in the decls for the yystuff here, in case they're needed */
extern int      yylen;
extern int      yylex();
extern char    *yylloc;
extern VALUE    yylval;
extern int      yywrap();

#ifndef BAD_ERROR        /* failed parse marked at deepest pt */
# define BAD_ERROR(x) fprintf(stderr,"(line %d) failed parse:\
 probable error near .. <%c> ..\nSkipping ...\n",yylineno,*(char*)self->_maxp);\
 while(yytchar!=EOF && get1token(self));/*get1token(self);*/\
 yylloc=(char*)NULL;
#endif

#ifndef ZER_ERROR        /* incomplete parse shows least remainder */
# define ZER_ERROR(x) fprintf(stderr,"(line %d) incomplete parse:\
 possible error near .. <%c> ..\nSkipping ...\n",yylineno,*(char*)self->_maxp);\
 while(yytchar!=EOF && get1token(self));/*get1token(self);*/\
 yylloc=(char*)NULL;
#endif

/* if p_entry is set, use that as handler, else print message. */

#ifndef BTK_ERROR        /* backtracking across a parse boundary */
# define BTK_ERROR(x) \
 if (!self->p_entry){\
 fprintf(stderr,"(line %d) error:\
 parse backtracked across cut from point near .. <%c> ..\n",\
 yylineno,*(char*)self->_maxp);\
 }\
 yylloc=(char*)NULL;\
 long_jmp(self,-1);/* see if we handle it on the jump stack first */\
 longjmp(self->jmpb,(unsigned)self); /* to the ! we're backtracking across */
#endif



/* local defs */
#define P_OPCODE char
#define VOID void

/* typedefs */
typedef union {              /* STATUS is returned by a PARSER */
        int   status; 
        VALUE  value;
        } STATUS;

typedef int     BOOLEAN;     /* BOOLEAN is returned by a PREDICATE */

#define TOPARSER             /* could be "*(PARSER*)" */
#define TOVALUE              /* could be "(VALUE)" */

typedef struct {             /* an P_INSTRUCTION consists of ... */
    P_OPCODE        opcode;  /* an P_OPCODE as opcode and ... */
    union {                  /* an ACTION (really!) or  ... */
    VOID           *act;     /* ... a literal as operand. */
    TOKEN           tok;     /* The opcode selects the ... */
    VALUE           val;
    PARAM           par;
    }               operand; /* ... interpretation of the operand. */
}               P_INSTRUCTION;
typedef union {              /* The VALUE stack actually contains */
    VALUE           val;     /* P_STACKVALUES, which may be either */
    TOKEN           tok;     /* VALUEs or TOKENs. TOKENs are */
    PARAM           par;     /* ... */
}               P_STACKVALUE;    /* ... pushed when literals are hit. */
typedef struct {             /* All the info required for a REWIND */
    TOKEN          *_pstr;
    P_STACKVALUE   *_value;
    int             _pc;
    int             _lineno;
    /* P_INSTRUCTION instr;*/ /* to track optimization */
}               P_FRAME;
typedef struct P_DATA {
int     readbuffersize,      /* READBUFFERSIZE */
        maxprogramsize,      /* MAXPROGRAMSIZE */
        stacksize,           /* STACKSIZE */
	contextstacksize,    /* CONTEXTSTACKSIZE */
        stacktokens,         /* (boolean) support tokens as attrs for old code*/
        oldattributes;       /* (boolean) generate yacc style attr. refs */
TOKEN  *_pstr,               /* input token buffer pointer */
       *_maxp,               /* max penetration into buffer */
       *buffer,              /* input buffer */
       *yybuffer;            /* another name for the input buffer */
VALUE  *lvbuff;              /* attributes for input buffer */
int     _passcount,          /* cut counter */
        _pc;                 /* program index */
P_INSTRUCTION
       *program,             /* program area */
        instr;               /* program instruction cache */
P_FRAME *fstack,             /* parse frame stack */
       *fptr,                /* and pointer */
        p_frame;             /* frame cache */
P_STACKVALUE
       *stack,               /* obsolete yacc attribute stack */
       *_value;              /* and pointer */
jmp_buf jmpb,                /* environment */
       *last_pjmp;           /* jump stack top */
int     p_depth;             /* for debugging */
#ifdef __cplusplus
STATUS (*p_entry)(struct P_DATA *, ...);      /* error parser */
#else
STATUS (*p_entry)();         /* error parser */
#endif __cplusplus
int     p_enargs;            /* always zero */
PARAM   p_eargv[P_MAXARGS];  /* the 0 args of the error parser */
#ifdef __cplusplus
VOID   (*zer_error)(struct P_DATA *, ...),    /* error operators */
       (*bad_error)(struct P_DATA *, ...),
       (*btk_error)(struct P_DATA *, ...),
       (*precc_begin)(struct P_DATA *, ...),  /* user supplied routines */
       (*precc_end)(struct P_DATA *, ...);
#else
VOID   (*zer_error)(),       /* error operators */
       (*bad_error)(),
       (*btk_error)(),
       (*precc_begin)(),     /* user supplied routines */
       (*precc_end)();
#endif __cplusplus
int    (*yylex)(),           /* lexer stuff */
       (*yywrap)(),
       *yytcharp,
       *yylinenop,
       *yylenp;
char  **yyllocp;
VALUE  *yylvalp;
}       P_DATA;              /* the class data */
typedef P_DATA PRECC_DATA;   /* the class is its data in C */
#define PRECC PRECC_DATA     /* the class is its data in C */

#ifdef __cplusplus
#define P_BEGIN extern "C" {
#define P_END   }
#else
#define P_BEGIN 
#define P_END   
#endif

#ifdef __cplusplus
P_BEGIN
typedef STATUS  PARSER(P_DATA *, ...);
typedef BOOLEAN PREDICATE(TOKEN, ...);
typedef VOID    ACTION(P_DATA *, ...);
P_END
#else
typedef STATUS  PARSER();    /* PARSER returns a STATUS */
typedef BOOLEAN PREDICATE(); /* PREDICATE returns a BOOLEAN */
typedef VOID    ACTION();    /* VALUE stack manipulation */
#endif

/* compatibility */
#define pstr self->_pstr
#define maxp self->_maxp
#define pc   self->_pc

#ifdef __cplusplus
class PRECC_OBJ {
  public:
    PRECC_DATA data;
    PRECC_OBJ() { VOID p_init_data(PRECC_DATA*, ...);  p_init_data(&data); };
    void creat(){ VOID p_creat_data(PRECC_DATA*, ...); p_creat_data(&data); };
   ~PRECC_OBJ() { VOID p_destr_data(PRECC_DATA*, ...); p_destr_data(&data); };
    void       run(PARSER *x) { extern ACTION p_run; p_run(&data,x,0); };
};
#endif



/* instruction destructors and constructors */
#define P_Action(x) ((ACTION *)(x).operand.act)
#define P_Token(x)  (x).operand.tok
#define P_Param(x)  (x).operand.par
#define P_Opcode(x) (x).opcode
#define P_Value(x)  (x).operand.val

/* status macros */
#define BADSTATUS(x)  (!(x).status)  /* BADSTATUS(x) is a PREDICATE */
#define GOODSTATUS(x) ((x).status)   /* as is GOODSTATUS(x) */
                                     /* This reads the PARAM part */
#define INSTATUS(x) (  (x).status -= ( 0>(x).status ? 0 : 1 ), (x).value )
                                     /* success deconstructor */
#define OK(x) ( p_tok.value = (VALUE)(x), p_tok.status += ( 0>p_tok.status ? 0 : 1 ), p_tok )
                                     /* success constructor */
#define KO(x)  ( p_tok.status = 0, p_tok )
#define SUCCESS ( p_tok.status = 1, p_tok )
#define FAILURE KO(0)


/* input stream manipulations */

/* P_MARK has to be first line in a  routine.
 * The P_MARK saves the current parse frame.
 *
 */

#if defined(__cplusplus) || ! defined(C_NONCONST_INITIALIZERS)
# define P_MARK P_FRAME p_frame; { p_fsave(p_frame); }
#else
# define P_MARK P_FRAME p_frame = {\
self->_pstr,\
0, /* "_value" not required by p_fsave */\
self->_pc,\
self->_passcount\
};
#endif

/* P_REMARK overwrites the current P_MARK
 */

#define P_REMARK { p_fsave(p_frame); }

/* P_REWIND resets the parse point to the P_MARK at the head of the fn. 
 * provided that the read buffer hasn't been overwritten, in which case 
 * just go back as far as possible
 *
 */

#define P_REWIND { p_frestore(p_frame); }

/* RELEASE will destroy the temporary references
 *
 */

#define P_RELEASE

/*
 * maxp+1 is the first address I have not yet written into. The TOKEN space
 * should be occupied by a 0. maxp is the last position  I have written into.
 * 
 * pstr is the current TOKEN position. Notice that I am going to have to read
 * one TOKEN into *pstr to start up?
 * 
 * We start with pstr=maxp=&buffer, and *buffer=first token.
 */

#define P_MOVEON { \
get1token(self); \
}

typedef struct p_jmpstack {
        jmp_buf *tail,
                 head;
} P_JMPSTACK;


#ifndef DO_NOT_USE_JUMPS
# define P_THROWABLE 1
# define P_CATCH(x) break; \
            case x: 
# define P_CAUGHT break; \
            default: \
            fprintf(stderr,"handler rethrows signal %d\n",p_retval);\
            P_RESTORE;\
            long_jmp(self,p_retval);\
            fprintf(stderr,"handler cannot rethrow bad signal %d\n",p_retval);\
            p_exit(1); break; \
            } P_RESTORE; }
# define P_ALTSET setjmp(p_alt_frame.head)
# define P_TRY { static int p_retval; P_JMPSTACK p_alt_frame = {0,};\
        switch((p_retval=P_ALTSET),p_retval) { case 0: P_ALTMARK;
# define P_THROW(x) long_jmp(self,P_THROWABLE)
# define P_ALTMARK p_alt_frame.tail = push_jmp(self,&(p_alt_frame.head))
# define P_RESTORE pop_jmp (self,p_alt_frame.tail)
#else
# define P_THROWABLE 1
# define P_ALTMARK
# define P_RESTORE
# define P_TRY if(1) { 
# define P_CATCH(x) } else {
# define P_CAUGHT }
# define P_THROW(x)
#endif


/* the secret parse string and stacks */
/* try and make these externally invisible */
/* */
extern int      call_mode;  /* 0 for auto-calling convention, 1=manual */
extern int      optimize;   /* 1 for flying optimization */
extern int      p_argc;     /* command line argument count */
extern char   **p_argv;     /* command line argument array */
extern PRECC_DATA
                precc_data; /* all globals kept here */
extern int      msdos;
extern char   *p_infile,    /* stdin name (eventually "-" if not a file) */
              *p_outfile;   /* stdout name (eventually "-" if not a file) */
extern int     p_argsign;   /* (+-1) ascending/descending args on stack */

/* opcodes */
#define P_INCR   5        /* increment value stack */
#define P_PARM   4        /* parameter to a function call */
#define P_FUNC   3        /* That's got an ACTION operand */
#define P_EXIT   2
#define P_CNST   1        /* That's got a VALUE operand. */
#define P_NOP    0        /* Saves time. */

/* program stack manipulation */
#define p_push(x) {if(self->_pc>=self->maxprogramsize-1){\
                 fprintf(stderr,"precc: program stack overflow (%d).\n\
If the application accepts the -p flag, try using -p%d\n",(int)self->_pc,\
                 (int)(2*self->maxprogramsize*sizeof(P_INSTRUCTION))/1024);\
                 p_exit(1);\
                 }\
                 self->program[self->_pc++]=(x);\
                }
#define p_pull(n) (self->_pc-=(n))
#define p_pop(x)  (x=self->program[--self->_pc])
#define p_ppeek(x) (self->_pc>0?x=self->program[self->_pc-1]:((x).opcode=EXIT,(x)))
#define p_ppoke(x) {if(self->_pc>0)self->program[self->_pc-1]=(x);}

/* frame stack manipulation */
#define p_fpush(x) (*self->fptr++=(x))
#define p_fpop(x)  (x=*--self->fptr)
#define p_fpull(n) (self->fptr-=(n))

/* frame fill and recovery */
#define p_fsave(x) \
x._pstr=self->_pstr;\
/*x._value=self->_value;*/\
x._pc=self->_pc;\
x._lineno=self->_passcount
/*;\ ppeek(x.instr)*/
#define p_frestore(x) \
self->_pstr=(x._lineno==self->_passcount)?x._pstr:(self->btk_error(self),self->buffer);\
self->_pc=x._pc\
/*; self->_value=x._value*/
/*; ppoke(x.instr)*/

/* parameter space is calculated in ARGUNITs.
 * I think they can't be bigger than long or these units may not be
 * physically on the call stack with some compilers.
 * Does it matter? Think about it!
 */
#define ARGUNIT long

/* ARGSIGN may be negative (-1) for vaxen, (+1) otherwise */
#ifndef ARGSIGN
# ifdef C_DESCENDING_STACK
#  define ARGSIGN (-1)
# else
#  define ARGSIGN (+1)
# endif
#endif

/* load and unload the current instruction */
#define p_getinstruction(i,n,x)   {P_Opcode(i)=(n);P_Action(i)=(x);}
#define p_pushinstruction(n,x)  {P_INSTRUCTION instr;p_getinstruction(instr,n,x);p_push(instr);}
#define p_getTOKEN(i,x)           {P_Opcode(i)=(P_CNST);P_Token(i)=(TOKEN)(x);}
#define p_getPARAM(i,x)           {P_Opcode(i)=(P_PARM);P_Param(i)=(PARAM)(x);}
#define p_getMANIP(i,x)           {P_Opcode(i)=(P_INCR);P_Param(i)=(PARAM)(x);}
#define p_getVALUE(i,x)           {P_Opcode(i)=(P_CNST);P_Value(i)=(VALUE)(x);}
#define p_pushTOKEN(x)   {P_INSTRUCTION instr;p_getTOKEN(instr,x);p_push(instr);}
#define p_pushPARAM(x)   {P_INSTRUCTION instr;p_getPARAM(instr,x);p_push(instr);}
#define p_pushVALUE(x)   {P_INSTRUCTION instr;p_getVALUE(instr,x);p_push(instr);}
/* cast is temporary hack - 2.45i */
#define p_pushACTION(x)            p_pushinstruction(P_FUNC,(VOID *)(x))
#define p_pushEXIT                 p_pushinstruction(P_EXIT,0)



#define p_pushMANIP(x)             /* vacuous */
#define p_pushINCR                 p_pushMANIP(1)
#define p_pushDECR                 p_pushMANIP(-1)
#define p_pushNOP                  p_pushinstruction(P_NOP,0)

/* evaluation stack manipulation */
#define p_pushvalue(x) ((self->_value++)->val)=(x)
#define p_pushparam(x) ((self->_value++)->par)=(x)
#define p_pushtoken(x) ((self->_value++)->val)=(TOKEN)(x)
#define p_popvalue(x)  (x=(--self->_value)->val)
#define p_poptoken(x)  (x=(TOKEN)((--self->_value)->val))
#define p_popparam(x)  (x=(--self->_value)->par)
#define p_pullvalue(n) &((self->_value-=(n))->val)
#define p_pullparam(n) &((self->_value-=(n))->par)
#define p_pulltoken(n) (TOKEN)(&((self->_value-=(n))->val))

#ifndef DOS
/* SUNUNIX versions */
# define p_setvalue(n)  p_pullvalue(call_mode?(n)-1:0);p_refvalue(1)
# define p_settoken(n)  p_pullvalue(call_mode?(n)-1:0);p_reftoken(1)
# define p_refvalue(n)  (self->_value[(n)-2].val)
# define p_reftoken(n)  (TOKEN)(long)(self->_value[(n)-2].val)
# define p_refpar(n)    (self->_value[(n)-2].par)
#else
/* BORLAND versions */
# define p_setvalue(n)  ((p_pullvalue(call_mode?(n)-1:0))[-1].val)
# define p_settoken(n)  (TOKEN)((p_pullvalue(call_mode?(n)-1:0))[-1].val)
# define p_refvalue(n)  (self->_value[(n)-2].val)
# define p_reftoken(n)  (TOKEN)(self->_value[(n)-2].val)
# define p_refpar(n)    (self->_value[(n)-2].par)
#endif

/* program-interpreter
 * in engine.c */
extern int      p_evaluate(PRECC_DATA*);

/* read and run parser, interpret resulting program
 * in engine.c */
extern VOID    p_run(PRECC_DATA*,...);

/* parsers without actions */
/* defined in cc.c */
P_BEGIN
extern STATUS   p_andparse0(PRECC_DATA *, PARSER *, PARSER *);
extern STATUS   p_orparse0(PRECC_DATA *, PARSER *, PARSER *);
extern STATUS   p_many0(PRECC_DATA *, PARSER *);
extern STATUS   p_iter0(PRECC_DATA *, int, PARSER *);
extern STATUS   p_some0(PRECC_DATA *, PARSER *);
extern STATUS   p_option0(PRECC_DATA *, PARSER *);
extern STATUS   p_range0(PRECC_DATA *, PREDICATE *);
extern STATUS   p_hidden0(PRECC_DATA *, PARSER *);
extern STATUS   p_atch0(PRECC_DATA *, VALUE);
P_END


/* defined in common.c */
P_BEGIN
extern STATUS   p_nothing0(PRECC_DATA *);
extern STATUS   p_anything0(PRECC_DATA *);
extern STATUS   p_first0(PRECC_DATA *);
extern STATUS   p_last0(PRECC_DATA *);
extern STATUS   p_exactly0(PRECC_DATA *, TOKEN);
extern STATUS   p_notexactly0(PRECC_DATA *, TOKEN);
extern STATUS   p_attach0(PRECC_DATA *, PARSER *);
extern STATUS   p_uerror0(PRECC_DATA *, PARSER *);
extern STATUS   p_uniq0(PRECC_DATA *);
extern STATUS   p_test0(PRECC_DATA *,int);
P_END

/* parsers with actions attached */
/* in cc.c */
P_BEGIN
extern STATUS   p_attach(PRECC_DATA *, PARSER *, ACTION *);
extern STATUS   p_prepend(PRECC_DATA *, ACTION *, PARSER *);
P_END
/* in common.c */
P_BEGIN
extern PARSER   p_andparse;
extern PARSER   p_orparse;
extern PARSER   p_nothing;
extern PARSER   p_option;
extern PARSER   p_many;
extern PARSER   p_some;
extern PARSER   p_anything;
extern PARSER   p_first;
extern PARSER   p_last;
extern PARSER   p_exactly;
extern PARSER   p_notexactly;
extern PARSER   p_range;
P_END


/* parsers taking a variable number of arguments */
extern STATUS   p_andparse0n(PRECC_DATA *,...);
extern STATUS   p_orparse0n (PRECC_DATA *,...);
extern STATUS   p_option0n  (PRECC_DATA *,...);
extern STATUS   p_hidden0n  (PRECC_DATA *,...);
extern STATUS   p_many0n    (PRECC_DATA *,...);
extern STATUS   p_iter0n    (PRECC_DATA *,...);
extern STATUS   p_some0n    (PRECC_DATA *,...);
extern STATUS   p_uniq0n    (PRECC_DATA *,...);
extern STATUS   p_attach0n  (PRECC_DATA *,...);
extern STATUS   p_prepend0n (PRECC_DATA *,...);
extern STATUS   p_range0n   (PRECC_DATA *,...);
extern STATUS   p_uerror0n  (PRECC_DATA *,...);
extern STATUS   p_until0n   (PRECC_DATA *,...);
extern STATUS   p_andparse0n(PRECC_DATA *,...);
extern STATUS   p_nothing0n (PRECC_DATA *,...);
extern STATUS   p_test0n    (PRECC_DATA *,...);

/* but replaced by macros here - args ignored */

#define p_andparse0n(s,p,a,q,b) p_andparse0(s,p,q)
#define p_orparse0n(s,p,a,q,b)  p_orparse0 (s,p,q)
#define p_option0n(s,p,a)       p_option0  (s,p)
#define p_hidden0n(s,p,a)       p_hidden0  (s,p)
#define p_many0n(s,p,a)         p_many0    (s,p)
#define p_iter0n(s,n,p,a)       p_iter0    (s,n,p)
#define p_some0n(s,p,a)         p_some0    (s,p)
#define p_uniq0n(s,p,a)         p_uniq0    (s,p)
#define p_attach0n(s,p,a,f,b)   p_attach   (s,p,f)
#define p_prepend0n(s,p,a,f,b)  p_prepend  (s,p,f)
#define p_range0n(s,p,a)        p_range0   (s,p)
#define p_uerror0n(s,p,a)       p_uerror0  (s,p)
#define p_until0n(s,p,a)        p_until0   (s,p)
#define p_nothing0n(s)          p_nothing0 (s)

/* actions */
/* in common.c */
extern ACTION   nop;

/* aux */
extern void     p_exit(int);
/* in engine.c */
extern TOKEN    get1token(PRECC_DATA*);
extern VOID     realignbuffer(PRECC_DATA*);
    /* (in on_error.c) */
extern VOID   p_zer_error(PRECC_DATA *, ...);
extern VOID   p_bad_error(PRECC_DATA *, ...);
extern VOID   p_btk_error(PRECC_DATA *, ...);
extern VOID   p_begin(PRECC_DATA *, ...);
extern VOID   p_end(PRECC_DATA *, ...);
    /* lexer (in yystuff.c)*/
extern int yylex();

/* in jmp.c */
extern   void	  init_jmp (PRECC_DATA *);
extern   void	  long_jmp (PRECC_DATA *, int);
extern   jmp_buf *push_jmp (PRECC_DATA *, jmp_buf *);
extern   void	  pop_jmp  (PRECC_DATA *, jmp_buf *);

    /* (in ccdata.c) */
extern VOID   p_init_data(PRECC_DATA *, ...);
extern VOID   p_creat_data(PRECC_DATA *, ...);
extern VOID   p_destr_data(PRECC_DATA *, ...);

#ifndef BEGIN
# define BEGIN
#endif
#ifndef END
# define END
#endif


#define P_PSTAR(X,CALL1,CALL2) \
  MARK;  p_tok = CALL1;\
  if (BADSTATUS(p_tok)) {RELEASE;return p_tok;}\
  X = (PARAM)INSTATUS(p_tok); /* decode */\
  p_tok = CALL2;\
  if (BADSTATUS(p_tok)) {REWIND;} else {RELEASE;}

#define P_PAND(CALL1,CALL2) \
  MARK; p_tok = CALL1;\
  if (BADSTATUS(p_tok)) {RELEASE;return p_tok;}\
  p_tok = CALL2;\
  if (BADSTATUS(p_tok)) {REWIND;} else {RELEASE;}

#ifdef DEBUG
# define P_RETURN(x,y) {static STATUS p_tok;\
  fprintf(stderr,"(%d) Looking for %s\n",self->p_depth++,y);\
  p_tok = x;\
  if (BADSTATUS(p_tok))\
    fprintf(stderr,"(%d) Failed to find %s\n",--self->p_depth,y);\
  else\
    fprintf(stderr,"(%d) Found %s\n",--self->p_depth,y);\
  return p_tok;\
  }
#else
# define P_RETURN(x,y) return x
#endif


/* round a size up to an integer size multiple of bytes */
#define P_ROUND(TYPE) (((sizeof(TYPE)+sizeof(int)-1)/sizeof(int))*sizeof(int))
#define P_SIZE_VALUE P_ROUND(VALUE)
#define P_SIZE_PARAM P_ROUND(PARAM)

#define P_SZ(n1,n2) ((n1)+(n2)*((sizeof(VALUE)+1)/sizeof(PARAM) - 1))


#ifdef DOS
# define P_IFDEF_DOS(x) x
#else
# define P_IFDEF_DOS(x)
#endif

/* experimental C++ like decl. that could be better done! */
#define PRECC_NEW(x,y) \
  PRECC_DATA *x; x = p_new(); p_creat_data(((y),x)) /* extra inits */ 

# define MAIN(x) \
 VOID  precc_zer_error(PRECC_DATA * self, ...){ZER_ERROR(0);}\
 VOID  precc_bad_error(PRECC_DATA * self, ...){BAD_ERROR(1);}\
 VOID  precc_btk_error(PRECC_DATA * self, ...){BTK_ERROR(-1);}\
 VOID  precc_begin(PRECC_DATA * self, ...){BEGIN;}\
 VOID  precc_end(PRECC_DATA * self, ...){END;}\
 VOID  precc_free(PRECC_DATA * self, ...){\
       VOID  p_destr_data(PRECC_DATA*, ...); p_destr_data(self);\
 }\
 VOID precc_brk(PRECC_DATA * self, ...){\
       P_IFDEF_DOS(int brk(); brk((void*)C_STACKSIZE); /* set the C stack to 32K or whatever*/)\
 }\
int main(int argc, char **argv)\
{\
 void p_exit(int);\
 PRECC_DATA *p_new();\
 PRECC_NEW(self,(\
 self->readbuffersize=READBUFFERSIZE,\
 self->maxprogramsize=MAXPROGRAMSIZE,\
 self->stacksize=STACKSIZE,\
 self->contextstacksize=CONTEXTSTACKSIZE,\
 self->stacktokens=STACKTOKENS,\
 self->oldattributes=OLDATTRIBUTES,\
 self->zer_error=(ACTION*)precc_zer_error,\
 self->bad_error=(ACTION*)precc_bad_error,\
 self->btk_error=(ACTION*)precc_btk_error,\
 self->precc_begin=(ACTION*)precc_begin,\
 self->precc_end=(ACTION*)precc_end,\
 /* default anyway - just made explicit for maintainability */\
 self->yylex = yylex,\
 self->yywrap = yywrap,\
 self->yytcharp = &yytchar,\
 self->yylinenop = &yylineno,\
 self->yylenp = &yylen,\
 self->yyllocp = &yylloc,\
 self->yylvalp = &yylval\
 ));\
 precc_brk(self) /* only in dos */;\
 p_argc=argc;p_argv=argv;\
 p_run (self,x,0);\
 precc_free(self);          /* release memory, close files */\
 p_exit(0);\
 return 0;\
}

#ifdef PRECC_Y
# define V(n)  p_refvalue(n)   /* n'th argument */
# define T(n)  p_reftoken(n)   /* n'th argument */
# define VV(n) p_setvalue(n)   /* result from n args */
# define TT(n) p_settoken(n)   /* result of n args */
#endif

#endif
