/*+file-overview
**
** A Lex/Precc definition for Z
*/
/*# define DEBUG*/
# define PARAM char*
/*# define VALUE char**/
#include "ccx.h"

/* Flag which indicates if lexemes are to be displayed or not.
** Non zero means display them.
*/
int    z_l_display_lexemes=1;

void output(char *s)
{
    if (z_l_display_lexemes)
    {
        printf("%s",s);
    }
}

/* A cheap little line counter so that the cause of an error is easier
** to find.  If you use this software for anything serious, please change
** this to something more robust that does not use a manifest type.
*/
int    z_l_line_number;
extern
int    yylineno;
extern
int    yytchar;
/* Remember to set yytchar to EOF in yyterminate().  */

@ ws1   =          <' '>                        {: output(" "); :}
@       |          <'\t'>                       {: output("\t");:}

@ ws    =          ws1
@       |          <'~'>                        {: output("~"); :}
@       |          <'\\'> {<';'>|<'!'>|<','>}   {: output("\\;");:}
@       |          <'%'> [ >'%'< ?* ] nl        {: output("%\n");:}
@       |          nl                           {: output("\n");:} 

@ key0(w)=         )*(char*)w==0(                         {@ $w @}
@       |          <*(char*)w> key0((PARAM)((char*)w+1))  {@ $w @}

@ key(w)=          key0(w)
@                  {: output(w); :}  ws*                  {@ $w @}

@ key1(w)=         key0(w)
@                  {: output(w); :}  ws1*                 {@ $w @}

@ digit =          (isdigit)

@ letter=          (isalpha)

@ ident =          letter { letter | digit | <'\\'> <'_'> }*

@ infix =          [ <'='> [ <'='> ] | <','> ]
@                  { <'+'> | <'-'> | <'*'> | <'.'> | <'='> |
@                    <'<'> | <'>'> | <','> }+

@ latex =         <'\\'> [ keyword ] letter+  /* but not a keyword!! */
@                 [ ws* <'{'> ws* { word ws* }* <'}'> ]

static int n; /* number buffer */

@ number=         digit+

@ stroke=         <'?'> | <'!'> | <'_'> digit

/* or infix! ? */

@ word  =         ident | latex  | infix

@ nl     =        $  {:printf("%% line %d OK",(yylineno=z_l_line_number+=1));:}

@ priority =      digit\x )'1'<=(int)$x && (int)$x<='6'(  {@ (int)$x-'0' @}

/* this looks up in list with a little less stack-depth than linear search */

@ keys(n,list) =  )(int)n<=1(   key0(*(char**)list)
@              |  )(int)n >1( { keys((int)n/2,list)
@                             | keys((int)n - (int)n/2,(PARAM)((char**)list+(int)n/2))
@                             }

char* keylist[]  =
{
"Delta",
"Xi",
"IF",
"THEN",
"ELSE",
"LET",
"also",
"begin",
"bsup",
"cross", /*added - ptb */
"end",
"esup",
"exists",
"forall",
"defs",
"hide",
"iff",
"implies",
"in",
"inrel",
"lambda",
"land",
"langle",
"lbag",
"ldata,"
"limg",  /* 26 */
"lnot",
"lor",
"mu",
"pipe",
"power",
"pre",
"project",
"rangle",
"rbag",
"rdata",
"rimg",
"semi",
"theta",
"where",
"begin", /* two additions of mine - ptb */
"end",
""       /* 43 */
};

@ keyword =  keys((PARAM)42,(PARAM)keylist)

# define MAXWORDS 2048

extern int ukey(char *, long);

static char c[2];

@ L_COMMENTCHAR  = 
@                  { [ key("\\begin") L_OPENBRACE
@                     { key("zed")
@                     | key("axdef")
@                     | key("schema")
@                     | key("gendef")
@                     }
@                    ] /*]>'%'<[*/ >'}'<\x   {: c[0]=(int)$x;output(c); :}
@                  |   <'}'>     {: output("}"); :}
@                  |   ws 
@                  }   ws*

@ dummy    =      {@ pstr @}

@ taken(p) =      dummy\begin p dummy\end
@                 {@ ukey($begin,(long)$end-(long)$begin) @}

@ L_WORD   =      [ key("\\Delta") | key("\\Xi") ] taken(word)\x
@                 {: output("<WORD>"); :} ws*     {@ $x @}

@ L_STROKE =      taken(stroke)\x
@                 {: output("<STROKE>"); :} ws*   {@ $x @}

@ L_INFIX  =      taken(infix)\x
@                 {: output("<INFIX>"); :} ws*    {@ $x @}

@ L_NUMBER =      taken(number)\x
@                 {: output("<NUMBER>"); :} ws*   {@ $x @}

@ L_PRIORITY =    priority\x
@                 {: output("<PRIORITY>");:} ws1* {@ $x @}

@ L_SYMBOL   =    taken(word)\x
@                 {: output("<SYMBOL>"); :} ws1*  {@ $x @}

@ L_ENDLINE  =    nl
@                 {: output("\n"); :}       ws*

@ L_ELSE   =      key("\\ELSE")

@ L_IF     =      key("\\IF")

@ L_LET    =      key("\\LET")

@ L_THEN   =      key("\\THEN")

@ L_ALSO =        key("\\also")

@ L_BEGIN_ZED =   key("\\begin")
@                 L_OPENBRACE key("zed") L_CLOSEBRACE

@ L_BEGIN_AXDEF = key("\\begin")
@                 L_OPENBRACE key("axdef") L_CLOSEBRACE

@ L_BEGIN_SCHEMA= key("\\begin")
@                 L_OPENBRACE key("schema") L_CLOSEBRACE

@ L_BEGIN_GENDEF= key("\\begin")
@                 L_OPENBRACE key("gendef") L_CLOSEBRACE

@ L_BSUP =        key("\\bsup")

@ L_CROSS =       key("\\cross")

@ L_END_ZED =     key("\\end")
@                 L_OPENBRACE key("zed") L_CLOSEBRACE

@ L_END_AXDEF =   key("\\end")
@                 L_OPENBRACE key("axdef") L_CLOSEBRACE

@ L_END_SCHEMA = key("\\end")
@                 L_OPENBRACE key("schema") L_CLOSEBRACE

@ L_END_GENDEF = key("\\end")
@                 L_OPENBRACE key("gendef") L_CLOSEBRACE

@ L_ESUP =       key("\\esup")

@ L_EXISTS =     key("\\exists")

@ L_EXISTS_1 =   key("\\exists_1")

@ L_FORALL =     key("\\forall")

@ L_DEFS =       key("\\defs")

@ L_HIDE =       key("\\hide")

@ L_IFF =        key("\\iff")

@ L_IMPLIES =    key("\\implies")

@ L_IN =         key("\\in")

@ L_INREL =      key("\\inrel")

@ L_LAMBDA =     key("\\lambda")

@ L_LAND =       key("\\land")

@ L_LANGLE =     key("\\langle")

@ L_LBAG =       key("\\lbag")

@ L_LDATA =      key("\\ldata")

@ L_LIMG =       key("\\limg")

@ L_LNOT =       key("\\lnot")

@ L_LOR =        key("\\lor")

@ L_MU =         key("\\mu")

@ L_PIPE =       key("\\pipe")

@ L_POWER =      key("\\power")

@ L_PRE =        key("\\pre")

@ L_PROJECT =    key("\\project")

@ L_RANGLE =     key("\\rangle")

@ L_RBAG =       key("\\rbag")

@ L_RDATA =      key("\\rdata")

@ L_RIMG =       key("\\rimg")

@ L_SEMI =       key("\\semi")

@ L_THETA =      key("\\theta")

@ L_WHERE =      key("\\where")

@ L_TRUE =       key("true")

@ L_FALSE =      key("false")

@ L_VERT =       key("|")

@ L_HYPHEN =     key("-")

@ L_POINT =      key(".")

@ L_OPENBRACKET = key("[")

@ L_CLOSEBRACKET= key("]")

@ L_OPENBRACE =  key("{")

@ L_CLOSEBRACE = key("}")

@ L_OPENPAREN =  key("(")

@ L_CLOSEPAREN = key(")")

@ L_OPENSET =    key("\\{")

@ L_CLOSESET =   key("\\}")

@ L_UNDERSCORE = key("\\_")

@ L_COMMA =      key(",")

@ L_EQUALS_EQUALS = key("==")

@ L_COLON_COLON_EQUALS = key("::=")

@ L_SEMICOLON = key(";")

@ L_COLON    = key(":")

@ L_BACKSLASH_BACKSLASH = key("\\\\")

@ L_AT = key("@")

@ L_SLASH = key("/")

@ L_EQUALS = key("=")

@ L_PERCENT_PERCENT_INOP   = ^ key1("%%inop")

@ L_PERCENT_PERCENT_POSTOP = ^ key1("%%postop")

@ L_PERCENT_PERCENT_INREL  = ^ key1("%%inrel")

@ L_PERCENT_PERCENT_PREREL = ^ key1("%%prerel")

@ L_PERCENT_PERCENT_INGEN  = ^ key1("%%ingen")

@ L_PERCENT_PERCENT_PREGEN = ^ key1("%%pregen")

@ L_PERCENT_PERCENT_IGNORE = ^ key1("%%ignore")

@ L_PERCENT_PERCENT_UNCHECKED = ^ key1("%%unchecked")

@ L_PERCENT_PERCENT_TAME   = ^ key1("%%tame")

@ L_PERCENT_PERCENT_TOKEN  = ^ key1("%%token")






static void z_l_echo ()
{
    if (z_l_display_lexemes)
    {
        /*ECHO;*/
        putc('\n', stdout);
    }
}



static void z_l_invalid_lexeme (char *lexeme)
{
    fprintf(stderr,
            "z 2 lexer: line %d: invalid lexeme\n",
            z_l_line_number);
}



void z_l_initialise ()
{
    z_l_display_lexemes= 0;
    z_l_line_number= 0;
}



