/*+file-overview
**
** A Lex/Precc definition for Z
*/
/*# define DEBUG*/
# define PARAM char*
/*# define VALUE char**/
#include "ccx.h"

/* Flag which indicates if lexemes are to be displayed or not.
** Non zero means display them.
*/
int    z_l_display_lexemes=1;

void output(char *s)
{
    if (z_l_display_lexemes)
    {
        printf("%s",s);
    }
}

/* A cheap little line counter so that the cause of an error is easier
** to find.  If you use this software for anything serious, please change
** this to something more robust that does not use a manifest type.
*/
int    z_l_line_number;
extern
int    yylineno;
extern
int    yytchar;
/* Remember to set yytchar to EOF in yyterminate().  */

P_BEGIN
static STATUS hid0(PRECC_DATA* self) {
return p_exactly0(self,' ');
}
static VOID hid1(PRECC_DATA* self) {
 output(" "); 
}
static STATUS hid2(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid1;
return p_attach0n(self,TOPARSER p_nothing0,0,hid1,0);
}
static STATUS hid3(PRECC_DATA* self) {
PARSER hid0, hid2;
return p_andparse0n (self,TOPARSER hid0,0,TOPARSER hid2,0);
}
static STATUS hid4(PRECC_DATA* self) {
return p_exactly0(self,'\t');
}
static VOID hid5(PRECC_DATA* self) {
 output("\t");
}
static STATUS hid6(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid5;
return p_attach0n(self,TOPARSER p_nothing0,0,hid5,0);
}
static STATUS hid7(PRECC_DATA* self) {
PARSER hid4, hid6;
return p_andparse0n (self,TOPARSER hid4,0,TOPARSER hid6,0);
}
static STATUS hid8 (PRECC_DATA* self) {
PARSER hid3, hid7;
return p_orparse0n (self,TOPARSER hid3,0,TOPARSER hid7,0);
}
STATUS ws1(PRECC_DATA* self) {
PARSER hid8;
P_RETURN((TOPARSER hid8)(self),"ws1");
}
P_END

P_BEGIN
static STATUS hid9(PRECC_DATA* self) {
return p_exactly0(self,'~');
}
static VOID hid10(PRECC_DATA* self) {
 output("~"); 
}
static STATUS hid11(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid10;
return p_attach0n(self,TOPARSER p_nothing0,0,hid10,0);
}
static STATUS hid12(PRECC_DATA* self) {
PARSER hid9, hid11;
return p_andparse0n (self,TOPARSER hid9,0,TOPARSER hid11,0);
}
static STATUS hid13(PRECC_DATA* self) {
return p_exactly0(self,'\\');
}
static STATUS hid14(PRECC_DATA* self) {
return p_exactly0(self,';');
}
static STATUS hid15(PRECC_DATA* self) {
return p_exactly0(self,'!');
}
static STATUS hid16(PRECC_DATA* self) {
return p_exactly0(self,',');
}
static STATUS hid17 (PRECC_DATA* self) {
PARSER hid15, hid16;
return p_orparse0n (self,TOPARSER hid15,0,TOPARSER hid16,0);
}
static STATUS hid18 (PRECC_DATA* self) {
PARSER hid14, hid17;
return p_orparse0n (self,TOPARSER hid14,0,TOPARSER hid17,0);
}
static VOID hid19(PRECC_DATA* self) {
 output("\\;");
}
static STATUS hid20(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid19;
return p_attach0n(self,TOPARSER p_nothing0,0,hid19,0);
}
static STATUS hid21(PRECC_DATA* self) {
PARSER hid18, hid20;
return p_andparse0n (self,TOPARSER hid18,0,TOPARSER hid20,0);
}
static STATUS hid22(PRECC_DATA* self) {
PARSER hid13, hid21;
return p_andparse0n (self,TOPARSER hid13,0,TOPARSER hid21,0);
}
static STATUS hid23(PRECC_DATA* self) {
return p_exactly0(self,'%');
}
static STATUS hid24(PRECC_DATA* self) {
return p_notexactly0(self,'%');
}
static STATUS hid25(PRECC_DATA* self) {
PARSER p_anything0;
return p_many0n(self,TOPARSER p_anything0,0);
}
static STATUS hid26(PRECC_DATA* self) {
PARSER hid24, hid25;
return p_andparse0n (self,TOPARSER hid24,0,TOPARSER hid25,0);
}
static STATUS hid27(PRECC_DATA* self) {
PARSER hid26;
return p_option0n(self,TOPARSER hid26,0);
}
static VOID hid28(PRECC_DATA* self) {
 output("%\n");
}
static STATUS hid29(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid28;
return p_attach0n(self,TOPARSER p_nothing0,0,hid28,0);
}
static STATUS hid30(PRECC_DATA* self) {
PARSER nl, hid29;
return p_andparse0n (self,TOPARSER nl,0,TOPARSER hid29,0);
}
static STATUS hid31(PRECC_DATA* self) {
PARSER hid27, hid30;
return p_andparse0n (self,TOPARSER hid27,0,TOPARSER hid30,0);
}
static STATUS hid32(PRECC_DATA* self) {
PARSER hid23, hid31;
return p_andparse0n (self,TOPARSER hid23,0,TOPARSER hid31,0);
}
static VOID hid33(PRECC_DATA* self) {
 output("\n");
}
static STATUS hid34(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid33;
return p_attach0n(self,TOPARSER p_nothing0,0,hid33,0);
}
static STATUS hid35(PRECC_DATA* self) {
PARSER nl, hid34;
return p_andparse0n (self,TOPARSER nl,0,TOPARSER hid34,0);
}
static STATUS hid36 (PRECC_DATA* self) {
PARSER hid32, hid35;
return p_orparse0n (self,TOPARSER hid32,0,TOPARSER hid35,0);
}
static STATUS hid37 (PRECC_DATA* self) {
PARSER hid22, hid36;
return p_orparse0n (self,TOPARSER hid22,0,TOPARSER hid36,0);
}
static STATUS hid38 (PRECC_DATA* self) {
PARSER hid12, hid37;
return p_orparse0n (self,TOPARSER hid12,0,TOPARSER hid37,0);
}
static STATUS hid39 (PRECC_DATA* self) {
PARSER ws1, hid38;
return p_orparse0n (self,TOPARSER ws1,0,TOPARSER hid38,0);
}
STATUS ws(PRECC_DATA* self) {
PARSER hid39;
P_RETURN((TOPARSER hid39)(self),"ws");
}
P_END

P_BEGIN
static STATUS hid40(PRECC_DATA* self,PARAM w) {
return p_test0(self,*(char*)w==0);
}
static STATUS hid41(PRECC_DATA* self,PARAM w) {
return p_atch0(self,/* VALUE */ (TOVALUE w) );
}
static STATUS hid42(PRECC_DATA* self,PARAM w) {
PARSER hid40, hid41;
return p_andparse0n (self,TOPARSER hid40,P_SZ(1,0),w,TOPARSER hid41,P_SZ(1,0),w);
}
static STATUS hid43(PRECC_DATA* self,PARAM w) {
return p_exactly0(self,*(char*)w);
}
static STATUS hid44(PRECC_DATA* self,PARAM w) {
return p_atch0(self,/* VALUE */ (TOVALUE w) );
}
static STATUS hid45(PRECC_DATA* self,PARAM w) {
PARSER key0, hid44;
return p_andparse0n (self,TOPARSER key0,P_SZ(1,0),(PARAM)((char*)w+1),TOPARSER hid44,P_SZ(1,0),w);
}
static STATUS hid46(PRECC_DATA* self,PARAM w) {
PARSER hid43, hid45;
return p_andparse0n (self,TOPARSER hid43,P_SZ(1,0),w,TOPARSER hid45,P_SZ(1,0),w);
}
static STATUS hid47 (PRECC_DATA* self,PARAM w) {
PARSER hid42, hid46;
return p_orparse0n (self,TOPARSER hid42,P_SZ(1,0),w,TOPARSER hid46,P_SZ(1,0),w);
}
STATUS key0(PRECC_DATA* self,PARAM w) {
PARSER hid47;
P_RETURN((TOPARSER hid47)(self,w),"key0");
}
P_END

P_BEGIN
static VOID hid48(PRECC_DATA* self,PARAM w) {
 output(w); 
}
static STATUS hid49(PRECC_DATA* self,PARAM w) {
PARSER p_nothing0;ACTION hid48;
return p_attach0n(self,TOPARSER p_nothing0,0,hid48,P_SZ(1,0),w);
}
static STATUS hid50(PRECC_DATA* self,PARAM w) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid51(PRECC_DATA* self,PARAM w) {
return p_atch0(self,/* VALUE */ (TOVALUE w) );
}
static STATUS hid52(PRECC_DATA* self,PARAM w) {
PARSER hid50, hid51;
return p_andparse0n (self,TOPARSER hid50,P_SZ(1,0),w,TOPARSER hid51,P_SZ(1,0),w);
}
static STATUS hid53(PRECC_DATA* self,PARAM w) {
PARSER hid49, hid52;
return p_andparse0n (self,TOPARSER hid49,P_SZ(1,0),w,TOPARSER hid52,P_SZ(1,0),w);
}
static STATUS hid54(PRECC_DATA* self,PARAM w) {
PARSER key0, hid53;
return p_andparse0n (self,TOPARSER key0,P_SZ(1,0),w,TOPARSER hid53,P_SZ(1,0),w);
}
STATUS key(PRECC_DATA* self,PARAM w) {
PARSER hid54;
P_RETURN((TOPARSER hid54)(self,w),"key");
}
P_END

P_BEGIN
static VOID hid55(PRECC_DATA* self,PARAM w) {
 output(w); 
}
static STATUS hid56(PRECC_DATA* self,PARAM w) {
PARSER p_nothing0;ACTION hid55;
return p_attach0n(self,TOPARSER p_nothing0,0,hid55,P_SZ(1,0),w);
}
static STATUS hid57(PRECC_DATA* self,PARAM w) {
PARSER ws1;
return p_many0n(self,TOPARSER ws1,0);
}
static STATUS hid58(PRECC_DATA* self,PARAM w) {
return p_atch0(self,/* VALUE */ (TOVALUE w) );
}
static STATUS hid59(PRECC_DATA* self,PARAM w) {
PARSER hid57, hid58;
return p_andparse0n (self,TOPARSER hid57,P_SZ(1,0),w,TOPARSER hid58,P_SZ(1,0),w);
}
static STATUS hid60(PRECC_DATA* self,PARAM w) {
PARSER hid56, hid59;
return p_andparse0n (self,TOPARSER hid56,P_SZ(1,0),w,TOPARSER hid59,P_SZ(1,0),w);
}
static STATUS hid61(PRECC_DATA* self,PARAM w) {
PARSER key0, hid60;
return p_andparse0n (self,TOPARSER key0,P_SZ(1,0),w,TOPARSER hid60,P_SZ(1,0),w);
}
STATUS key1(PRECC_DATA* self,PARAM w) {
PARSER hid61;
P_RETURN((TOPARSER hid61)(self,w),"key1");
}
P_END

P_BEGIN
static STATUS hid62(PRECC_DATA* self) {
PREDICATE isdigit;
return p_range0n(self,isdigit,0);
}
STATUS digit(PRECC_DATA* self) {
PARSER hid62;
P_RETURN((TOPARSER hid62)(self),"digit");
}
P_END

P_BEGIN
static STATUS hid63(PRECC_DATA* self) {
PREDICATE isalpha;
return p_range0n(self,isalpha,0);
}
STATUS letter(PRECC_DATA* self) {
PARSER hid63;
P_RETURN((TOPARSER hid63)(self),"letter");
}
P_END

P_BEGIN
static STATUS hid64(PRECC_DATA* self) {
return p_exactly0(self,'\\');
}
static STATUS hid65(PRECC_DATA* self) {
return p_exactly0(self,'_');
}
static STATUS hid66(PRECC_DATA* self) {
PARSER hid64, hid65;
return p_andparse0n (self,TOPARSER hid64,0,TOPARSER hid65,0);
}
static STATUS hid67 (PRECC_DATA* self) {
PARSER digit, hid66;
return p_orparse0n (self,TOPARSER digit,0,TOPARSER hid66,0);
}
static STATUS hid68 (PRECC_DATA* self) {
PARSER letter, hid67;
return p_orparse0n (self,TOPARSER letter,0,TOPARSER hid67,0);
}
static STATUS hid69(PRECC_DATA* self) {
PARSER hid68;
return p_many0n(self,TOPARSER hid68,0);
}
static STATUS hid70(PRECC_DATA* self) {
PARSER letter, hid69;
return p_andparse0n (self,TOPARSER letter,0,TOPARSER hid69,0);
}
STATUS ident(PRECC_DATA* self) {
PARSER hid70;
P_RETURN((TOPARSER hid70)(self),"ident");
}
P_END

P_BEGIN
static STATUS hid71(PRECC_DATA* self) {
return p_exactly0(self,'=');
}
static STATUS hid72(PRECC_DATA* self) {
return p_exactly0(self,'=');
}
static STATUS hid73(PRECC_DATA* self) {
PARSER hid72;
return p_option0n(self,TOPARSER hid72,0);
}
static STATUS hid74(PRECC_DATA* self) {
PARSER hid71, hid73;
return p_andparse0n (self,TOPARSER hid71,0,TOPARSER hid73,0);
}
static STATUS hid75(PRECC_DATA* self) {
return p_exactly0(self,',');
}
static STATUS hid76 (PRECC_DATA* self) {
PARSER hid74, hid75;
return p_orparse0n (self,TOPARSER hid74,0,TOPARSER hid75,0);
}
static STATUS hid77(PRECC_DATA* self) {
PARSER hid76;
return p_option0n(self,TOPARSER hid76,0);
}
static STATUS hid78(PRECC_DATA* self) {
return p_exactly0(self,'+');
}
static STATUS hid79(PRECC_DATA* self) {
return p_exactly0(self,'-');
}
static STATUS hid80(PRECC_DATA* self) {
return p_exactly0(self,'*');
}
static STATUS hid81(PRECC_DATA* self) {
return p_exactly0(self,'.');
}
static STATUS hid82(PRECC_DATA* self) {
return p_exactly0(self,'=');
}
static STATUS hid83(PRECC_DATA* self) {
return p_exactly0(self,'<');
}
static STATUS hid84(PRECC_DATA* self) {
return p_exactly0(self,'>');
}
static STATUS hid85(PRECC_DATA* self) {
return p_exactly0(self,',');
}
static STATUS hid86 (PRECC_DATA* self) {
PARSER hid84, hid85;
return p_orparse0n (self,TOPARSER hid84,0,TOPARSER hid85,0);
}
static STATUS hid87 (PRECC_DATA* self) {
PARSER hid83, hid86;
return p_orparse0n (self,TOPARSER hid83,0,TOPARSER hid86,0);
}
static STATUS hid88 (PRECC_DATA* self) {
PARSER hid82, hid87;
return p_orparse0n (self,TOPARSER hid82,0,TOPARSER hid87,0);
}
static STATUS hid89 (PRECC_DATA* self) {
PARSER hid81, hid88;
return p_orparse0n (self,TOPARSER hid81,0,TOPARSER hid88,0);
}
static STATUS hid90 (PRECC_DATA* self) {
PARSER hid80, hid89;
return p_orparse0n (self,TOPARSER hid80,0,TOPARSER hid89,0);
}
static STATUS hid91 (PRECC_DATA* self) {
PARSER hid79, hid90;
return p_orparse0n (self,TOPARSER hid79,0,TOPARSER hid90,0);
}
static STATUS hid92 (PRECC_DATA* self) {
PARSER hid78, hid91;
return p_orparse0n (self,TOPARSER hid78,0,TOPARSER hid91,0);
}
static STATUS hid93(PRECC_DATA* self) {
PARSER hid92;
return p_some0n(self,TOPARSER hid92,0);
}
static STATUS hid94(PRECC_DATA* self) {
PARSER hid77, hid93;
return p_andparse0n (self,TOPARSER hid77,0,TOPARSER hid93,0);
}
STATUS infix(PRECC_DATA* self) {
PARSER hid94;
P_RETURN((TOPARSER hid94)(self),"infix");
}
P_END

P_BEGIN
static STATUS hid95(PRECC_DATA* self) {
return p_exactly0(self,'\\');
}
static STATUS hid96(PRECC_DATA* self) {
PARSER keyword;
return p_option0n(self,TOPARSER keyword,0);
}
static STATUS hid97(PRECC_DATA* self) {
PARSER letter;
return p_some0n(self,TOPARSER letter,0);
}
static STATUS hid98(PRECC_DATA* self) {
PARSER /* but not a keyword!! */ws;
return p_many0n(self,TOPARSER /* but not a keyword!! */ws,0);
}
static STATUS hid99(PRECC_DATA* self) {
return p_exactly0(self,'{');
}
static STATUS hid100(PRECC_DATA* self) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid101(PRECC_DATA* self) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid102(PRECC_DATA* self) {
PARSER word, hid101;
return p_andparse0n (self,TOPARSER word,0,TOPARSER hid101,0);
}
static STATUS hid103(PRECC_DATA* self) {
PARSER hid102;
return p_many0n(self,TOPARSER hid102,0);
}
static STATUS hid104(PRECC_DATA* self) {
return p_exactly0(self,'}');
}
static STATUS hid105(PRECC_DATA* self) {
PARSER hid103, hid104;
return p_andparse0n (self,TOPARSER hid103,0,TOPARSER hid104,0);
}
static STATUS hid106(PRECC_DATA* self) {
PARSER hid100, hid105;
return p_andparse0n (self,TOPARSER hid100,0,TOPARSER hid105,0);
}
static STATUS hid107(PRECC_DATA* self) {
PARSER hid99, hid106;
return p_andparse0n (self,TOPARSER hid99,0,TOPARSER hid106,0);
}
static STATUS hid108(PRECC_DATA* self) {
PARSER hid98, hid107;
return p_andparse0n (self,TOPARSER hid98,0,TOPARSER hid107,0);
}
static STATUS hid109(PRECC_DATA* self) {
PARSER hid108;
return p_option0n(self,TOPARSER hid108,0);
}
static STATUS hid110(PRECC_DATA* self) {
PARSER hid97, hid109;
return p_andparse0n (self,TOPARSER hid97,0,TOPARSER hid109,0);
}
static STATUS hid111(PRECC_DATA* self) {
PARSER hid96, hid110;
return p_andparse0n (self,TOPARSER hid96,0,TOPARSER hid110,0);
}
static STATUS hid112(PRECC_DATA* self) {
PARSER hid95, hid111;
return p_andparse0n (self,TOPARSER hid95,0,TOPARSER hid111,0);
}
STATUS latex(PRECC_DATA* self) {
PARSER hid112;
P_RETURN((TOPARSER hid112)(self),"latex");
}
P_END

static int n; /* number buffer */

P_BEGIN
static STATUS hid113(PRECC_DATA* self) {
PARSER digit;
return p_some0n(self,TOPARSER digit,0);
}
STATUS number(PRECC_DATA* self) {
PARSER hid113;
P_RETURN((TOPARSER hid113)(self),"number");
}
P_END

P_BEGIN
static STATUS hid114(PRECC_DATA* self) {
return p_exactly0(self,'?');
}
static STATUS hid115(PRECC_DATA* self) {
return p_exactly0(self,'!');
}
static STATUS hid116(PRECC_DATA* self) {
return p_exactly0(self,'_');
}
static STATUS hid117(PRECC_DATA* self) {
PARSER hid116, digit;
return p_andparse0n (self,TOPARSER hid116,0,TOPARSER digit,0);
}
static STATUS hid118 (PRECC_DATA* self) {
PARSER hid115, hid117;
return p_orparse0n (self,TOPARSER hid115,0,TOPARSER hid117,0);
}
static STATUS hid119 (PRECC_DATA* self) {
PARSER hid114, hid118;
return p_orparse0n (self,TOPARSER hid114,0,TOPARSER hid118,0);
}
STATUS stroke(PRECC_DATA* self) {
PARSER hid119;
P_RETURN((TOPARSER hid119)(self),"stroke");
}
P_END

/* or infix! ? */

P_BEGIN
static STATUS hid120 (PRECC_DATA* self) {
PARSER latex, infix;
return p_orparse0n (self,TOPARSER latex,0,TOPARSER infix,0);
}
static STATUS hid121 (PRECC_DATA* self) {
PARSER ident, hid120;
return p_orparse0n (self,TOPARSER ident,0,TOPARSER hid120,0);
}
STATUS word(PRECC_DATA* self) {
PARSER hid121;
P_RETURN((TOPARSER hid121)(self),"word");
}
P_END

P_BEGIN
static VOID hid122(PRECC_DATA* self) {
printf("%% line %d OK",(yylineno=z_l_line_number+=1));
}
static STATUS hid123(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid122;
return p_attach0n(self,TOPARSER p_nothing0,0,hid122,0);
}
static STATUS hid124(PRECC_DATA* self) {
PARSER p_last0, hid123;
return p_andparse0n (self,TOPARSER p_last0,0,TOPARSER hid123,0);
}
STATUS nl(PRECC_DATA* self) {
PARSER hid124;
P_RETURN((TOPARSER hid124)(self),"nl");
}
P_END

P_BEGIN
static STATUS hid125(PRECC_DATA* self,VALUE x) {
return p_test0(self,'1'<=(int)(TOVALUE x)&&(int)(TOVALUE x)<='6');
}
static STATUS hid126(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (int)(TOVALUE x)-'0' );
}
static STATUS hid127(PRECC_DATA* self,VALUE x) {
PARSER hid125, hid126;
return p_andparse0n (self,TOPARSER hid125,P_SZ(1,1),x,TOPARSER hid126,P_SZ(1,1),x);
}
static STATUS hid128(PRECC_DATA* self) {
PARSER digit, hid127; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER digit)(self),(TOPARSER hid127)(self,x));
return p_tok;
}
STATUS priority(PRECC_DATA* self) {
PARSER hid128;
P_RETURN((TOPARSER hid128)(self),"priority");
}
P_END

/* this looks up in list with a little less stack-depth than linear search */

P_BEGIN
static STATUS hid129(PRECC_DATA* self,PARAM n,PARAM list) {
return p_test0(self,(int)n<=1);
}
static STATUS hid130(PRECC_DATA* self,PARAM n,PARAM list) {
PARSER hid129, key0;
return p_andparse0n (self,TOPARSER hid129,P_SZ(2,0),n,list,TOPARSER key0,P_SZ(1,0),*(char**)list);
}
static STATUS hid131(PRECC_DATA* self,PARAM n,PARAM list) {
return p_test0(self,(int)n>1);
}
static STATUS hid132 (PRECC_DATA* self,PARAM n,PARAM list) {
PARSER keys, keys;
return p_orparse0n (self,TOPARSER keys,P_SZ(2,0),(int)n/2,list,TOPARSER keys,P_SZ(2,0),(int)n-(int)n/2,(PARAM)((char**)list+(int)n/2));
}
static STATUS hid133(PRECC_DATA* self,PARAM n,PARAM list) {
PARSER hid131, hid132;
return p_andparse0n (self,TOPARSER hid131,P_SZ(2,0),n,list,TOPARSER hid132,P_SZ(2,0),n,list);
}
static STATUS hid134 (PRECC_DATA* self,PARAM n,PARAM list) {
PARSER hid130, hid133;
return p_orparse0n (self,TOPARSER hid130,P_SZ(2,0),n,list,TOPARSER hid133,P_SZ(2,0),n,list);
}
STATUS keys(PRECC_DATA* self,PARAM n,PARAM list) {
PARSER hid134;
P_RETURN((TOPARSER hid134)(self,n,list),"keys");
}
P_END

char* keylist[]  =
{
"Delta",
"Xi",
"IF",
"THEN",
"ELSE",
"LET",
"also",
"begin",
"bsup",
"cross", /*added - ptb */
"end",
"esup",
"exists",
"forall",
"defs",
"hide",
"iff",
"implies",
"in",
"inrel",
"lambda",
"land",
"langle",
"lbag",
"ldata,"
"limg",  /* 26 */
"lnot",
"lor",
"mu",
"pipe",
"power",
"pre",
"project",
"rangle",
"rbag",
"rdata",
"rimg",
"semi",
"theta",
"where",
"begin", /* two additions of mine - ptb */
"end",
""       /* 43 */
};

P_BEGIN
STATUS keyword(PRECC_DATA* self) {
PARSER keys;
P_RETURN((TOPARSER keys)(self,(PARAM)42,(PARAM)keylist),"keyword");
}
P_END

# define MAXWORDS 2048

extern int ukey(char *, long);

static char c[2];

P_BEGIN
static STATUS hid135 (PRECC_DATA* self) {
PARSER key, key;
return p_orparse0n (self,TOPARSER key,P_SZ(1,0),"schema",TOPARSER key,P_SZ(1,0),"gendef");
}
static STATUS hid136 (PRECC_DATA* self) {
PARSER key, hid135;
return p_orparse0n (self,TOPARSER key,P_SZ(1,0),"axdef",TOPARSER hid135,0);
}
static STATUS hid137 (PRECC_DATA* self) {
PARSER key, hid136;
return p_orparse0n (self,TOPARSER key,P_SZ(1,0),"zed",TOPARSER hid136,0);
}
static STATUS hid138(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid137;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid137,0);
}
static STATUS hid139(PRECC_DATA* self) {
PARSER key, hid138;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\begin",TOPARSER hid138,0);
}
static STATUS hid140(PRECC_DATA* self) {
PARSER hid139;
return p_option0n(self,TOPARSER hid139,0);
}
static STATUS hid141(PRECC_DATA* self) {
return p_notexactly0(self,/*]>'%'<[*/'}');
}
static VOID hid142(PRECC_DATA* self,VALUE x) {
 c[0]=(int)(TOVALUE x);output(c); 
}
static STATUS hid143(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid142;
return p_attach0n(self,TOPARSER p_nothing0,0,hid142,P_SZ(1,1),x);
}
static STATUS hid144(PRECC_DATA* self) {
PARSER hid141, hid143; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER hid141)(self),(TOPARSER hid143)(self,x));
return p_tok;
}
static STATUS hid145(PRECC_DATA* self) {
PARSER hid140, hid144;
return p_andparse0n (self,TOPARSER hid140,0,TOPARSER hid144,0);
}
static STATUS hid146(PRECC_DATA* self) {
return p_exactly0(self,'}');
}
static VOID hid147(PRECC_DATA* self) {
 output("}"); 
}
static STATUS hid148(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid147;
return p_attach0n(self,TOPARSER p_nothing0,0,hid147,0);
}
static STATUS hid149(PRECC_DATA* self) {
PARSER hid146, hid148;
return p_andparse0n (self,TOPARSER hid146,0,TOPARSER hid148,0);
}
static STATUS hid150 (PRECC_DATA* self) {
PARSER hid149, ws;
return p_orparse0n (self,TOPARSER hid149,0,TOPARSER ws,0);
}
static STATUS hid151 (PRECC_DATA* self) {
PARSER hid145, hid150;
return p_orparse0n (self,TOPARSER hid145,0,TOPARSER hid150,0);
}
static STATUS hid152(PRECC_DATA* self) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid153(PRECC_DATA* self) {
PARSER hid151, hid152;
return p_andparse0n (self,TOPARSER hid151,0,TOPARSER hid152,0);
}
STATUS L_COMMENTCHAR(PRECC_DATA* self) {
PARSER hid153;
P_RETURN((TOPARSER hid153)(self),"L_COMMENTCHAR");
}
P_END

P_BEGIN
static STATUS hid154(PRECC_DATA* self) {
return p_atch0(self,/* VALUE */ pstr );
}
STATUS dummy(PRECC_DATA* self) {
PARSER hid154;
P_RETURN((TOPARSER hid154)(self),"dummy");
}
P_END

P_BEGIN
static STATUS hid155(PRECC_DATA* self,PARAM p,VALUE begin,VALUE end) {
return p_atch0(self,/* VALUE */ ukey((TOVALUE begin),(long)(TOVALUE end)-(long)(TOVALUE begin)) );
}
static STATUS hid156(PRECC_DATA* self,PARAM p,VALUE begin) {
PARSER dummy, hid155; VALUE end;
static STATUS p_tok;
P_PSTAR(end,(TOPARSER dummy)(self),(TOPARSER hid155)(self,p,begin,end));
return p_tok;
}
static STATUS hid157(PRECC_DATA* self,PARAM p,VALUE begin) {
PARSER hid156;
return p_andparse0n (self,TOPARSER p,0,TOPARSER hid156,P_SZ(2,1),p,begin);
}
static STATUS hid158(PRECC_DATA* self,PARAM p) {
PARSER dummy, hid157; VALUE begin;
static STATUS p_tok;
P_PSTAR(begin,(TOPARSER dummy)(self),(TOPARSER hid157)(self,p,begin));
return p_tok;
}
STATUS taken(PRECC_DATA* self,PARAM p) {
PARSER hid158;
P_RETURN((TOPARSER hid158)(self,p),"taken");
}
P_END

P_BEGIN
static STATUS hid159 (PRECC_DATA* self) {
PARSER key, key;
return p_orparse0n (self,TOPARSER key,P_SZ(1,0),"\\Delta",TOPARSER key,P_SZ(1,0),"\\Xi");
}
static STATUS hid160(PRECC_DATA* self) {
PARSER hid159;
return p_option0n(self,TOPARSER hid159,0);
}
static VOID hid161(PRECC_DATA* self,VALUE x) {
 output("<WORD>"); 
}
static STATUS hid162(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid161;
return p_attach0n(self,TOPARSER p_nothing0,0,hid161,P_SZ(1,1),x);
}
static STATUS hid163(PRECC_DATA* self,VALUE x) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid164(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid165(PRECC_DATA* self,VALUE x) {
PARSER hid163, hid164;
return p_andparse0n (self,TOPARSER hid163,P_SZ(1,1),x,TOPARSER hid164,P_SZ(1,1),x);
}
static STATUS hid166(PRECC_DATA* self,VALUE x) {
PARSER hid162, hid165;
return p_andparse0n (self,TOPARSER hid162,P_SZ(1,1),x,TOPARSER hid165,P_SZ(1,1),x);
}
static STATUS hid167(PRECC_DATA* self) {
PARSER taken, hid166; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER taken)(self,word),(TOPARSER hid166)(self,x));
return p_tok;
}
static STATUS hid168(PRECC_DATA* self) {
PARSER hid160, hid167;
return p_andparse0n (self,TOPARSER hid160,0,TOPARSER hid167,0);
}
STATUS L_WORD(PRECC_DATA* self) {
PARSER hid168;
P_RETURN((TOPARSER hid168)(self),"L_WORD");
}
P_END

P_BEGIN
static VOID hid169(PRECC_DATA* self,VALUE x) {
 output("<STROKE>"); 
}
static STATUS hid170(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid169;
return p_attach0n(self,TOPARSER p_nothing0,0,hid169,P_SZ(1,1),x);
}
static STATUS hid171(PRECC_DATA* self,VALUE x) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid172(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid173(PRECC_DATA* self,VALUE x) {
PARSER hid171, hid172;
return p_andparse0n (self,TOPARSER hid171,P_SZ(1,1),x,TOPARSER hid172,P_SZ(1,1),x);
}
static STATUS hid174(PRECC_DATA* self,VALUE x) {
PARSER hid170, hid173;
return p_andparse0n (self,TOPARSER hid170,P_SZ(1,1),x,TOPARSER hid173,P_SZ(1,1),x);
}
static STATUS hid175(PRECC_DATA* self) {
PARSER taken, hid174; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER taken)(self,stroke),(TOPARSER hid174)(self,x));
return p_tok;
}
STATUS L_STROKE(PRECC_DATA* self) {
PARSER hid175;
P_RETURN((TOPARSER hid175)(self),"L_STROKE");
}
P_END

P_BEGIN
static VOID hid176(PRECC_DATA* self,VALUE x) {
 output("<INFIX>"); 
}
static STATUS hid177(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid176;
return p_attach0n(self,TOPARSER p_nothing0,0,hid176,P_SZ(1,1),x);
}
static STATUS hid178(PRECC_DATA* self,VALUE x) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid179(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid180(PRECC_DATA* self,VALUE x) {
PARSER hid178, hid179;
return p_andparse0n (self,TOPARSER hid178,P_SZ(1,1),x,TOPARSER hid179,P_SZ(1,1),x);
}
static STATUS hid181(PRECC_DATA* self,VALUE x) {
PARSER hid177, hid180;
return p_andparse0n (self,TOPARSER hid177,P_SZ(1,1),x,TOPARSER hid180,P_SZ(1,1),x);
}
static STATUS hid182(PRECC_DATA* self) {
PARSER taken, hid181; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER taken)(self,infix),(TOPARSER hid181)(self,x));
return p_tok;
}
STATUS L_INFIX(PRECC_DATA* self) {
PARSER hid182;
P_RETURN((TOPARSER hid182)(self),"L_INFIX");
}
P_END

P_BEGIN
static VOID hid183(PRECC_DATA* self,VALUE x) {
 output("<NUMBER>"); 
}
static STATUS hid184(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid183;
return p_attach0n(self,TOPARSER p_nothing0,0,hid183,P_SZ(1,1),x);
}
static STATUS hid185(PRECC_DATA* self,VALUE x) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid186(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid187(PRECC_DATA* self,VALUE x) {
PARSER hid185, hid186;
return p_andparse0n (self,TOPARSER hid185,P_SZ(1,1),x,TOPARSER hid186,P_SZ(1,1),x);
}
static STATUS hid188(PRECC_DATA* self,VALUE x) {
PARSER hid184, hid187;
return p_andparse0n (self,TOPARSER hid184,P_SZ(1,1),x,TOPARSER hid187,P_SZ(1,1),x);
}
static STATUS hid189(PRECC_DATA* self) {
PARSER taken, hid188; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER taken)(self,number),(TOPARSER hid188)(self,x));
return p_tok;
}
STATUS L_NUMBER(PRECC_DATA* self) {
PARSER hid189;
P_RETURN((TOPARSER hid189)(self),"L_NUMBER");
}
P_END

P_BEGIN
static VOID hid190(PRECC_DATA* self,VALUE x) {
 output("<PRIORITY>");
}
static STATUS hid191(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid190;
return p_attach0n(self,TOPARSER p_nothing0,0,hid190,P_SZ(1,1),x);
}
static STATUS hid192(PRECC_DATA* self,VALUE x) {
PARSER ws1;
return p_many0n(self,TOPARSER ws1,0);
}
static STATUS hid193(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid194(PRECC_DATA* self,VALUE x) {
PARSER hid192, hid193;
return p_andparse0n (self,TOPARSER hid192,P_SZ(1,1),x,TOPARSER hid193,P_SZ(1,1),x);
}
static STATUS hid195(PRECC_DATA* self,VALUE x) {
PARSER hid191, hid194;
return p_andparse0n (self,TOPARSER hid191,P_SZ(1,1),x,TOPARSER hid194,P_SZ(1,1),x);
}
static STATUS hid196(PRECC_DATA* self) {
PARSER priority, hid195; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER priority)(self),(TOPARSER hid195)(self,x));
return p_tok;
}
STATUS L_PRIORITY(PRECC_DATA* self) {
PARSER hid196;
P_RETURN((TOPARSER hid196)(self),"L_PRIORITY");
}
P_END

P_BEGIN
static VOID hid197(PRECC_DATA* self,VALUE x) {
 output("<SYMBOL>"); 
}
static STATUS hid198(PRECC_DATA* self,VALUE x) {
PARSER p_nothing0;ACTION hid197;
return p_attach0n(self,TOPARSER p_nothing0,0,hid197,P_SZ(1,1),x);
}
static STATUS hid199(PRECC_DATA* self,VALUE x) {
PARSER ws1;
return p_many0n(self,TOPARSER ws1,0);
}
static STATUS hid200(PRECC_DATA* self,VALUE x) {
return p_atch0(self,/* VALUE */ (TOVALUE x) );
}
static STATUS hid201(PRECC_DATA* self,VALUE x) {
PARSER hid199, hid200;
return p_andparse0n (self,TOPARSER hid199,P_SZ(1,1),x,TOPARSER hid200,P_SZ(1,1),x);
}
static STATUS hid202(PRECC_DATA* self,VALUE x) {
PARSER hid198, hid201;
return p_andparse0n (self,TOPARSER hid198,P_SZ(1,1),x,TOPARSER hid201,P_SZ(1,1),x);
}
static STATUS hid203(PRECC_DATA* self) {
PARSER taken, hid202; VALUE x;
static STATUS p_tok;
P_PSTAR(x,(TOPARSER taken)(self,word),(TOPARSER hid202)(self,x));
return p_tok;
}
STATUS L_SYMBOL(PRECC_DATA* self) {
PARSER hid203;
P_RETURN((TOPARSER hid203)(self),"L_SYMBOL");
}
P_END

P_BEGIN
static VOID hid204(PRECC_DATA* self) {
 output("\n"); 
}
static STATUS hid205(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid204;
return p_attach0n(self,TOPARSER p_nothing0,0,hid204,0);
}
static STATUS hid206(PRECC_DATA* self) {
PARSER ws;
return p_many0n(self,TOPARSER ws,0);
}
static STATUS hid207(PRECC_DATA* self) {
PARSER hid205, hid206;
return p_andparse0n (self,TOPARSER hid205,0,TOPARSER hid206,0);
}
static STATUS hid208(PRECC_DATA* self) {
PARSER nl, hid207;
return p_andparse0n (self,TOPARSER nl,0,TOPARSER hid207,0);
}
STATUS L_ENDLINE(PRECC_DATA* self) {
PARSER hid208;
P_RETURN((TOPARSER hid208)(self),"L_ENDLINE");
}
P_END

P_BEGIN
STATUS L_ELSE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\ELSE"),"L_ELSE");
}
P_END

P_BEGIN
STATUS L_IF(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\IF"),"L_IF");
}
P_END

P_BEGIN
STATUS L_LET(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\LET"),"L_LET");
}
P_END

P_BEGIN
STATUS L_THEN(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\THEN"),"L_THEN");
}
P_END

P_BEGIN
STATUS L_ALSO(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\also"),"L_ALSO");
}
P_END

P_BEGIN
static STATUS hid209(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"zed",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid210(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid209;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid209,0);
}
static STATUS hid211(PRECC_DATA* self) {
PARSER key, hid210;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\begin",TOPARSER hid210,0);
}
STATUS L_BEGIN_ZED(PRECC_DATA* self) {
PARSER hid211;
P_RETURN((TOPARSER hid211)(self),"L_BEGIN_ZED");
}
P_END

P_BEGIN
static STATUS hid212(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"axdef",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid213(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid212;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid212,0);
}
static STATUS hid214(PRECC_DATA* self) {
PARSER key, hid213;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\begin",TOPARSER hid213,0);
}
STATUS L_BEGIN_AXDEF(PRECC_DATA* self) {
PARSER hid214;
P_RETURN((TOPARSER hid214)(self),"L_BEGIN_AXDEF");
}
P_END

P_BEGIN
static STATUS hid215(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"schema",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid216(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid215;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid215,0);
}
static STATUS hid217(PRECC_DATA* self) {
PARSER key, hid216;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\begin",TOPARSER hid216,0);
}
STATUS L_BEGIN_SCHEMA(PRECC_DATA* self) {
PARSER hid217;
P_RETURN((TOPARSER hid217)(self),"L_BEGIN_SCHEMA");
}
P_END

P_BEGIN
static STATUS hid218(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"gendef",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid219(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid218;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid218,0);
}
static STATUS hid220(PRECC_DATA* self) {
PARSER key, hid219;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\begin",TOPARSER hid219,0);
}
STATUS L_BEGIN_GENDEF(PRECC_DATA* self) {
PARSER hid220;
P_RETURN((TOPARSER hid220)(self),"L_BEGIN_GENDEF");
}
P_END

P_BEGIN
STATUS L_BSUP(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\bsup"),"L_BSUP");
}
P_END

P_BEGIN
STATUS L_CROSS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\cross"),"L_CROSS");
}
P_END

P_BEGIN
static STATUS hid221(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"zed",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid222(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid221;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid221,0);
}
static STATUS hid223(PRECC_DATA* self) {
PARSER key, hid222;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\end",TOPARSER hid222,0);
}
STATUS L_END_ZED(PRECC_DATA* self) {
PARSER hid223;
P_RETURN((TOPARSER hid223)(self),"L_END_ZED");
}
P_END

P_BEGIN
static STATUS hid224(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"axdef",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid225(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid224;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid224,0);
}
static STATUS hid226(PRECC_DATA* self) {
PARSER key, hid225;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\end",TOPARSER hid225,0);
}
STATUS L_END_AXDEF(PRECC_DATA* self) {
PARSER hid226;
P_RETURN((TOPARSER hid226)(self),"L_END_AXDEF");
}
P_END

P_BEGIN
static STATUS hid227(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"schema",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid228(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid227;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid227,0);
}
static STATUS hid229(PRECC_DATA* self) {
PARSER key, hid228;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\end",TOPARSER hid228,0);
}
STATUS L_END_SCHEMA(PRECC_DATA* self) {
PARSER hid229;
P_RETURN((TOPARSER hid229)(self),"L_END_SCHEMA");
}
P_END

P_BEGIN
static STATUS hid230(PRECC_DATA* self) {
PARSER key, L_CLOSEBRACE;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"gendef",TOPARSER L_CLOSEBRACE,0);
}
static STATUS hid231(PRECC_DATA* self) {
PARSER L_OPENBRACE, hid230;
return p_andparse0n (self,TOPARSER L_OPENBRACE,0,TOPARSER hid230,0);
}
static STATUS hid232(PRECC_DATA* self) {
PARSER key, hid231;
return p_andparse0n (self,TOPARSER key,P_SZ(1,0),"\\end",TOPARSER hid231,0);
}
STATUS L_END_GENDEF(PRECC_DATA* self) {
PARSER hid232;
P_RETURN((TOPARSER hid232)(self),"L_END_GENDEF");
}
P_END

P_BEGIN
STATUS L_ESUP(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\esup"),"L_ESUP");
}
P_END

P_BEGIN
STATUS L_EXISTS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\exists"),"L_EXISTS");
}
P_END

P_BEGIN
STATUS L_EXISTS_1(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\exists_1"),"L_EXISTS_1");
}
P_END

P_BEGIN
STATUS L_FORALL(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\forall"),"L_FORALL");
}
P_END

P_BEGIN
STATUS L_DEFS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\defs"),"L_DEFS");
}
P_END

P_BEGIN
STATUS L_HIDE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\hide"),"L_HIDE");
}
P_END

P_BEGIN
STATUS L_IFF(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\iff"),"L_IFF");
}
P_END

P_BEGIN
STATUS L_IMPLIES(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\implies"),"L_IMPLIES");
}
P_END

P_BEGIN
STATUS L_IN(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\in"),"L_IN");
}
P_END

P_BEGIN
STATUS L_INREL(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\inrel"),"L_INREL");
}
P_END

P_BEGIN
STATUS L_LAMBDA(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\lambda"),"L_LAMBDA");
}
P_END

P_BEGIN
STATUS L_LAND(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\land"),"L_LAND");
}
P_END

P_BEGIN
STATUS L_LANGLE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\langle"),"L_LANGLE");
}
P_END

P_BEGIN
STATUS L_LBAG(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\lbag"),"L_LBAG");
}
P_END

P_BEGIN
STATUS L_LDATA(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\ldata"),"L_LDATA");
}
P_END

P_BEGIN
STATUS L_LIMG(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\limg"),"L_LIMG");
}
P_END

P_BEGIN
STATUS L_LNOT(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\lnot"),"L_LNOT");
}
P_END

P_BEGIN
STATUS L_LOR(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\lor"),"L_LOR");
}
P_END

P_BEGIN
STATUS L_MU(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\mu"),"L_MU");
}
P_END

P_BEGIN
STATUS L_PIPE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\pipe"),"L_PIPE");
}
P_END

P_BEGIN
STATUS L_POWER(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\power"),"L_POWER");
}
P_END

P_BEGIN
STATUS L_PRE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\pre"),"L_PRE");
}
P_END

P_BEGIN
STATUS L_PROJECT(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\project"),"L_PROJECT");
}
P_END

P_BEGIN
STATUS L_RANGLE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\rangle"),"L_RANGLE");
}
P_END

P_BEGIN
STATUS L_RBAG(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\rbag"),"L_RBAG");
}
P_END

P_BEGIN
STATUS L_RDATA(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\rdata"),"L_RDATA");
}
P_END

P_BEGIN
STATUS L_RIMG(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\rimg"),"L_RIMG");
}
P_END

P_BEGIN
STATUS L_SEMI(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\semi"),"L_SEMI");
}
P_END

P_BEGIN
STATUS L_THETA(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\theta"),"L_THETA");
}
P_END

P_BEGIN
STATUS L_WHERE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\where"),"L_WHERE");
}
P_END

P_BEGIN
STATUS L_TRUE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"true"),"L_TRUE");
}
P_END

P_BEGIN
STATUS L_FALSE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"false"),"L_FALSE");
}
P_END

P_BEGIN
STATUS L_VERT(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"|"),"L_VERT");
}
P_END

P_BEGIN
STATUS L_HYPHEN(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"-"),"L_HYPHEN");
}
P_END

P_BEGIN
STATUS L_POINT(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"."),"L_POINT");
}
P_END

P_BEGIN
STATUS L_OPENBRACKET(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"["),"L_OPENBRACKET");
}
P_END

P_BEGIN
STATUS L_CLOSEBRACKET(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"]"),"L_CLOSEBRACKET");
}
P_END

P_BEGIN
STATUS L_OPENBRACE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"{"),"L_OPENBRACE");
}
P_END

P_BEGIN
STATUS L_CLOSEBRACE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"}"),"L_CLOSEBRACE");
}
P_END

P_BEGIN
STATUS L_OPENPAREN(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"("),"L_OPENPAREN");
}
P_END

P_BEGIN
STATUS L_CLOSEPAREN(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,")"),"L_CLOSEPAREN");
}
P_END

P_BEGIN
STATUS L_OPENSET(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\{"),"L_OPENSET");
}
P_END

P_BEGIN
STATUS L_CLOSESET(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\}"),"L_CLOSESET");
}
P_END

P_BEGIN
STATUS L_UNDERSCORE(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\_"),"L_UNDERSCORE");
}
P_END

P_BEGIN
STATUS L_COMMA(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,","),"L_COMMA");
}
P_END

P_BEGIN
STATUS L_EQUALS_EQUALS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"=="),"L_EQUALS_EQUALS");
}
P_END

P_BEGIN
STATUS L_COLON_COLON_EQUALS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"::="),"L_COLON_COLON_EQUALS");
}
P_END

P_BEGIN
STATUS L_SEMICOLON(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,";"),"L_SEMICOLON");
}
P_END

P_BEGIN
STATUS L_COLON(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,":"),"L_COLON");
}
P_END

P_BEGIN
STATUS L_BACKSLASH_BACKSLASH(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"\\\\"),"L_BACKSLASH_BACKSLASH");
}
P_END

P_BEGIN
STATUS L_AT(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"@"),"L_AT");
}
P_END

P_BEGIN
STATUS L_SLASH(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"/"),"L_SLASH");
}
P_END

P_BEGIN
STATUS L_EQUALS(PRECC_DATA* self) {
PARSER key;
P_RETURN((TOPARSER key)(self,"="),"L_EQUALS");
}
P_END

P_BEGIN
static STATUS hid233(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%inop");
}
STATUS L_PERCENT_PERCENT_INOP(PRECC_DATA* self) {
PARSER hid233;
P_RETURN((TOPARSER hid233)(self),"L_PERCENT_PERCENT_INOP");
}
P_END

P_BEGIN
static STATUS hid234(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%postop");
}
STATUS L_PERCENT_PERCENT_POSTOP(PRECC_DATA* self) {
PARSER hid234;
P_RETURN((TOPARSER hid234)(self),"L_PERCENT_PERCENT_POSTOP");
}
P_END

P_BEGIN
static STATUS hid235(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%inrel");
}
STATUS L_PERCENT_PERCENT_INREL(PRECC_DATA* self) {
PARSER hid235;
P_RETURN((TOPARSER hid235)(self),"L_PERCENT_PERCENT_INREL");
}
P_END

P_BEGIN
static STATUS hid236(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%prerel");
}
STATUS L_PERCENT_PERCENT_PREREL(PRECC_DATA* self) {
PARSER hid236;
P_RETURN((TOPARSER hid236)(self),"L_PERCENT_PERCENT_PREREL");
}
P_END

P_BEGIN
static STATUS hid237(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%ingen");
}
STATUS L_PERCENT_PERCENT_INGEN(PRECC_DATA* self) {
PARSER hid237;
P_RETURN((TOPARSER hid237)(self),"L_PERCENT_PERCENT_INGEN");
}
P_END

P_BEGIN
static STATUS hid238(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%pregen");
}
STATUS L_PERCENT_PERCENT_PREGEN(PRECC_DATA* self) {
PARSER hid238;
P_RETURN((TOPARSER hid238)(self),"L_PERCENT_PERCENT_PREGEN");
}
P_END

P_BEGIN
static STATUS hid239(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%ignore");
}
STATUS L_PERCENT_PERCENT_IGNORE(PRECC_DATA* self) {
PARSER hid239;
P_RETURN((TOPARSER hid239)(self),"L_PERCENT_PERCENT_IGNORE");
}
P_END

P_BEGIN
static STATUS hid240(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%unchecked");
}
STATUS L_PERCENT_PERCENT_UNCHECKED(PRECC_DATA* self) {
PARSER hid240;
P_RETURN((TOPARSER hid240)(self),"L_PERCENT_PERCENT_UNCHECKED");
}
P_END

P_BEGIN
static STATUS hid241(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%tame");
}
STATUS L_PERCENT_PERCENT_TAME(PRECC_DATA* self) {
PARSER hid241;
P_RETURN((TOPARSER hid241)(self),"L_PERCENT_PERCENT_TAME");
}
P_END

P_BEGIN
static STATUS hid242(PRECC_DATA* self) {
PARSER p_first0, key1;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER key1,P_SZ(1,0),"%%token");
}
STATUS L_PERCENT_PERCENT_TOKEN(PRECC_DATA* self) {
PARSER hid242;
P_RETURN((TOPARSER hid242)(self),"L_PERCENT_PERCENT_TOKEN");
}
P_END






static void z_l_echo ()
{
    if (z_l_display_lexemes)
    {
        /*ECHO;*/
        putc('\n', stdout);
    }
}



static void z_l_invalid_lexeme (char *lexeme)
{
    fprintf(stderr,
            "z 2 lexer: line %d: invalid lexeme\n",
            z_l_line_number);
}



void z_l_initialise ()
{
    z_l_display_lexemes= 0;
    z_l_line_number= 0;
}



