# define BEGIN begin(p_argc,p_argv)
# define DEBUG
# define PARAM char*
/*# define VALUE char**/
# include "ccx.h"


int begin(int argc,char **argv)
{
        static int passes; /* no. of times re-entered MAIN */

        if(passes++==0)
        {
            dup2(0,5);  /* save stdin and stdout */
            dup2(1,6);
            switch(argc)
            {
            case 3:
                    if (freopen(argv[2], "w", stdout)==NULL)
                      exit (2);
            case 2:
                    if (freopen(argv[1], "r", stdin)==NULL)
                      exit (5);
            case 1: break;
            default: exit(6);/* too many files named */
            }
        }
        return 0;                /* success */
}

@ Specification = ws* { Paragraph !}*

@ Paragraph     = Unboxed_Para 
@               | Axiomatic_Box
@               | Schema_Box
@               | Generic_Box
@               | Directive
@               | Comment

static int nsymbol;         /* local buffer for symbols in directives */
static int symbol[32];

extern void         add_inops  (int *ss, int sn, int p);
extern void         add_postops(int *ss, int sn);
extern void         add_inrels (int *ss, int sn);
extern void         add_prerels(int *ss, int sn);
extern void         add_ingens(int *ss, int sn);
extern void         add_pregens(int *ss, int sn);
extern void         add_ignores(int *ss, int sn);
extern void         add_tokens(int *ss, int sn);

@ Directive     = L_PERCENT_PERCENT_INOP   Symbols Priority\p L_ENDLINE
@                   {: add_inops(symbol,nsymbol,(int)$p); :} !
@               | L_PERCENT_PERCENT_POSTOP Symbols L_ENDLINE
@                   {: add_postops(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_INREL  Symbols L_ENDLINE
@                   {: add_inrels(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_PREREL Symbols L_ENDLINE
@                   {: add_prerels(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_INGEN  Symbols L_ENDLINE
@                   {: add_ingens(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_PREGEN Symbols L_ENDLINE
@                   {: add_pregens(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_IGNORE Symbols L_ENDLINE
@                   {: add_ignores(symbol,nsymbol); :} !
@               | L_PERCENT_PERCENT_UNCHECKED Symbols L_ENDLINE
@               | L_PERCENT_PERCENT_TAME   Symbols L_ENDLINE
@               | L_PERCENT_PERCENT_TOKEN  Symbols L_ENDLINE

/* let this be * instead of + */

@ Symbols       = {: nsymbol=0; :} {Symbol\x {: symbol[nsymbol++]=(int)$x; :} }*

/* symbols can't have new lines in */

@ Symbol        = L_SYMBOL

@ Priority      = L_PRIORITY

@ Comment       = L_COMMENTCHAR+

@ Unboxed_Para  = L_BEGIN_ZED
@                     Item {Sep Item}*
@                 L_END_ZED

@ Item          = L_OPENBRACKET Ident {L_COMMA Ident}* L_CLOSEBRACKET
@               | Schema_Name [ Gen_Formals ] L_DEFS Schema_Exp
@               | Def_Lhs L_EQUALS_EQUALS Expression
@               | Ident L_COLON_COLON_EQUALS Branch {L_VERT Branch}*
@               | Predicate

/* making the Decl_Part execute pending actions so that the decls we just did
   can be seen */

@ Axiomatic_Box = L_BEGIN_AXDEF
@                     Decl_Part
@               [ L_WHERE 
@                     Axiom_Part ]
@                 L_END_AXDEF

@ Schema_Box    = L_BEGIN_SCHEMA L_OPENBRACE Schema_Name L_CLOSEBRACE [Gen_Formals]
@                     Decl_Part 
@               [ L_WHERE
@                     Axiom_Part ]
@                 L_END_SCHEMA

@ Generic_Box   = L_BEGIN_GENDEF [Gen_Formals]
@                     Decl_Part
@               [ L_WHERE
@                     Axiom_Part ]
@                 L_END_GENDEF


@ Decl_Part     = Basic_Decl {Sep Basic_Decl}*

@ Axiom_Part    = Predicate {Sep Predicate}*

@ Sep           = L_SEMICOLON | L_BACKSLASH_BACKSLASH | L_ALSO

/* I hope these next are distinguishable syntactically */

@ Def_Lhs       = Var_Name [ Gen_Formals ]
@               | Pre_Gen Ident
@               | Ident In_Gen Ident

/* I've changed the order here, in case I can't distinguish Var_Name and Ident
**/

@ Branch        = Var_Name L_LDATA Expression L_RDATA
@               | Ident

/* the next is in inefficient form - but I'll stick to the text */

@ Schema_Exp    = L_FORALL Schema_Text L_AT Schema_Exp
@               | L_EXISTS Schema_Text L_AT Schema_Exp
@               | L_EXISTS_1 Schema_Text L_AT Schema_Exp
@               | Schema_Exp_1

/* I can't see any sense in distinguishing left and right associativity
** here since that's really something to be left to the build function.
** Therefore I've deviated wildly from the text. To make left assoc
** easier to build I've bundled all the stuff before a final left assoc op
** into a single list. To make right assoc easier to build, I've
** handled it recursively.
**/

/* here are the right assoc ops, on top, recursion and all */

@ Schema_Exp_1  = Schema_Exp_2 [ L_IMPLIES Schema_Exp_1 ]

/* now we look for a series of L_HIDES separated by left assoc ops */

@ Schema_Exp_2  = Schema_Exp_3
@                 { { L_LAND | L_LOR | L_IFF | L_PROJECT | L_SEMI | L_PIPE }
@                   Schema_Exp_3
@                 }*

/* and before a L_HIDE we expect a series separated by left assoc ops */

@ Schema_Exp_3  = Schema_Exp_U
@                 { { L_LAND | L_LOR | L_IFF | L_PROJECT | L_SEMI | L_PIPE }
@                    Schema_Exp_U
@                 }*
@                 { L_HIDE L_OPENPAREN Decl_Name {L_COMMA Decl_Name}* L_CLOSEPAREN }*

/* and these are definitely atomic */

@ Schema_Exp_U  = L_OPENBRACKET Schema_Text L_CLOSEBRACKET
@               | L_LNOT Schema_Exp_U
@               | L_PRE  Schema_Exp_U
@               | L_OPENPAREN Schema_Exp L_CLOSEPAREN
@               | Schema_Ref


@ Schema_Text   = Declaration [ L_VERT Predicate ]

@ Schema_Ref    = Schema_Name Decoration [ Gen_Actuals ] [ Renaming ]

@ Renaming      = L_OPENBRACKET
@                     Decl_Name L_SLASH Decl_Name
@                     { L_COMMA Decl_Name L_SLASH Decl_Name }*
@                 L_CLOSEBRACKET

@ Declaration   = Basic_Decl { L_SEMICOLON Basic_Decl }*

@ Basic_Decl    = Decl_Name { L_COMMA Decl_Name }* L_COLON Expression
@               | Schema_Ref

@ Predicate     = L_FORALL Schema_Text L_AT Predicate
@               | L_EXISTS Schema_Text L_AT Predicate
@               | L_EXISTS_1 Schema_Text L_AT Predicate
@               | L_LET Let_Def { L_SEMICOLON Let_Def }* L_AT Predicate
@               | Predicate_1

/* are L_TRUE and L_FALSE backslashed ? */

@ Predicate_1   = Predicate_2 [ L_IMPLIES Predicate_1 ]

@ Predicate_2   = Predicate_U
@                 { { L_LAND | L_LOR | L_IFF }
@                   Predicate_U
@                 }*

@ Predicate_U   = Expression { Rel Expression }*
@               | Pre_Rel Expression
@               | L_PRE Schema_Ref
@               | L_TRUE
@               | L_FALSE
@               | L_LNOT Predicate_1
@               | L_OPENPAREN Predicate L_CLOSEPAREN
@               | Schema_Ref

@ Rel           = L_EQUALS | L_IN | In_Rel
@               | L_INREL L_OPENBRACE Ident L_CLOSEBRACE

@ Let_Def       = Var_Name L_EQUALS_EQUALS Expression

@ Expression_0  = L_LAMBDA Schema_Text L_AT Expression
@               | L_MU Schema_Text [ L_AT Expression ]
@               | L_LET Let_Def { L_SEMICOLON Let_Def }* L_AT Expression
@               | Expression


@ Expression    = L_IF Predicate L_THEN Expression L_ELSE Expression
@               | Expression_1

/* generic expression with binding powers m (1:highest) to l (6:lowest) */

extern int level(int);

@ binex(u,s,l,m)= )l<m( u
@               | )l>=m(  binex(u,s,l-1,m)
@                         {s\x )level((int)x)==(int)l( binex(u,s,l-1,m)}*

PARSER Expression_1A, In_Gen;

@ Expression_1  = binex(Expression_1A,In_Gen,(PARAM)6,(PARAM)1)

@ Expression_1A = Expression_2 { L_CROSS Expression_2 }*

PARSER Expression_2A, In_Fun;

@ Expression_2  = binex(Expression_2A,In_Fun,(PARAM)6,(PARAM)1)

@ Expression_2A = L_POWER Expression_4
@               | Pre_Gen Expression_4
@               | L_HYPHEN Decoration Expression_4
@               | Expression_4 L_LIMG Expression_0 L_RIMG Decoration
@               | Expression_3

@ Expression_3  = Expression_4+

/* I'm breaking up expression_4 to catch the postops */

@ Expression_4  = Expression_4A [ L_POINT Var_Name
@                               | Post_Fun 
@                               | L_BSUP Expression L_ESUP
@                               ]

/* I introduce a list of expressions, for brevity */

@ Expressions   = Expression { L_COMMA Expression }*

/* Do we want infixes etc. as Var_Name? */

@ Expression_4A = Var_Name [ Gen_Actuals ]
@               | Number
@               | Set_Exp
@               | L_LANGLE [ Expressions ] L_RANGLE
@               | Expression_4B

/* try without brackets around lambdas and so on */

@ Expression_4B = L_OPENPAREN Expressions L_CLOSEPAREN
@               | L_LBAG   [ Expressions ] L_RBAG     /* ??? */
@               | L_THETA Schema_Name Decoration [ Renaming ]
@               | L_OPENPAREN Expression_0 L_CLOSEPAREN
@               | Schema_Ref

@ Set_Exp       = L_OPENSET [ Expressions ] L_CLOSESET
@               | L_OPENSET Schema_Text [ L_AT Expression ] L_CLOSESET

/* FIX ME: Ident could be changed to avoid picking up registered keywords
 * as Var_Name with Expression_4A. Or the check can be in Expression_4A.
 */

@ Ident         = L_WORD Decoration

@ Decl_Name     = Op_Name | Ident

@ Var_Name      = L_OPENPAREN Op_Name L_CLOSEPAREN | Ident

@ Op_Name       = L_UNDERSCORE In_Sym L_UNDERSCORE
@               | Pre_Sym L_UNDERSCORE
@               | L_UNDERSCORE Post_Sym 
@               | L_UNDERSCORE L_LIMG L_UNDERSCORE L_RIMG Decoration
@               | L_HYPHEN Decoration

@ In_Sym        = In_Fun | In_Gen | In_Rel

@ Pre_Sym       = Pre_Gen | Pre_Rel

@ Post_Sym      = Post_Fun

@ Decoration    = Stroke*

@ Gen_Formals   = L_OPENBRACKET Ident { L_COMMA Ident }* L_CLOSEBRACKET

@ Gen_Actuals   = L_OPENBRACKET Expression { L_COMMA Expression }* L_CLOSEBRACKET

/* I am adding decorations in to the basics here, as they are never naked */

/* maybe only those things that have been registered can qualify here?  */

extern int          is_postop  (int x);
extern int          is_inrel   (int x);
extern int          is_ingen   (int x);
extern int          is_prerel  (int x);
extern int          is_pregen  (int x);
extern int          is_inop    (int x);
extern int          is_ignore  (int x);       

@ In_Fun        = L_WORD\x )is_inop((int)$x)( Decoration  {@ x @}

@ In_Gen        = L_WORD\x )is_ingen((int)$x)( Decoration  {@ x @}

@ In_Rel        = L_WORD\x )is_inrel((int)$x)( Decoration  {@ x @}

@ Pre_Gen       = L_WORD\x )is_pregen((int)$x)( Decoration  {@ x @}

@ Pre_Rel       = L_WORD\x )is_prerel((int)$x)( Decoration  {@ x @}

@ Post_Fun      = L_WORD\x )is_postop((int)$x)( Decoration  {@ x @}

@ Stroke        = L_STROKE

@ Schema_Name   = L_WORD

@ Number        = L_NUMBER

MAIN(Specification)
