
/* this next avoids warnings about implicitly declaring filbuf in
 * some installations, but it also shifts to functions from
 * macros, which may not be as fast unless your optimizer magics
 * it all away again.
 */

#undef getchar
#undef putchar
extern int getchar();
extern int putchar();

#include "ccx.h"

extern TOKEN *yybuffer;		/* hook into the cc.c file */

static int goteof;		/* EOF flag */
int yytchar;			/* the last char read */
static char lastc;		/* pushed back char */
static int lastcsemaphore;
int yylineno;			/* line count */
int yylen;			/* eventually, the length of the token we
				 * caught */
char *yylloc;			/* where the last token came from */
VALUE yylval;

int yylex()
/*
 * Just in case you don't have a lexer available.
 *
 * Read in characters into yybuffer up to the next  EOL, but ignore escaped
 * End-Of-Lines, then dole them out one at a time.
 *
 * Return 0!=token for a good read and 0=FAILURE when an EOF is encountered.
 *
 * I'm not quite doing things right here, since yylen actually represents the
 * size of the readahead buffer store (and doesn't decrease as I dole out
 * TOKENs), but yylloc does point to the last character out.
 *
 * I should have yylen as 1 always.
 */
{
    /* if we get an EOF not immediately after a LF, pretend we got a LF
     * (so the final line will be empty). */

    static char vline[READBUFFERSIZE];	/* virtual line buffer   */
    static int nvline;		/* remaining in virtual line */
    char *rline = (char *) vline;	/* pointer to real line  */
    static int nrline;		/* remaining in real line    */
    static union {
	int i;
	VALUE v;
    }
    yycast;			/* casting hack */

    if (NULL != yylloc)
	if (nvline > 0) {	/* we can use a token we read ahead for */
	    yylen = 1;
	    nvline--;
	    nrline--;		/* this is just for accounting - no
				 * purpose */
	    yytchar = *++yylloc;
	    yycast.i = yytchar;	/* handle the 'cast' via union */
	    yylval = yycast.v;
	    return yytchar;
	} else {

	    /* we ask for more TOKENS next time and return the EOL (0) now
	     * It'll be used to terminate a TOKEN string, but we don't
	     * know that. */

	    yylloc = NULL;
	    yylen = 0;
	    nvline = 0;
	    nrline = 0;		/* this is just for accounting - no
				 * purpose */
	    yycast.i = 0;	/* casting hack */
	    yylval = yycast.v;
	    return yytchar = 0;

	}
    /* now we have to load the readahead buff  */

    /* i.e. yyloc = vline - 1 for starters  */
    yylloc = rline - 1;		/* we will return a token at *rline ... */
    *rline = yytchar = 0;	/* ... but we start clean               */
    nvline = 0;			/* length of readahead buffer           */
    nrline = 0;			/* just for accounts - no purpose       */


    /* we're here because the readahead buffer was empty and so the
     * initialization conditions hold: yylloc=rline - 1, etc. */

    while (gets((char *) rline) != NULL) {

	yylineno++;

	nrline = (int) strlen((char *) rline);	/* count the booty */
	nvline += nrline;

	if (nrline == 0) {	/* we got a linefeed only */

	    if (nvline > 0) {
		yylen = 1;
		nvline--;
		yytchar = *++yylloc;
		yycast.i = yytchar;	/* casting hack */
		yylval = yycast.v;
		return yytchar;
	    }
	    yylen = 0;
	    yylloc = NULL;	/* signal to read ahead again next time
				 * round */
	    yycast.i = 0;	/* casting hack */
	    yylval = yycast.v;
	    return yytchar = 0;	/* return the 0 string terminator */
	}
	/* would allow escaped linefeeds */

	/* if (rline[nrline  - 1] == '\\') { * escaped newline, so .. *
	 * rline += --nrline ;    * .. we go round again * nvline--;
	 * continue; } */

	/* ordinary token return. just ... */
	/* ... crank our buffer */
	nvline--;
	yylen = 1;

	/* the absence of a reason to continue reading is a reason to
	 * cease reading ahead */

	yytchar = *++yylloc;
	yycast.i = yytchar;	/* casting hack */
	yylval = yycast.v;
	return yytchar;

    }				/* endwhile */

    /* we're here because gets() failed */
    goteof = 1;
    yytchar = EOF;		/* EOF encountered */
    yylloc = NULL;		/* signal that readahead buffer is empty */
    return 0;

}



int yyinput()
/* in case no lexer */
{
    if (goteof) {
	yytchar = EOF;
	return (0);
    }
    if (lastcsemaphore > 0) {	/* an unput char must be regot */
	lastcsemaphore = 0;
	return (yytchar = lastc);
    }
    /* lastcsemaphore == 0        so take a new character now */
    yytchar = getchar();
    if (yytchar == EOF)
	return (0);
    else
	return (yytchar);
}

void yyunput(int c)
/* in case no lexer */
{
    lastc = c;			/* stash char and set flag */
    lastcsemaphore++;
}

int yyoutput(int c)
/* in case no lexer */
{
    return (putchar(c));	/* straight stuff */
}

int yywrap()
/* makes us repeat parse attempts */
{
    return 1;
}
