# include "ccx.h"
# include "cobol-l.h"


	/* ------------ PROCEDURE DIVISION ------------------------ */

@procedure_division= <C_PROCEDURE> <C_DIVISION>
@                    stop
@                    procedure_div

@procedure_div    =  paragraphs sections

@sections         =  section*

@section          =  sectionhead
@	    			 stop
@	      			 paragraphs

@sectionhead      =  <C_SECTION> literal_iden

	/* there was a <label> somewhere here, ... */

@paragraphs       =  paragraph*

@paragraph        =  label
@	     			 stop
@	       			 [ cobol_code ]

@cobol_code       =  sentence
@                    stop
@                    [ cobol_code ]

static char *paranam;

@ label           = identifier(&paranam)               |
@	    			natnum_rep(&paranam)

@sentences        =   sentence+

@sentence         = perform_sentence                  |
@                   conditional_sentence              |
@                   atomic_sentence

@perform_sentence = <C_PERFORM> perform_part

@perform_part     = thru_part [ times_until_or_varying_part ]

@thru_part        = label [<C_THRU> label ]

@times_until_or_varying_part =
@                   {<C_TIMES>|<C_UNTIL>} cob_exp       |
@                    <C_VARYING> literal_iden
@                    <C_FROM> cob_exp
@                    <C_BY> cob_exp
@                    <C_UNTIL> condition

@conditional_sentence =
@                    <C_IF> condition sentences
@	       			 [ else_limb ]                     |
@                    <C_SEARCH> optional_all
@                             literal_iden [ at_end_part ]
@                    <C_WHEN> condition sentence

	/* Is this optional? */

@else_limb        =  <C_ELSE> sentences | skip

@atomic_sentence  =  atomic_sentenceA                    |
@	     			 atomic_sentenceB                    |
@	     			 atomic_sentenceC
		     
@atomic_sentenceA =  <C_STOP> <C_RUN>                    |
@                    <C_MOVE> cob_exp <C_TO> cob_exp     |
@                     skip                               |
@                    <C_ADD> add_sentence                |
@                    <C_COMPUTE> rounded_idlist <'='>
@						cob_exp [ on_size_error_part ]   |
@                    <C_SUBTRACT> subtract_sentence      |
@                    <C_DIVIDE> divide_sentence          |
@                    <C_GO> <C_TO> label                 |
@	     				<C_IF> condition
@							<C_GO> <C_TO> label       	 |
@	     				<C_ALTER> literal_iden
@						<C_TO> literal_iden              |
@	     				<C_READ> literal_iden
@						[ into_part | <C_NEXT>]
@						[ at_end_part ]

@atomic_sentenceB =  <C_WRITE> literal_iden
@	        		[ write_from_part ]
@						[ invalid_key_part]              |
@	     			<C_DELETE> literal_iden
@						[ invalid_key_part]              |
@	     			<C_RELEASE> literal_iden
@						[ write_from_part ]              |
@	     			<C_RETURN> literal_iden
@						[ into_part ] [ at_end_part ]    |
@	     			<C_REWRITE> literal_iden
@						[ write_from_part ]
@						[ invalid_key_part]              |
@	     			 <C_OPEN> open_instructions          |
@	     			 <C_CLOSE> open_idlist               |
@	     				<C_DISPLAY> disp_string
@						[ upon_part ]                    |
@	     			 <C_ACCEPT> literal_iden
@	        				[ accept_from_part ]
		     
@atomic_sentenceC =  <C_START> literal_iden
@						<C_KEY> [<C_IS>] cob_op cob_exp
@						[ invalid_key_part]              |
@	     			 <C_SET> literal_iden <C_TO> cob_exp |
@                    <C_INITIATE> literal_iden           |
@                    <C_TERMINATE> literal_iden          |
@                    <C_GENERATE> literal_iden           |
@                    <C_CALL> literal_iden
@						<C_USING> open_idlist            |
@                    <C_CANCEL> literal_iden

@skip             =  <C_NEXT> <C_SENTENCE> | <C_EXIT>

@disp_string      = literal_iden | string_const


	/* needs expansion */

@add_sentence     =   open_explist add_form literal_iden
@                     [ rounded_part ] [ on_size_error_part ]

@add_form         =  <C_GIVING> | <C_TO>

@optional_all     =  <C_ALL>

@subtract_sentence=   open_explist
@      				    literal_iden [ rounded_part ]
@                   	    [<C_GIVING> literal_iden
@ 				    	            [ rounded_part ]
@                           ] [ on_size_error_part ] 

@open_explist     = cob_exp+

	/* something missing */

@divide_sentence  =   div_remainder

@div_remainder    =   cob_exp <C_INTO> cob_exp
@						[ rounded_part ]
@                    	<C_GIVING> open_idlist
@        				[ on_size_error_part ]
@	      				cob_exp <C_BY> cob_exp
@	     				<C_GIVING> open_idlist
@                		[ on_size_error_part ]           |
@	      			cob_exp <C_INTO> open_idlist
@						[ rounded_part ]
@						[ on_size_error_part ]
                

	/* Just a set of words */

@condition        =    expression

@cob_exp          =    expression

@rounded_part     =   <C_ROUNDED>

@on_size_error_part = <C_ON> <C_SIZE> <C_ERROR> sentence

@at_end_part      =  <C_AT> <C_END> sentence

@write_from_part  =  <C_FROM> literal_iden

@accept_from_part =  <C_FROM> { literal_iden | <C_CONSOLE> }

@into_part        =  <C_INTO> literal_iden

@upon_part        =  <C_UPON> { literal_iden | <C_CONSOLE> }

@invalid_key_part =  <C_INVALID> <C_KEY> sentence

@open_instructions=  {
@                      open_mode
@                      open_idlist
@                    }*

@open_mode        = <C_INPUT>|<C_OUTPUT>|<C_EXTEND>|<C_I_O>

@open_idlist      =    literal_iden [ <','> open_idlist ]

	/* in <list> parsing - you can always eliminate such a clause */
	/* as 100 100 - 100100. */

@rounded_idlist   =   literal_iden [ [ rounded_part] rounded_idlist]


