# include "ccx.h"
# include "cobol-l.h"


	/* ------------ ENVIRONMENT DIVISION ------------------------ */

@environment_division =
@                    <C_ENVIRONMENT> <C_DIVISION>
@                    stop
@	      			 configuration_section
@	       			 input_output_section


typedef struct {
	char *source;
	char *object;
	} CONFIG;
static CONFIG config;

@configuration_section=
@	     			 <C_CONFIGURATION> <C_SECTION>
@	     			 stop
@	      			 source_computer
@	      			 object_computer
@	      			 special_names

@source_computer   = <C_SOURCE_COMPUTER>
@	     			 stop
@	      			 source_computer_name
@	      			 [ debugging_mode]
@	     			 stop

@debugging_mode    = [ <C_WITH> ] <C_DEBUGGING> <C_MODE>

@object_computer   = <C_OBJECT_COMPUTER>
@	     			 stop
@	      			 object_computer_name
@                                [ memory_size ]
@                                [ collating_sequence ]
@                                [ segment_limit ]
@	     			 stop

@memory_size       = <C_MEMORY> [ <C_SIZE> ] integer
@                    { <C_WORDS> | <C_CHARACTERS> | <C_MODULES> }

@collating_sequence= [<C_PROGRAM>] [<C_COLLATING>]
@                    <C_SEQUENCE>
@                    [<C_IS>] alphabet_name

@segment_limit     = <C_SEGMENT_LIMIT> [<C_IS>] segment_number

@special_names     = <C_SPECIAL_NAMES>
@                    stop
@                    [ function_special ]
@                    alphabet*
@                    [ currency_sign ]
@                    [ decimal_point ]
@                    stop

/* seems as though two stops with nothing between are possible! */

@ function_special = function_name function_designator

@ function_designator =
@                    <C_IS> mnemonic_name [ status_designator ]
@                  | status_designator


@ status_designator   = status_designator_a [ status_designator_b ]
@                     | status_designator_b [ status_designator_a ]

@status_designator_a  =
@                    <C_ON> [<C_STATUS>] <C_IS> condition_name_1

@status_designator_b  =
@                    <C_OFF> [<C_STATUS>] <C_IS> condition_name_2

@ alphabet            = alphabet_name_1 [<C_IS>] alphabet_option

@ alphabet_option     = <C_STANDARD_1>
@                     | <C_NATIVE>
@                     | alphabet_range+ 

@ alphabet_range      = literal_1 [ alphabet_range_delim ]

@ alphabet_range_delim= {<C_THROUGH> | <C_THRU>} literal_2
@                     | {<C_ALSO> literal_3 }+

@ currency_sign       = <C_CURRENCY> [<C_SIGN>] [<C_IS>] literal_6

@ decimal_point       = <C_DECIMAL_POINT> [<C_IS>] <C_COMMA>

/* the standard says no full-stop after i-o-section. Must be wrong? */

@input_output_section =
@                    <C_INPUT_OUTPUT> <C_SECTION>
@                    stop
@                     file_control
@                     [ io_control0 ]
@                     [ <C_I_O_CONTROL> stop ]
@                     io_control1*

@file_control     =  <C_FILE_CONTROL>
@                    stop
@                     file_control_entry+

	/*  can be several internal names for same external file  */


@file_control_entry=  sequential_file
@                  |  relative_file
@                  |  indexed_file


@sequential_file  =  <C_SELECT> [<C_OPTIONAL>]
@	     			 file_name_1
@                    <C_ASSIGN> [<C_TO>]
@	     			 file_assigned
@                    [ file_reserve_area ]
@                    [ seq_file_organization ]
@                    [ seq_file_access_mode ]
@                    [ file_status ]

@file_assigned    =  [<C_EXTERNAL>|<C_DYNAMIC>]
@                    file_or_device 
@                    { external_file_reference | data_name_1 | literal_1 }

@file_or_device   =  [ file_designator ] <C_FILE>
@                 |  <C_DISK>
@                 |  <C_KEYBOARD>
@                 |  <C_DISPLAY>
@                 |  <C_PRINTER>
@                 |  <C_PRINTER_1>

@file_designator  = <C_LINE> <C_ADVANCING>
@                 | <C_MULTIPLE> {<C_REEL>|<C_UNIT>}
@                 | [<C_DISK>]

/* reserve appears to be OK on its own */

@ file_reserve_area= <C_RESERVE> [integer_1] [<C_AREA>|<C_AREAS>]

@seq_file_organization=  <C_ORGANIZATION> [<C_IS>] <C_SEQUENTIAL>

@seq_file_access_mode=  <C_ACCESS> [<C_MODE>] [<C_IS>] <C_SEQUENTIAL>

@file_status      =  [<C_FILE>] <C_STATUS> [<C_IS>]
@	      			 data_name_2

@relative_file    =  <C_SELECT>  file_name_1
@                    <C_ASSIGN> [<C_TO>]
@                    [ file_reserve_area ]
@                    rel_file_organization
@                    [ rel_file_access_mode ]
@                    [ file_status ]

@rel_file_organization=  <C_ORGANIZATION> [<C_IS>] <C_RELATIVE>

@rel_file_access_mode=  <C_ACCESS> [<C_MODE>] [<C_IS>]
@                  { <C_SEQUENTIAL> [rel_file_key]
@                  | {<C_RANDOM>|<C_DYNAMIC>} rel_file_key
@                  }

@rel_file_key     =  <C_RELATIVE> [<C_KEY>] [<C_IS>] data_name_6

@indexed_file     =  <C_SELECT>  file_name_1
@                    <C_ASSIGN> [<C_TO>]
@                    [ file_reserve_area ]
@                    index_file_organization
@                    [ index_file_access_mode ]
@                    [ file_status ]
@                    [ file_io_count ]

@index_file_organization=  <C_ORGANIZATION> [<C_IS>] <C_INDEXED>

@index_file_access_mode=  <C_ACCESS> [<C_MODE>] [<C_IS>]
@                  { <C_SEQUENTIAL>
@                  | <C_RANDOM>
@                  | <C_DYNAMIC>
@                  }  index_file_record

@index_file_record = <C_RECORD> [<C_KEY>] [<C_IS>] data_name_6
@                    [ index_file_record_alt ]

@index_file_record_alt=
@                    <C_ALTERNATE> <C_RECORD> [<C_KEY>] [<C_IS>]
@                    data_name_10
@                    [ [<C_WITH>] <C_DUPLICATES> ]

@file_io_count     = <C_I_O> <C_COUNT> [<C_IS>] data_name_14

@io_control0       = <C_I_O> <C_CONTROL> stop
@                    io_rerun*
@                    io_same*
@                    io_multiple*

@io_rerun          = <C_RERUN> [ <C_ON> {file_name_1 | character_string} ]
@                    [<C_EVERY>] io_rerun_delim

@io_rerun_delim    = { <C_END> [<C_OF>] {<C_REEL>|<C_UNIT>}
@                    | integer_1 <C_RECORDS>
@                    } [<C_OF>] file_name_2
@                  | integer_2 <C_CLOCK_UNITS>
@                  | condition_name

@io_same           = <C_SAME> [<C_RECORD>] [<C_AREA>] [<C_FOR>]
@                    file_name_3 file_name_4+

@io_multiple       = <C_MULTIPLE> <C_FILE> [<C_TAPE>] [<C_CONTAINS>]
@                    {file_name_5 [<C_POSITION> integer_3]}+

@io_control1       = <C_SAME> {<C_RECORD>|<C_SORT>|<C_MERGE>}
@                    [<C_AREA>] [<C_FOR>] file_name_1 file_name_2+

