# include "ccx.h"
# include "cobol-l.h"


	/* ------------ DATA DIVISION ------------------------ */

@data_division    =  <C_DATA> <C_DIVISION> stop
@	       		       [ file_section ]
@                      [ working_storage_section ]
@                      [ linkage_section ]
@                      [ report_section ]

@file_section     =  <C_FILE> <C_SECTION> stop
@						 file_descriptions

@file_descriptions=   file_description*

@file_description = <C_FD> identifier
@	      			[ block_data ]
@	      			[ record_data]
@                   label_data
@	     			stop       			
@	       			record_description(1)

@block_data       = <C_BLOCK> <C_CONTAINS>
@	      			natnum_rep <C_RECORDS>

@record_data      = <C_RECORD> <C_CONTAINS>
@	      			natnum_rep <C_CHARACTERS>

@label_data       = <C_LABEL> <C_RECORDS>
@	      			identifier

	/* records of level AT LEAST L */

@record_descriptions(L)=
@	      record_description(L)*

@record_description(L)= record_d(L)
@		         | level_88_d
@		         | )L<9( record_description(L+1)
	
	/* record of level EXACTLY Level */

@record_d(Level)  = level_number(Level)
@                   identifier
@                   [ redefines_part ]
@                    stop
@                   data_descriptions(Level+1)

@redefines_part   = <C_REDEFINES> identifier

	/* fields of level AT LEAST LEVEL */

@data_descriptions(LEVEL) =
@                   data_description(LEVEL)*

@data_description(L)= data_des(L)                      
@	              |  )L<9( data_description(L+1)
		
@data_des(L)      =  data_d(L)                         
@	     	      |	value_d(L)                        
@	     	      |	)L<9( record_d(L)


		/* single field record */

@level_88         =   <'8'> <'8'> | <'7'> <'7'>

@level_88_d       =   level_88
@                     identifier
@	                  level_88_d_c

@level_88_d_c     =   [ redefines_part  ]
@                     [ <C_PIC> format_descrip ]
@                     [ level_88_tags ]
@                    stop

@level_88_tags    =   level_88_tag { literal_iden level_88_tag }*

@level_88_tag     = <C_VALUE> [<C_IS>] ranges_cob_exp

	/* field of level EXACTLY L */


@data_d(L)        =  level_number(L)
@                    identifier
@                    [ redefines_part ]
@                    <C_PIC> format_descrip
@                    [ occurrences_part ]
@                    [ level_88_tags ]
@                    stop

	/* value of level EXACTLY L */
		

@value_d(L)      =   value_descrip
@	     			 level_number(L)
@                    identifier
@	      			 value_d_c(L)

@value_d_c(L)   =    [ redefines_part ]
@	     			 [ format_part ]
@                    [ usage_part ]
@                    [ occurrences_part ]
@                    stop

@format_part    =   <C_PIC> format_descrip

@ranges_cob_exp =  <C_ALL> cob_exp                
@               |    cob_exp [ <C_THRU> cob_exp ]

@format_descrip= single_format
@           	    [ format_descrip ]

@single_format = x_string
@                 | nine_string
@                 | z_string

	/* ETC */

@value_descrip    = <C_VALUE> cob_exp

@usage_part       =  <C_USAGE> [<C_IS>] identifier

@occurrences_part =
@	     	       <C_OCCURS> ranges_part
@                     [ key_part ]
@                     [ indexing_part ]

@ranges_part   = natnum_rep [ <C_TIMES> ]

@key_part(c)      = {<C_ASCENDING> | <C_DESCENDING> }
@                    <C_KEY> [<C_IS>] identifier

@indexing_part =  <C_INDEXED> <C_BY> identifier

@working_storage_section =
@                    <C_WORKING_STORAGE> <C_SECTION>
@                    stop
@                    w_s_s

@w_s_s            =   record_descriptions(1)

@linkage_section  = <C_LINKAGE> <C_SECTION>
@                    stop
@                    w_s_s

@report_section   =  <C_REPORT> <C_SECTION>
@                    stop
@                    report_files

@report_files     = report_file*

@report_file      =  <C_RD> identifier
@                    stop
@                    report_records

@report_records   = report_record*

@report_record    = level_number(1)
@	     			identifier
@                   report_sources
@                   stop

@report_sources   = {<C_SOURCE> identifier }*

