%{
# include "cobol-l.h"

# undef output
# define output(c) switch(c){\
case '\n': unput(0)/*bomb*/; break;\
default  : fprintf(yyout,"<%d>",c); break;\
}  /* print out */

extern char *yybuffer; /* this is the buffer in cc.c */
static int comment;
static int contin;
static int string;
char *yyptr;

int yywrap()
{
  return 1;
}

char           *yylloc;        /* replaces the one in yystuff.c */
long           yylval;
%}

%e 6000
%p 11000
%n 2000
%k 3000
%a 5000
%o 6000

sep			[ \t\r\n]
pnct			[ \t\r\n,+*/;:\.,]
blank			[ \t]
cont			[ \t]*"-"[ \t]*"'"
nonquote		[a-zA-Z0-9\ \t\~\`\!\@\#\$\%\^\&\*\(\)\-_=\+\{\}:;\"\.,<>?/\\|\[\]]
alpha			[a-zA-Z_]|"-"
alphanum		[a-zA-Z0-9]|"-"
num			[0-9]

%%
^{blank}*[\*\/].*$ 	printf("/*%s*/\n",yytext);
"'"({nonquote}*\n{cont})*{nonquote}*"'"/{pnct}	{/*these are string constants*/
			output('\'');
			yyptr=yytext;
			while(*++yyptr){
				if(*yyptr=='\n')
					while(*++yyptr&&*yyptr!='\'');
				else
					output(*yyptr);
			}
			}
{sep}"ACCEPT"/{pnct}	output(C_ACCEPT);
{sep}"ACCESS"/{pnct}	output(C_ACCESS);
{sep}"ADD"/{pnct}	output(C_ADD);
{sep}"ALL"/{pnct}	output(C_ALL);
{sep}"ALTER"/{pnct}	output(C_ALTER);
{sep}"ASCENDING"/{pnct}	output(C_ASCENDING);
{sep}"ASSIGN"/{pnct}	output(C_ASSIGN);
{sep}"AT"/{pnct}	output(C_AT);
{sep}"BY"/{pnct}	output(C_BY);
{sep}"CALL"/{pnct}	output(C_CALL);
{sep}"CANCEL"/{pnct}	output(C_CANCEL);
{sep}"CLOSE"/{pnct}	output(C_CLOSE);
{sep}"COMPUTE"/{pnct}	output(C_COMPUTE);
{sep}"DATA"/{pnct}	output(C_DATA);
{sep}"DELETE"/{pnct}	output(C_DELETE);
{sep}"DESCENDING"/{pnct}	output(C_DESCENDING);
{sep}"DISPLAY"/{pnct}	output(C_DISPLAY);
{sep}"DIVIDE"/{pnct}	output(C_DIVIDE);
{sep}"DIVISION"/{pnct}	output(C_DIVISION);
{sep}"DYNAMIC"/{pnct}	output(C_DYNAMIC);
{sep}"ELSE"/{pnct}	output(C_ELSE);
{sep}"END"/{pnct}	output(C_END);
{sep}"ENVIRONMENT"/{pnct}	output(C_ENVIRONMENT);
{sep}"ERROR"/{pnct}	output(C_ERROR);
{sep}"EXIT"/{pnct}	output(C_EXIT);
{sep}"EXTEND"/{pnct}	output(C_EXTEND);
{sep}"FD"/{pnct}	output(C_FD);
{sep}"FILE"/{pnct}	output(C_FILE);
{sep}"FILE-CONTROL"/{pnct}	output(C_FILE_CONTROL);
{sep}"FROM"/{pnct}	output(C_FROM);
{sep}"GENERATE"/{pnct}	output(C_GENERATE);
{sep}"GIVING"/{pnct}	output(C_GIVING);
{sep}"GO"/{pnct}	output(C_GO);
{sep}"I-O"/{pnct}	output(C_I_O);
{sep}"IF"/{pnct}	output(C_IF);
{sep}"INDEXED"/{pnct}	output(C_INDEXED);
{sep}"INITIATE"/{pnct}	output(C_INITIATE);
{sep}"INPUT"/{pnct}	output(C_INPUT);
{sep}"INPUT-OUTPUT"/{pnct}	output(C_INPUT_OUTPUT);
{sep}"INTO"/{pnct}	output(C_INTO);
{sep}"INVALID"/{pnct}	output(C_INVALID);
{sep}"IS"/{pnct}	output(C_IS);
{sep}"KEY"/{pnct}	output(C_KEY);
{sep}"LABEL"/{pnct}	output(C_LABEL);
{sep}"LINKAGE"/{pnct}	output(C_LINKAGE);
{sep}"MODE"/{pnct}	output(C_MODE);
{sep}"MOVE"/{pnct}	output(C_MOVE);
{sep}"NEXT"/{pnct}	output(C_NEXT);
{sep}"OCCURS"/{pnct}	output(C_OCCURS);
{sep}"ON"/{pnct}	output(C_ON);
{sep}"OPEN"/{pnct}	output(C_OPEN);
{sep}"ORGANIZATION"/{pnct}	output(C_ORGANIZATION);
{sep}"OUTPUT"/{pnct}	output(C_OUTPUT);
{sep}"PERFORM"/{pnct}	output(C_PERFORM);
{sep}"PIC"/{pnct}	output(C_PIC);
{sep}"PROCEDURE"/{pnct}	output(C_PROCEDURE);
{sep}"RANDOM"/{pnct}	output(C_RANDOM);
{sep}"RD"/{pnct}	output(C_RD);
{sep}"READ"/{pnct}	output(C_READ);
{sep}"RECORD"/{pnct}	output(C_RECORD);
{sep}"RECORDS"/{pnct}	output(C_RECORDS);
{sep}"REDEFINES"/{pnct}	output(C_REDEFINES);
{sep}"RELATIVE"/{pnct}	output(C_RELATIVE);
{sep}"RELEASE"/{pnct}	output(C_RELEASE);
{sep}"REPORT"/{pnct}	output(C_REPORT);
{sep}"RETURN"/{pnct}	output(C_RETURN);
{sep}"REWRITE"/{pnct}	output(C_REWRITE);
{sep}"ROUNDED"/{pnct}	output(C_ROUNDED);
{sep}"RUN"/{pnct}	output(C_RUN);
{sep}"SEARCH"/{pnct}	output(C_SEARCH);
{sep}"SECTION"/{pnct}	output(C_SECTION);
{sep}"SELECT"/{pnct}	output(C_SELECT);
{sep}"SENTENCE"/{pnct}	output(C_SENTENCE);
{sep}"SEQUENTIAL"/{pnct}	output(C_SEQUENTIAL);
{sep}"SET"/{pnct}	output(C_SET);
{sep}"SIZE"/{pnct}	output(C_SIZE);
{sep}"SOURCE"/{pnct}	output(C_SOURCE);
{sep}"START"/{pnct}	output(C_START);
{sep}"STATUS"/{pnct}	output(C_STATUS);
{sep}"STOP"/{pnct}	output(C_STOP);
{sep}"SUBTRACT"/{pnct}	output(C_SUBTRACT);
{sep}"TERMINATE"/{pnct}	output(C_TERMINATE);
{sep}"THRU"/{pnct}	output(C_THRU);
{sep}"THROUGH"/{pnct}	output(C_THROUGH);
{sep}"TIMES"/{pnct}	output(C_TIMES);
{sep}"TO"/{pnct}	output(C_TO);
{sep}"UNTIL"/{pnct}	output(C_UNTIL);
{sep}"USAGE"/{pnct}	output(C_USAGE);
{sep}"USING"/{pnct}	output(C_USING);
{sep}"VALUE"/{pnct}	output(C_VALUE);
{sep}"VARYING"/{pnct}	output(C_VARYING);
{sep}"WHEN"/{pnct}	output(C_WHEN);
{sep}"WORKING-STORAGE"/{pnct}	output(C_WORKING_STORAGE);
{sep}"WRITE"/{pnct}	output(C_WRITE);
{sep}"IDENTIFICATION"/{pnct}	output(C_IDENTIFICATION);
{sep}"PROGRAM-ID"/{pnct}	output(C_PROGRAM_ID);
{sep}"REMARKS"/{pnct}	output(C_REMARKS);
{sep}"CONFIGURATION"/{pnct}	output(C_CONFIGURATION);
{sep}"SOURCE-COMPUTER"/{pnct}	output(C_SOURCE_COMPUTER);
{sep}"OBJECT-COMPUTER"/{pnct}	output(C_OBJECT_COMPUTER);
{sep}"BLOCK"/{pnct}	output(C_BLOCK);
{sep}"CONTAINS"/{pnct}	output(C_CONTAINS);
{sep}"CHARACTERS"/{pnct}	output(C_CHARACTERS);
{sep}"SPACES"/{pnct}	output(C_SPACES);
{sep}"UPON"/{pnct}	output(C_UPON);
{sep}"CONSOLE"/{pnct}	output(C_CONSOLE);
{sep}"OR"/{pnct}	output(C_OR);
{sep}"AND"/{pnct}	output(C_AND);
{sep}"NOT"/{pnct}	output(C_NOT);
{sep}"LESS"/{pnct}	output(C_LESS);
{sep}"GREATER"/{pnct}	output(C_GREATER);
{sep}"THAN"/{pnct}	output(C_THAN);
{sep}"WITH"/{pnct}	output(C_WITH);
{sep}"DEBUGGING"/{pnct}	output(C_DEBUGGING);
{sep}"MEMORY"/{pnct}	output(C_MEMORY);
{sep}"WORDS"/{pnct}	output(C_WORDS);
{sep}"MODULES"/{pnct}	output(C_MODULES);
{sep}"PROGRAM"/{pnct}	output(C_PROGRAM);
{sep}"COLLATING"/{pnct}	output(C_COLLATING);
{sep}"SEQUENCE"/{pnct}	output(C_SEQUENCE);
{sep}"SEGMENT_LIMIT"/{pnct}	output(C_SEGMENT_LIMIT);
{sep}"SPECIAL_NAMES"/{pnct}	output(C_SPECIAL_NAMES);
{sep}"OFF"/{pnct}	output(C_OFF);
{sep}"STANDARD_1"/{pnct}	output(C_STANDARD_1);
{sep}"NATIVE"/{pnct}	output(C_NATIVE);
{sep}"ALSO"/{pnct}	output(C_ALSO);
{sep}"CURRENCY"/{pnct}	output(C_CURRENCY);
{sep}"SAME"/{pnct}	output(C_SAME);
{sep}"MULTIPLE"/{pnct}	output(C_MULTIPLE);
{sep}"SIGN"/{pnct}	output(C_SIGN);
{sep}"DECIMAL_POINT"/{pnct}	output(C_DECIMAL_POINT);
{sep}"COMMA"/{pnct}	output(C_COMMA);
{sep}"I_O_CONTROL"/{pnct}	output(C_I_O_CONTROL);
{sep}"OPTIONAL"/{pnct}	output(C_OPTIONAL);
{sep}"EXTERNAL"/{pnct}	output(C_EXTERNAL);
{sep}"DISK"/{pnct}	output(C_DISK);
{sep}"KEYBOARD"/{pnct}	output(C_KEYBOARD);
{sep}"PRINTER"/{pnct}	output(C_PRINTER);
{sep}"PRINTER_1"/{pnct}	output(C_PRINTER_1);
{sep}"LINE"/{pnct}	output(C_LINE);
{sep}"ADVANCING"/{pnct}	output(C_ADVANCING);
{sep}"REEL"/{pnct}	output(C_REEL);
{sep}"UNIT"/{pnct}	output(C_UNIT);
{sep}"RESERVE"/{pnct}	output(C_RESERVE);
{sep}"AREA"/{pnct}	output(C_AREA);
{sep}"AREAS"/{pnct}	output(C_AREAS);
{sep}"ALTERNATE"/{pnct}	output(C_ALTERNATE);
{sep}"DUPLICATES"/{pnct}	output(C_DUPLICATES);
{sep}"COUNT"/{pnct}	output(C_COUNT);
{sep}"CONTROL"/{pnct}	output(C_CONTROL);
{sep}"RERUN"/{pnct}	output(C_RERUN);
{sep}"EVERY"/{pnct}	output(C_EVERY);
{sep}"OF"/{pnct}	output(C_OF);
{sep}"CLOCK_UNITS"/{pnct}	output(C_CLOCK_UNITS);
{sep}"TAPE"/{pnct}	output(C_TAPE);
{sep}"POSITION"/{pnct}	output(C_POSITION);
{sep}"SORT"/{pnct}	output(C_SORT);
{sep}"MERGE"/{pnct}	output(C_MERGE);
{sep}"FOR"/{pnct}	output(C_FOR);
{sep}"AUTHOR"/{pnct}	output(C_AUTHOR);
    /* These take up printable char space. Help. Fix me. */
{sep}"INSTALLATION"/{pnct}	output(C_INSTALLATION);
{sep}"DATE_WRITTEN"/{pnct}	output(C_DATE_WRITTEN);
{sep}"DATE_COMPILED"/{pnct}	output(C_DATE_COMPILED);
{sep}"SECURITY"/{pnct}	output(C_SECURITY);
{sep}{num}+"."{num}*/{pnct}	{yyptr=yytext+1;
			while(*yyptr) output(*yyptr++);
			}
"."			{output('.');output('\n');}
{sep}			;
.			output(*yytext);
%%
