
# define TOKEN char
# define VALUE char*
# define STACKTOKENS 1
# define STACKSIZE 2048

# define BEGIN p_pbegin(self)
# define PRECC_Y /* signal to get precc's special V(x), T(x)  macros */
# include "cc.h"
# include "preccx.h"
# undef UNSETNAME
# include "preamble.h"

static
int p_pbegin(PRECC_DATA * self){
        static int passes; /* no. of times re-entered MAIN */
        int narg;          /* no of command line args */
        int nswitch;       /* count of command line switches */
        int switches;      /* flag - when doing command line switches */
        /*int dup2(int,int);*/
        
        if(passes++==0){   /* print motto */
                printf("\n\
/*    PRE-CC %d.%d compiler-compiler %s \n\
 *       Copyright Peter Breuer 1989-1998\n\
 *             <ptb@it.uc3m.es>\n\
 */\n\
",__PRECC__,__DATE__);
            call_mode=1;/* set no-auto shift in value stack */
            dup2(0,5);  /* save stdin and stdout */
            dup2(1,6);
            nswitch=0;  /* begin command line processing */
            switches=1;
            for (narg=1;narg<p_argc;narg++){
                switch(p_argv[narg][0]){
                case '-':
                    if(!switches) /* mixed switches and files */
                      usage (self,1);
                    nswitch++;
                    switch(p_argv[narg][1]){
                    case 'r': /* read buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->readbuffersize,
                                   sizeof (TOKEN) + sizeof (VALUE));
                        break;
                    case 'p': /* internal program length in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->maxprogramsize,
                                   sizeof (P_INSTRUCTION));
                        break;
                    case 'v': /* internal VALUE stack size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->stacksize,
                                   sizeof (P_STACKVALUE));
                        break;
                    case 'f': /* internal FRAME stack size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->contextstacksize,
                                   sizeof (P_FRAME));
                        break;
                    case 'c': /* internal stuff buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,&cbuffsize,
                                   sizeof (char));
                        break;
                    case 'n': /* internal name buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,&nbuffsize,
                                   sizeof (char));
                        break;
                    case 'o': 
                        if (0==strcmp(p_argv[narg]+1,"old"))
                            self->oldattributes=1;
                        else
                            self->oldattributes=0;
                        break;
                    default: /* unknown option */
                        usage(self,3);
                    }
                    break;
                default:
                    switches=0; /* end of switches */
                    break;
                }
            }                   /* now deal with redirects */
            p_infile = p_outfile = "-"; /* in and out file names */
            switch(p_argc-1-nswitch){
            case 2:
                    if (freopen(p_outfile=p_argv[nswitch+2], "w", stdout)==NULL) 
                      usage (self,2);
            case 1:
                    if (freopen(p_infile=p_argv[nswitch+1], "r", stdin)==NULL) 
                      usage (self,5);
            case 0: break;
            default: /* too many files named */
                    usage (self,6);
            }
            if (self->yylex != precc_yylex) {
               /* install our lexer */
               self->yylex = precc_yylex;
               self->yywrap = precc_yywrap;
               self->yytcharp = &precc_yytchar;
               self->yylinenop = &precc_yylineno;
               self->yylenp = &precc_yylen;
               self->yyllocp = &precc_yylloc;
               self->yylvalp = &precc_yylval;  
            }
	    {
	      /* remake data in case sizes have changed */
	      p_destr_data(self);
	      p_creat_data(self);
              p_creat_intern_data();
	    }
        }
        /* else passes > 0 */
        return 0;                /* success */
}

char *envs[PSTACKLENGTH];      /*environment stack*/
char *plvs[PSTACKLENGTH];      /*plainenv    stack*/
int  ecount=0;                 /*pointer */
int  countstack[PSTACKLENGTH]; /*stack of number of sequents we have seen */
int  countcount =0;            /*pointer */


void pushenv()
/* save the current environment and begin another */
{
    ecount++;
}

void popenv()
/* release the current env and recall the old */
{
    ecount--;
}

void pushcount()
/* save the current count of sequents and begin another */
{
    countcount++;
    /* the next line disambiguates references in blocks, but that is
     * probably not what is wanted.
     */
    /* count = countcount*PSTACKLENGTH + 1; */
    /* this next line does no disambiguation
     * and therefore causes warnings from C code,
     * but it doesn't matter.
     */
    count = 1;
}
void popcount()
/* release the current count of sequents and recall the old */
{
    countcount--;
}
int getcount()
/* return the current count level for sequents */
{
    return countcount;
}


                /* -- idens with params ------- */

@ nameplusargs =  IDENTIFIER [ rdbrktargs :VV(2)=V(1);: ] 

@ nameplusvars =  IDENTIFIER [ rdbrktvars :VV(2)=V(1);: ] 

@ sqbrktargs = openbracket
@              WHITESPACE theargs WHITESPACE
@              closebracket :VV(5)=V(3);: 

@ rdbrktargs = openparen
@              WHITESPACE theargs WHITESPACE
@              closeparen   :VV(5)=V(3);: 

@ rdbrktvars = openparen
@              WHITESPACE thevars WHITESPACE
@              closeparen   :VV(5)=V(3);: 

/* these are token-driven writes */

@ openparen    = OPENPAREN  : VV(1) = putchar(T(1)); :

@ closeparen   = CLOSEPAREN : VV(1) = putchar(T(1)); :

@ openbracket  = OPENBRACKET  : VV(1) = putchar(T(1)); :

@ closebracket = CLOSEBRACKET : VV(1) = putchar(T(1)); :

@ openbrace    = OPENBRACE  : VV(1) = putchar(T(1)); :

@ closebrace   = CLOSEBRACE : VV(1) = putchar(T(1)); :


@ theargs = someargs
@         |  : VV(0)=""; :

@ thevars = somevars
@         |  : VV(0)=""; :

@ comma = COMMA : VV(1)=putchar(','); :

@ someargs =expr { WHITESPACE  comma WHITESPACE expr :VV(5)=V(1);: }*


@ somevars =var  { WHITESPACE  comma WHITESPACE var  :VV(5)=V(1);: }*


@ var   = IDENTIFIER
@                :if(*putargs(""))putargs(",");putargs("PARAM ");putargs(V(1));
@                 if(*putmeta(""))putmeta(",");putmeta(V(1));:


                /* -- parser identifiers --- */

/* collect IDENTIFIERs from buffers */

void SETENV()
/* seal the current environment to be whats in the buffers now */
{
  environment=putargs("");
  plainenv=putmeta("");
  getargs(&environment);
  getmeta(&plainenv);
}

char *LASTVAR()
/* last variable in the current environment */
{
char *s;
if (ecount<0)
  return (char*)NULL;
s = strchr(plainenv,',');
if (!s)
  return plainenv;
return s+1;
}

/* first item written in a declaration block */
@ declname = nameplusvars :getname(&V(1));SETENV();:

/* to make #line references to definitions immediately before the
   first STATUS foo line in the emitted code, insert P_LINE; before the
   getname above */


/* collect a domain IDENTIFIER in the same way */

@ exprname = nameplusargs :getname(&V(1));:


                /* -- start of precc defn ----   */


@ declaration = ^ AT !{declerr} WHITESPACE declname
@              WHITESPACE EQUALS WHITESPACE
@              :printf("P_BEGIN\n");:
@              expression WHITESPACE
@              :VV(10) = P_REN(V(5),V(9));countcount=0;RESET;:
@              :printf("P_END\n");:

void ADDVAR(char *x)
/* make a new environment with one more var. save the old. */
{
  char *n;
                 /* finish off current env */
  getargs(&n);
  getmeta(&n);
                 /* copy old to new - start by buffering it */
  putargs(environment);
  putmeta(plainenv);
                 /* increment env count */
  pushenv();
                 /* point env at buffer */
  environment=putargs("");
  plainenv=putmeta("");
                 /* add new var */

  if (is_in(x,plainenv))
      return;    /* unless already there */

  if(*environment){
    putargs(",");
    putmeta(",");
  }
  putargs("VALUE ");  /* this is a special kind of new variable */
  putargs(x);
  putmeta(x);
                 /* note that the buffer is still unterminated */
}



/* to make #line references to definitions immediately before the
   STATUS foo line in the emitted code, insert P_LINE; before the
   VV above */

@ declerr = printdeclerr
@           passthrough :VV(2)=V(1);:

@ printdeclerr =  :VV(0)="@";
@                 fprintf(stderr,"line %d error: malformed declaration\n@?",*self->yylinenop); :

                /* that was it. Now the top level (MAIN) parse. */

@ line = declaration
@      | notanat passthrough
@      |  :VV(0)="";printf("\n");:

@ notanat = NOTANAT : VV(1)=putchar(T(1)); :

/* this is a deliberate pop of the value 'behind'  if we get none */

@ passthrough = {anychar : VV(2)=V(1); :}*
@                :getname(&V(1));printf("%s\n",V(1)); RESET;:

@ anychar = ANYTHING : VV(1)=putchar(T(1)); :

                /* ----  parser expressions -------- */

@ expression = alternates
@            | empty

/* a <'|'> separated series, at least one <'|'>  - note the overpull 
   I prefer the order which results from recursion */

@ alternates = sequence
@              [ WHITESPACE OR WHITESPACE alternates
@                :char *n;
@                 VV(5)=(GETNEWNAME(&n,plainenv),P_ALT(n,V(1),V(5)));:
@              ]

/* appending is much more efficient than prepending because I don't waste
  C-stack space with MARK before a parse */

/* this is a command separated sequence of sequents which are not commands
*/

@ sequence = manysequents 
@            { 
@              WHITESPACE command
@              WHITESPACE manysequents
@                 :char *n;
@                  VV(3)=(GETNEWNAME(&n,plainenv),P_AND(n,V(1),V(3)));:
@            }*
@            [ WHITESPACE command ]

 /* here we attach to the manysequents which this follows */

@ command =  COLON c_code COLONorEOL
@           : char *n,*m;
@             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,V(1),n,V(4))); :

@ bracketcommand = OPENBRACE COLON c_code1 COLON CLOSEBRACE
@           : char *n,*m;
@             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,"p_nothing0",n,V(3))); :
@                | COLON OPENBRACE c_code2 CLOSEBRACE COLON
@           : char *n,*m;
@             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,"p_nothing0",n,V(3))); :

/* manysequents is a 0 or more long list of nonempty non-commands */

/* start a new count */

/* do the pulling in moresequents, if it happens */

@ manysequents = firstsequent [ moresequents ] : popcount();:

/* need "empty newvar empty" and "sequent newvar empty" to make the
   above complete, but it's too much bother right now */

@ firstsequent = { sequent
@                | empty
@                }            :pushcount();:


        /* overpull again in the option 
           again, I prefer to use recursion for better output order */

/* without a parameterized spec, I can't prevent repetitions */

@ newvar = BACKSLASH IDENTIFIER
@     :VV(2)=V(2);getname(&V(2));ADDVAR(V(2));:

/* moresequents is a 1 or more long list of sequents, or an attr decl
 * followed by a 1 or more long list. It is not empty. It is not
 * (presently) a newvar on its own, though it might eventually be */

@ moresequents = newvar WHITESPACE sequent [ moresequents ]
@        : char *n; VV(4)=V(1);popenv();
@          GETNEWNAME(&n,plainenv);V(1)=P_STAR(n,V(1),V(4),V(2));:
@              | dummyvar WHITESPACE sequent [ moresequents ]
@        : char *n; VV(4)=V(1);
@          if (self->oldattributes){popenv();
@          GETNEWNAME(&n,plainenv);V(1)=P_STAR(n,V(1),V(4),V(2));}
@          else{
@          GETNEWNAME(&n,plainenv);V(1)=P_AND(n,V(1),V(4));}:

/* in the above, have to be careful to avoid allowing a trailing "empty"
   because that wrecks the returned value from an @foo@ */

@ dummyvar =  :/*empty*/ VV(0)=V(1);
@             if(self->oldattributes){
@             getname(&V(1));
@             GETANAME(&V(1),"p_","",count++);
@             V(1)=GNAME(V(1));putname(V(1));
@             getname(&V(1));
@             ADDVAR(V(1)); }

        /* Don't overpull now because ... */

@ sequent = seqoperand [ postfix ] 

        /* in each of these cases the postfix must behave as though the
        seqoperand were before it and overpull its arguments and write into
        the stack position to the left of itself */


@ postfix = starop
@         | plusop 
@         | hideop

@ bracket = OPENBRACE WHITESPACE
@           expression
@           WHITESPACE CLOSEBRACE
@    : VV(5) = V(3); :

@ option =  OPENBRACKET WHITESPACE
@           expression
@           WHITESPACE CLOSEBRACKET
@   : char *n;VV(5)=(GETNEWNAME(&n,plainenv),P_OPT(n,V(3))); :

@ empty =  : VV(0)= "p_nothing0"; :


@ result=  AT WHITESPACE expr WHITESPACE AT
@                 :char *n; VV(5)=(getname(&V(3)),
@                  GETNEWNAME(&n,plainenv),P_ATA(n,V(3))); :

@ bracketresult=  OPENBRACE AT WHITESPACE atstuffs WHITESPACE AT CLOSEBRACE
@                 :char *n; VV(7)=(getname(&V(4)),
@                  GETNEWNAME(&n,plainenv),P_ATA(n,V(4))); :
@              |  AT OPENBRACE WHITESPACE aatstuffs WHITESPACE CLOSEBRACE AT 
@                 :char *n; VV(7)=(getname(&V(4)),
@                  GETNEWNAME(&n,plainenv),P_ATA(n,V(4))); :


                /* here is one overpull */

int starflag=0;
char *starqual;

/* can't allow "a * n" because it can't be distinguished from "a* b" */

@ starop = STAR [ expr :starflag=1;VV(2)=(getname(&V(2)),V(2));: ]
@          : char *n;if(starflag){
@                  VV(2)=(GETNEWNAME(&n,plainenv),P_ITR(n,V(1),V(3))); 
@                  }  else {
@                  VV(2)=(GETNEWNAME(&n,plainenv),P_INF(n,V(1)));
@                  }  starflag=0; :

@ anymatch = QUESTION : VV(1)="p_anything0"; :

/* recall that exprnames get saved in the cbuff */


@ seqoperand = bracketcommand
@            | bracketresult
@            | brackettest
@            | bracket
@            | option
@            | literal
@            | antiliteral
@            | range  
@            | test
@            | phantom
@            | result
@            | anymatch | beginmatch | eofmatch
@            | dollarplingmatch | finishmatch
@            | plingexpr
@            | plingmatch | exprname


@ plingexpr  = PLING bracket 
@     : char *n;   VV(2)=(GETNEWNAME(&n,plainenv),P_ERR(n,V(2))); :

@ phantom = CLOSEBRACKET WHITESPACE
@              expression
@           WHITESPACE OPENBRACKET
@           :char *n;VV(5)=(GETNEWNAME(&n,plainenv),P_PHA(n,V(3))); :


/* ----------- subtokens of large "tokens" --------------------------- */

/* a literal is anything inside angle brackets.
 * an antiliteral is anything inside anti angle brackets.
 * anglebrackets inside may be escaped to protect them
 */

@ lstuff = STRING 
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTARIGHTANGLEBRACKET : VV(1) = putchar(T(1)); :

@ alstuff = STRING  
@         | CHARCONST
@         | DOLLARID
@         | COMMENT
@         | NOTALEFTANGLEBRACKET : VV(1) = putchar(T(1)); :

/* anything except (} */

@ tlstuff = STRING  
@         | CHARCONST
@         | DOLLARID
@         | COMMENT
@         | NOTANOPENPARBRACE : VV(1) = putchar(T(1)); :

/* anything except }( */

@atlstuff = STRING  
@         | CHARCONST
@         | DOLLARID
@         | COMMENT
@         | NOTABRACEOPENPAR : VV(1) = putchar(T(1)); :

# define NLCONV(x) ((x)=='\b'?'\n':(x)) /* undo yylex \n->\b conversion */
# define NLCONV(x) ((x)=='\b'?'\n':(x)) /* undo yylex \n->\b conversion */

/* anything except @} */

@ atstuff= STRING
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTANATBRACE : VV(1) = putchar(NLCONV(T(1))); :

/* anything except }@ */

@aatstuff= STRING
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTABRACEAT : VV(1) = putchar(NLCONV(T(1))); :

/* anything except : */

@ cstuff = STRING
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTACOLON : VV(1) = putchar(NLCONV(T(1))); :

/* anything except :} */

@ cstuff1= STRING
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTACOLONBRACE : VV(1) = putchar(NLCONV(T(1))); :

/* anything except }: */

@ cstuff2= STRING
@        | CHARCONST
@        | DOLLARID
@        | COMMENT
@        | NOTABRACECOLON : VV(1) = putchar(NLCONV(T(1))); :

/* -------------------------------------------------------------------- */


/* ------- let a stream flow by, while engraving itself in cbuff ------ */

@ atstuffs= atstuff { atstuff : VV(2) = V(1); : }*
@        |  : VV(0) =""; :

@aatstuffs= aatstuff { aatstuff : VV(2) = V(1); : }*
@        |  : VV(0) =""; :

@ lstuffs  = lstuff { lstuff : VV(2) = V(1); : }*
@          |  : VV(0)=""; :

@ alstuffs = alstuff { alstuff : VV(2) = V(1); : }*
@          |  : VV(0)=""; :

/* stuff inside a test can be anything except (} */

@ tlstuffs = tlstuff { tlstuff : VV(2) = V(1); : }*
@          |  : VV(0)=""; :

/* stuff inside a test can be anything except }( */

@atlstuffs = atlstuff { atlstuff : VV(2) = V(1); : }*
@          |  : VV(0)=""; :

/* the stuff inside a command is a sequence of C constants or C tokens */

@ cstuffs= cstuff { cstuff : VV(2) = V(1); : }*
@        |  : VV(0) =""; :

/* this kind of interior of a command ends only at a :} */

@ cstuffs1= cstuff1 { cstuff1 : VV(2) = V(1); : }*
@        |  : VV(0) =""; :

/* this kind of interior of a command ends only at a }: */

@ cstuffs2= cstuff2 { cstuff2 : VV(2) = V(1); : }*
@        |  : VV(0) =""; :

/* ------------------------------------------------------------------- */



/* ------------- close the cbuff accumulator  ------------------------ */

@ lits     = lstuffs :VV(1)=V(1);getname(&V(1));:

@ alits    = alstuffs :VV(1)=V(1);getname(&V(1));:

@ tlits    = tlstuffs :VV(1)=V(1);getname(&V(1));:

@atlits    =atlstuffs :VV(1)=V(1);getname(&V(1));:

/* commands didn't use to be able to be treated as ordinary atoms, because they
 * were required to end a sequence of 'and's and force a stack shift */

@ c_code = cstuffs : VV(1)=V(1); getname(&V(1)); :

/* otoh, this kind of command is an atom - it has code inside {: :} pairs */

@ c_code1= cstuffs1 : VV(1)=V(1); getname(&V(1)); :

/* or :{ }: pairs */

@ c_code2= cstuffs2 : VV(1)=V(1); getname(&V(1)); :

/* ------------------------------------------------------------------- */


/* ---------------------- large "tokens" ----------------------------- */

@ LITERAL  = LEFTANGLEBRACKET
@             lits
@            RIGHTANGLEBRACKET
@            : VV(3) = V(2); :

@ ANTILITERAL = RIGHTANGLEBRACKET
@               alits
@               LEFTANGLEBRACKET 
@               : VV(3) = V(2) ; : 

/* ------------------------------------------------------------------- */


@ literal = LITERAL 
@  :char *n;VV(1)=(GETNEWNAME(&n,plainenv),P_LIT(n,V(1))); :

@ antiliteral = ANTILITERAL
@  :char *n;VV(1)=(GETNEWNAME(&n,plainenv),P_ALI(n,V(1))); :

@ range = OPENPAREN WHITESPACE expr WHITESPACE CLOSEPAREN
@  :char *n;VV(5)=(getname(&V(3)),GETNEWNAME(&n,plainenv),P_RAN(n,V(3)));:

@ test = CLOSEPAREN WHITESPACE expr WHITESPACE OPENPAREN
@  :char *n;VV(5)=(getname(&V(3)),GETNEWNAME(&n,plainenv),P_TST(n,V(3)));:

@ brackettest = OPENBRACE CLOSEPAREN WHITESPACE tlits WHITESPACE OPENPAREN CLOSEBRACE
@  :char *n;VV(7)=(GETNEWNAME(&n,plainenv),P_TST(n,V(4))); :
@             | CLOSEPAREN OPENBRACE WHITESPACE atlits WHITESPACE CLOSEBRACE OPENPAREN
@  :char *n;VV(7)=(GETNEWNAME(&n,plainenv),P_TST(n,V(4))); :

@ beginmatch  = CARET : VV(1)="p_first0"; :

@ finishmatch = DOLLAR : VV(1)="p_last0"; :

@ plingmatch  = PLING : VV(1)="p_uniq0"; :

@ dollarplingmatch = DOLLAR PLING : VV(2)="p_lastuniq0"; :

@ eofmatch = DOLLAR DOLLAR : VV(2)="p_eof0"; :

                /* another overpull */

@ plusop = PLUS
@              : char *n;VV(2)=(GETNEWNAME(&n,plainenv),P_SOM(n,V(1))); :

@ hideop = SLASH OPENPAREN expr CLOSEPAREN
@  :char *n;
@   VV(5)=(getname(&V(4)),GETNEWNAME(&n,plainenv),P_HID(n,V(1),V(4)));:


                /* ------- finis -------- */

MAIN(line)










