# ifndef PRECCX_H
# define PRECCX_H
/*
  header file of precc macros
*/

# include "version.h"                /* version number and date */
# include "cc.h"

# undef  USE_INLINE_OR               /* Generate parser OR code inline */
                                     /* (seems a good thing) */
# undef  USE_INLINE_AND              /* Would make parser AND code inline */
                                     /* (the latter seems to load the symtab
                                      * too much for some compilers to handle)
                                      */

# define CBUFFSIZE 4096              /* size of general char buffer */
extern int cbuffsize;
# define NBUFFSIZE 4096              /* size of name buffer */
extern int nbuffsize;
# define PSTACKLENGTH 1024           /* max sequence of sequents */

#define count countstack[countcount] /* current count of sequents */
#define environment envs[ecount]     /* holds the typed list of params */
#define plainenv plvs[ecount]        /* this holds the untyped list of params*/
extern void popcount();              /* restores the last count of seQs */
extern void pushcount();             /* saves count of seqs seen currently */
extern int  getcount();              /* returns count level of seqs */


/* start up functions */
void usage(PRECC_DATA*,int);         /* usage and error messages */
int getkintarg(PRECC_DATA*,char*,int*,size_t); /* translate string to int (x1024) */

/* locals */
typedef char CHAR;                   /* character type */
typedef CHAR *CHARS;                 /* string type */

extern char *p_infile,               /* references to in/out file names */
            *p_outfile;

/* structures */

/* the class of agents */
typedef struct {                     /* temp place to hold and get out info */
/* private */
    CHARS buffer;                    /* underlying data area */
    CHARS in;                        /* where we're reading in to */
    CHARS out;                       /* where we're reading out from */
    CHARS limit;                     /* can't go past here */
} AGENT;

/* methods - as they would be if inline */
/*
 * VOID  initagent(AGENT*,char[],int) * supply the buffer *
 * CHARS putagent(AGENT *, CHAR)      * add a CHAR        *
 * CHARS nputagent(AGENT*, CHARS)     * add CHARS         *
 * CHARS getagent(AGENT *, CHARS*)    * pop into CHAR*    *
 * CHARS resetagent(AGENT *)          * zero              *
 */

/* as macros  - they are function calls nowadays */
/*
 * # define initagent(x,y,n) x={y,y,y,y+n}
 * # define putagent(x,y) ((*((x).in)++)=(y),(*((x).in)=0),&(x).in[-1])
 * # define nputagent(x,y) ((x).in=p_scpy((x).in,(y)),(x).out)
 * # define getagent(x,y) ((*((x).in)++)=0,(y)=(x).out,(x).out=(x).in)
 * # define resetagent(x) ((x).out=(x).in=(x).buffer)
*/


extern CHAR *cbuff;                  /* the general stuff buffer */
extern AGENT chars;                  /* and its protecting agent */

# define cptr chars.in               /* for backward continuity */
# define nptr chars.out

extern CHAR *nbuff;                  /* used to hold vars     */
extern AGENT namE;                   /* an agent for names    */
extern AGENT args;                   /* and one for arguments */
extern AGENT keys;                   /* and one for keywords  */

/* these are the operations on the name agent */

# undef putchar /* the stdio one */
# define putchar myputchar
extern CHARS myputchar(int);         /* CHARS putchar(CHAR)   */
extern CHARS getname(CHARS *);       /* pull and lock store   */
extern CHARS putname(CHARS);         /* multi putchar         */

# define RESET {resetall();}

/* ----------------- output code patterns ------------------------ */

# define P_FRSZ "P_SZ(%d,%d)"   /* pattern for size of x-y PARAMs & y VALUEs */

# define P_REN(x,y) (printf("\
STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
P_RETURN((TOPARSER %s)(self%s%s),\"%s\");\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
GNAME(y),ISEMPTY(GARGS(y))?"":",",GARGS(y),\
GNAME(x)),UNSETNAME(x))

/* no longer used */
# define P_REN2(x,y,z) (printf("\
STATUS %s(%s){\n\
PARSER %s, p_atch0;\n\
static VALUE p_%s_attr;\n\
PARAM %s=(PARAM)&p_%s_attr;\n\
return p_andparse0n(%s,p_atch0,1,(PARAM)p_%s_attr);\n\
}\n\
",GNAME(x),(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
GNAME(x),(z),GNAME(x),\
CATFUNCARGS(y,environment),GNAME(x)),UNSETNAME(x))

# ifdef USE_INLINE_AND
/* inline version */
# define P_AND(x,y,z) (printf("\
static STATUS %s(self%s%s) PRECC_DATA * self{;\n\
PARSER %s, %s;\n\
static STATUS p_tok;\n\
P_PAND((TOPARSER %s)(self,%s),(TOPARSER %s)(self,%s));\n\
return p_tok;\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
GNAME(y),GARGS(y),GNAME(z),GARGS(z)), UNSETNAME(x))
# else
/* the version of AND with the kernel call */
# define P_AND(x,y,z) (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s, %s;\n\
return p_andparse0n (self,TOPARSER %s,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
CATFUNCARGS(y,environment),CATFUNCARGS(z,environment)),UNSETNAME(x))
# endif

/* this next works using references, but there is a problem
 * in that the referenced item may have disappeared
 * by execution time, because the references only are saved
 * on the stack, not what they point to. Included in case I
 * ever need to "refer" to it!
 */

/*********** discontinued ****************************
# define P_STAR(x,y,z,u) (printf("\
static STATUS %s(%s){\n\
PARSER %s, %s;\n\
VALUE p_dummy0;\n\
static PARAM %s; %s = (PARAM)&p_dummy0;\n\
return p_starparse0n ((VALUE*)%s,TOPARSER %s,TOPARSER %s);\n\
}\n\
",GNAME(x),(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
(u),(u),(u),CATFUNCARGS(y,environment),CATFUNCARGS(z,environment)),UNSETNAME(x))
******************************************************/

/* Nothing wrong with this next, but it's a bit unwieldy
 * to place inline, so I have replaced the innards with
 * a macro (below).
 */

/*********** discontinued ****************************
# define P_STAR(x,y,z,u) (printf("\
static STATUS %s(%s){\n\
PARSER %s, %s;\n\
PARAM %s; static STATUS p_tok;\n\
  MARK;  p_tok = (TOPARSER %s) (%s);\n\
  if (BADSTATUS(p_tok)) {RELEASE;return p_tok;}\n\
  %s = (PARAM)p_tok; p_tok = (TOPARSER %s) (%s);\n\
  if (BADSTATUS(p_tok)) {REWIND;} else {RELEASE;}\n\
  return p_tok;\n\
}\n\
",GNAME(x),(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
u,GNAME(y),GARGS(y),u,GNAME(z),GARGS(z)),UNSETNAME(x))
******************************************************/

# define P_STAR(x,y,z,u) (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s, %s; VALUE %s;\n\
static STATUS p_tok;\n\
P_PSTAR(%s,(TOPARSER %s)(self%s%s),(TOPARSER %s)(self%s%s));\n\
return p_tok;\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
u,u,GNAME(y),ISEMPTY(GARGS(y))?"":",",GARGS(y),\
GNAME(z),ISEMPTY(GARGS(z))?"":",",GARGS(z)), UNSETNAME(x))

# ifdef USE_INLINE_OR
/* inline version */
# define P_ALT(x,y,z) (printf ("\
static STATUS %s (self%s%s){\n\
PARSER %s, %s;\n\
static STATUS p_tok;\n\
MARK;\n\
P_TRY { p_tok = (TOPARSER %s) (self%s%s);\n\
} P_CATCH(P_THROWABLE) { p_tok = FAILURE; REWIND; } P_CAUGHT;\n\
if (GOODSTATUS(p_tok)) { RELEASE; return p_tok; }\n\
P_TRY { p_tok = (TOPARSER %s) (self%s%s);\n\
} P_CATCH(P_THROWABLE) { p_tok = FAILURE; REWIND; } P_CAUGHT;\n\
if (GOODSTATUS(p_tok)) { RELEASE; return p_tok; }\n\
RELEASE; P_THROW(\"p_orparse0\"); return p_tok;\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
GNAME(y),ISEMPTY(GARGS(z))?"":",",GARGS(y)),GARGS(y),\
GNAME(z),ISEMPTY(GARGS(z))?"":",",GARGS(z)),UNSETNAME(x))
# else
/* library call version */
# define P_ALT(x,y,z) (printf ("\
static STATUS %s (PRECC_DATA* self%s%s) {\n\
PARSER %s, %s;\n\
return p_orparse0n (self,TOPARSER %s,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
!is_in(GNAME(z),(char*)plainenv)?GNAME(z):"dummy2",\
CATFUNCARGS(y,environment),CATFUNCARGS(z,environment)),UNSETNAME(x))
# endif

# define P_ATT(x,y,z,w) (printf("\
static VOID %s(PRECC_DATA* self%s%s) {\n\
%s\n\
}\n\
",GNAME(z),ISEMPTY(environment)?"":",",(char*)environment,(w)),\
printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;ACTION %s;\n\
return p_attach0n(self,TOPARSER %s,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
GNAME(y),GNAME(z),CATFUNCARGS(y,environment),CATFUNCARGS(z,environment)),UNSETNAME(x))

/* no longer used */
# define P_PRE(x,y,z,w) (printf("\
static VOID %s(PRECC_DATA* self%s%s) {\n\
%s\n\
}\n\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;ACTION %s;\n\
return p_prepend0n(self,%s,%s);\n\
}\n\
",GNAME(z),ISEMPTY(environment)?"":",",(char*)environment,(w),\
GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,GNAME(y),GNAME(z),\
CATFUNCARGS(z,environment),CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_OPT(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_option0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_ATA(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
return p_atch0(self,/* VALUE */ %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
(y)),UNSETNAME(x))

# define P_INF(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_many0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_ITR(x,y,z)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_iter0n(self,(int)%s,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
z,CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_SOM(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_some0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_PHA(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_hidden0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_ERR(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_uerror0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_UNI(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_uniq0n(self,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
GNAME(y),CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_LIT(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
return p_exactly0(self,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,(y)),UNSETNAME(x))

# define P_ALI(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
return p_notexactly0(self,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,(y)),UNSETNAME(x))

# define P_RAN(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PREDICATE %s;\n\
return p_range0n(self,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,GNAME(y),CATFUNCARGS(y,environment)),UNSETNAME(x))

# define P_TST(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
return p_test0(self,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,(y)),UNSETNAME(x))

# define P_HID(x,y,z)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PREDICATE %s;\n\
PARSER %s;\n\
return p_hide0n(self,TOPARSER %s,%s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,GNAME(z),\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment),CATFUNCARGS(z,environment)),UNSETNAME(x))

# define P_UNT(x,y)   (printf("\
static STATUS %s(PRECC_DATA* self%s%s) {\n\
PARSER %s;\n\
return p_until0n(self,TOPARSER %s);\n\
}\n\
",GNAME(x),ISEMPTY(environment)?"":",",(char*)environment,\
!is_in(GNAME(y),(char*)plainenv)?GNAME(y):"dummy1",\
CATFUNCARGS(y,environment)),UNSETNAME(x))

/* this prints out the line numbers for cpp */
# define P_LINE ((*p_infile!='-')?printf("#line %d \"%s\"\n",\
yylineno, p_infile):0)

# endif
