
# define TOKEN char
# define VALUE char*
# define STACKTOKENS 1
# define STACKSIZE 2048

# define BEGIN p_pbegin(self)
# define PRECC_Y /* signal to get precc's special V(x), T(x)  macros */
# include "cc.h"
# include "preccx.h"
# undef UNSETNAME
# include "preamble.h"

static
int p_pbegin(PRECC_DATA * self){
        static int passes; /* no. of times re-entered MAIN */
        int narg;          /* no of command line args */
        int nswitch;       /* count of command line switches */
        int switches;      /* flag - when doing command line switches */
        /*int dup2(int,int);*/
        
        if(passes++==0){   /* print motto */
                printf("\n\
/*    PRE-CC %d.%d compiler-compiler %s \n\
 *       Copyright Peter Breuer 1989-1998\n\
 *             <ptb@it.uc3m.es>\n\
 */\n\
",__PRECC__,__DATE__);
            call_mode=1;/* set no-auto shift in value stack */
            dup2(0,5);  /* save stdin and stdout */
            dup2(1,6);
            nswitch=0;  /* begin command line processing */
            switches=1;
            for (narg=1;narg<p_argc;narg++){
                switch(p_argv[narg][0]){
                case '-':
                    if(!switches) /* mixed switches and files */
                      usage (self,1);
                    nswitch++;
                    switch(p_argv[narg][1]){
                    case 'r': /* read buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->readbuffersize,
                                   sizeof (TOKEN) + sizeof (VALUE));
                        break;
                    case 'p': /* internal program length in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->maxprogramsize,
                                   sizeof (P_INSTRUCTION));
                        break;
                    case 'v': /* internal VALUE stack size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->stacksize,
                                   sizeof (P_STACKVALUE));
                        break;
                    case 'f': /* internal FRAME stack size in Kb */
                        getkintarg(self,p_argv[narg]+2,& self->contextstacksize,
                                   sizeof (P_FRAME));
                        break;
                    case 'c': /* internal stuff buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,&cbuffsize,
                                   sizeof (char));
                        break;
                    case 'n': /* internal name buffer size in Kb */
                        getkintarg(self,p_argv[narg]+2,&nbuffsize,
                                   sizeof (char));
                        break;
                    case 'o': 
                        if (0==strcmp(p_argv[narg]+1,"old"))
                            self->oldattributes=1;
                        else
                            self->oldattributes=0;
                        break;
                    default: /* unknown option */
                        usage(self,3);
                    }
                    break;
                default:
                    switches=0; /* end of switches */
                    break;
                }
            }                   /* now deal with redirects */
            p_infile = p_outfile = "-"; /* in and out file names */
            switch(p_argc-1-nswitch){
            case 2:
                    if (freopen(p_outfile=p_argv[nswitch+2], "w", stdout)==NULL) 
                      usage (self,2);
            case 1:
                    if (freopen(p_infile=p_argv[nswitch+1], "r", stdin)==NULL) 
                      usage (self,5);
            case 0: break;
            default: /* too many files named */
                    usage (self,6);
            }
            if (self->yylex != precc_yylex) {
               /* install our lexer */
               self->yylex = precc_yylex;
               self->yywrap = precc_yywrap;
               self->yytcharp = &precc_yytchar;
               self->yylinenop = &precc_yylineno;
               self->yylenp = &precc_yylen;
               self->yyllocp = &precc_yylloc;
               self->yylvalp = &precc_yylval;  
            }
	    {
	      /* remake data in case sizes have changed */
	      p_destr_data(self);
	      p_creat_data(self);
              p_creat_intern_data();
	    }
        }
        /* else passes > 0 */
        return 0;                /* success */
}

char *envs[PSTACKLENGTH];      /*environment stack*/
char *plvs[PSTACKLENGTH];      /*plainenv    stack*/
int  ecount=0;                 /*pointer */
int  countstack[PSTACKLENGTH]; /*stack of number of sequents we have seen */
int  countcount =0;            /*pointer */


void pushenv()
/* save the current environment and begin another */
{
    ecount++;
}

void popenv()
/* release the current env and recall the old */
{
    ecount--;
}

void pushcount()
/* save the current count of sequents and begin another */
{
    countcount++;
    /* the next line disambiguates references in blocks, but that is
     * probably not what is wanted.
     */
    /* count = countcount*PSTACKLENGTH + 1; */
    /* this next line does no disambiguation
     * and therefore causes warnings from C code,
     * but it doesn't matter.
     */
    count = 1;
}
void popcount()
/* release the current count of sequents and recall the old */
{
    countcount--;
}
int getcount()
/* return the current count level for sequents */
{
    return countcount;
}


                /* -- idens with params ------- */

P_BEGIN
static VOID hid0(PRECC_DATA* self) {
VV(2)=V(1);
}
static STATUS hid1(PRECC_DATA* self) {
PARSER rdbrktargs;ACTION hid0;
return p_attach0n(self,TOPARSER rdbrktargs,0,hid0,0);
}
static STATUS hid2(PRECC_DATA* self) {
PARSER hid1, p_nothing0;
return p_andparse0n (self,TOPARSER hid1,0,TOPARSER p_nothing0,0);
}
static STATUS hid3(PRECC_DATA* self) {
PARSER hid2;
return p_option0n(self,TOPARSER hid2,0);
}
static STATUS hid4(PRECC_DATA* self) {
PARSER IDENTIFIER, hid3;
return p_andparse0n (self,TOPARSER IDENTIFIER,0,TOPARSER hid3,0);
}
STATUS nameplusargs(PRECC_DATA* self) {
PARSER hid4;
P_RETURN((TOPARSER hid4)(self),"nameplusargs");
}
P_END

P_BEGIN
static VOID hid5(PRECC_DATA* self) {
VV(2)=V(1);
}
static STATUS hid6(PRECC_DATA* self) {
PARSER rdbrktvars;ACTION hid5;
return p_attach0n(self,TOPARSER rdbrktvars,0,hid5,0);
}
static STATUS hid7(PRECC_DATA* self) {
PARSER hid6, p_nothing0;
return p_andparse0n (self,TOPARSER hid6,0,TOPARSER p_nothing0,0);
}
static STATUS hid8(PRECC_DATA* self) {
PARSER hid7;
return p_option0n(self,TOPARSER hid7,0);
}
static STATUS hid9(PRECC_DATA* self) {
PARSER IDENTIFIER, hid8;
return p_andparse0n (self,TOPARSER IDENTIFIER,0,TOPARSER hid8,0);
}
STATUS nameplusvars(PRECC_DATA* self) {
PARSER hid9;
P_RETURN((TOPARSER hid9)(self),"nameplusvars");
}
P_END

P_BEGIN
static STATUS hid10(PRECC_DATA* self) {
PARSER WHITESPACE, closebracket;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER closebracket,0);
}
static STATUS hid11(PRECC_DATA* self) {
PARSER theargs, hid10;
return p_andparse0n (self,TOPARSER theargs,0,TOPARSER hid10,0);
}
static STATUS hid12(PRECC_DATA* self) {
PARSER WHITESPACE, hid11;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid11,0);
}
static STATUS hid13(PRECC_DATA* self) {
PARSER openbracket, hid12;
return p_andparse0n (self,TOPARSER openbracket,0,TOPARSER hid12,0);
}
static VOID hid14(PRECC_DATA* self) {
VV(5)=V(3);
}
static STATUS hid15(PRECC_DATA* self) {
PARSER hid13;ACTION hid14;
return p_attach0n(self,TOPARSER hid13,0,hid14,0);
}
static STATUS hid16(PRECC_DATA* self) {
PARSER hid15, p_nothing0;
return p_andparse0n (self,TOPARSER hid15,0,TOPARSER p_nothing0,0);
}
STATUS sqbrktargs(PRECC_DATA* self) {
PARSER hid16;
P_RETURN((TOPARSER hid16)(self),"sqbrktargs");
}
P_END

P_BEGIN
static STATUS hid17(PRECC_DATA* self) {
PARSER WHITESPACE, closeparen;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER closeparen,0);
}
static STATUS hid18(PRECC_DATA* self) {
PARSER theargs, hid17;
return p_andparse0n (self,TOPARSER theargs,0,TOPARSER hid17,0);
}
static STATUS hid19(PRECC_DATA* self) {
PARSER WHITESPACE, hid18;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid18,0);
}
static STATUS hid20(PRECC_DATA* self) {
PARSER openparen, hid19;
return p_andparse0n (self,TOPARSER openparen,0,TOPARSER hid19,0);
}
static VOID hid21(PRECC_DATA* self) {
VV(5)=V(3);
}
static STATUS hid22(PRECC_DATA* self) {
PARSER hid20;ACTION hid21;
return p_attach0n(self,TOPARSER hid20,0,hid21,0);
}
static STATUS hid23(PRECC_DATA* self) {
PARSER hid22, p_nothing0;
return p_andparse0n (self,TOPARSER hid22,0,TOPARSER p_nothing0,0);
}
STATUS rdbrktargs(PRECC_DATA* self) {
PARSER hid23;
P_RETURN((TOPARSER hid23)(self),"rdbrktargs");
}
P_END

P_BEGIN
static STATUS hid24(PRECC_DATA* self) {
PARSER WHITESPACE, closeparen;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER closeparen,0);
}
static STATUS hid25(PRECC_DATA* self) {
PARSER thevars, hid24;
return p_andparse0n (self,TOPARSER thevars,0,TOPARSER hid24,0);
}
static STATUS hid26(PRECC_DATA* self) {
PARSER WHITESPACE, hid25;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid25,0);
}
static STATUS hid27(PRECC_DATA* self) {
PARSER openparen, hid26;
return p_andparse0n (self,TOPARSER openparen,0,TOPARSER hid26,0);
}
static VOID hid28(PRECC_DATA* self) {
VV(5)=V(3);
}
static STATUS hid29(PRECC_DATA* self) {
PARSER hid27;ACTION hid28;
return p_attach0n(self,TOPARSER hid27,0,hid28,0);
}
static STATUS hid30(PRECC_DATA* self) {
PARSER hid29, p_nothing0;
return p_andparse0n (self,TOPARSER hid29,0,TOPARSER p_nothing0,0);
}
STATUS rdbrktvars(PRECC_DATA* self) {
PARSER hid30;
P_RETURN((TOPARSER hid30)(self),"rdbrktvars");
}
P_END

/* these are token-driven writes */

P_BEGIN
static VOID hid31(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid32(PRECC_DATA* self) {
PARSER OPENPAREN;ACTION hid31;
return p_attach0n(self,TOPARSER OPENPAREN,0,hid31,0);
}
static STATUS hid33(PRECC_DATA* self) {
PARSER hid32, p_nothing0;
return p_andparse0n (self,TOPARSER hid32,0,TOPARSER p_nothing0,0);
}
STATUS openparen(PRECC_DATA* self) {
PARSER hid33;
P_RETURN((TOPARSER hid33)(self),"openparen");
}
P_END

P_BEGIN
static VOID hid34(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid35(PRECC_DATA* self) {
PARSER CLOSEPAREN;ACTION hid34;
return p_attach0n(self,TOPARSER CLOSEPAREN,0,hid34,0);
}
static STATUS hid36(PRECC_DATA* self) {
PARSER hid35, p_nothing0;
return p_andparse0n (self,TOPARSER hid35,0,TOPARSER p_nothing0,0);
}
STATUS closeparen(PRECC_DATA* self) {
PARSER hid36;
P_RETURN((TOPARSER hid36)(self),"closeparen");
}
P_END

P_BEGIN
static VOID hid37(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid38(PRECC_DATA* self) {
PARSER OPENBRACKET;ACTION hid37;
return p_attach0n(self,TOPARSER OPENBRACKET,0,hid37,0);
}
static STATUS hid39(PRECC_DATA* self) {
PARSER hid38, p_nothing0;
return p_andparse0n (self,TOPARSER hid38,0,TOPARSER p_nothing0,0);
}
STATUS openbracket(PRECC_DATA* self) {
PARSER hid39;
P_RETURN((TOPARSER hid39)(self),"openbracket");
}
P_END

P_BEGIN
static VOID hid40(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid41(PRECC_DATA* self) {
PARSER CLOSEBRACKET;ACTION hid40;
return p_attach0n(self,TOPARSER CLOSEBRACKET,0,hid40,0);
}
static STATUS hid42(PRECC_DATA* self) {
PARSER hid41, p_nothing0;
return p_andparse0n (self,TOPARSER hid41,0,TOPARSER p_nothing0,0);
}
STATUS closebracket(PRECC_DATA* self) {
PARSER hid42;
P_RETURN((TOPARSER hid42)(self),"closebracket");
}
P_END

P_BEGIN
static VOID hid43(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid44(PRECC_DATA* self) {
PARSER OPENBRACE;ACTION hid43;
return p_attach0n(self,TOPARSER OPENBRACE,0,hid43,0);
}
static STATUS hid45(PRECC_DATA* self) {
PARSER hid44, p_nothing0;
return p_andparse0n (self,TOPARSER hid44,0,TOPARSER p_nothing0,0);
}
STATUS openbrace(PRECC_DATA* self) {
PARSER hid45;
P_RETURN((TOPARSER hid45)(self),"openbrace");
}
P_END

P_BEGIN
static VOID hid46(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid47(PRECC_DATA* self) {
PARSER CLOSEBRACE;ACTION hid46;
return p_attach0n(self,TOPARSER CLOSEBRACE,0,hid46,0);
}
static STATUS hid48(PRECC_DATA* self) {
PARSER hid47, p_nothing0;
return p_andparse0n (self,TOPARSER hid47,0,TOPARSER p_nothing0,0);
}
STATUS closebrace(PRECC_DATA* self) {
PARSER hid48;
P_RETURN((TOPARSER hid48)(self),"closebrace");
}
P_END


P_BEGIN
static VOID hid49(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid50(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid49;
return p_attach0n(self,TOPARSER p_nothing0,0,hid49,0);
}
static STATUS hid51(PRECC_DATA* self) {
PARSER hid50, p_nothing0;
return p_andparse0n (self,TOPARSER hid50,0,TOPARSER p_nothing0,0);
}
static STATUS hid52 (PRECC_DATA* self) {
PARSER someargs, hid51;
return p_orparse0n (self,TOPARSER someargs,0,TOPARSER hid51,0);
}
STATUS theargs(PRECC_DATA* self) {
PARSER hid52;
P_RETURN((TOPARSER hid52)(self),"theargs");
}
P_END

P_BEGIN
static VOID hid53(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid54(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid53;
return p_attach0n(self,TOPARSER p_nothing0,0,hid53,0);
}
static STATUS hid55(PRECC_DATA* self) {
PARSER hid54, p_nothing0;
return p_andparse0n (self,TOPARSER hid54,0,TOPARSER p_nothing0,0);
}
static STATUS hid56 (PRECC_DATA* self) {
PARSER somevars, hid55;
return p_orparse0n (self,TOPARSER somevars,0,TOPARSER hid55,0);
}
STATUS thevars(PRECC_DATA* self) {
PARSER hid56;
P_RETURN((TOPARSER hid56)(self),"thevars");
}
P_END

P_BEGIN
static VOID hid57(PRECC_DATA* self) {
 VV(1)=putchar(','); 
}
static STATUS hid58(PRECC_DATA* self) {
PARSER COMMA;ACTION hid57;
return p_attach0n(self,TOPARSER COMMA,0,hid57,0);
}
static STATUS hid59(PRECC_DATA* self) {
PARSER hid58, p_nothing0;
return p_andparse0n (self,TOPARSER hid58,0,TOPARSER p_nothing0,0);
}
STATUS comma(PRECC_DATA* self) {
PARSER hid59;
P_RETURN((TOPARSER hid59)(self),"comma");
}
P_END

P_BEGIN
static STATUS hid60(PRECC_DATA* self) {
PARSER WHITESPACE, expr;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER expr,0);
}
static STATUS hid61(PRECC_DATA* self) {
PARSER comma, hid60;
return p_andparse0n (self,TOPARSER comma,0,TOPARSER hid60,0);
}
static STATUS hid62(PRECC_DATA* self) {
PARSER WHITESPACE, hid61;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid61,0);
}
static VOID hid63(PRECC_DATA* self) {
VV(5)=V(1);
}
static STATUS hid64(PRECC_DATA* self) {
PARSER hid62;ACTION hid63;
return p_attach0n(self,TOPARSER hid62,0,hid63,0);
}
static STATUS hid65(PRECC_DATA* self) {
PARSER hid64, p_nothing0;
return p_andparse0n (self,TOPARSER hid64,0,TOPARSER p_nothing0,0);
}
static STATUS hid66(PRECC_DATA* self) {
PARSER hid65;
return p_many0n(self,TOPARSER hid65,0);
}
static STATUS hid67(PRECC_DATA* self) {
PARSER expr, hid66;
return p_andparse0n (self,TOPARSER expr,0,TOPARSER hid66,0);
}
STATUS someargs(PRECC_DATA* self) {
PARSER hid67;
P_RETURN((TOPARSER hid67)(self),"someargs");
}
P_END


P_BEGIN
static STATUS hid68(PRECC_DATA* self) {
PARSER WHITESPACE, var;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER var,0);
}
static STATUS hid69(PRECC_DATA* self) {
PARSER comma, hid68;
return p_andparse0n (self,TOPARSER comma,0,TOPARSER hid68,0);
}
static STATUS hid70(PRECC_DATA* self) {
PARSER WHITESPACE, hid69;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid69,0);
}
static VOID hid71(PRECC_DATA* self) {
VV(5)=V(1);
}
static STATUS hid72(PRECC_DATA* self) {
PARSER hid70;ACTION hid71;
return p_attach0n(self,TOPARSER hid70,0,hid71,0);
}
static STATUS hid73(PRECC_DATA* self) {
PARSER hid72, p_nothing0;
return p_andparse0n (self,TOPARSER hid72,0,TOPARSER p_nothing0,0);
}
static STATUS hid74(PRECC_DATA* self) {
PARSER hid73;
return p_many0n(self,TOPARSER hid73,0);
}
static STATUS hid75(PRECC_DATA* self) {
PARSER var, hid74;
return p_andparse0n (self,TOPARSER var,0,TOPARSER hid74,0);
}
STATUS somevars(PRECC_DATA* self) {
PARSER hid75;
P_RETURN((TOPARSER hid75)(self),"somevars");
}
P_END


P_BEGIN
static VOID hid76(PRECC_DATA* self) {
if(*putargs(""))putargs(",");putargs("PARAM ");putargs(V(1));
                 if(*putmeta(""))putmeta(",");putmeta(V(1));
}
static STATUS hid77(PRECC_DATA* self) {
PARSER IDENTIFIER;ACTION hid76;
return p_attach0n(self,TOPARSER IDENTIFIER,0,hid76,0);
}
static STATUS hid78(PRECC_DATA* self) {
PARSER hid77, p_nothing0;
return p_andparse0n (self,TOPARSER hid77,0,TOPARSER p_nothing0,0);
}
STATUS var(PRECC_DATA* self) {
PARSER hid78;
P_RETURN((TOPARSER hid78)(self),"var");
}
P_END


                /* -- parser identifiers --- */

/* collect IDENTIFIERs from buffers */

void SETENV()
/* seal the current environment to be whats in the buffers now */
{
  environment=putargs("");
  plainenv=putmeta("");
  getargs(&environment);
  getmeta(&plainenv);
}

char *LASTVAR()
/* last variable in the current environment */
{
char *s;
if (ecount<0)
  return (char*)NULL;
s = strchr(plainenv,',');
if (!s)
  return plainenv;
return s+1;
}

/* first item written in a declaration block */
P_BEGIN
static VOID hid79(PRECC_DATA* self) {
getname(&V(1));SETENV();
}
static STATUS hid80(PRECC_DATA* self) {
PARSER nameplusvars;ACTION hid79;
return p_attach0n(self,TOPARSER nameplusvars,0,hid79,0);
}
static STATUS hid81(PRECC_DATA* self) {
PARSER hid80, p_nothing0;
return p_andparse0n (self,TOPARSER hid80,0,TOPARSER p_nothing0,0);
}
STATUS declname(PRECC_DATA* self) {
PARSER hid81;
P_RETURN((TOPARSER hid81)(self),"declname");
}
P_END

/* to make #line references to definitions immediately before the
   first STATUS foo line in the emitted code, insert P_LINE; before the
   getname above */


/* collect a domain IDENTIFIER in the same way */

P_BEGIN
static VOID hid82(PRECC_DATA* self) {
getname(&V(1));
}
static STATUS hid83(PRECC_DATA* self) {
PARSER nameplusargs;ACTION hid82;
return p_attach0n(self,TOPARSER nameplusargs,0,hid82,0);
}
static STATUS hid84(PRECC_DATA* self) {
PARSER hid83, p_nothing0;
return p_andparse0n (self,TOPARSER hid83,0,TOPARSER p_nothing0,0);
}
STATUS exprname(PRECC_DATA* self) {
PARSER hid84;
P_RETURN((TOPARSER hid84)(self),"exprname");
}
P_END


                /* -- start of precc defn ----   */


P_BEGIN
static STATUS hid85(PRECC_DATA* self) {
PARSER declerr;
return p_uerror0n(self,TOPARSER declerr,0);
}
static STATUS hid86(PRECC_DATA* self) {
PARSER EQUALS, WHITESPACE;
return p_andparse0n (self,TOPARSER EQUALS,0,TOPARSER WHITESPACE,0);
}
static STATUS hid87(PRECC_DATA* self) {
PARSER WHITESPACE, hid86;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid86,0);
}
static STATUS hid88(PRECC_DATA* self) {
PARSER declname, hid87;
return p_andparse0n (self,TOPARSER declname,0,TOPARSER hid87,0);
}
static STATUS hid89(PRECC_DATA* self) {
PARSER WHITESPACE, hid88;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid88,0);
}
static STATUS hid90(PRECC_DATA* self) {
PARSER hid85, hid89;
return p_andparse0n (self,TOPARSER hid85,0,TOPARSER hid89,0);
}
static STATUS hid91(PRECC_DATA* self) {
PARSER AT, hid90;
return p_andparse0n (self,TOPARSER AT,0,TOPARSER hid90,0);
}
static STATUS hid92(PRECC_DATA* self) {
PARSER p_first0, hid91;
return p_andparse0n (self,TOPARSER p_first0,0,TOPARSER hid91,0);
}
static VOID hid93(PRECC_DATA* self) {
printf("P_BEGIN\n");
}
static STATUS hid94(PRECC_DATA* self) {
PARSER hid92;ACTION hid93;
return p_attach0n(self,TOPARSER hid92,0,hid93,0);
}
static STATUS hid95(PRECC_DATA* self) {
PARSER expression, WHITESPACE;
return p_andparse0n (self,TOPARSER expression,0,TOPARSER WHITESPACE,0);
}
static STATUS hid96(PRECC_DATA* self) {
PARSER hid94, hid95;
return p_andparse0n (self,TOPARSER hid94,0,TOPARSER hid95,0);
}
static VOID hid97(PRECC_DATA* self) {
VV(10) = P_REN(V(5),V(9));countcount=0;RESET;
}
static STATUS hid98(PRECC_DATA* self) {
PARSER hid96;ACTION hid97;
return p_attach0n(self,TOPARSER hid96,0,hid97,0);
}
static STATUS hid99(PRECC_DATA* self) {
PARSER hid98, p_nothing0;
return p_andparse0n (self,TOPARSER hid98,0,TOPARSER p_nothing0,0);
}
static VOID hid100(PRECC_DATA* self) {
printf("P_END\n");
}
static STATUS hid101(PRECC_DATA* self) {
PARSER hid99;ACTION hid100;
return p_attach0n(self,TOPARSER hid99,0,hid100,0);
}
static STATUS hid102(PRECC_DATA* self) {
PARSER hid101, p_nothing0;
return p_andparse0n (self,TOPARSER hid101,0,TOPARSER p_nothing0,0);
}
STATUS declaration(PRECC_DATA* self) {
PARSER hid102;
P_RETURN((TOPARSER hid102)(self),"declaration");
}
P_END

void ADDVAR(char *x)
/* make a new environment with one more var. save the old. */
{
  char *n;
                 /* finish off current env */
  getargs(&n);
  getmeta(&n);
                 /* copy old to new - start by buffering it */
  putargs(environment);
  putmeta(plainenv);
                 /* increment env count */
  pushenv();
                 /* point env at buffer */
  environment=putargs("");
  plainenv=putmeta("");
                 /* add new var */

  if (is_in(x,plainenv))
      return;    /* unless already there */

  if(*environment){
    putargs(",");
    putmeta(",");
  }
  putargs("VALUE ");  /* this is a special kind of new variable */
  putargs(x);
  putmeta(x);
                 /* note that the buffer is still unterminated */
}



/* to make #line references to definitions immediately before the
   STATUS foo line in the emitted code, insert P_LINE; before the
   VV above */

P_BEGIN
static STATUS hid103(PRECC_DATA* self) {
PARSER printdeclerr, passthrough;
return p_andparse0n (self,TOPARSER printdeclerr,0,TOPARSER passthrough,0);
}
static VOID hid104(PRECC_DATA* self) {
VV(2)=V(1);
}
static STATUS hid105(PRECC_DATA* self) {
PARSER hid103;ACTION hid104;
return p_attach0n(self,TOPARSER hid103,0,hid104,0);
}
static STATUS hid106(PRECC_DATA* self) {
PARSER hid105, p_nothing0;
return p_andparse0n (self,TOPARSER hid105,0,TOPARSER p_nothing0,0);
}
STATUS declerr(PRECC_DATA* self) {
PARSER hid106;
P_RETURN((TOPARSER hid106)(self),"declerr");
}
P_END

P_BEGIN
static VOID hid107(PRECC_DATA* self) {
VV(0)="@";
                 fprintf(stderr,"line %d error: malformed declaration\n@?",*self->yylinenop); 
}
static STATUS hid108(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid107;
return p_attach0n(self,TOPARSER p_nothing0,0,hid107,0);
}
static STATUS hid109(PRECC_DATA* self) {
PARSER hid108, p_nothing0;
return p_andparse0n (self,TOPARSER hid108,0,TOPARSER p_nothing0,0);
}
STATUS printdeclerr(PRECC_DATA* self) {
PARSER hid109;
P_RETURN((TOPARSER hid109)(self),"printdeclerr");
}
P_END

                /* that was it. Now the top level (MAIN) parse. */

P_BEGIN
static STATUS hid110(PRECC_DATA* self) {
PARSER notanat, passthrough;
return p_andparse0n (self,TOPARSER notanat,0,TOPARSER passthrough,0);
}
static VOID hid111(PRECC_DATA* self) {
VV(0)="";printf("\n");
}
static STATUS hid112(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid111;
return p_attach0n(self,TOPARSER p_nothing0,0,hid111,0);
}
static STATUS hid113(PRECC_DATA* self) {
PARSER hid112, p_nothing0;
return p_andparse0n (self,TOPARSER hid112,0,TOPARSER p_nothing0,0);
}
static STATUS hid114 (PRECC_DATA* self) {
PARSER hid110, hid113;
return p_orparse0n (self,TOPARSER hid110,0,TOPARSER hid113,0);
}
static STATUS hid115 (PRECC_DATA* self) {
PARSER declaration, hid114;
return p_orparse0n (self,TOPARSER declaration,0,TOPARSER hid114,0);
}
STATUS line(PRECC_DATA* self) {
PARSER hid115;
P_RETURN((TOPARSER hid115)(self),"line");
}
P_END

P_BEGIN
static VOID hid116(PRECC_DATA* self) {
 VV(1)=putchar(T(1)); 
}
static STATUS hid117(PRECC_DATA* self) {
PARSER NOTANAT;ACTION hid116;
return p_attach0n(self,TOPARSER NOTANAT,0,hid116,0);
}
static STATUS hid118(PRECC_DATA* self) {
PARSER hid117, p_nothing0;
return p_andparse0n (self,TOPARSER hid117,0,TOPARSER p_nothing0,0);
}
STATUS notanat(PRECC_DATA* self) {
PARSER hid118;
P_RETURN((TOPARSER hid118)(self),"notanat");
}
P_END

/* this is a deliberate pop of the value 'behind'  if we get none */

P_BEGIN
static VOID hid119(PRECC_DATA* self) {
 VV(2)=V(1); 
}
static STATUS hid120(PRECC_DATA* self) {
PARSER anychar;ACTION hid119;
return p_attach0n(self,TOPARSER anychar,0,hid119,0);
}
static STATUS hid121(PRECC_DATA* self) {
PARSER hid120, p_nothing0;
return p_andparse0n (self,TOPARSER hid120,0,TOPARSER p_nothing0,0);
}
static STATUS hid122(PRECC_DATA* self) {
PARSER hid121;
return p_many0n(self,TOPARSER hid121,0);
}
static VOID hid123(PRECC_DATA* self) {
getname(&V(1));printf("%s\n",V(1)); RESET;
}
static STATUS hid124(PRECC_DATA* self) {
PARSER hid122;ACTION hid123;
return p_attach0n(self,TOPARSER hid122,0,hid123,0);
}
static STATUS hid125(PRECC_DATA* self) {
PARSER hid124, p_nothing0;
return p_andparse0n (self,TOPARSER hid124,0,TOPARSER p_nothing0,0);
}
STATUS passthrough(PRECC_DATA* self) {
PARSER hid125;
P_RETURN((TOPARSER hid125)(self),"passthrough");
}
P_END

P_BEGIN
static VOID hid126(PRECC_DATA* self) {
 VV(1)=putchar(T(1)); 
}
static STATUS hid127(PRECC_DATA* self) {
PARSER ANYTHING;ACTION hid126;
return p_attach0n(self,TOPARSER ANYTHING,0,hid126,0);
}
static STATUS hid128(PRECC_DATA* self) {
PARSER hid127, p_nothing0;
return p_andparse0n (self,TOPARSER hid127,0,TOPARSER p_nothing0,0);
}
STATUS anychar(PRECC_DATA* self) {
PARSER hid128;
P_RETURN((TOPARSER hid128)(self),"anychar");
}
P_END

                /* ----  parser expressions -------- */

P_BEGIN
static STATUS hid129 (PRECC_DATA* self) {
PARSER alternates, empty;
return p_orparse0n (self,TOPARSER alternates,0,TOPARSER empty,0);
}
STATUS expression(PRECC_DATA* self) {
PARSER hid129;
P_RETURN((TOPARSER hid129)(self),"expression");
}
P_END

/* a <'|'> separated series, at least one <'|'>  - note the overpull 
   I prefer the order which results from recursion */

P_BEGIN
static STATUS hid130(PRECC_DATA* self) {
PARSER WHITESPACE, alternates;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER alternates,0);
}
static STATUS hid131(PRECC_DATA* self) {
PARSER OR, hid130;
return p_andparse0n (self,TOPARSER OR,0,TOPARSER hid130,0);
}
static STATUS hid132(PRECC_DATA* self) {
PARSER WHITESPACE, hid131;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid131,0);
}
static VOID hid133(PRECC_DATA* self) {
char *n;
                 VV(5)=(GETNEWNAME(&n,plainenv),P_ALT(n,V(1),V(5)));
}
static STATUS hid134(PRECC_DATA* self) {
PARSER hid132;ACTION hid133;
return p_attach0n(self,TOPARSER hid132,0,hid133,0);
}
static STATUS hid135(PRECC_DATA* self) {
PARSER hid134, p_nothing0;
return p_andparse0n (self,TOPARSER hid134,0,TOPARSER p_nothing0,0);
}
static STATUS hid136(PRECC_DATA* self) {
PARSER hid135;
return p_option0n(self,TOPARSER hid135,0);
}
static STATUS hid137(PRECC_DATA* self) {
PARSER sequence, hid136;
return p_andparse0n (self,TOPARSER sequence,0,TOPARSER hid136,0);
}
STATUS alternates(PRECC_DATA* self) {
PARSER hid137;
P_RETURN((TOPARSER hid137)(self),"alternates");
}
P_END

/* appending is much more efficient than prepending because I don't waste
  C-stack space with MARK before a parse */

/* this is a command separated sequence of sequents which are not commands
*/

P_BEGIN
static STATUS hid138(PRECC_DATA* self) {
PARSER WHITESPACE, manysequents;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER manysequents,0);
}
static STATUS hid139(PRECC_DATA* self) {
PARSER command, hid138;
return p_andparse0n (self,TOPARSER command,0,TOPARSER hid138,0);
}
static STATUS hid140(PRECC_DATA* self) {
PARSER WHITESPACE, hid139;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid139,0);
}
static VOID hid141(PRECC_DATA* self) {
char *n;
                  VV(3)=(GETNEWNAME(&n,plainenv),P_AND(n,V(1),V(3)));
}
static STATUS hid142(PRECC_DATA* self) {
PARSER hid140;ACTION hid141;
return p_attach0n(self,TOPARSER hid140,0,hid141,0);
}
static STATUS hid143(PRECC_DATA* self) {
PARSER hid142, p_nothing0;
return p_andparse0n (self,TOPARSER hid142,0,TOPARSER p_nothing0,0);
}
static STATUS hid144(PRECC_DATA* self) {
PARSER hid143;
return p_many0n(self,TOPARSER hid143,0);
}
static STATUS hid145(PRECC_DATA* self) {
PARSER WHITESPACE, command;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER command,0);
}
static STATUS hid146(PRECC_DATA* self) {
PARSER hid145;
return p_option0n(self,TOPARSER hid145,0);
}
static STATUS hid147(PRECC_DATA* self) {
PARSER hid144, hid146;
return p_andparse0n (self,TOPARSER hid144,0,TOPARSER hid146,0);
}
static STATUS hid148(PRECC_DATA* self) {
PARSER manysequents, hid147;
return p_andparse0n (self,TOPARSER manysequents,0,TOPARSER hid147,0);
}
STATUS sequence(PRECC_DATA* self) {
PARSER hid148;
P_RETURN((TOPARSER hid148)(self),"sequence");
}
P_END

 /* here we attach to the manysequents which this follows */

P_BEGIN
static STATUS hid149(PRECC_DATA* self) {
PARSER c_code, COLONorEOL;
return p_andparse0n (self,TOPARSER c_code,0,TOPARSER COLONorEOL,0);
}
static STATUS hid150(PRECC_DATA* self) {
PARSER COLON, hid149;
return p_andparse0n (self,TOPARSER COLON,0,TOPARSER hid149,0);
}
static VOID hid151(PRECC_DATA* self) {
 char *n,*m;
             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,V(1),n,V(4))); 
}
static STATUS hid152(PRECC_DATA* self) {
PARSER hid150;ACTION hid151;
return p_attach0n(self,TOPARSER hid150,0,hid151,0);
}
static STATUS hid153(PRECC_DATA* self) {
PARSER hid152, p_nothing0;
return p_andparse0n (self,TOPARSER hid152,0,TOPARSER p_nothing0,0);
}
STATUS command(PRECC_DATA* self) {
PARSER hid153;
P_RETURN((TOPARSER hid153)(self),"command");
}
P_END

P_BEGIN
static STATUS hid154(PRECC_DATA* self) {
PARSER COLON, CLOSEBRACE;
return p_andparse0n (self,TOPARSER COLON,0,TOPARSER CLOSEBRACE,0);
}
static STATUS hid155(PRECC_DATA* self) {
PARSER c_code1, hid154;
return p_andparse0n (self,TOPARSER c_code1,0,TOPARSER hid154,0);
}
static STATUS hid156(PRECC_DATA* self) {
PARSER COLON, hid155;
return p_andparse0n (self,TOPARSER COLON,0,TOPARSER hid155,0);
}
static STATUS hid157(PRECC_DATA* self) {
PARSER OPENBRACE, hid156;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid156,0);
}
static VOID hid158(PRECC_DATA* self) {
 char *n,*m;
             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,"p_nothing0",n,V(3))); 
}
static STATUS hid159(PRECC_DATA* self) {
PARSER hid157;ACTION hid158;
return p_attach0n(self,TOPARSER hid157,0,hid158,0);
}
static STATUS hid160(PRECC_DATA* self) {
PARSER hid159, p_nothing0;
return p_andparse0n (self,TOPARSER hid159,0,TOPARSER p_nothing0,0);
}
static STATUS hid161(PRECC_DATA* self) {
PARSER CLOSEBRACE, COLON;
return p_andparse0n (self,TOPARSER CLOSEBRACE,0,TOPARSER COLON,0);
}
static STATUS hid162(PRECC_DATA* self) {
PARSER c_code2, hid161;
return p_andparse0n (self,TOPARSER c_code2,0,TOPARSER hid161,0);
}
static STATUS hid163(PRECC_DATA* self) {
PARSER OPENBRACE, hid162;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid162,0);
}
static STATUS hid164(PRECC_DATA* self) {
PARSER COLON, hid163;
return p_andparse0n (self,TOPARSER COLON,0,TOPARSER hid163,0);
}
static VOID hid165(PRECC_DATA* self) {
 char *n,*m;
             VV(5)=(GETNEWNAME(&n,plainenv),GETNEWNAME(&m,plainenv),P_ATT(m,"p_nothing0",n,V(3))); 
}
static STATUS hid166(PRECC_DATA* self) {
PARSER hid164;ACTION hid165;
return p_attach0n(self,TOPARSER hid164,0,hid165,0);
}
static STATUS hid167(PRECC_DATA* self) {
PARSER hid166, p_nothing0;
return p_andparse0n (self,TOPARSER hid166,0,TOPARSER p_nothing0,0);
}
static STATUS hid168 (PRECC_DATA* self) {
PARSER hid160, hid167;
return p_orparse0n (self,TOPARSER hid160,0,TOPARSER hid167,0);
}
STATUS bracketcommand(PRECC_DATA* self) {
PARSER hid168;
P_RETURN((TOPARSER hid168)(self),"bracketcommand");
}
P_END

/* manysequents is a 0 or more long list of nonempty non-commands */

/* start a new count */

/* do the pulling in moresequents, if it happens */

P_BEGIN
static STATUS hid169(PRECC_DATA* self) {
PARSER moresequents;
return p_option0n(self,TOPARSER moresequents,0);
}
static STATUS hid170(PRECC_DATA* self) {
PARSER firstsequent, hid169;
return p_andparse0n (self,TOPARSER firstsequent,0,TOPARSER hid169,0);
}
static VOID hid171(PRECC_DATA* self) {
 popcount();
}
static STATUS hid172(PRECC_DATA* self) {
PARSER hid170;ACTION hid171;
return p_attach0n(self,TOPARSER hid170,0,hid171,0);
}
static STATUS hid173(PRECC_DATA* self) {
PARSER hid172, p_nothing0;
return p_andparse0n (self,TOPARSER hid172,0,TOPARSER p_nothing0,0);
}
STATUS manysequents(PRECC_DATA* self) {
PARSER hid173;
P_RETURN((TOPARSER hid173)(self),"manysequents");
}
P_END

/* need "empty newvar empty" and "sequent newvar empty" to make the
   above complete, but it's too much bother right now */

P_BEGIN
static STATUS hid174 (PRECC_DATA* self) {
PARSER sequent, empty;
return p_orparse0n (self,TOPARSER sequent,0,TOPARSER empty,0);
}
static VOID hid175(PRECC_DATA* self) {
pushcount();
}
static STATUS hid176(PRECC_DATA* self) {
PARSER hid174;ACTION hid175;
return p_attach0n(self,TOPARSER hid174,0,hid175,0);
}
static STATUS hid177(PRECC_DATA* self) {
PARSER hid176, p_nothing0;
return p_andparse0n (self,TOPARSER hid176,0,TOPARSER p_nothing0,0);
}
STATUS firstsequent(PRECC_DATA* self) {
PARSER hid177;
P_RETURN((TOPARSER hid177)(self),"firstsequent");
}
P_END


        /* overpull again in the option 
           again, I prefer to use recursion for better output order */

/* without a parameterized spec, I can't prevent repetitions */

P_BEGIN
static STATUS hid178(PRECC_DATA* self) {
PARSER BACKSLASH, IDENTIFIER;
return p_andparse0n (self,TOPARSER BACKSLASH,0,TOPARSER IDENTIFIER,0);
}
static VOID hid179(PRECC_DATA* self) {
VV(2)=V(2);getname(&V(2));ADDVAR(V(2));
}
static STATUS hid180(PRECC_DATA* self) {
PARSER hid178;ACTION hid179;
return p_attach0n(self,TOPARSER hid178,0,hid179,0);
}
static STATUS hid181(PRECC_DATA* self) {
PARSER hid180, p_nothing0;
return p_andparse0n (self,TOPARSER hid180,0,TOPARSER p_nothing0,0);
}
STATUS newvar(PRECC_DATA* self) {
PARSER hid181;
P_RETURN((TOPARSER hid181)(self),"newvar");
}
P_END

/* moresequents is a 1 or more long list of sequents, or an attr decl
 * followed by a 1 or more long list. It is not empty. It is not
 * (presently) a newvar on its own, though it might eventually be */

P_BEGIN
static STATUS hid182(PRECC_DATA* self) {
PARSER moresequents;
return p_option0n(self,TOPARSER moresequents,0);
}
static STATUS hid183(PRECC_DATA* self) {
PARSER sequent, hid182;
return p_andparse0n (self,TOPARSER sequent,0,TOPARSER hid182,0);
}
static STATUS hid184(PRECC_DATA* self) {
PARSER WHITESPACE, hid183;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid183,0);
}
static STATUS hid185(PRECC_DATA* self) {
PARSER newvar, hid184;
return p_andparse0n (self,TOPARSER newvar,0,TOPARSER hid184,0);
}
static VOID hid186(PRECC_DATA* self) {
 char *n; VV(4)=V(1);popenv();
          GETNEWNAME(&n,plainenv);V(1)=P_STAR(n,V(1),V(4),V(2));
}
static STATUS hid187(PRECC_DATA* self) {
PARSER hid185;ACTION hid186;
return p_attach0n(self,TOPARSER hid185,0,hid186,0);
}
static STATUS hid188(PRECC_DATA* self) {
PARSER hid187, p_nothing0;
return p_andparse0n (self,TOPARSER hid187,0,TOPARSER p_nothing0,0);
}
static STATUS hid189(PRECC_DATA* self) {
PARSER moresequents;
return p_option0n(self,TOPARSER moresequents,0);
}
static STATUS hid190(PRECC_DATA* self) {
PARSER sequent, hid189;
return p_andparse0n (self,TOPARSER sequent,0,TOPARSER hid189,0);
}
static STATUS hid191(PRECC_DATA* self) {
PARSER WHITESPACE, hid190;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid190,0);
}
static STATUS hid192(PRECC_DATA* self) {
PARSER dummyvar, hid191;
return p_andparse0n (self,TOPARSER dummyvar,0,TOPARSER hid191,0);
}
static VOID hid193(PRECC_DATA* self) {
 char *n; VV(4)=V(1);
          if (self->oldattributes){popenv();
          GETNEWNAME(&n,plainenv);V(1)=P_STAR(n,V(1),V(4),V(2));}
          else{
          GETNEWNAME(&n,plainenv);V(1)=P_AND(n,V(1),V(4));}
}
static STATUS hid194(PRECC_DATA* self) {
PARSER hid192;ACTION hid193;
return p_attach0n(self,TOPARSER hid192,0,hid193,0);
}
static STATUS hid195(PRECC_DATA* self) {
PARSER hid194, p_nothing0;
return p_andparse0n (self,TOPARSER hid194,0,TOPARSER p_nothing0,0);
}
static STATUS hid196 (PRECC_DATA* self) {
PARSER hid188, hid195;
return p_orparse0n (self,TOPARSER hid188,0,TOPARSER hid195,0);
}
STATUS moresequents(PRECC_DATA* self) {
PARSER hid196;
P_RETURN((TOPARSER hid196)(self),"moresequents");
}
P_END

/* in the above, have to be careful to avoid allowing a trailing "empty"
   because that wrecks the returned value from an @foo@ */

P_BEGIN
static VOID hid197(PRECC_DATA* self) {
/*empty*/ VV(0)=V(1);
             if(self->oldattributes){
             getname(&V(1));
             GETANAME(&V(1),"p_","",count++);
             V(1)=GNAME(V(1));putname(V(1));
             getname(&V(1));
             ADDVAR(V(1)); }
}
static STATUS hid198(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid197;
return p_attach0n(self,TOPARSER p_nothing0,0,hid197,0);
}
static STATUS hid199(PRECC_DATA* self) {
PARSER hid198, p_nothing0;
return p_andparse0n (self,TOPARSER hid198,0,TOPARSER p_nothing0,0);
}
STATUS dummyvar(PRECC_DATA* self) {
PARSER hid199;
P_RETURN((TOPARSER hid199)(self),"dummyvar");
}
P_END
        /* Don't overpull now because ... */

P_BEGIN
static STATUS hid200(PRECC_DATA* self) {
PARSER postfix;
return p_option0n(self,TOPARSER postfix,0);
}
static STATUS hid201(PRECC_DATA* self) {
PARSER seqoperand, hid200;
return p_andparse0n (self,TOPARSER seqoperand,0,TOPARSER hid200,0);
}
STATUS sequent(PRECC_DATA* self) {
PARSER hid201;
P_RETURN((TOPARSER hid201)(self),"sequent");
}
P_END

        /* in each of these cases the postfix must behave as though the
        seqoperand were before it and overpull its arguments and write into
        the stack position to the left of itself */


P_BEGIN
static STATUS hid202 (PRECC_DATA* self) {
PARSER plusop, hideop;
return p_orparse0n (self,TOPARSER plusop,0,TOPARSER hideop,0);
}
static STATUS hid203 (PRECC_DATA* self) {
PARSER starop, hid202;
return p_orparse0n (self,TOPARSER starop,0,TOPARSER hid202,0);
}
STATUS postfix(PRECC_DATA* self) {
PARSER hid203;
P_RETURN((TOPARSER hid203)(self),"postfix");
}
P_END

P_BEGIN
static STATUS hid204(PRECC_DATA* self) {
PARSER WHITESPACE, CLOSEBRACE;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER CLOSEBRACE,0);
}
static STATUS hid205(PRECC_DATA* self) {
PARSER expression, hid204;
return p_andparse0n (self,TOPARSER expression,0,TOPARSER hid204,0);
}
static STATUS hid206(PRECC_DATA* self) {
PARSER WHITESPACE, hid205;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid205,0);
}
static STATUS hid207(PRECC_DATA* self) {
PARSER OPENBRACE, hid206;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid206,0);
}
static VOID hid208(PRECC_DATA* self) {
 VV(5) = V(3); 
}
static STATUS hid209(PRECC_DATA* self) {
PARSER hid207;ACTION hid208;
return p_attach0n(self,TOPARSER hid207,0,hid208,0);
}
static STATUS hid210(PRECC_DATA* self) {
PARSER hid209, p_nothing0;
return p_andparse0n (self,TOPARSER hid209,0,TOPARSER p_nothing0,0);
}
STATUS bracket(PRECC_DATA* self) {
PARSER hid210;
P_RETURN((TOPARSER hid210)(self),"bracket");
}
P_END

P_BEGIN
static STATUS hid211(PRECC_DATA* self) {
PARSER WHITESPACE, CLOSEBRACKET;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER CLOSEBRACKET,0);
}
static STATUS hid212(PRECC_DATA* self) {
PARSER expression, hid211;
return p_andparse0n (self,TOPARSER expression,0,TOPARSER hid211,0);
}
static STATUS hid213(PRECC_DATA* self) {
PARSER WHITESPACE, hid212;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid212,0);
}
static STATUS hid214(PRECC_DATA* self) {
PARSER OPENBRACKET, hid213;
return p_andparse0n (self,TOPARSER OPENBRACKET,0,TOPARSER hid213,0);
}
static VOID hid215(PRECC_DATA* self) {
 char *n;VV(5)=(GETNEWNAME(&n,plainenv),P_OPT(n,V(3))); 
}
static STATUS hid216(PRECC_DATA* self) {
PARSER hid214;ACTION hid215;
return p_attach0n(self,TOPARSER hid214,0,hid215,0);
}
static STATUS hid217(PRECC_DATA* self) {
PARSER hid216, p_nothing0;
return p_andparse0n (self,TOPARSER hid216,0,TOPARSER p_nothing0,0);
}
STATUS option(PRECC_DATA* self) {
PARSER hid217;
P_RETURN((TOPARSER hid217)(self),"option");
}
P_END

P_BEGIN
static VOID hid218(PRECC_DATA* self) {
 VV(0)= "p_nothing0"; 
}
static STATUS hid219(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid218;
return p_attach0n(self,TOPARSER p_nothing0,0,hid218,0);
}
static STATUS hid220(PRECC_DATA* self) {
PARSER hid219, p_nothing0;
return p_andparse0n (self,TOPARSER hid219,0,TOPARSER p_nothing0,0);
}
STATUS empty(PRECC_DATA* self) {
PARSER hid220;
P_RETURN((TOPARSER hid220)(self),"empty");
}
P_END


P_BEGIN
static STATUS hid221(PRECC_DATA* self) {
PARSER WHITESPACE, AT;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER AT,0);
}
static STATUS hid222(PRECC_DATA* self) {
PARSER expr, hid221;
return p_andparse0n (self,TOPARSER expr,0,TOPARSER hid221,0);
}
static STATUS hid223(PRECC_DATA* self) {
PARSER WHITESPACE, hid222;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid222,0);
}
static STATUS hid224(PRECC_DATA* self) {
PARSER AT, hid223;
return p_andparse0n (self,TOPARSER AT,0,TOPARSER hid223,0);
}
static VOID hid225(PRECC_DATA* self) {
char *n; VV(5)=(getname(&V(3)),
                  GETNEWNAME(&n,plainenv),P_ATA(n,V(3))); 
}
static STATUS hid226(PRECC_DATA* self) {
PARSER hid224;ACTION hid225;
return p_attach0n(self,TOPARSER hid224,0,hid225,0);
}
static STATUS hid227(PRECC_DATA* self) {
PARSER hid226, p_nothing0;
return p_andparse0n (self,TOPARSER hid226,0,TOPARSER p_nothing0,0);
}
STATUS result(PRECC_DATA* self) {
PARSER hid227;
P_RETURN((TOPARSER hid227)(self),"result");
}
P_END

P_BEGIN
static STATUS hid228(PRECC_DATA* self) {
PARSER AT, CLOSEBRACE;
return p_andparse0n (self,TOPARSER AT,0,TOPARSER CLOSEBRACE,0);
}
static STATUS hid229(PRECC_DATA* self) {
PARSER WHITESPACE, hid228;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid228,0);
}
static STATUS hid230(PRECC_DATA* self) {
PARSER atstuffs, hid229;
return p_andparse0n (self,TOPARSER atstuffs,0,TOPARSER hid229,0);
}
static STATUS hid231(PRECC_DATA* self) {
PARSER WHITESPACE, hid230;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid230,0);
}
static STATUS hid232(PRECC_DATA* self) {
PARSER AT, hid231;
return p_andparse0n (self,TOPARSER AT,0,TOPARSER hid231,0);
}
static STATUS hid233(PRECC_DATA* self) {
PARSER OPENBRACE, hid232;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid232,0);
}
static VOID hid234(PRECC_DATA* self) {
char *n; VV(7)=(getname(&V(4)),
                  GETNEWNAME(&n,plainenv),P_ATA(n,V(4))); 
}
static STATUS hid235(PRECC_DATA* self) {
PARSER hid233;ACTION hid234;
return p_attach0n(self,TOPARSER hid233,0,hid234,0);
}
static STATUS hid236(PRECC_DATA* self) {
PARSER hid235, p_nothing0;
return p_andparse0n (self,TOPARSER hid235,0,TOPARSER p_nothing0,0);
}
static STATUS hid237(PRECC_DATA* self) {
PARSER CLOSEBRACE, AT;
return p_andparse0n (self,TOPARSER CLOSEBRACE,0,TOPARSER AT,0);
}
static STATUS hid238(PRECC_DATA* self) {
PARSER WHITESPACE, hid237;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid237,0);
}
static STATUS hid239(PRECC_DATA* self) {
PARSER aatstuffs, hid238;
return p_andparse0n (self,TOPARSER aatstuffs,0,TOPARSER hid238,0);
}
static STATUS hid240(PRECC_DATA* self) {
PARSER WHITESPACE, hid239;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid239,0);
}
static STATUS hid241(PRECC_DATA* self) {
PARSER OPENBRACE, hid240;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid240,0);
}
static STATUS hid242(PRECC_DATA* self) {
PARSER AT, hid241;
return p_andparse0n (self,TOPARSER AT,0,TOPARSER hid241,0);
}
static VOID hid243(PRECC_DATA* self) {
char *n; VV(7)=(getname(&V(4)),
                  GETNEWNAME(&n,plainenv),P_ATA(n,V(4))); 
}
static STATUS hid244(PRECC_DATA* self) {
PARSER hid242;ACTION hid243;
return p_attach0n(self,TOPARSER hid242,0,hid243,0);
}
static STATUS hid245(PRECC_DATA* self) {
PARSER hid244, p_nothing0;
return p_andparse0n (self,TOPARSER hid244,0,TOPARSER p_nothing0,0);
}
static STATUS hid246 (PRECC_DATA* self) {
PARSER hid236, hid245;
return p_orparse0n (self,TOPARSER hid236,0,TOPARSER hid245,0);
}
STATUS bracketresult(PRECC_DATA* self) {
PARSER hid246;
P_RETURN((TOPARSER hid246)(self),"bracketresult");
}
P_END


                /* here is one overpull */

int starflag=0;
char *starqual;

/* can't allow "a * n" because it can't be distinguished from "a* b" */

P_BEGIN
static VOID hid247(PRECC_DATA* self) {
starflag=1;VV(2)=(getname(&V(2)),V(2));
}
static STATUS hid248(PRECC_DATA* self) {
PARSER expr;ACTION hid247;
return p_attach0n(self,TOPARSER expr,0,hid247,0);
}
static STATUS hid249(PRECC_DATA* self) {
PARSER hid248, p_nothing0;
return p_andparse0n (self,TOPARSER hid248,0,TOPARSER p_nothing0,0);
}
static STATUS hid250(PRECC_DATA* self) {
PARSER hid249;
return p_option0n(self,TOPARSER hid249,0);
}
static STATUS hid251(PRECC_DATA* self) {
PARSER STAR, hid250;
return p_andparse0n (self,TOPARSER STAR,0,TOPARSER hid250,0);
}
static VOID hid252(PRECC_DATA* self) {
 char *n;if(starflag){
                  VV(2)=(GETNEWNAME(&n,plainenv),P_ITR(n,V(1),V(3))); 
                  }  else {
                  VV(2)=(GETNEWNAME(&n,plainenv),P_INF(n,V(1)));
                  }  starflag=0; 
}
static STATUS hid253(PRECC_DATA* self) {
PARSER hid251;ACTION hid252;
return p_attach0n(self,TOPARSER hid251,0,hid252,0);
}
static STATUS hid254(PRECC_DATA* self) {
PARSER hid253, p_nothing0;
return p_andparse0n (self,TOPARSER hid253,0,TOPARSER p_nothing0,0);
}
STATUS starop(PRECC_DATA* self) {
PARSER hid254;
P_RETURN((TOPARSER hid254)(self),"starop");
}
P_END

P_BEGIN
static VOID hid255(PRECC_DATA* self) {
 VV(1)="p_anything0"; 
}
static STATUS hid256(PRECC_DATA* self) {
PARSER QUESTION;ACTION hid255;
return p_attach0n(self,TOPARSER QUESTION,0,hid255,0);
}
static STATUS hid257(PRECC_DATA* self) {
PARSER hid256, p_nothing0;
return p_andparse0n (self,TOPARSER hid256,0,TOPARSER p_nothing0,0);
}
STATUS anymatch(PRECC_DATA* self) {
PARSER hid257;
P_RETURN((TOPARSER hid257)(self),"anymatch");
}
P_END

/* recall that exprnames get saved in the cbuff */


P_BEGIN
static STATUS hid258 (PRECC_DATA* self) {
PARSER plingmatch, exprname;
return p_orparse0n (self,TOPARSER plingmatch,0,TOPARSER exprname,0);
}
static STATUS hid259 (PRECC_DATA* self) {
PARSER plingexpr, hid258;
return p_orparse0n (self,TOPARSER plingexpr,0,TOPARSER hid258,0);
}
static STATUS hid260 (PRECC_DATA* self) {
PARSER finishmatch, hid259;
return p_orparse0n (self,TOPARSER finishmatch,0,TOPARSER hid259,0);
}
static STATUS hid261 (PRECC_DATA* self) {
PARSER dollarplingmatch, hid260;
return p_orparse0n (self,TOPARSER dollarplingmatch,0,TOPARSER hid260,0);
}
static STATUS hid262 (PRECC_DATA* self) {
PARSER eofmatch, hid261;
return p_orparse0n (self,TOPARSER eofmatch,0,TOPARSER hid261,0);
}
static STATUS hid263 (PRECC_DATA* self) {
PARSER beginmatch, hid262;
return p_orparse0n (self,TOPARSER beginmatch,0,TOPARSER hid262,0);
}
static STATUS hid264 (PRECC_DATA* self) {
PARSER anymatch, hid263;
return p_orparse0n (self,TOPARSER anymatch,0,TOPARSER hid263,0);
}
static STATUS hid265 (PRECC_DATA* self) {
PARSER result, hid264;
return p_orparse0n (self,TOPARSER result,0,TOPARSER hid264,0);
}
static STATUS hid266 (PRECC_DATA* self) {
PARSER phantom, hid265;
return p_orparse0n (self,TOPARSER phantom,0,TOPARSER hid265,0);
}
static STATUS hid267 (PRECC_DATA* self) {
PARSER test, hid266;
return p_orparse0n (self,TOPARSER test,0,TOPARSER hid266,0);
}
static STATUS hid268 (PRECC_DATA* self) {
PARSER range, hid267;
return p_orparse0n (self,TOPARSER range,0,TOPARSER hid267,0);
}
static STATUS hid269 (PRECC_DATA* self) {
PARSER antiliteral, hid268;
return p_orparse0n (self,TOPARSER antiliteral,0,TOPARSER hid268,0);
}
static STATUS hid270 (PRECC_DATA* self) {
PARSER literal, hid269;
return p_orparse0n (self,TOPARSER literal,0,TOPARSER hid269,0);
}
static STATUS hid271 (PRECC_DATA* self) {
PARSER option, hid270;
return p_orparse0n (self,TOPARSER option,0,TOPARSER hid270,0);
}
static STATUS hid272 (PRECC_DATA* self) {
PARSER bracket, hid271;
return p_orparse0n (self,TOPARSER bracket,0,TOPARSER hid271,0);
}
static STATUS hid273 (PRECC_DATA* self) {
PARSER brackettest, hid272;
return p_orparse0n (self,TOPARSER brackettest,0,TOPARSER hid272,0);
}
static STATUS hid274 (PRECC_DATA* self) {
PARSER bracketresult, hid273;
return p_orparse0n (self,TOPARSER bracketresult,0,TOPARSER hid273,0);
}
static STATUS hid275 (PRECC_DATA* self) {
PARSER bracketcommand, hid274;
return p_orparse0n (self,TOPARSER bracketcommand,0,TOPARSER hid274,0);
}
STATUS seqoperand(PRECC_DATA* self) {
PARSER hid275;
P_RETURN((TOPARSER hid275)(self),"seqoperand");
}
P_END


P_BEGIN
static STATUS hid276(PRECC_DATA* self) {
PARSER PLING, bracket;
return p_andparse0n (self,TOPARSER PLING,0,TOPARSER bracket,0);
}
static VOID hid277(PRECC_DATA* self) {
 char *n;   VV(2)=(GETNEWNAME(&n,plainenv),P_ERR(n,V(2))); 
}
static STATUS hid278(PRECC_DATA* self) {
PARSER hid276;ACTION hid277;
return p_attach0n(self,TOPARSER hid276,0,hid277,0);
}
static STATUS hid279(PRECC_DATA* self) {
PARSER hid278, p_nothing0;
return p_andparse0n (self,TOPARSER hid278,0,TOPARSER p_nothing0,0);
}
STATUS plingexpr(PRECC_DATA* self) {
PARSER hid279;
P_RETURN((TOPARSER hid279)(self),"plingexpr");
}
P_END

P_BEGIN
static STATUS hid280(PRECC_DATA* self) {
PARSER WHITESPACE, OPENBRACKET;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER OPENBRACKET,0);
}
static STATUS hid281(PRECC_DATA* self) {
PARSER expression, hid280;
return p_andparse0n (self,TOPARSER expression,0,TOPARSER hid280,0);
}
static STATUS hid282(PRECC_DATA* self) {
PARSER WHITESPACE, hid281;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid281,0);
}
static STATUS hid283(PRECC_DATA* self) {
PARSER CLOSEBRACKET, hid282;
return p_andparse0n (self,TOPARSER CLOSEBRACKET,0,TOPARSER hid282,0);
}
static VOID hid284(PRECC_DATA* self) {
char *n;VV(5)=(GETNEWNAME(&n,plainenv),P_PHA(n,V(3))); 
}
static STATUS hid285(PRECC_DATA* self) {
PARSER hid283;ACTION hid284;
return p_attach0n(self,TOPARSER hid283,0,hid284,0);
}
static STATUS hid286(PRECC_DATA* self) {
PARSER hid285, p_nothing0;
return p_andparse0n (self,TOPARSER hid285,0,TOPARSER p_nothing0,0);
}
STATUS phantom(PRECC_DATA* self) {
PARSER hid286;
P_RETURN((TOPARSER hid286)(self),"phantom");
}
P_END


/* ----------- subtokens of large "tokens" --------------------------- */

/* a literal is anything inside angle brackets.
 * an antiliteral is anything inside anti angle brackets.
 * anglebrackets inside may be escaped to protect them
 */

P_BEGIN
static VOID hid287(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid288(PRECC_DATA* self) {
PARSER NOTARIGHTANGLEBRACKET;ACTION hid287;
return p_attach0n(self,TOPARSER NOTARIGHTANGLEBRACKET,0,hid287,0);
}
static STATUS hid289(PRECC_DATA* self) {
PARSER hid288, p_nothing0;
return p_andparse0n (self,TOPARSER hid288,0,TOPARSER p_nothing0,0);
}
static STATUS hid290 (PRECC_DATA* self) {
PARSER COMMENT, hid289;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid289,0);
}
static STATUS hid291 (PRECC_DATA* self) {
PARSER DOLLARID, hid290;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid290,0);
}
static STATUS hid292 (PRECC_DATA* self) {
PARSER CHARCONST, hid291;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid291,0);
}
static STATUS hid293 (PRECC_DATA* self) {
PARSER STRING, hid292;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid292,0);
}
STATUS lstuff(PRECC_DATA* self) {
PARSER hid293;
P_RETURN((TOPARSER hid293)(self),"lstuff");
}
P_END

P_BEGIN
static VOID hid294(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid295(PRECC_DATA* self) {
PARSER NOTALEFTANGLEBRACKET;ACTION hid294;
return p_attach0n(self,TOPARSER NOTALEFTANGLEBRACKET,0,hid294,0);
}
static STATUS hid296(PRECC_DATA* self) {
PARSER hid295, p_nothing0;
return p_andparse0n (self,TOPARSER hid295,0,TOPARSER p_nothing0,0);
}
static STATUS hid297 (PRECC_DATA* self) {
PARSER COMMENT, hid296;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid296,0);
}
static STATUS hid298 (PRECC_DATA* self) {
PARSER DOLLARID, hid297;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid297,0);
}
static STATUS hid299 (PRECC_DATA* self) {
PARSER CHARCONST, hid298;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid298,0);
}
static STATUS hid300 (PRECC_DATA* self) {
PARSER STRING, hid299;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid299,0);
}
STATUS alstuff(PRECC_DATA* self) {
PARSER hid300;
P_RETURN((TOPARSER hid300)(self),"alstuff");
}
P_END

/* anything except (} */

P_BEGIN
static VOID hid301(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid302(PRECC_DATA* self) {
PARSER NOTANOPENPARBRACE;ACTION hid301;
return p_attach0n(self,TOPARSER NOTANOPENPARBRACE,0,hid301,0);
}
static STATUS hid303(PRECC_DATA* self) {
PARSER hid302, p_nothing0;
return p_andparse0n (self,TOPARSER hid302,0,TOPARSER p_nothing0,0);
}
static STATUS hid304 (PRECC_DATA* self) {
PARSER COMMENT, hid303;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid303,0);
}
static STATUS hid305 (PRECC_DATA* self) {
PARSER DOLLARID, hid304;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid304,0);
}
static STATUS hid306 (PRECC_DATA* self) {
PARSER CHARCONST, hid305;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid305,0);
}
static STATUS hid307 (PRECC_DATA* self) {
PARSER STRING, hid306;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid306,0);
}
STATUS tlstuff(PRECC_DATA* self) {
PARSER hid307;
P_RETURN((TOPARSER hid307)(self),"tlstuff");
}
P_END

/* anything except }( */

P_BEGIN
static VOID hid308(PRECC_DATA* self) {
 VV(1) = putchar(T(1)); 
}
static STATUS hid309(PRECC_DATA* self) {
PARSER NOTABRACEOPENPAR;ACTION hid308;
return p_attach0n(self,TOPARSER NOTABRACEOPENPAR,0,hid308,0);
}
static STATUS hid310(PRECC_DATA* self) {
PARSER hid309, p_nothing0;
return p_andparse0n (self,TOPARSER hid309,0,TOPARSER p_nothing0,0);
}
static STATUS hid311 (PRECC_DATA* self) {
PARSER COMMENT, hid310;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid310,0);
}
static STATUS hid312 (PRECC_DATA* self) {
PARSER DOLLARID, hid311;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid311,0);
}
static STATUS hid313 (PRECC_DATA* self) {
PARSER CHARCONST, hid312;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid312,0);
}
static STATUS hid314 (PRECC_DATA* self) {
PARSER STRING, hid313;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid313,0);
}
STATUS atlstuff(PRECC_DATA* self) {
PARSER hid314;
P_RETURN((TOPARSER hid314)(self),"atlstuff");
}
P_END

# define NLCONV(x) ((x)=='\b'?'\n':(x)) /* undo yylex \n->\b conversion */
# define NLCONV(x) ((x)=='\b'?'\n':(x)) /* undo yylex \n->\b conversion */

/* anything except @} */

P_BEGIN
static VOID hid315(PRECC_DATA* self) {
 VV(1) = putchar(NLCONV(T(1))); 
}
static STATUS hid316(PRECC_DATA* self) {
PARSER NOTANATBRACE;ACTION hid315;
return p_attach0n(self,TOPARSER NOTANATBRACE,0,hid315,0);
}
static STATUS hid317(PRECC_DATA* self) {
PARSER hid316, p_nothing0;
return p_andparse0n (self,TOPARSER hid316,0,TOPARSER p_nothing0,0);
}
static STATUS hid318 (PRECC_DATA* self) {
PARSER COMMENT, hid317;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid317,0);
}
static STATUS hid319 (PRECC_DATA* self) {
PARSER DOLLARID, hid318;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid318,0);
}
static STATUS hid320 (PRECC_DATA* self) {
PARSER CHARCONST, hid319;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid319,0);
}
static STATUS hid321 (PRECC_DATA* self) {
PARSER STRING, hid320;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid320,0);
}
STATUS atstuff(PRECC_DATA* self) {
PARSER hid321;
P_RETURN((TOPARSER hid321)(self),"atstuff");
}
P_END

/* anything except }@ */

P_BEGIN
static VOID hid322(PRECC_DATA* self) {
 VV(1) = putchar(NLCONV(T(1))); 
}
static STATUS hid323(PRECC_DATA* self) {
PARSER NOTABRACEAT;ACTION hid322;
return p_attach0n(self,TOPARSER NOTABRACEAT,0,hid322,0);
}
static STATUS hid324(PRECC_DATA* self) {
PARSER hid323, p_nothing0;
return p_andparse0n (self,TOPARSER hid323,0,TOPARSER p_nothing0,0);
}
static STATUS hid325 (PRECC_DATA* self) {
PARSER COMMENT, hid324;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid324,0);
}
static STATUS hid326 (PRECC_DATA* self) {
PARSER DOLLARID, hid325;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid325,0);
}
static STATUS hid327 (PRECC_DATA* self) {
PARSER CHARCONST, hid326;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid326,0);
}
static STATUS hid328 (PRECC_DATA* self) {
PARSER STRING, hid327;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid327,0);
}
STATUS aatstuff(PRECC_DATA* self) {
PARSER hid328;
P_RETURN((TOPARSER hid328)(self),"aatstuff");
}
P_END

/* anything except : */

P_BEGIN
static VOID hid329(PRECC_DATA* self) {
 VV(1) = putchar(NLCONV(T(1))); 
}
static STATUS hid330(PRECC_DATA* self) {
PARSER NOTACOLON;ACTION hid329;
return p_attach0n(self,TOPARSER NOTACOLON,0,hid329,0);
}
static STATUS hid331(PRECC_DATA* self) {
PARSER hid330, p_nothing0;
return p_andparse0n (self,TOPARSER hid330,0,TOPARSER p_nothing0,0);
}
static STATUS hid332 (PRECC_DATA* self) {
PARSER COMMENT, hid331;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid331,0);
}
static STATUS hid333 (PRECC_DATA* self) {
PARSER DOLLARID, hid332;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid332,0);
}
static STATUS hid334 (PRECC_DATA* self) {
PARSER CHARCONST, hid333;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid333,0);
}
static STATUS hid335 (PRECC_DATA* self) {
PARSER STRING, hid334;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid334,0);
}
STATUS cstuff(PRECC_DATA* self) {
PARSER hid335;
P_RETURN((TOPARSER hid335)(self),"cstuff");
}
P_END

/* anything except :} */

P_BEGIN
static VOID hid336(PRECC_DATA* self) {
 VV(1) = putchar(NLCONV(T(1))); 
}
static STATUS hid337(PRECC_DATA* self) {
PARSER NOTACOLONBRACE;ACTION hid336;
return p_attach0n(self,TOPARSER NOTACOLONBRACE,0,hid336,0);
}
static STATUS hid338(PRECC_DATA* self) {
PARSER hid337, p_nothing0;
return p_andparse0n (self,TOPARSER hid337,0,TOPARSER p_nothing0,0);
}
static STATUS hid339 (PRECC_DATA* self) {
PARSER COMMENT, hid338;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid338,0);
}
static STATUS hid340 (PRECC_DATA* self) {
PARSER DOLLARID, hid339;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid339,0);
}
static STATUS hid341 (PRECC_DATA* self) {
PARSER CHARCONST, hid340;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid340,0);
}
static STATUS hid342 (PRECC_DATA* self) {
PARSER STRING, hid341;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid341,0);
}
STATUS cstuff1(PRECC_DATA* self) {
PARSER hid342;
P_RETURN((TOPARSER hid342)(self),"cstuff1");
}
P_END

/* anything except }: */

P_BEGIN
static VOID hid343(PRECC_DATA* self) {
 VV(1) = putchar(NLCONV(T(1))); 
}
static STATUS hid344(PRECC_DATA* self) {
PARSER NOTABRACECOLON;ACTION hid343;
return p_attach0n(self,TOPARSER NOTABRACECOLON,0,hid343,0);
}
static STATUS hid345(PRECC_DATA* self) {
PARSER hid344, p_nothing0;
return p_andparse0n (self,TOPARSER hid344,0,TOPARSER p_nothing0,0);
}
static STATUS hid346 (PRECC_DATA* self) {
PARSER COMMENT, hid345;
return p_orparse0n (self,TOPARSER COMMENT,0,TOPARSER hid345,0);
}
static STATUS hid347 (PRECC_DATA* self) {
PARSER DOLLARID, hid346;
return p_orparse0n (self,TOPARSER DOLLARID,0,TOPARSER hid346,0);
}
static STATUS hid348 (PRECC_DATA* self) {
PARSER CHARCONST, hid347;
return p_orparse0n (self,TOPARSER CHARCONST,0,TOPARSER hid347,0);
}
static STATUS hid349 (PRECC_DATA* self) {
PARSER STRING, hid348;
return p_orparse0n (self,TOPARSER STRING,0,TOPARSER hid348,0);
}
STATUS cstuff2(PRECC_DATA* self) {
PARSER hid349;
P_RETURN((TOPARSER hid349)(self),"cstuff2");
}
P_END

/* -------------------------------------------------------------------- */


/* ------- let a stream flow by, while engraving itself in cbuff ------ */

P_BEGIN
static VOID hid350(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid351(PRECC_DATA* self) {
PARSER atstuff;ACTION hid350;
return p_attach0n(self,TOPARSER atstuff,0,hid350,0);
}
static STATUS hid352(PRECC_DATA* self) {
PARSER hid351, p_nothing0;
return p_andparse0n (self,TOPARSER hid351,0,TOPARSER p_nothing0,0);
}
static STATUS hid353(PRECC_DATA* self) {
PARSER hid352;
return p_many0n(self,TOPARSER hid352,0);
}
static STATUS hid354(PRECC_DATA* self) {
PARSER atstuff, hid353;
return p_andparse0n (self,TOPARSER atstuff,0,TOPARSER hid353,0);
}
static VOID hid355(PRECC_DATA* self) {
 VV(0) =""; 
}
static STATUS hid356(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid355;
return p_attach0n(self,TOPARSER p_nothing0,0,hid355,0);
}
static STATUS hid357(PRECC_DATA* self) {
PARSER hid356, p_nothing0;
return p_andparse0n (self,TOPARSER hid356,0,TOPARSER p_nothing0,0);
}
static STATUS hid358 (PRECC_DATA* self) {
PARSER hid354, hid357;
return p_orparse0n (self,TOPARSER hid354,0,TOPARSER hid357,0);
}
STATUS atstuffs(PRECC_DATA* self) {
PARSER hid358;
P_RETURN((TOPARSER hid358)(self),"atstuffs");
}
P_END

P_BEGIN
static VOID hid359(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid360(PRECC_DATA* self) {
PARSER aatstuff;ACTION hid359;
return p_attach0n(self,TOPARSER aatstuff,0,hid359,0);
}
static STATUS hid361(PRECC_DATA* self) {
PARSER hid360, p_nothing0;
return p_andparse0n (self,TOPARSER hid360,0,TOPARSER p_nothing0,0);
}
static STATUS hid362(PRECC_DATA* self) {
PARSER hid361;
return p_many0n(self,TOPARSER hid361,0);
}
static STATUS hid363(PRECC_DATA* self) {
PARSER aatstuff, hid362;
return p_andparse0n (self,TOPARSER aatstuff,0,TOPARSER hid362,0);
}
static VOID hid364(PRECC_DATA* self) {
 VV(0) =""; 
}
static STATUS hid365(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid364;
return p_attach0n(self,TOPARSER p_nothing0,0,hid364,0);
}
static STATUS hid366(PRECC_DATA* self) {
PARSER hid365, p_nothing0;
return p_andparse0n (self,TOPARSER hid365,0,TOPARSER p_nothing0,0);
}
static STATUS hid367 (PRECC_DATA* self) {
PARSER hid363, hid366;
return p_orparse0n (self,TOPARSER hid363,0,TOPARSER hid366,0);
}
STATUS aatstuffs(PRECC_DATA* self) {
PARSER hid367;
P_RETURN((TOPARSER hid367)(self),"aatstuffs");
}
P_END

P_BEGIN
static VOID hid368(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid369(PRECC_DATA* self) {
PARSER lstuff;ACTION hid368;
return p_attach0n(self,TOPARSER lstuff,0,hid368,0);
}
static STATUS hid370(PRECC_DATA* self) {
PARSER hid369, p_nothing0;
return p_andparse0n (self,TOPARSER hid369,0,TOPARSER p_nothing0,0);
}
static STATUS hid371(PRECC_DATA* self) {
PARSER hid370;
return p_many0n(self,TOPARSER hid370,0);
}
static STATUS hid372(PRECC_DATA* self) {
PARSER lstuff, hid371;
return p_andparse0n (self,TOPARSER lstuff,0,TOPARSER hid371,0);
}
static VOID hid373(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid374(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid373;
return p_attach0n(self,TOPARSER p_nothing0,0,hid373,0);
}
static STATUS hid375(PRECC_DATA* self) {
PARSER hid374, p_nothing0;
return p_andparse0n (self,TOPARSER hid374,0,TOPARSER p_nothing0,0);
}
static STATUS hid376 (PRECC_DATA* self) {
PARSER hid372, hid375;
return p_orparse0n (self,TOPARSER hid372,0,TOPARSER hid375,0);
}
STATUS lstuffs(PRECC_DATA* self) {
PARSER hid376;
P_RETURN((TOPARSER hid376)(self),"lstuffs");
}
P_END

P_BEGIN
static VOID hid377(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid378(PRECC_DATA* self) {
PARSER alstuff;ACTION hid377;
return p_attach0n(self,TOPARSER alstuff,0,hid377,0);
}
static STATUS hid379(PRECC_DATA* self) {
PARSER hid378, p_nothing0;
return p_andparse0n (self,TOPARSER hid378,0,TOPARSER p_nothing0,0);
}
static STATUS hid380(PRECC_DATA* self) {
PARSER hid379;
return p_many0n(self,TOPARSER hid379,0);
}
static STATUS hid381(PRECC_DATA* self) {
PARSER alstuff, hid380;
return p_andparse0n (self,TOPARSER alstuff,0,TOPARSER hid380,0);
}
static VOID hid382(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid383(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid382;
return p_attach0n(self,TOPARSER p_nothing0,0,hid382,0);
}
static STATUS hid384(PRECC_DATA* self) {
PARSER hid383, p_nothing0;
return p_andparse0n (self,TOPARSER hid383,0,TOPARSER p_nothing0,0);
}
static STATUS hid385 (PRECC_DATA* self) {
PARSER hid381, hid384;
return p_orparse0n (self,TOPARSER hid381,0,TOPARSER hid384,0);
}
STATUS alstuffs(PRECC_DATA* self) {
PARSER hid385;
P_RETURN((TOPARSER hid385)(self),"alstuffs");
}
P_END

/* stuff inside a test can be anything except (} */

P_BEGIN
static VOID hid386(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid387(PRECC_DATA* self) {
PARSER tlstuff;ACTION hid386;
return p_attach0n(self,TOPARSER tlstuff,0,hid386,0);
}
static STATUS hid388(PRECC_DATA* self) {
PARSER hid387, p_nothing0;
return p_andparse0n (self,TOPARSER hid387,0,TOPARSER p_nothing0,0);
}
static STATUS hid389(PRECC_DATA* self) {
PARSER hid388;
return p_many0n(self,TOPARSER hid388,0);
}
static STATUS hid390(PRECC_DATA* self) {
PARSER tlstuff, hid389;
return p_andparse0n (self,TOPARSER tlstuff,0,TOPARSER hid389,0);
}
static VOID hid391(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid392(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid391;
return p_attach0n(self,TOPARSER p_nothing0,0,hid391,0);
}
static STATUS hid393(PRECC_DATA* self) {
PARSER hid392, p_nothing0;
return p_andparse0n (self,TOPARSER hid392,0,TOPARSER p_nothing0,0);
}
static STATUS hid394 (PRECC_DATA* self) {
PARSER hid390, hid393;
return p_orparse0n (self,TOPARSER hid390,0,TOPARSER hid393,0);
}
STATUS tlstuffs(PRECC_DATA* self) {
PARSER hid394;
P_RETURN((TOPARSER hid394)(self),"tlstuffs");
}
P_END

/* stuff inside a test can be anything except }( */

P_BEGIN
static VOID hid395(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid396(PRECC_DATA* self) {
PARSER atlstuff;ACTION hid395;
return p_attach0n(self,TOPARSER atlstuff,0,hid395,0);
}
static STATUS hid397(PRECC_DATA* self) {
PARSER hid396, p_nothing0;
return p_andparse0n (self,TOPARSER hid396,0,TOPARSER p_nothing0,0);
}
static STATUS hid398(PRECC_DATA* self) {
PARSER hid397;
return p_many0n(self,TOPARSER hid397,0);
}
static STATUS hid399(PRECC_DATA* self) {
PARSER atlstuff, hid398;
return p_andparse0n (self,TOPARSER atlstuff,0,TOPARSER hid398,0);
}
static VOID hid400(PRECC_DATA* self) {
 VV(0)=""; 
}
static STATUS hid401(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid400;
return p_attach0n(self,TOPARSER p_nothing0,0,hid400,0);
}
static STATUS hid402(PRECC_DATA* self) {
PARSER hid401, p_nothing0;
return p_andparse0n (self,TOPARSER hid401,0,TOPARSER p_nothing0,0);
}
static STATUS hid403 (PRECC_DATA* self) {
PARSER hid399, hid402;
return p_orparse0n (self,TOPARSER hid399,0,TOPARSER hid402,0);
}
STATUS atlstuffs(PRECC_DATA* self) {
PARSER hid403;
P_RETURN((TOPARSER hid403)(self),"atlstuffs");
}
P_END

/* the stuff inside a command is a sequence of C constants or C tokens */

P_BEGIN
static VOID hid404(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid405(PRECC_DATA* self) {
PARSER cstuff;ACTION hid404;
return p_attach0n(self,TOPARSER cstuff,0,hid404,0);
}
static STATUS hid406(PRECC_DATA* self) {
PARSER hid405, p_nothing0;
return p_andparse0n (self,TOPARSER hid405,0,TOPARSER p_nothing0,0);
}
static STATUS hid407(PRECC_DATA* self) {
PARSER hid406;
return p_many0n(self,TOPARSER hid406,0);
}
static STATUS hid408(PRECC_DATA* self) {
PARSER cstuff, hid407;
return p_andparse0n (self,TOPARSER cstuff,0,TOPARSER hid407,0);
}
static VOID hid409(PRECC_DATA* self) {
 VV(0) =""; 
}
static STATUS hid410(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid409;
return p_attach0n(self,TOPARSER p_nothing0,0,hid409,0);
}
static STATUS hid411(PRECC_DATA* self) {
PARSER hid410, p_nothing0;
return p_andparse0n (self,TOPARSER hid410,0,TOPARSER p_nothing0,0);
}
static STATUS hid412 (PRECC_DATA* self) {
PARSER hid408, hid411;
return p_orparse0n (self,TOPARSER hid408,0,TOPARSER hid411,0);
}
STATUS cstuffs(PRECC_DATA* self) {
PARSER hid412;
P_RETURN((TOPARSER hid412)(self),"cstuffs");
}
P_END

/* this kind of interior of a command ends only at a :} */

P_BEGIN
static VOID hid413(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid414(PRECC_DATA* self) {
PARSER cstuff1;ACTION hid413;
return p_attach0n(self,TOPARSER cstuff1,0,hid413,0);
}
static STATUS hid415(PRECC_DATA* self) {
PARSER hid414, p_nothing0;
return p_andparse0n (self,TOPARSER hid414,0,TOPARSER p_nothing0,0);
}
static STATUS hid416(PRECC_DATA* self) {
PARSER hid415;
return p_many0n(self,TOPARSER hid415,0);
}
static STATUS hid417(PRECC_DATA* self) {
PARSER cstuff1, hid416;
return p_andparse0n (self,TOPARSER cstuff1,0,TOPARSER hid416,0);
}
static VOID hid418(PRECC_DATA* self) {
 VV(0) =""; 
}
static STATUS hid419(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid418;
return p_attach0n(self,TOPARSER p_nothing0,0,hid418,0);
}
static STATUS hid420(PRECC_DATA* self) {
PARSER hid419, p_nothing0;
return p_andparse0n (self,TOPARSER hid419,0,TOPARSER p_nothing0,0);
}
static STATUS hid421 (PRECC_DATA* self) {
PARSER hid417, hid420;
return p_orparse0n (self,TOPARSER hid417,0,TOPARSER hid420,0);
}
STATUS cstuffs1(PRECC_DATA* self) {
PARSER hid421;
P_RETURN((TOPARSER hid421)(self),"cstuffs1");
}
P_END

/* this kind of interior of a command ends only at a }: */

P_BEGIN
static VOID hid422(PRECC_DATA* self) {
 VV(2) = V(1); 
}
static STATUS hid423(PRECC_DATA* self) {
PARSER cstuff2;ACTION hid422;
return p_attach0n(self,TOPARSER cstuff2,0,hid422,0);
}
static STATUS hid424(PRECC_DATA* self) {
PARSER hid423, p_nothing0;
return p_andparse0n (self,TOPARSER hid423,0,TOPARSER p_nothing0,0);
}
static STATUS hid425(PRECC_DATA* self) {
PARSER hid424;
return p_many0n(self,TOPARSER hid424,0);
}
static STATUS hid426(PRECC_DATA* self) {
PARSER cstuff2, hid425;
return p_andparse0n (self,TOPARSER cstuff2,0,TOPARSER hid425,0);
}
static VOID hid427(PRECC_DATA* self) {
 VV(0) =""; 
}
static STATUS hid428(PRECC_DATA* self) {
PARSER p_nothing0;ACTION hid427;
return p_attach0n(self,TOPARSER p_nothing0,0,hid427,0);
}
static STATUS hid429(PRECC_DATA* self) {
PARSER hid428, p_nothing0;
return p_andparse0n (self,TOPARSER hid428,0,TOPARSER p_nothing0,0);
}
static STATUS hid430 (PRECC_DATA* self) {
PARSER hid426, hid429;
return p_orparse0n (self,TOPARSER hid426,0,TOPARSER hid429,0);
}
STATUS cstuffs2(PRECC_DATA* self) {
PARSER hid430;
P_RETURN((TOPARSER hid430)(self),"cstuffs2");
}
P_END

/* ------------------------------------------------------------------- */



/* ------------- close the cbuff accumulator  ------------------------ */

P_BEGIN
static VOID hid431(PRECC_DATA* self) {
VV(1)=V(1);getname(&V(1));
}
static STATUS hid432(PRECC_DATA* self) {
PARSER lstuffs;ACTION hid431;
return p_attach0n(self,TOPARSER lstuffs,0,hid431,0);
}
static STATUS hid433(PRECC_DATA* self) {
PARSER hid432, p_nothing0;
return p_andparse0n (self,TOPARSER hid432,0,TOPARSER p_nothing0,0);
}
STATUS lits(PRECC_DATA* self) {
PARSER hid433;
P_RETURN((TOPARSER hid433)(self),"lits");
}
P_END

P_BEGIN
static VOID hid434(PRECC_DATA* self) {
VV(1)=V(1);getname(&V(1));
}
static STATUS hid435(PRECC_DATA* self) {
PARSER alstuffs;ACTION hid434;
return p_attach0n(self,TOPARSER alstuffs,0,hid434,0);
}
static STATUS hid436(PRECC_DATA* self) {
PARSER hid435, p_nothing0;
return p_andparse0n (self,TOPARSER hid435,0,TOPARSER p_nothing0,0);
}
STATUS alits(PRECC_DATA* self) {
PARSER hid436;
P_RETURN((TOPARSER hid436)(self),"alits");
}
P_END

P_BEGIN
static VOID hid437(PRECC_DATA* self) {
VV(1)=V(1);getname(&V(1));
}
static STATUS hid438(PRECC_DATA* self) {
PARSER tlstuffs;ACTION hid437;
return p_attach0n(self,TOPARSER tlstuffs,0,hid437,0);
}
static STATUS hid439(PRECC_DATA* self) {
PARSER hid438, p_nothing0;
return p_andparse0n (self,TOPARSER hid438,0,TOPARSER p_nothing0,0);
}
STATUS tlits(PRECC_DATA* self) {
PARSER hid439;
P_RETURN((TOPARSER hid439)(self),"tlits");
}
P_END

P_BEGIN
static VOID hid440(PRECC_DATA* self) {
VV(1)=V(1);getname(&V(1));
}
static STATUS hid441(PRECC_DATA* self) {
PARSER atlstuffs;ACTION hid440;
return p_attach0n(self,TOPARSER atlstuffs,0,hid440,0);
}
static STATUS hid442(PRECC_DATA* self) {
PARSER hid441, p_nothing0;
return p_andparse0n (self,TOPARSER hid441,0,TOPARSER p_nothing0,0);
}
STATUS atlits(PRECC_DATA* self) {
PARSER hid442;
P_RETURN((TOPARSER hid442)(self),"atlits");
}
P_END

/* commands didn't use to be able to be treated as ordinary atoms, because they
 * were required to end a sequence of 'and's and force a stack shift */

P_BEGIN
static VOID hid443(PRECC_DATA* self) {
 VV(1)=V(1); getname(&V(1)); 
}
static STATUS hid444(PRECC_DATA* self) {
PARSER cstuffs;ACTION hid443;
return p_attach0n(self,TOPARSER cstuffs,0,hid443,0);
}
static STATUS hid445(PRECC_DATA* self) {
PARSER hid444, p_nothing0;
return p_andparse0n (self,TOPARSER hid444,0,TOPARSER p_nothing0,0);
}
STATUS c_code(PRECC_DATA* self) {
PARSER hid445;
P_RETURN((TOPARSER hid445)(self),"c_code");
}
P_END

/* otoh, this kind of command is an atom - it has code inside {: :} pairs */

P_BEGIN
static VOID hid446(PRECC_DATA* self) {
 VV(1)=V(1); getname(&V(1)); 
}
static STATUS hid447(PRECC_DATA* self) {
PARSER cstuffs1;ACTION hid446;
return p_attach0n(self,TOPARSER cstuffs1,0,hid446,0);
}
static STATUS hid448(PRECC_DATA* self) {
PARSER hid447, p_nothing0;
return p_andparse0n (self,TOPARSER hid447,0,TOPARSER p_nothing0,0);
}
STATUS c_code1(PRECC_DATA* self) {
PARSER hid448;
P_RETURN((TOPARSER hid448)(self),"c_code1");
}
P_END

/* or :{ }: pairs */

P_BEGIN
static VOID hid449(PRECC_DATA* self) {
 VV(1)=V(1); getname(&V(1)); 
}
static STATUS hid450(PRECC_DATA* self) {
PARSER cstuffs2;ACTION hid449;
return p_attach0n(self,TOPARSER cstuffs2,0,hid449,0);
}
static STATUS hid451(PRECC_DATA* self) {
PARSER hid450, p_nothing0;
return p_andparse0n (self,TOPARSER hid450,0,TOPARSER p_nothing0,0);
}
STATUS c_code2(PRECC_DATA* self) {
PARSER hid451;
P_RETURN((TOPARSER hid451)(self),"c_code2");
}
P_END

/* ------------------------------------------------------------------- */


/* ---------------------- large "tokens" ----------------------------- */

P_BEGIN
static STATUS hid452(PRECC_DATA* self) {
PARSER lits, RIGHTANGLEBRACKET;
return p_andparse0n (self,TOPARSER lits,0,TOPARSER RIGHTANGLEBRACKET,0);
}
static STATUS hid453(PRECC_DATA* self) {
PARSER LEFTANGLEBRACKET, hid452;
return p_andparse0n (self,TOPARSER LEFTANGLEBRACKET,0,TOPARSER hid452,0);
}
static VOID hid454(PRECC_DATA* self) {
 VV(3) = V(2); 
}
static STATUS hid455(PRECC_DATA* self) {
PARSER hid453;ACTION hid454;
return p_attach0n(self,TOPARSER hid453,0,hid454,0);
}
static STATUS hid456(PRECC_DATA* self) {
PARSER hid455, p_nothing0;
return p_andparse0n (self,TOPARSER hid455,0,TOPARSER p_nothing0,0);
}
STATUS LITERAL(PRECC_DATA* self) {
PARSER hid456;
P_RETURN((TOPARSER hid456)(self),"LITERAL");
}
P_END

P_BEGIN
static STATUS hid457(PRECC_DATA* self) {
PARSER alits, LEFTANGLEBRACKET;
return p_andparse0n (self,TOPARSER alits,0,TOPARSER LEFTANGLEBRACKET,0);
}
static STATUS hid458(PRECC_DATA* self) {
PARSER RIGHTANGLEBRACKET, hid457;
return p_andparse0n (self,TOPARSER RIGHTANGLEBRACKET,0,TOPARSER hid457,0);
}
static VOID hid459(PRECC_DATA* self) {
 VV(3) = V(2) ; 
}
static STATUS hid460(PRECC_DATA* self) {
PARSER hid458;ACTION hid459;
return p_attach0n(self,TOPARSER hid458,0,hid459,0);
}
static STATUS hid461(PRECC_DATA* self) {
PARSER hid460, p_nothing0;
return p_andparse0n (self,TOPARSER hid460,0,TOPARSER p_nothing0,0);
}
STATUS ANTILITERAL(PRECC_DATA* self) {
PARSER hid461;
P_RETURN((TOPARSER hid461)(self),"ANTILITERAL");
}
P_END

/* ------------------------------------------------------------------- */


P_BEGIN
static VOID hid462(PRECC_DATA* self) {
char *n;VV(1)=(GETNEWNAME(&n,plainenv),P_LIT(n,V(1))); 
}
static STATUS hid463(PRECC_DATA* self) {
PARSER LITERAL;ACTION hid462;
return p_attach0n(self,TOPARSER LITERAL,0,hid462,0);
}
static STATUS hid464(PRECC_DATA* self) {
PARSER hid463, p_nothing0;
return p_andparse0n (self,TOPARSER hid463,0,TOPARSER p_nothing0,0);
}
STATUS literal(PRECC_DATA* self) {
PARSER hid464;
P_RETURN((TOPARSER hid464)(self),"literal");
}
P_END

P_BEGIN
static VOID hid465(PRECC_DATA* self) {
char *n;VV(1)=(GETNEWNAME(&n,plainenv),P_ALI(n,V(1))); 
}
static STATUS hid466(PRECC_DATA* self) {
PARSER ANTILITERAL;ACTION hid465;
return p_attach0n(self,TOPARSER ANTILITERAL,0,hid465,0);
}
static STATUS hid467(PRECC_DATA* self) {
PARSER hid466, p_nothing0;
return p_andparse0n (self,TOPARSER hid466,0,TOPARSER p_nothing0,0);
}
STATUS antiliteral(PRECC_DATA* self) {
PARSER hid467;
P_RETURN((TOPARSER hid467)(self),"antiliteral");
}
P_END

P_BEGIN
static STATUS hid468(PRECC_DATA* self) {
PARSER WHITESPACE, CLOSEPAREN;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER CLOSEPAREN,0);
}
static STATUS hid469(PRECC_DATA* self) {
PARSER expr, hid468;
return p_andparse0n (self,TOPARSER expr,0,TOPARSER hid468,0);
}
static STATUS hid470(PRECC_DATA* self) {
PARSER WHITESPACE, hid469;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid469,0);
}
static STATUS hid471(PRECC_DATA* self) {
PARSER OPENPAREN, hid470;
return p_andparse0n (self,TOPARSER OPENPAREN,0,TOPARSER hid470,0);
}
static VOID hid472(PRECC_DATA* self) {
char *n;VV(5)=(getname(&V(3)),GETNEWNAME(&n,plainenv),P_RAN(n,V(3)));
}
static STATUS hid473(PRECC_DATA* self) {
PARSER hid471;ACTION hid472;
return p_attach0n(self,TOPARSER hid471,0,hid472,0);
}
static STATUS hid474(PRECC_DATA* self) {
PARSER hid473, p_nothing0;
return p_andparse0n (self,TOPARSER hid473,0,TOPARSER p_nothing0,0);
}
STATUS range(PRECC_DATA* self) {
PARSER hid474;
P_RETURN((TOPARSER hid474)(self),"range");
}
P_END

P_BEGIN
static STATUS hid475(PRECC_DATA* self) {
PARSER WHITESPACE, OPENPAREN;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER OPENPAREN,0);
}
static STATUS hid476(PRECC_DATA* self) {
PARSER expr, hid475;
return p_andparse0n (self,TOPARSER expr,0,TOPARSER hid475,0);
}
static STATUS hid477(PRECC_DATA* self) {
PARSER WHITESPACE, hid476;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid476,0);
}
static STATUS hid478(PRECC_DATA* self) {
PARSER CLOSEPAREN, hid477;
return p_andparse0n (self,TOPARSER CLOSEPAREN,0,TOPARSER hid477,0);
}
static VOID hid479(PRECC_DATA* self) {
char *n;VV(5)=(getname(&V(3)),GETNEWNAME(&n,plainenv),P_TST(n,V(3)));
}
static STATUS hid480(PRECC_DATA* self) {
PARSER hid478;ACTION hid479;
return p_attach0n(self,TOPARSER hid478,0,hid479,0);
}
static STATUS hid481(PRECC_DATA* self) {
PARSER hid480, p_nothing0;
return p_andparse0n (self,TOPARSER hid480,0,TOPARSER p_nothing0,0);
}
STATUS test(PRECC_DATA* self) {
PARSER hid481;
P_RETURN((TOPARSER hid481)(self),"test");
}
P_END

P_BEGIN
static STATUS hid482(PRECC_DATA* self) {
PARSER OPENPAREN, CLOSEBRACE;
return p_andparse0n (self,TOPARSER OPENPAREN,0,TOPARSER CLOSEBRACE,0);
}
static STATUS hid483(PRECC_DATA* self) {
PARSER WHITESPACE, hid482;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid482,0);
}
static STATUS hid484(PRECC_DATA* self) {
PARSER tlits, hid483;
return p_andparse0n (self,TOPARSER tlits,0,TOPARSER hid483,0);
}
static STATUS hid485(PRECC_DATA* self) {
PARSER WHITESPACE, hid484;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid484,0);
}
static STATUS hid486(PRECC_DATA* self) {
PARSER CLOSEPAREN, hid485;
return p_andparse0n (self,TOPARSER CLOSEPAREN,0,TOPARSER hid485,0);
}
static STATUS hid487(PRECC_DATA* self) {
PARSER OPENBRACE, hid486;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid486,0);
}
static VOID hid488(PRECC_DATA* self) {
char *n;VV(7)=(GETNEWNAME(&n,plainenv),P_TST(n,V(4))); 
}
static STATUS hid489(PRECC_DATA* self) {
PARSER hid487;ACTION hid488;
return p_attach0n(self,TOPARSER hid487,0,hid488,0);
}
static STATUS hid490(PRECC_DATA* self) {
PARSER hid489, p_nothing0;
return p_andparse0n (self,TOPARSER hid489,0,TOPARSER p_nothing0,0);
}
static STATUS hid491(PRECC_DATA* self) {
PARSER CLOSEBRACE, OPENPAREN;
return p_andparse0n (self,TOPARSER CLOSEBRACE,0,TOPARSER OPENPAREN,0);
}
static STATUS hid492(PRECC_DATA* self) {
PARSER WHITESPACE, hid491;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid491,0);
}
static STATUS hid493(PRECC_DATA* self) {
PARSER atlits, hid492;
return p_andparse0n (self,TOPARSER atlits,0,TOPARSER hid492,0);
}
static STATUS hid494(PRECC_DATA* self) {
PARSER WHITESPACE, hid493;
return p_andparse0n (self,TOPARSER WHITESPACE,0,TOPARSER hid493,0);
}
static STATUS hid495(PRECC_DATA* self) {
PARSER OPENBRACE, hid494;
return p_andparse0n (self,TOPARSER OPENBRACE,0,TOPARSER hid494,0);
}
static STATUS hid496(PRECC_DATA* self) {
PARSER CLOSEPAREN, hid495;
return p_andparse0n (self,TOPARSER CLOSEPAREN,0,TOPARSER hid495,0);
}
static VOID hid497(PRECC_DATA* self) {
char *n;VV(7)=(GETNEWNAME(&n,plainenv),P_TST(n,V(4))); 
}
static STATUS hid498(PRECC_DATA* self) {
PARSER hid496;ACTION hid497;
return p_attach0n(self,TOPARSER hid496,0,hid497,0);
}
static STATUS hid499(PRECC_DATA* self) {
PARSER hid498, p_nothing0;
return p_andparse0n (self,TOPARSER hid498,0,TOPARSER p_nothing0,0);
}
static STATUS hid500 (PRECC_DATA* self) {
PARSER hid490, hid499;
return p_orparse0n (self,TOPARSER hid490,0,TOPARSER hid499,0);
}
STATUS brackettest(PRECC_DATA* self) {
PARSER hid500;
P_RETURN((TOPARSER hid500)(self),"brackettest");
}
P_END

P_BEGIN
static VOID hid501(PRECC_DATA* self) {
 VV(1)="p_first0"; 
}
static STATUS hid502(PRECC_DATA* self) {
PARSER CARET;ACTION hid501;
return p_attach0n(self,TOPARSER CARET,0,hid501,0);
}
static STATUS hid503(PRECC_DATA* self) {
PARSER hid502, p_nothing0;
return p_andparse0n (self,TOPARSER hid502,0,TOPARSER p_nothing0,0);
}
STATUS beginmatch(PRECC_DATA* self) {
PARSER hid503;
P_RETURN((TOPARSER hid503)(self),"beginmatch");
}
P_END

P_BEGIN
static VOID hid504(PRECC_DATA* self) {
 VV(1)="p_last0"; 
}
static STATUS hid505(PRECC_DATA* self) {
PARSER DOLLAR;ACTION hid504;
return p_attach0n(self,TOPARSER DOLLAR,0,hid504,0);
}
static STATUS hid506(PRECC_DATA* self) {
PARSER hid505, p_nothing0;
return p_andparse0n (self,TOPARSER hid505,0,TOPARSER p_nothing0,0);
}
STATUS finishmatch(PRECC_DATA* self) {
PARSER hid506;
P_RETURN((TOPARSER hid506)(self),"finishmatch");
}
P_END

P_BEGIN
static VOID hid507(PRECC_DATA* self) {
 VV(1)="p_uniq0"; 
}
static STATUS hid508(PRECC_DATA* self) {
PARSER PLING;ACTION hid507;
return p_attach0n(self,TOPARSER PLING,0,hid507,0);
}
static STATUS hid509(PRECC_DATA* self) {
PARSER hid508, p_nothing0;
return p_andparse0n (self,TOPARSER hid508,0,TOPARSER p_nothing0,0);
}
STATUS plingmatch(PRECC_DATA* self) {
PARSER hid509;
P_RETURN((TOPARSER hid509)(self),"plingmatch");
}
P_END

P_BEGIN
static STATUS hid510(PRECC_DATA* self) {
PARSER DOLLAR, PLING;
return p_andparse0n (self,TOPARSER DOLLAR,0,TOPARSER PLING,0);
}
static VOID hid511(PRECC_DATA* self) {
 VV(2)="p_lastuniq0"; 
}
static STATUS hid512(PRECC_DATA* self) {
PARSER hid510;ACTION hid511;
return p_attach0n(self,TOPARSER hid510,0,hid511,0);
}
static STATUS hid513(PRECC_DATA* self) {
PARSER hid512, p_nothing0;
return p_andparse0n (self,TOPARSER hid512,0,TOPARSER p_nothing0,0);
}
STATUS dollarplingmatch(PRECC_DATA* self) {
PARSER hid513;
P_RETURN((TOPARSER hid513)(self),"dollarplingmatch");
}
P_END

P_BEGIN
static STATUS hid514(PRECC_DATA* self) {
PARSER DOLLAR, DOLLAR;
return p_andparse0n (self,TOPARSER DOLLAR,0,TOPARSER DOLLAR,0);
}
static VOID hid515(PRECC_DATA* self) {
 VV(2)="p_eof0"; 
}
static STATUS hid516(PRECC_DATA* self) {
PARSER hid514;ACTION hid515;
return p_attach0n(self,TOPARSER hid514,0,hid515,0);
}
static STATUS hid517(PRECC_DATA* self) {
PARSER hid516, p_nothing0;
return p_andparse0n (self,TOPARSER hid516,0,TOPARSER p_nothing0,0);
}
STATUS eofmatch(PRECC_DATA* self) {
PARSER hid517;
P_RETURN((TOPARSER hid517)(self),"eofmatch");
}
P_END

                /* another overpull */

P_BEGIN
static VOID hid518(PRECC_DATA* self) {
 char *n;VV(2)=(GETNEWNAME(&n,plainenv),P_SOM(n,V(1))); 
}
static STATUS hid519(PRECC_DATA* self) {
PARSER PLUS;ACTION hid518;
return p_attach0n(self,TOPARSER PLUS,0,hid518,0);
}
static STATUS hid520(PRECC_DATA* self) {
PARSER hid519, p_nothing0;
return p_andparse0n (self,TOPARSER hid519,0,TOPARSER p_nothing0,0);
}
STATUS plusop(PRECC_DATA* self) {
PARSER hid520;
P_RETURN((TOPARSER hid520)(self),"plusop");
}
P_END

P_BEGIN
static STATUS hid521(PRECC_DATA* self) {
PARSER expr, CLOSEPAREN;
return p_andparse0n (self,TOPARSER expr,0,TOPARSER CLOSEPAREN,0);
}
static STATUS hid522(PRECC_DATA* self) {
PARSER OPENPAREN, hid521;
return p_andparse0n (self,TOPARSER OPENPAREN,0,TOPARSER hid521,0);
}
static STATUS hid523(PRECC_DATA* self) {
PARSER SLASH, hid522;
return p_andparse0n (self,TOPARSER SLASH,0,TOPARSER hid522,0);
}
static VOID hid524(PRECC_DATA* self) {
char *n;
   VV(5)=(getname(&V(4)),GETNEWNAME(&n,plainenv),P_HID(n,V(1),V(4)));
}
static STATUS hid525(PRECC_DATA* self) {
PARSER hid523;ACTION hid524;
return p_attach0n(self,TOPARSER hid523,0,hid524,0);
}
static STATUS hid526(PRECC_DATA* self) {
PARSER hid525, p_nothing0;
return p_andparse0n (self,TOPARSER hid525,0,TOPARSER p_nothing0,0);
}
STATUS hideop(PRECC_DATA* self) {
PARSER hid526;
P_RETURN((TOPARSER hid526)(self),"hideop");
}
P_END


                /* ------- finis -------- */

MAIN(line)










